// SPDX-License-Identifier: GPL-2.0-only
/*
 * Samsung Exynos4 SoC series FIMC-IS slave interface driver
 *
 * Error log interface functions
 *
 * Copyright (C) 2011 - 2013 Samsung Electronics Co., Ltd.
 *
 * Authors: Younghwan Joo <yhwan.joo@samsung.com>
 *          Sylwester Nawrocki <s.nawrocki@samsung.com>
 */

#include "fimc-is-errno.h"

const char *fimc_is_strerr(unsigned int error)
{
	error &= ~IS_ERROR_TIME_OUT_FLAG;

	switch (error) {
	/* General */
	case IS_ERROR_INVALID_COMMAND:
		return "IS_ERROR_INVALID_COMMAND";
	case IS_ERROR_REQUEST_FAIL:
		return "IS_ERROR_REQUEST_FAIL";
	case IS_ERROR_INVALID_SCENARIO:
		return "IS_ERROR_INVALID_SCENARIO";
	case IS_ERROR_INVALID_SENSORID:
		return "IS_ERROR_INVALID_SENSORID";
	case IS_ERROR_INVALID_MODE_CHANGE:
		return "IS_ERROR_INVALID_MODE_CHANGE";
	case IS_ERROR_INVALID_MAGIC_NUMBER:
		return "IS_ERROR_INVALID_MAGIC_NUMBER";
	case IS_ERROR_INVALID_SETFILE_HDR:
		return "IS_ERROR_INVALID_SETFILE_HDR";
	case IS_ERROR_BUSY:
		return "IS_ERROR_BUSY";
	case IS_ERROR_SET_PARAMETER:
		return "IS_ERROR_SET_PARAMETER";
	case IS_ERROR_INVALID_PATH:
		return "IS_ERROR_INVALID_PATH";
	case IS_ERROR_OPEN_SENSOR_FAIL:
		return "IS_ERROR_OPEN_SENSOR_FAIL";
	case IS_ERROR_ENTRY_MSG_THREAD_DOWN:
		return "IS_ERROR_ENTRY_MSG_THREAD_DOWN";
	case IS_ERROR_ISP_FRAME_END_NOT_DONE:
		return "IS_ERROR_ISP_FRAME_END_NOT_DONE";
	case IS_ERROR_DRC_FRAME_END_NOT_DONE:
		return "IS_ERROR_DRC_FRAME_END_NOT_DONE";
	case IS_ERROR_SCALERC_FRAME_END_NOT_DONE:
		return "IS_ERROR_SCALERC_FRAME_END_NOT_DONE";
	case IS_ERROR_ODC_FRAME_END_NOT_DONE:
		return "IS_ERROR_ODC_FRAME_END_NOT_DONE";
	case IS_ERROR_DIS_FRAME_END_NOT_DONE:
		return "IS_ERROR_DIS_FRAME_END_NOT_DONE";
	case IS_ERROR_TDNR_FRAME_END_NOT_DONE:
		return "IS_ERROR_TDNR_FRAME_END_NOT_DONE";
	case IS_ERROR_SCALERP_FRAME_END_NOT_DONE:
		return "IS_ERROR_SCALERP_FRAME_END_NOT_DONE";
	case IS_ERROR_WAIT_STREAM_OFF_NOT_DONE:
		return "IS_ERROR_WAIT_STREAM_OFF_NOT_DONE";
	case IS_ERROR_NO_MSG_IS_RECEIVED:
		return "IS_ERROR_NO_MSG_IS_RECEIVED";
	case IS_ERROR_SENSOR_MSG_FAIL:
		return "IS_ERROR_SENSOR_MSG_FAIL";
	case IS_ERROR_ISP_MSG_FAIL:
		return "IS_ERROR_ISP_MSG_FAIL";
	case IS_ERROR_DRC_MSG_FAIL:
		return "IS_ERROR_DRC_MSG_FAIL";
	case IS_ERROR_LHFD_MSG_FAIL:
		return "IS_ERROR_LHFD_MSG_FAIL";
	case IS_ERROR_UNKNOWN:
		return "IS_ERROR_UNKNOWN";

	/* Sensor */
	case IS_ERROR_SENSOR_PWRDN_FAIL:
		return "IS_ERROR_SENSOR_PWRDN_FAIL";

	/* ISP */
	case IS_ERROR_ISP_PWRDN_FAIL:
		return "IS_ERROR_ISP_PWRDN_FAIL";
	case IS_ERROR_ISP_MULTIPLE_INPUT:
		return "IS_ERROR_ISP_MULTIPLE_INPUT";
	case IS_ERROR_ISP_ABSENT_INPUT:
		return "IS_ERROR_ISP_ABSENT_INPUT";
	case IS_ERROR_ISP_ABSENT_OUTPUT:
		return "IS_ERROR_ISP_ABSENT_OUTPUT";
	case IS_ERROR_ISP_NONADJACENT_OUTPUT:
		return "IS_ERROR_ISP_NONADJACENT_OUTPUT";
	case IS_ERROR_ISP_FORMAT_MISMATCH:
		return "IS_ERROR_ISP_FORMAT_MISMATCH";
	case IS_ERROR_ISP_WIDTH_MISMATCH:
		return "IS_ERROR_ISP_WIDTH_MISMATCH";
	case IS_ERROR_ISP_HEIGHT_MISMATCH:
		return "IS_ERROR_ISP_HEIGHT_MISMATCH";
	case IS_ERROR_ISP_BITWIDTH_MISMATCH:
		return "IS_ERROR_ISP_BITWIDTH_MISMATCH";
	case IS_ERROR_ISP_FRAME_END_TIME_OUT:
		return "IS_ERROR_ISP_FRAME_END_TIME_OUT";

	/* DRC */
	case IS_ERROR_DRC_PWRDN_FAIL:
		return "IS_ERROR_DRC_PWRDN_FAIL";
	case IS_ERROR_DRC_MULTIPLE_INPUT:
		return "IS_ERROR_DRC_MULTIPLE_INPUT";
	case IS_ERROR_DRC_ABSENT_INPUT:
		return "IS_ERROR_DRC_ABSENT_INPUT";
	case IS_ERROR_DRC_NONADJACENT_INPUT:
		return "IS_ERROR_DRC_NONADJACENT_INPUT";
	case IS_ERROR_DRC_ABSENT_OUTPUT:
		return "IS_ERROR_DRC_ABSENT_OUTPUT";
	case IS_ERROR_DRC_NONADJACENT_OUTPUT:
		return "IS_ERROR_DRC_NONADJACENT_OUTPUT";
	case IS_ERROR_DRC_FORMAT_MISMATCH:
		return "IS_ERROR_DRC_FORMAT_MISMATCH";
	case IS_ERROR_DRC_WIDTH_MISMATCH:
		return "IS_ERROR_DRC_WIDTH_MISMATCH";
	case IS_ERROR_DRC_HEIGHT_MISMATCH:
		return "IS_ERROR_DRC_HEIGHT_MISMATCH";
	case IS_ERROR_DRC_BITWIDTH_MISMATCH:
		return "IS_ERROR_DRC_BITWIDTH_MISMATCH";
	case IS_ERROR_DRC_FRAME_END_TIME_OUT:
		return "IS_ERROR_DRC_FRAME_END_TIME_OUT";

	/* FD */
	case IS_ERROR_FD_PWRDN_FAIL:
		return "IS_ERROR_FD_PWRDN_FAIL";
	case IS_ERROR_FD_MULTIPLE_INPUT:
		return "IS_ERROR_FD_MULTIPLE_INPUT";
	case IS_ERROR_FD_ABSENT_INPUT:
		return "IS_ERROR_FD_ABSENT_INPUT";
	case IS_ERROR_FD_NONADJACENT_INPUT:
		return "IS_ERROR_FD_NONADJACENT_INPUT";
	case IS_ERROR_LHFD_FRAME_END_TIME_OUT:
		return "IS_ERROR_LHFD_FRAME_END_TIME_OUT";
	default:
		return "Unknown";
	}
}
