/* -*- Mode: C; tab-width: 4 -*-
 *
 * Copyright (c) 2009 Apple Computer, Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */





#include "stdafx.h"

#include "resource.h"

#include "DLLX.h"

#include "dlldatax.h"

#include <DebugServices.h>





class CDLLComponentModule : public CAtlDllModuleT< CDLLComponentModule >

{

public :

	DECLARE_LIBID(LIBID_Bonjour)

	DECLARE_REGISTRY_APPID_RESOURCEID(IDR_DLLX, "{56608F9C-223B-4CB6-813D-85EDCCADFB4B}")

};



CDLLComponentModule _AtlModule;





#ifdef _MANAGED

#pragma managed(push, off)

#endif



// DLL Entry Point

extern "C" BOOL WINAPI DllMain(HINSTANCE hInstance, DWORD dwReason, LPVOID lpReserved)

{

	debug_initialize( kDebugOutputTypeWindowsDebugger );
	debug_set_property( kDebugPropertyTagPrintLevel, kDebugLevelVerbose );



#ifdef _MERGE_PROXYSTUB

    if (!PrxDllMain(hInstance, dwReason, lpReserved))

        return FALSE;

#endif

	hInstance;

    return _AtlModule.DllMain(dwReason, lpReserved); 

}



#ifdef _MANAGED

#pragma managed(pop)

#endif









// Used to determine whether the DLL can be unloaded by OLE

STDAPI DllCanUnloadNow(void)

{

#ifdef _MERGE_PROXYSTUB

    HRESULT hr = PrxDllCanUnloadNow();

    if (hr != S_OK)

        return hr;

#endif

    return _AtlModule.DllCanUnloadNow();

}





// Returns a class factory to create an object of the requested type

STDAPI DllGetClassObject(REFCLSID rclsid, REFIID riid, LPVOID* ppv)

{

#ifdef _MERGE_PROXYSTUB

    if (PrxDllGetClassObject(rclsid, riid, ppv) == S_OK)

        return S_OK;

#endif

    return _AtlModule.DllGetClassObject(rclsid, riid, ppv);

}





// DllRegisterServer - Adds entries to the system registry

STDAPI DllRegisterServer(void)

{

    // registers object, typelib and all interfaces in typelib

    HRESULT hr = _AtlModule.DllRegisterServer();

#ifdef _MERGE_PROXYSTUB

    if (FAILED(hr))

        return hr;

    hr = PrxDllRegisterServer();

#endif

	return hr;

}





// DllUnregisterServer - Removes entries from the system registry

STDAPI DllUnregisterServer(void)

{

	HRESULT hr = _AtlModule.DllUnregisterServer();

#ifdef _MERGE_PROXYSTUB

    if (FAILED(hr))

        return hr;

    hr = PrxDllRegisterServer();

    if (FAILED(hr))

        return hr;

    hr = PrxDllUnregisterServer();

#endif

	return hr;

}



