/* SPDX-License-Identifier: GPL-2.0+ */
/*
 * Copyright 2024 NXP
 */

#ifndef __ASM_ARCH_IMX91_PINS_H__
#define __ASM_ARCH_IMX91_PINS_H__

#include <asm/mach-imx/iomux-v3.h>

enum {
	MX91_PAD_DAP_TDI__JTAG_MUX_TDI                                                  = IOMUX_PAD(0x01B0, 0x0000, 0x00, 0x03D8, 0x00, 0x00),
	MX91_PAD_DAP_TDI__MQS2_LEFT                                                     = IOMUX_PAD(0x01B0, 0x0000, 0x01, 0x0000, 0x00, 0x00),
	MX91_PAD_DAP_TDI__CAN2_TX                                                       = IOMUX_PAD(0x01B0, 0x0000, 0x03, 0x0000, 0x00, 0x00),
	MX91_PAD_DAP_TDI__FLEXIO2_FLEXIO30                                              = IOMUX_PAD(0x01B0, 0x0000, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_DAP_TDI__GPIO3_IO28                                                    = IOMUX_PAD(0x01B0, 0x0000, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_DAP_TDI__LPUART5_RX                                                    = IOMUX_PAD(0x01B0, 0x0000, 0x06, 0x0488, 0x00, 0x00),

	MX91_PAD_DAP_TMS_SWDIO__JTAG_MUX_TMS                                            = IOMUX_PAD(0x01B4, 0x0004, 0x00, 0x03DC, 0x00, 0x00),
	MX91_PAD_DAP_TMS_SWDIO__FLEXIO2_FLEXIO31                                        = IOMUX_PAD(0x01B4, 0x0004, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_DAP_TMS_SWDIO__GPIO3_IO29                                              = IOMUX_PAD(0x01B4, 0x0004, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_DAP_TMS_SWDIO__LPUART5_RTS_B                                           = IOMUX_PAD(0x01B4, 0x0004, 0x06, 0x0000, 0x00, 0x00),

	MX91_PAD_DAP_TCLK_SWCLK__JTAG_MUX_TCK                                           = IOMUX_PAD(0x01B8, 0x0008, 0x00, 0x03D4, 0x00, 0x00),
	MX91_PAD_DAP_TCLK_SWCLK__FLEXIO1_FLEXIO30                                       = IOMUX_PAD(0x01B8, 0x0008, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_DAP_TCLK_SWCLK__GPIO3_IO30                                             = IOMUX_PAD(0x01B8, 0x0008, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_DAP_TCLK_SWCLK__LPUART5_CTS_B                                          = IOMUX_PAD(0x01B8, 0x0008, 0x06, 0x0484, 0x00, 0x00),

	MX91_PAD_DAP_TDO_TRACESWO__JTAG_MUX_TDO                                         = IOMUX_PAD(0x01BC, 0x000C, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_DAP_TDO_TRACESWO__MQS2_RIGHT                                           = IOMUX_PAD(0x01BC, 0x000C, 0x01, 0x0000, 0x00, 0x00),
	MX91_PAD_DAP_TDO_TRACESWO__CAN2_RX                                              = IOMUX_PAD(0x01BC, 0x000C, 0x03, 0x0364, 0x00, 0x00),
	MX91_PAD_DAP_TDO_TRACESWO__FLEXIO1_FLEXIO31                                     = IOMUX_PAD(0x01BC, 0x000C, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_DAP_TDO_TRACESWO__GPIO3_IO31                                           = IOMUX_PAD(0x01BC, 0x000C, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_DAP_TDO_TRACESWO__LPUART5_TX                                           = IOMUX_PAD(0x01BC, 0x000C, 0x06, 0x048C, 0x00, 0x00),

	MX91_PAD_GPIO_IO00__GPIO2_IO0                                                   = IOMUX_PAD(0x01C0, 0x0010, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO00__LPI2C3_SDA                                                  = IOMUX_PAD(0x01C0, 0x0010, 0x01, 0x03F4, 0x00, 0x00),
	MX91_PAD_GPIO_IO00__MEDIAMIX_CAM_CLK                                            = IOMUX_PAD(0x01C0, 0x0010, 0x02, 0x04BC, 0x00, 0x00),
	MX91_PAD_GPIO_IO00__MEDIAMIX_DISP_CLK                                           = IOMUX_PAD(0x01C0, 0x0010, 0x03, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO00__LPSPI6_PCS0                                                 = IOMUX_PAD(0x01C0, 0x0010, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO00__LPUART5_TX                                                  = IOMUX_PAD(0x01C0, 0x0010, 0x05, 0x048C, 0x01, 0x00),
	MX91_PAD_GPIO_IO00__LPI2C5_SDA                                                  = IOMUX_PAD(0x01C0, 0x0010, 0x06, 0x0404, 0x00, 0x00),
	MX91_PAD_GPIO_IO00__FLEXIO1_FLEXIO0                                             = IOMUX_PAD(0x01C0, 0x0010, 0x07, 0x036C, 0x00, 0x00),

	MX91_PAD_GPIO_IO01__GPIO2_IO1                                                   = IOMUX_PAD(0x01C4, 0x0014, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO01__LPI2C3_SCL                                                  = IOMUX_PAD(0x01C4, 0x0014, 0x01, 0x03F0, 0x00, 0x00),
	MX91_PAD_GPIO_IO01__MEDIAMIX_CAM_DATA0                                          = IOMUX_PAD(0x01C4, 0x0014, 0x02, 0x0490, 0x00, 0x00),
	MX91_PAD_GPIO_IO01__MEDIAMIX_DISP_DE                                            = IOMUX_PAD(0x01C4, 0x0014, 0x03, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO01__LPSPI6_SIN                                                  = IOMUX_PAD(0x01C4, 0x0014, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO01__LPUART5_RX                                                  = IOMUX_PAD(0x01C4, 0x0014, 0x05, 0x0488, 0x01, 0x00),
	MX91_PAD_GPIO_IO01__LPI2C5_SCL                                                  = IOMUX_PAD(0x01C4, 0x0014, 0x06, 0x0400, 0x00, 0x00),
	MX91_PAD_GPIO_IO01__FLEXIO1_FLEXIO1                                             = IOMUX_PAD(0x01C4, 0x0014, 0x07, 0x0370, 0x00, 0x00),

	MX91_PAD_GPIO_IO02__GPIO2_IO2                                                   = IOMUX_PAD(0x01C8, 0x0018, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO02__LPI2C4_SDA                                                  = IOMUX_PAD(0x01C8, 0x0018, 0x01, 0x03FC, 0x00, 0x00),
	MX91_PAD_GPIO_IO02__MEDIAMIX_CAM_VSYNC                                          = IOMUX_PAD(0x01C8, 0x0018, 0x02, 0x04C0, 0x00, 0x00),
	MX91_PAD_GPIO_IO02__MEDIAMIX_DISP_VSYNC                                         = IOMUX_PAD(0x01C8, 0x0018, 0x03, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO02__LPSPI6_SOUT                                                 = IOMUX_PAD(0x01C8, 0x0018, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO02__LPUART5_CTS_B                                               = IOMUX_PAD(0x01C8, 0x0018, 0x05, 0x0484, 0x01, 0x00),
	MX91_PAD_GPIO_IO02__LPI2C6_SDA                                                  = IOMUX_PAD(0x01C8, 0x0018, 0x06, 0x040C, 0x00, 0x00),
	MX91_PAD_GPIO_IO02__FLEXIO1_FLEXIO2                                             = IOMUX_PAD(0x01C8, 0x0018, 0x07, 0x0374, 0x00, 0x00),

	MX91_PAD_GPIO_IO03__GPIO2_IO3                                                   = IOMUX_PAD(0x01CC, 0x001C, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO03__LPI2C4_SCL                                                  = IOMUX_PAD(0x01CC, 0x001C, 0x01, 0x03F8, 0x00, 0x00),
	MX91_PAD_GPIO_IO03__MEDIAMIX_CAM_HSYNC                                          = IOMUX_PAD(0x01CC, 0x001C, 0x02, 0x04B8, 0x00, 0x00),
	MX91_PAD_GPIO_IO03__MEDIAMIX_DISP_HSYNC                                         = IOMUX_PAD(0x01CC, 0x001C, 0x03, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO03__LPSPI6_SCK                                                  = IOMUX_PAD(0x01CC, 0x001C, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO03__LPUART5_RTS_B                                               = IOMUX_PAD(0x01CC, 0x001C, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO03__LPI2C6_SCL                                                  = IOMUX_PAD(0x01CC, 0x001C, 0x06, 0x0408, 0x00, 0x00),
	MX91_PAD_GPIO_IO03__FLEXIO1_FLEXIO3                                             = IOMUX_PAD(0x01CC, 0x001C, 0x07, 0x0378, 0x00, 0x00),

	MX91_PAD_GPIO_IO04__GPIO2_IO4                                                   = IOMUX_PAD(0x01D0, 0x0020, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO04__TPM3_CH0                                                    = IOMUX_PAD(0x01D0, 0x0020, 0x01, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO04__PDM_CLK                                                     = IOMUX_PAD(0x01D0, 0x0020, 0x02, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO04__MEDIAMIX_DISP_DATA0                                         = IOMUX_PAD(0x01D0, 0x0020, 0x03, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO04__LPSPI7_PCS0                                                 = IOMUX_PAD(0x01D0, 0x0020, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO04__LPUART6_TX                                                  = IOMUX_PAD(0x01D0, 0x0020, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO04__LPI2C6_SDA                                                  = IOMUX_PAD(0x01D0, 0x0020, 0x06, 0x040C, 0x01, 0x00),
	MX91_PAD_GPIO_IO04__FLEXIO1_FLEXIO4                                             = IOMUX_PAD(0x01D0, 0x0020, 0x07, 0x037C, 0x00, 0x00),

	MX91_PAD_GPIO_IO05__GPIO2_IO5                                                   = IOMUX_PAD(0x01D4, 0x0024, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO05__TPM4_CH0                                                    = IOMUX_PAD(0x01D4, 0x0024, 0x01, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO05__PDM_BIT_STREAM0                                             = IOMUX_PAD(0x01D4, 0x0024, 0x02, 0x04C4, 0x00, 0x00),
	MX91_PAD_GPIO_IO05__MEDIAMIX_DISP_DATA1                                         = IOMUX_PAD(0x01D4, 0x0024, 0x03, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO05__LPSPI7_SIN                                                  = IOMUX_PAD(0x01D4, 0x0024, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO05__LPUART6_RX                                                  = IOMUX_PAD(0x01D4, 0x0024, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO05__LPI2C6_SCL                                                  = IOMUX_PAD(0x01D4, 0x0024, 0x06, 0x0408, 0x01, 0x00),
	MX91_PAD_GPIO_IO05__FLEXIO1_FLEXIO5                                             = IOMUX_PAD(0x01D4, 0x0024, 0x07, 0x0380, 0x00, 0x00),

	MX91_PAD_GPIO_IO06__GPIO2_IO6                                                   = IOMUX_PAD(0x01D8, 0x0028, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO06__TPM5_CH0                                                    = IOMUX_PAD(0x01D8, 0x0028, 0x01, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO06__PDM_BIT_STREAM1                                             = IOMUX_PAD(0x01D8, 0x0028, 0x02, 0x04C8, 0x00, 0x00),
	MX91_PAD_GPIO_IO06__MEDIAMIX_DISP_DATA2                                         = IOMUX_PAD(0x01D8, 0x0028, 0x03, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO06__LPSPI7_SOUT                                                 = IOMUX_PAD(0x01D8, 0x0028, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO06__LPUART6_CTS_B                                               = IOMUX_PAD(0x01D8, 0x0028, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO06__LPI2C7_SDA                                                  = IOMUX_PAD(0x01D8, 0x0028, 0x06, 0x0414, 0x00, 0x00),
	MX91_PAD_GPIO_IO06__FLEXIO1_FLEXIO6                                             = IOMUX_PAD(0x01D8, 0x0028, 0x07, 0x0384, 0x00, 0x00),

	MX91_PAD_GPIO_IO07__GPIO2_IO7                                                   = IOMUX_PAD(0x01DC, 0x002C, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO07__LPSPI3_PCS1                                                 = IOMUX_PAD(0x01DC, 0x002C, 0x01, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO07__MEDIAMIX_CAM_DATA1                                          = IOMUX_PAD(0x01DC, 0x002C, 0x02, 0x0494, 0x00, 0x00),
	MX91_PAD_GPIO_IO07__MEDIAMIX_DISP_DATA3                                         = IOMUX_PAD(0x01DC, 0x002C, 0x03, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO07__LPSPI7_SCK                                                  = IOMUX_PAD(0x01DC, 0x002C, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO07__LPUART6_RTS_B                                               = IOMUX_PAD(0x01DC, 0x002C, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO07__LPI2C7_SCL                                                  = IOMUX_PAD(0x01DC, 0x002C, 0x06, 0x0410, 0x00, 0x00),
	MX91_PAD_GPIO_IO07__FLEXIO1_FLEXIO7                                             = IOMUX_PAD(0x01DC, 0x002C, 0x07, 0x0388, 0x00, 0x00),

	MX91_PAD_GPIO_IO08__GPIO2_IO8                                                   = IOMUX_PAD(0x01E0, 0x0030, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO08__LPSPI3_PCS0                                                 = IOMUX_PAD(0x01E0, 0x0030, 0x01, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO08__MEDIAMIX_CAM_DATA2                                          = IOMUX_PAD(0x01E0, 0x0030, 0x02, 0x0498, 0x00, 0x00),
	MX91_PAD_GPIO_IO08__MEDIAMIX_DISP_DATA4                                         = IOMUX_PAD(0x01E0, 0x0030, 0x03, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO08__TPM6_CH0                                                    = IOMUX_PAD(0x01E0, 0x0030, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO08__LPUART7_TX                                                  = IOMUX_PAD(0x01E0, 0x0030, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO08__LPI2C7_SDA                                                  = IOMUX_PAD(0x01E0, 0x0030, 0x06, 0x0414, 0x01, 0x00),
	MX91_PAD_GPIO_IO08__FLEXIO1_FLEXIO8                                             = IOMUX_PAD(0x01E0, 0x0030, 0x07, 0x038C, 0x00, 0x00),

	MX91_PAD_GPIO_IO09__GPIO2_IO9                                                   = IOMUX_PAD(0x01E4, 0x0034, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO09__LPSPI3_SIN                                                  = IOMUX_PAD(0x01E4, 0x0034, 0x01, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO09__MEDIAMIX_CAM_DATA3                                          = IOMUX_PAD(0x01E4, 0x0034, 0x02, 0x049C, 0x00, 0x00),
	MX91_PAD_GPIO_IO09__MEDIAMIX_DISP_DATA5                                         = IOMUX_PAD(0x01E4, 0x0034, 0x03, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO09__TPM3_EXTCLK                                                 = IOMUX_PAD(0x01E4, 0x0034, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO09__LPUART7_RX                                                  = IOMUX_PAD(0x01E4, 0x0034, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO09__LPI2C7_SCL                                                  = IOMUX_PAD(0x01E4, 0x0034, 0x06, 0x0410, 0x01, 0x00),
	MX91_PAD_GPIO_IO09__FLEXIO1_FLEXIO9                                             = IOMUX_PAD(0x01E4, 0x0034, 0x07, 0x0390, 0x00, 0x00),

	MX91_PAD_GPIO_IO10__GPIO2_IO10                                                  = IOMUX_PAD(0x01E8, 0x0038, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO10__LPSPI3_SOUT                                                 = IOMUX_PAD(0x01E8, 0x0038, 0x01, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO10__MEDIAMIX_CAM_DATA4                                          = IOMUX_PAD(0x01E8, 0x0038, 0x02, 0x04A0, 0x00, 0x00),
	MX91_PAD_GPIO_IO10__MEDIAMIX_DISP_DATA6                                         = IOMUX_PAD(0x01E8, 0x0038, 0x03, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO10__TPM4_EXTCLK                                                 = IOMUX_PAD(0x01E8, 0x0038, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO10__LPUART7_CTS_B                                               = IOMUX_PAD(0x01E8, 0x0038, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO10__LPI2C8_SDA                                                  = IOMUX_PAD(0x01E8, 0x0038, 0x06, 0x041C, 0x00, 0x00),
	MX91_PAD_GPIO_IO10__FLEXIO1_FLEXIO10                                            = IOMUX_PAD(0x01E8, 0x0038, 0x07, 0x0394, 0x00, 0x00),

	MX91_PAD_GPIO_IO11__GPIO2_IO11                                                  = IOMUX_PAD(0x01EC, 0x003C, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO11__LPSPI3_SCK                                                  = IOMUX_PAD(0x01EC, 0x003C, 0x01, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO11__MEDIAMIX_CAM_DATA5                                          = IOMUX_PAD(0x01EC, 0x003C, 0x02, 0x04A4, 0x00, 0x00),
	MX91_PAD_GPIO_IO11__MEDIAMIX_DISP_DATA7                                         = IOMUX_PAD(0x01EC, 0x003C, 0x03, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO11__TPM5_EXTCLK                                                 = IOMUX_PAD(0x01EC, 0x003C, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO11__LPUART7_RTS_B                                               = IOMUX_PAD(0x01EC, 0x003C, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO11__LPI2C8_SCL                                                  = IOMUX_PAD(0x01EC, 0x003C, 0x06, 0x0418, 0x00, 0x00),
	MX91_PAD_GPIO_IO11__FLEXIO1_FLEXIO11                                            = IOMUX_PAD(0x01EC, 0x003C, 0x07, 0x0398, 0x00, 0x00),

	MX91_PAD_GPIO_IO12__GPIO2_IO12                                                  = IOMUX_PAD(0x01F0, 0x0040, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO12__TPM3_CH2                                                    = IOMUX_PAD(0x01F0, 0x0040, 0x01, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO12__PDM_BIT_STREAM2                                             = IOMUX_PAD(0x01F0, 0x0040, 0x02, 0x04CC, 0x00, 0x00),
	MX91_PAD_GPIO_IO12__MEDIAMIX_DISP_DATA8                                         = IOMUX_PAD(0x01F0, 0x0040, 0x03, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO12__LPSPI8_PCS0                                                 = IOMUX_PAD(0x01F0, 0x0040, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO12__LPUART8_TX                                                  = IOMUX_PAD(0x01F0, 0x0040, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO12__LPI2C8_SDA                                                  = IOMUX_PAD(0x01F0, 0x0040, 0x06, 0x041C, 0x01, 0x00),
	MX91_PAD_GPIO_IO12__SAI3_RX_SYNC                                                = IOMUX_PAD(0x01F0, 0x0040, 0x07, 0x04DC, 0x00, 0x00),

	MX91_PAD_GPIO_IO13__GPIO2_IO13                                                  = IOMUX_PAD(0x01F4, 0x0044, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO13__TPM4_CH2                                                    = IOMUX_PAD(0x01F4, 0x0044, 0x01, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO13__PDM_BIT_STREAM3                                             = IOMUX_PAD(0x01F4, 0x0044, 0x02, 0x04D0, 0x00, 0x00),
	MX91_PAD_GPIO_IO13__MEDIAMIX_DISP_DATA9                                         = IOMUX_PAD(0x01F4, 0x0044, 0x03, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO13__LPSPI8_SIN                                                  = IOMUX_PAD(0x01F4, 0x0044, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO13__LPUART8_RX                                                  = IOMUX_PAD(0x01F4, 0x0044, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO13__LPI2C8_SCL                                                  = IOMUX_PAD(0x01F4, 0x0044, 0x06, 0x0418, 0x01, 0x00),
	MX91_PAD_GPIO_IO13__FLEXIO1_FLEXIO13                                            = IOMUX_PAD(0x01F4, 0x0044, 0x07, 0x039C, 0x00, 0x00),

	MX91_PAD_GPIO_IO14__GPIO2_IO14                                                  = IOMUX_PAD(0x01F8, 0x0048, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO14__LPUART3_TX                                                  = IOMUX_PAD(0x01F8, 0x0048, 0x01, 0x0474, 0x00, 0x00),
	MX91_PAD_GPIO_IO14__MEDIAMIX_CAM_DATA6                                          = IOMUX_PAD(0x01F8, 0x0048, 0x02, 0x04A8, 0x00, 0x00),
	MX91_PAD_GPIO_IO14__MEDIAMIX_DISP_DATA10                                        = IOMUX_PAD(0x01F8, 0x0048, 0x03, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO14__LPSPI8_SOUT                                                 = IOMUX_PAD(0x01F8, 0x0048, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO14__LPUART8_CTS_B                                               = IOMUX_PAD(0x01F8, 0x0048, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO14__LPUART4_TX                                                  = IOMUX_PAD(0x01F8, 0x0048, 0x06, 0x0480, 0x00, 0x00),
	MX91_PAD_GPIO_IO14__FLEXIO1_FLEXIO14                                            = IOMUX_PAD(0x01F8, 0x0048, 0x07, 0x03A0, 0x00, 0x00),

	MX91_PAD_GPIO_IO15__GPIO2_IO15                                                  = IOMUX_PAD(0x01FC, 0x004C, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO15__LPUART3_RX                                                  = IOMUX_PAD(0x01FC, 0x004C, 0x01, 0x0470, 0x00, 0x00),
	MX91_PAD_GPIO_IO15__MEDIAMIX_CAM_DATA7                                          = IOMUX_PAD(0x01FC, 0x004C, 0x02, 0x04AC, 0x00, 0x00),
	MX91_PAD_GPIO_IO15__MEDIAMIX_DISP_DATA11                                        = IOMUX_PAD(0x01FC, 0x004C, 0x03, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO15__LPSPI8_SCK                                                  = IOMUX_PAD(0x01FC, 0x004C, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO15__LPUART8_RTS_B                                               = IOMUX_PAD(0x01FC, 0x004C, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO15__LPUART4_RX                                                  = IOMUX_PAD(0x01FC, 0x004C, 0x06, 0x047C, 0x00, 0x00),
	MX91_PAD_GPIO_IO15__FLEXIO1_FLEXIO15                                            = IOMUX_PAD(0x01FC, 0x004C, 0x07, 0x03A4, 0x00, 0x00),

	MX91_PAD_GPIO_IO16__GPIO2_IO16                                                  = IOMUX_PAD(0x0200, 0x0050, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO16__SAI3_TX_BCLK                                                = IOMUX_PAD(0x0200, 0x0050, 0x01, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO16__PDM_BIT_STREAM2                                             = IOMUX_PAD(0x0200, 0x0050, 0x02, 0x04CC, 0x01, 0x00),
	MX91_PAD_GPIO_IO16__MEDIAMIX_DISP_DATA12                                        = IOMUX_PAD(0x0200, 0x0050, 0x03, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO16__LPUART3_CTS_B                                               = IOMUX_PAD(0x0200, 0x0050, 0x04, 0x046C, 0x00, 0x00),
	MX91_PAD_GPIO_IO16__LPSPI4_PCS2                                                 = IOMUX_PAD(0x0200, 0x0050, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO16__LPUART4_CTS_B                                               = IOMUX_PAD(0x0200, 0x0050, 0x06, 0x0478, 0x00, 0x00),
	MX91_PAD_GPIO_IO16__FLEXIO1_FLEXIO16                                            = IOMUX_PAD(0x0200, 0x0050, 0x07, 0x03A8, 0x00, 0x00),

	MX91_PAD_GPIO_IO17__GPIO2_IO17                                                  = IOMUX_PAD(0x0204, 0x0054, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO17__SAI3_MCLK                                                   = IOMUX_PAD(0x0204, 0x0054, 0x01, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO17__MEDIAMIX_CAM_DATA8                                          = IOMUX_PAD(0x0204, 0x0054, 0x02, 0x04B0, 0x00, 0x00),
	MX91_PAD_GPIO_IO17__MEDIAMIX_DISP_DATA13                                        = IOMUX_PAD(0x0204, 0x0054, 0x03, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO17__LPUART3_RTS_B                                               = IOMUX_PAD(0x0204, 0x0054, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO17__LPSPI4_PCS1                                                 = IOMUX_PAD(0x0204, 0x0054, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO17__LPUART4_RTS_B                                               = IOMUX_PAD(0x0204, 0x0054, 0x06, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO17__FLEXIO1_FLEXIO17                                            = IOMUX_PAD(0x0204, 0x0054, 0x07, 0x03AC, 0x00, 0x00),

	MX91_PAD_GPIO_IO18__GPIO2_IO18                                                  = IOMUX_PAD(0x0208, 0x0058, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO18__SAI3_RX_BCLK                                                = IOMUX_PAD(0x0208, 0x0058, 0x01, 0x04D8, 0x00, 0x00),
	MX91_PAD_GPIO_IO18__MEDIAMIX_CAM_DATA9                                          = IOMUX_PAD(0x0208, 0x0058, 0x02, 0x04B4, 0x00, 0x00),
	MX91_PAD_GPIO_IO18__MEDIAMIX_DISP_DATA14                                        = IOMUX_PAD(0x0208, 0x0058, 0x03, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO18__LPSPI5_PCS0                                                 = IOMUX_PAD(0x0208, 0x0058, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO18__LPSPI4_PCS0                                                 = IOMUX_PAD(0x0208, 0x0058, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO18__TPM5_CH2                                                    = IOMUX_PAD(0x0208, 0x0058, 0x06, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO18__FLEXIO1_FLEXIO18                                            = IOMUX_PAD(0x0208, 0x0058, 0x07, 0x03B0, 0x00, 0x00),

	MX91_PAD_GPIO_IO19__GPIO2_IO19                                                  = IOMUX_PAD(0x020C, 0x005C, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO19__SAI3_RX_SYNC                                                = IOMUX_PAD(0x020C, 0x005C, 0x01, 0x04DC, 0x01, 0x00),
	MX91_PAD_GPIO_IO19__PDM_BIT_STREAM3                                             = IOMUX_PAD(0x020C, 0x005C, 0x02, 0x04D0, 0x01, 0x00),
	MX91_PAD_GPIO_IO19__MEDIAMIX_DISP_DATA15                                        = IOMUX_PAD(0x020C, 0x005C, 0x03, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO19__LPSPI5_SIN                                                  = IOMUX_PAD(0x020C, 0x005C, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO19__LPSPI4_SIN                                                  = IOMUX_PAD(0x020C, 0x005C, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO19__TPM6_CH2                                                    = IOMUX_PAD(0x020C, 0x005C, 0x06, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO19__SAI3_TX_DATA0                                               = IOMUX_PAD(0x020C, 0x005C, 0x07, 0x0000, 0x00, 0x00),

	MX91_PAD_GPIO_IO20__GPIO2_IO20                                                  = IOMUX_PAD(0x0210, 0x0060, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO20__SAI3_RX_DATA0                                               = IOMUX_PAD(0x0210, 0x0060, 0x01, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO20__PDM_BIT_STREAM0                                             = IOMUX_PAD(0x0210, 0x0060, 0x02, 0x04C4, 0x01, 0x00),
	MX91_PAD_GPIO_IO20__MEDIAMIX_DISP_DATA16                                        = IOMUX_PAD(0x0210, 0x0060, 0x03, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO20__LPSPI5_SOUT                                                 = IOMUX_PAD(0x0210, 0x0060, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO20__LPSPI4_SOUT                                                 = IOMUX_PAD(0x0210, 0x0060, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO20__TPM3_CH1                                                    = IOMUX_PAD(0x0210, 0x0060, 0x06, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO20__FLEXIO1_FLEXIO20                                            = IOMUX_PAD(0x0210, 0x0060, 0x07, 0x03B4, 0x00, 0x00),

	MX91_PAD_GPIO_IO21__GPIO2_IO21                                                  = IOMUX_PAD(0x0214, 0x0064, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO21__SAI3_TX_DATA0                                               = IOMUX_PAD(0x0214, 0x0064, 0x01, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO21__PDM_CLK                                                     = IOMUX_PAD(0x0214, 0x0064, 0x02, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO21__MEDIAMIX_DISP_DATA17                                        = IOMUX_PAD(0x0214, 0x0064, 0x03, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO21__LPSPI5_SCK                                                  = IOMUX_PAD(0x0214, 0x0064, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO21__LPSPI4_SCK                                                  = IOMUX_PAD(0x0214, 0x0064, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO21__TPM4_CH1                                                    = IOMUX_PAD(0x0214, 0x0064, 0x06, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO21__SAI3_RX_BCLK                                                = IOMUX_PAD(0x0214, 0x0064, 0x07, 0x04D8, 0x01, 0x00),

	MX91_PAD_GPIO_IO22__GPIO2_IO22                                                  = IOMUX_PAD(0x0218, 0x0068, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO22__USDHC3_CLK                                                  = IOMUX_PAD(0x0218, 0x0068, 0x01, 0x04E8, 0x00, 0x00),
	MX91_PAD_GPIO_IO22__SPDIF_IN                                                    = IOMUX_PAD(0x0218, 0x0068, 0x02, 0x04E4, 0x00, 0x00),
	MX91_PAD_GPIO_IO22__MEDIAMIX_DISP_DATA18                                        = IOMUX_PAD(0x0218, 0x0068, 0x03, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO22__TPM5_CH1                                                    = IOMUX_PAD(0x0218, 0x0068, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO22__TPM6_EXTCLK                                                 = IOMUX_PAD(0x0218, 0x0068, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO22__LPI2C5_SDA                                                  = IOMUX_PAD(0x0218, 0x0068, 0x06, 0x0404, 0x01, 0x00),
	MX91_PAD_GPIO_IO22__FLEXIO1_FLEXIO22                                            = IOMUX_PAD(0x0218, 0x0068, 0x07, 0x03B8, 0x00, 0x00),

	MX91_PAD_GPIO_IO23__GPIO2_IO23                                                  = IOMUX_PAD(0x021C, 0x006C, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO23__USDHC3_CMD                                                  = IOMUX_PAD(0x021C, 0x006C, 0x01, 0x04EC, 0x00, 0x00),
	MX91_PAD_GPIO_IO23__SPDIF_OUT                                                   = IOMUX_PAD(0x021C, 0x006C, 0x02, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO23__MEDIAMIX_DISP_DATA19                                        = IOMUX_PAD(0x021C, 0x006C, 0x03, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO23__TPM6_CH1                                                    = IOMUX_PAD(0x021C, 0x006C, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO23__LPI2C5_SCL                                                  = IOMUX_PAD(0x021C, 0x006C, 0x06, 0x0400, 0x01, 0x00),
	MX91_PAD_GPIO_IO23__FLEXIO1_FLEXIO23                                            = IOMUX_PAD(0x021C, 0x006C, 0x07, 0x03BC, 0x00, 0x00),

	MX91_PAD_GPIO_IO24__GPIO2_IO24                                                  = IOMUX_PAD(0x0220, 0x0070, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO24__USDHC3_DATA0                                                = IOMUX_PAD(0x0220, 0x0070, 0x01, 0x04F0, 0x00, 0x00),
	MX91_PAD_GPIO_IO24__MEDIAMIX_DISP_DATA20                                        = IOMUX_PAD(0x0220, 0x0070, 0x03, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO24__TPM3_CH3                                                    = IOMUX_PAD(0x0220, 0x0070, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO24__JTAG_MUX_TDO                                                = IOMUX_PAD(0x0220, 0x0070, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO24__LPSPI6_PCS1                                                 = IOMUX_PAD(0x0220, 0x0070, 0x06, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO24__FLEXIO1_FLEXIO24                                            = IOMUX_PAD(0x0220, 0x0070, 0x07, 0x03C0, 0x00, 0x00),

	MX91_PAD_GPIO_IO25__GPIO2_IO25                                                  = IOMUX_PAD(0x0224, 0x0074, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO25__USDHC3_DATA1                                                = IOMUX_PAD(0x0224, 0x0074, 0x01, 0x04F4, 0x00, 0x00),
	MX91_PAD_GPIO_IO25__CAN2_TX                                                     = IOMUX_PAD(0x0224, 0x0074, 0x02, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO25__MEDIAMIX_DISP_DATA21                                        = IOMUX_PAD(0x0224, 0x0074, 0x03, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO25__TPM4_CH3                                                    = IOMUX_PAD(0x0224, 0x0074, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO25__JTAG_MUX_TCK                                                = IOMUX_PAD(0x0224, 0x0074, 0x05, 0x03D4, 0x01, 0x00),
	MX91_PAD_GPIO_IO25__LPSPI7_PCS1                                                 = IOMUX_PAD(0x0224, 0x0074, 0x06, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO25__FLEXIO1_FLEXIO25                                            = IOMUX_PAD(0x0224, 0x0074, 0x07, 0x03C4, 0x00, 0x00),

	MX91_PAD_GPIO_IO26__GPIO2_IO26                                                  = IOMUX_PAD(0x0228, 0x0078, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO26__USDHC3_DATA2                                                = IOMUX_PAD(0x0228, 0x0078, 0x01, 0x04F8, 0x00, 0x00),
	MX91_PAD_GPIO_IO26__PDM_BIT_STREAM1                                             = IOMUX_PAD(0x0228, 0x0078, 0x02, 0x04C8, 0x01, 0x00),
	MX91_PAD_GPIO_IO26__MEDIAMIX_DISP_DATA22                                        = IOMUX_PAD(0x0228, 0x0078, 0x03, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO26__TPM5_CH3                                                    = IOMUX_PAD(0x0228, 0x0078, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO26__JTAG_MUX_TDI                                                = IOMUX_PAD(0x0228, 0x0078, 0x05, 0x03D8, 0x01, 0x00),
	MX91_PAD_GPIO_IO26__LPSPI8_PCS1                                                 = IOMUX_PAD(0x0228, 0x0078, 0x06, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO26__SAI3_TX_SYNC                                                = IOMUX_PAD(0x0228, 0x0078, 0x07, 0x04E0, 0x00, 0x00),

	MX91_PAD_GPIO_IO27__GPIO2_IO27                                                  = IOMUX_PAD(0x022C, 0x007C, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO27__USDHC3_DATA3                                                = IOMUX_PAD(0x022C, 0x007C, 0x01, 0x04FC, 0x00, 0x00),
	MX91_PAD_GPIO_IO27__CAN2_RX                                                     = IOMUX_PAD(0x022C, 0x007C, 0x02, 0x0364, 0x01, 0x00),
	MX91_PAD_GPIO_IO27__MEDIAMIX_DISP_DATA23                                        = IOMUX_PAD(0x022C, 0x007C, 0x03, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO27__TPM6_CH3                                                    = IOMUX_PAD(0x022C, 0x007C, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO27__JTAG_MUX_TMS                                                = IOMUX_PAD(0x022C, 0x007C, 0x05, 0x03DC, 0x01, 0x00),
	MX91_PAD_GPIO_IO27__LPSPI5_PCS1                                                 = IOMUX_PAD(0x022C, 0x007C, 0x06, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO27__FLEXIO1_FLEXIO27                                            = IOMUX_PAD(0x022C, 0x007C, 0x07, 0x03C8, 0x00, 0x00),

	MX91_PAD_GPIO_IO28__GPIO2_IO28                                                  = IOMUX_PAD(0x0230, 0x0080, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO28__LPI2C3_SDA                                                  = IOMUX_PAD(0x0230, 0x0080, 0x01, 0x03F4, 0x01, 0x00),
	MX91_PAD_GPIO_IO28__CAN1_TX                                                     = IOMUX_PAD(0x0230, 0x0080, 0x02, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO28__FLEXIO1_FLEXIO28                                            = IOMUX_PAD(0x0230, 0x0080, 0x07, 0x0000, 0x00, 0x00),

	MX91_PAD_GPIO_IO29__GPIO2_IO29                                                  = IOMUX_PAD(0x0234, 0x0084, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_GPIO_IO29__LPI2C3_SCL                                                  = IOMUX_PAD(0x0234, 0x0084, 0x01, 0x03F0, 0x01, 0x00),
	MX91_PAD_GPIO_IO29__CAN1_RX                                                     = IOMUX_PAD(0x0234, 0x0084, 0x02, 0x0360, 0x00, 0x00),
	MX91_PAD_GPIO_IO29__FLEXIO1_FLEXIO29                                            = IOMUX_PAD(0x0234, 0x0084, 0x07, 0x0000, 0x00, 0x00),

	MX91_PAD_CCM_CLKO1__CCMSRCGPCMIX_CLKO1                                          = IOMUX_PAD(0x0238, 0x0088, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_CCM_CLKO1__FLEXIO1_FLEXIO26                                            = IOMUX_PAD(0x0238, 0x0088, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_CCM_CLKO1__GPIO3_IO26                                                  = IOMUX_PAD(0x0238, 0x0088, 0x05, 0x0000, 0x00, 0x00),

	MX91_PAD_CCM_CLKO2__GPIO3_IO27                                                  = IOMUX_PAD(0x023C, 0x008C, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_CCM_CLKO2__CCMSRCGPCMIX_CLKO2                                          = IOMUX_PAD(0x023C, 0x008C, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_CCM_CLKO2__FLEXIO1_FLEXIO27                                            = IOMUX_PAD(0x023C, 0x008C, 0x04, 0x03C8, 0x01, 0x00),

	MX91_PAD_CCM_CLKO3__CCMSRCGPCMIX_CLKO3                                          = IOMUX_PAD(0x0240, 0x0090, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_CCM_CLKO3__FLEXIO2_FLEXIO28                                            = IOMUX_PAD(0x0240, 0x0090, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_CCM_CLKO3__GPIO4_IO28                                                  = IOMUX_PAD(0x0240, 0x0090, 0x05, 0x0000, 0x00, 0x00),

	MX91_PAD_CCM_CLKO4__CCMSRCGPCMIX_CLKO4                                          = IOMUX_PAD(0x0244, 0x0094, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_CCM_CLKO4__FLEXIO2_FLEXIO29                                            = IOMUX_PAD(0x0244, 0x0094, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_CCM_CLKO4__GPIO4_IO29                                                  = IOMUX_PAD(0x0244, 0x0094, 0x05, 0x0000, 0x00, 0x00),

	MX91_PAD_ENET1_MDC__ENET1_MDC                                                   = IOMUX_PAD(0x0248, 0x0098, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET1_MDC__LPUART3_DCB_B                                               = IOMUX_PAD(0x0248, 0x0098, 0x01, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET1_MDC__I3C2_SCL                                                    = IOMUX_PAD(0x0248, 0x0098, 0x02, 0x03CC, 0x00, 0x00),
	MX91_PAD_ENET1_MDC__HSIOMIX_OTG_ID1                                             = IOMUX_PAD(0x0248, 0x0098, 0x03, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET1_MDC__FLEXIO2_FLEXIO0                                             = IOMUX_PAD(0x0248, 0x0098, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET1_MDC__GPIO4_IO0                                                   = IOMUX_PAD(0x0248, 0x0098, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET1_MDC__LPI2C1_SCL                                                  = IOMUX_PAD(0x0248, 0x0098, 0x06, 0x03E0, 0x00, 0x00),

	MX91_PAD_ENET1_MDIO__ENET_QOS_MDIO                                              = IOMUX_PAD(0x024C, 0x009C, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET1_MDIO__LPUART3_RIN_B                                              = IOMUX_PAD(0x024C, 0x009C, 0x01, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET1_MDIO__I3C2_SDA                                                   = IOMUX_PAD(0x024C, 0x009C, 0x02, 0x03D0, 0x00, 0x00),
	MX91_PAD_ENET1_MDIO__HSIOMIX_OTG_PWR1                                           = IOMUX_PAD(0x024C, 0x009C, 0x03, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET1_MDIO__FLEXIO2_FLEXIO1                                            = IOMUX_PAD(0x024C, 0x009C, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET1_MDIO__GPIO4_IO1                                                  = IOMUX_PAD(0x024C, 0x009C, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET1_MDIO__LPI2C1_SDA                                                 = IOMUX_PAD(0x024C, 0x009C, 0x06, 0x03E4, 0x00, 0x00),

	MX91_PAD_ENET1_TD3__ENET_QOS_RGMII_TD3                                          = IOMUX_PAD(0x0250, 0x00A0, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET1_TD3__CAN2_TX                                                     = IOMUX_PAD(0x0250, 0x00A0, 0x02, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET1_TD3__HSIOMIX_OTG_ID2                                             = IOMUX_PAD(0x0250, 0x00A0, 0x03, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET1_TD3__FLEXIO2_FLEXIO2                                             = IOMUX_PAD(0x0250, 0x00A0, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET1_TD3__GPIO4_IO3                                                   = IOMUX_PAD(0x0250, 0x00A0, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET1_TD3__LPI2C2_SCL                                                  = IOMUX_PAD(0x0250, 0x00A0, 0x06, 0x03E8, 0x00, 0x00),

	MX91_PAD_ENET1_TD2__ENET_QOS_RGMII_TD2                                          = IOMUX_PAD(0x0254, 0x00A4, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET1_TD2__ENET_QOS_CLOCK_GENERATE_CLK                                 = IOMUX_PAD(0x0254, 0x00A4, 0x01, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET1_TD2__CAN2_RX                                                     = IOMUX_PAD(0x0254, 0x00A4, 0x02, 0x0364, 0x02, 0x00),
	MX91_PAD_ENET1_TD2__HSIOMIX_OTG_OC2                                             = IOMUX_PAD(0x0254, 0x00A4, 0x03, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET1_TD2__FLEXIO2_FLEXIO3                                             = IOMUX_PAD(0x0254, 0x00A4, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET1_TD2__GPIO4_IO3                                                   = IOMUX_PAD(0x0254, 0x00A4, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET1_TD2__LPI2C2_SDA                                                  = IOMUX_PAD(0x0254, 0x00A4, 0x06, 0x03EC, 0x00, 0x00),

	MX91_PAD_ENET1_TD1__ENET1_RGMII_TD1                                             = IOMUX_PAD(0x0258, 0x00A8, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET1_TD1__LPUART3_RTS_B                                               = IOMUX_PAD(0x0258, 0x00A8, 0x01, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET1_TD1__I3C2_PUR                                                    = IOMUX_PAD(0x0258, 0x00A8, 0x02, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET1_TD1__HSIOMIX_OTG_OC1                                             = IOMUX_PAD(0x0258, 0x00A8, 0x03, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET1_TD1__FLEXIO2_FLEXIO4                                             = IOMUX_PAD(0x0258, 0x00A8, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET1_TD1__GPIO4_IO4                                                   = IOMUX_PAD(0x0258, 0x00A8, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET1_TD1__I3C2_PUR_B                                                  = IOMUX_PAD(0x0258, 0x00A8, 0x06, 0x0000, 0x00, 0x00),

	MX91_PAD_ENET1_TD0__ENET_QOS_RGMII_TD0                                          = IOMUX_PAD(0x025C, 0x00AC, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET1_TD0__LPUART3_TX                                                  = IOMUX_PAD(0x025C, 0x00AC, 0x01, 0x0474, 0x01, 0x00),
	MX91_PAD_ENET1_TD0__FLEXIO2_FLEXIO5                                             = IOMUX_PAD(0x025C, 0x00AC, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET1_TD0__GPIO4_IO5                                                   = IOMUX_PAD(0x025C, 0x00AC, 0x05, 0x0000, 0x00, 0x00),

	MX91_PAD_ENET1_TX_CTL__ENET_QOS_RGMII_TX_CTL                                    = IOMUX_PAD(0x0260, 0x00B0, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET1_TX_CTL__LPUART3_DTR_B                                            = IOMUX_PAD(0x0260, 0x00B0, 0x01, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET1_TX_CTL__FLEXIO2_FLEXIO6                                          = IOMUX_PAD(0x0260, 0x00B0, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET1_TX_CTL__GPIO4_IO6                                                = IOMUX_PAD(0x0260, 0x00B0, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET1_TX_CTL__LPSPI2_SCK                                               = IOMUX_PAD(0x0260, 0x00B0, 0x02, 0x043C, 0x00, 0x00),

	MX91_PAD_ENET1_TXC__CCM_ENET_QOS_CLOCK_GENERATE_TX_CLK                          = IOMUX_PAD(0x0264, 0x00B4, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET1_TXC__ENET_QOS_TX_ER                                              = IOMUX_PAD(0x0264, 0x00B4, 0x01, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET1_TXC__FLEXIO2_FLEXIO7                                             = IOMUX_PAD(0x0264, 0x00B4, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET1_TXC__GPIO4_IO7                                                   = IOMUX_PAD(0x0264, 0x00B4, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET1_TXC__LPSPI2_SIN                                                  = IOMUX_PAD(0x0264, 0x00B4, 0x02, 0x0440, 0x00, 0x00),

	MX91_PAD_ENET1_RX_CTL__ENET_QOS_RGMII_RX_CTL                                    = IOMUX_PAD(0x0268, 0x00B8, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET1_RX_CTL__LPUART3_DSR_B                                            = IOMUX_PAD(0x0268, 0x00B8, 0x01, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET1_RX_CTL__HSIOMIX_OTG_PWR2                                         = IOMUX_PAD(0x0268, 0x00B8, 0x03, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET1_RX_CTL__FLEXIO2_FLEXIO8                                          = IOMUX_PAD(0x0268, 0x00B8, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET1_RX_CTL__GPIO4_IO8                                                = IOMUX_PAD(0x0268, 0x00B8, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET1_RX_CTL__LPSPI2_PCS0                                              = IOMUX_PAD(0x0268, 0x00B8, 0x02, 0x0434, 0x00, 0x00),

	MX91_PAD_ENET1_RXC__ENET_QOS_RGMII_RXC                                          = IOMUX_PAD(0x026C, 0x00BC, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET1_RXC__ENET_QOS_RX_ER                                              = IOMUX_PAD(0x026C, 0x00BC, 0x01, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET1_RXC__FLEXIO2_FLEXIO9                                             = IOMUX_PAD(0x026C, 0x00BC, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET1_RXC__GPIO4_IO9                                                   = IOMUX_PAD(0x026C, 0x00BC, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET1_RXC__LPSPI2_SOUT                                                 = IOMUX_PAD(0x026C, 0x00BC, 0x02, 0x0444, 0x00, 0x00),

	MX91_PAD_ENET1_RD0__ENET_QOS_RGMII_RD0                                          = IOMUX_PAD(0x0270, 0x00C0, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET1_RD0__LPUART3_RX                                                  = IOMUX_PAD(0x0270, 0x00C0, 0x01, 0x0470, 0x01, 0x00),
	MX91_PAD_ENET1_RD0__FLEXIO2_FLEXIO10                                            = IOMUX_PAD(0x0270, 0x00C0, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET1_RD0__GPIO4_IO10                                                  = IOMUX_PAD(0x0270, 0x00C0, 0x05, 0x0000, 0x00, 0x00),

	MX91_PAD_ENET1_RD1__ENET_QOS_RGMII_RD1                                          = IOMUX_PAD(0x0274, 0x00C4, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET1_RD1__LPUART3_CTS_B                                               = IOMUX_PAD(0x0274, 0x00C4, 0x01, 0x046C, 0x01, 0x00),
	MX91_PAD_ENET1_RD1__LPTMR2_ALT1                                                 = IOMUX_PAD(0x0274, 0x00C4, 0x03, 0x0448, 0x00, 0x00),
	MX91_PAD_ENET1_RD1__FLEXIO2_FLEXIO11                                            = IOMUX_PAD(0x0274, 0x00C4, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET1_RD1__GPIO4_IO11                                                  = IOMUX_PAD(0x0274, 0x00C4, 0x05, 0x0000, 0x00, 0x00),

	MX91_PAD_ENET1_RD2__ENET_QOS_RGMII_RD2                                          = IOMUX_PAD(0x0278, 0x00C8, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET1_RD2__LPTMR2_ALT2                                                 = IOMUX_PAD(0x0278, 0x00C8, 0x03, 0x044C, 0x00, 0x00),
	MX91_PAD_ENET1_RD2__FLEXIO2_FLEXIO12                                            = IOMUX_PAD(0x0278, 0x00C8, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET1_RD2__GPIO4_IO12                                                  = IOMUX_PAD(0x0278, 0x00C8, 0x05, 0x0000, 0x00, 0x00),

	MX91_PAD_ENET1_RD3__ENET_QOS_RGMII_RD3                                          = IOMUX_PAD(0x027C, 0x00CC, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET1_RD3__FLEXSPI1_TESTER_TRIGGER                                     = IOMUX_PAD(0x027C, 0x00CC, 0x02, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET1_RD3__LPTMR2_ALT3                                                 = IOMUX_PAD(0x027C, 0x00CC, 0x03, 0x0450, 0x00, 0x00),
	MX91_PAD_ENET1_RD3__FLEXIO2_FLEXIO13                                            = IOMUX_PAD(0x027C, 0x00CC, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET1_RD3__GPIO4_IO13                                                  = IOMUX_PAD(0x027C, 0x00CC, 0x05, 0x0000, 0x00, 0x00),

	MX91_PAD_ENET2_MDC__ENET2_MDC                                                   = IOMUX_PAD(0x0280, 0x00D0, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET2_MDC__LPUART4_DCB_B                                               = IOMUX_PAD(0x0280, 0x00D0, 0x01, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET2_MDC__SAI2_RX_SYNC                                                = IOMUX_PAD(0x0280, 0x00D0, 0x02, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET2_MDC__FLEXIO2_FLEXIO14                                            = IOMUX_PAD(0x0280, 0x00D0, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET2_MDC__GPIO4_IO14                                                  = IOMUX_PAD(0x0280, 0x00D0, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET2_MDC__MEDIAMIX_CAM_CLK                                            = IOMUX_PAD(0x0280, 0x00D0, 0x06, 0x04BC, 0x01, 0x00),

	MX91_PAD_ENET2_MDIO__ENET2_MDIO                                                 = IOMUX_PAD(0x0284, 0x00D4, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET2_MDIO__LPUART4_RIN_B                                              = IOMUX_PAD(0x0284, 0x00D4, 0x01, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET2_MDIO__SAI2_RX_BCLK                                               = IOMUX_PAD(0x0284, 0x00D4, 0x02, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET2_MDIO__FLEXIO2_FLEXIO15                                           = IOMUX_PAD(0x0284, 0x00D4, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET2_MDIO__GPIO4_IO15                                                 = IOMUX_PAD(0x0284, 0x00D4, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET2_MDIO__MEDIAMIX_CAM_DATA0                                         = IOMUX_PAD(0x0284, 0x00D4, 0x06, 0x0490, 0x01, 0x00),

	MX91_PAD_ENET2_TD3__SAI2_RX_DATA0                                               = IOMUX_PAD(0x0288, 0x00D8, 0x02, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET2_TD3__FLEXIO2_FLEXIO16                                            = IOMUX_PAD(0x0288, 0x00D8, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET2_TD3__GPIO4_IO16                                                  = IOMUX_PAD(0x0288, 0x00D8, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET2_TD3__MEDIAMIX_CAM_VSYNC                                          = IOMUX_PAD(0x0288, 0x00D8, 0x06, 0x04C0, 0x01, 0x00),
	MX91_PAD_ENET2_TD3__ENET2_RGMII_TD3                                             = IOMUX_PAD(0x0288, 0x00D8, 0x00, 0x0000, 0x00, 0x00),

	MX91_PAD_ENET2_TD2__ENET2_RGMII_TD2                                             = IOMUX_PAD(0x028C, 0x00DC, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET2_TD2__ENET2_TX_CLK2                                               = IOMUX_PAD(0x028C, 0x00DC, 0x01, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET2_TD2__FLEXIO2_FLEXIO17                                            = IOMUX_PAD(0x028C, 0x00DC, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET2_TD2__GPIO4_IO17                                                  = IOMUX_PAD(0x028C, 0x00DC, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET2_TD2__MEDIAMIX_CAM_HSYNC                                          = IOMUX_PAD(0x028C, 0x00DC, 0x06, 0x04B8, 0x01, 0x00),

	MX91_PAD_ENET2_TD1__ENET2_RGMII_TD1                                             = IOMUX_PAD(0x0290, 0x00E0, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET2_TD1__LPUART4_RTS_B                                               = IOMUX_PAD(0x0290, 0x00E0, 0x01, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET2_TD1__FLEXIO2_FLEXIO18                                            = IOMUX_PAD(0x0290, 0x00E0, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET2_TD1__GPIO4_IO18                                                  = IOMUX_PAD(0x0290, 0x00E0, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET2_TD1__MEDIAMIX_CAM_DATA1                                          = IOMUX_PAD(0x0290, 0x00E0, 0x06, 0x0494, 0x01, 0x00),

	MX91_PAD_ENET2_TD0__ENET2_RGMII_TD0                                             = IOMUX_PAD(0x0294, 0x00E4, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET2_TD0__LPUART4_TX                                                  = IOMUX_PAD(0x0294, 0x00E4, 0x01, 0x0480, 0x01, 0x00),
	MX91_PAD_ENET2_TD0__FLEXIO2_FLEXIO19                                            = IOMUX_PAD(0x0294, 0x00E4, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET2_TD0__GPIO4_IO19                                                  = IOMUX_PAD(0x0294, 0x00E4, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET2_TD0__MEDIAMIX_CAM_DATA2                                          = IOMUX_PAD(0x0294, 0x00E4, 0x06, 0x0498, 0x01, 0x00),

	MX91_PAD_ENET2_TX_CTL__ENET2_RGMII_TX_CTL                                       = IOMUX_PAD(0x0298, 0x00E8, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET2_TX_CTL__LPUART4_DTR_B                                            = IOMUX_PAD(0x0298, 0x00E8, 0x01, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET2_TX_CTL__SAI2_TX_SYNC                                             = IOMUX_PAD(0x0298, 0x00E8, 0x02, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET2_TX_CTL__FLEXIO2_FLEXIO20                                         = IOMUX_PAD(0x0298, 0x00E8, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET2_TX_CTL__GPIO4_IO20                                               = IOMUX_PAD(0x0298, 0x00E8, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET2_TX_CTL__MEDIAMIX_CAM_DATA3                                       = IOMUX_PAD(0x0298, 0x00E8, 0x06, 0x049C, 0x01, 0x00),

	MX91_PAD_ENET2_TXC__ENET2_RGMII_TXC                                             = IOMUX_PAD(0x029C, 0x00EC, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET2_TXC__ENET2_TX_ER                                                 = IOMUX_PAD(0x029C, 0x00EC, 0x01, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET2_TXC__SAI2_TX_BCLK                                                = IOMUX_PAD(0x029C, 0x00EC, 0x02, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET2_TXC__FLEXIO2_FLEXIO21                                            = IOMUX_PAD(0x029C, 0x00EC, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET2_TXC__GPIO4_IO21                                                  = IOMUX_PAD(0x029C, 0x00EC, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET2_TXC__MEDIAMIX_CAM_DATA4                                          = IOMUX_PAD(0x029C, 0x00EC, 0x06, 0x04A0, 0x01, 0x00),

	MX91_PAD_ENET2_RX_CTL__ENET2_RGMII_RX_CTL                                       = IOMUX_PAD(0x02A0, 0x00F0, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET2_RX_CTL__LPUART4_DSR_B                                            = IOMUX_PAD(0x02A0, 0x00F0, 0x01, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET2_RX_CTL__SAI2_TX_DATA0                                            = IOMUX_PAD(0x02A0, 0x00F0, 0x02, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET2_RX_CTL__FLEXIO2_FLEXIO22                                         = IOMUX_PAD(0x02A0, 0x00F0, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET2_RX_CTL__GPIO4_IO22                                               = IOMUX_PAD(0x02A0, 0x00F0, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET2_RX_CTL__MEDIAMIX_CAM_DATA5                                       = IOMUX_PAD(0x02A0, 0x00F0, 0x06, 0x04A4, 0x01, 0x00),

	MX91_PAD_ENET2_RXC__ENET2_RGMII_RXC                                             = IOMUX_PAD(0x02A4, 0x00F4, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET2_RXC__ENET2_RX_ER                                                 = IOMUX_PAD(0x02A4, 0x00F4, 0x01, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET2_RXC__FLEXIO2_FLEXIO23                                            = IOMUX_PAD(0x02A4, 0x00F4, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET2_RXC__GPIO4_IO23                                                  = IOMUX_PAD(0x02A4, 0x00F4, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET2_RXC__MEDIAMIX_CAM_DATA6                                          = IOMUX_PAD(0x02A4, 0x00F4, 0x06, 0x04A8, 0x01, 0x00),

	MX91_PAD_ENET2_RD0__ENET2_RGMII_RD0                                             = IOMUX_PAD(0x02A8, 0x00F8, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET2_RD0__LPUART4_RX                                                  = IOMUX_PAD(0x02A8, 0x00F8, 0x01, 0x047C, 0x01, 0x00),
	MX91_PAD_ENET2_RD0__FLEXIO2_FLEXIO24                                            = IOMUX_PAD(0x02A8, 0x00F8, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET2_RD0__GPIO4_IO24                                                  = IOMUX_PAD(0x02A8, 0x00F8, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET2_RD0__MEDIAMIX_CAM_DATA7                                          = IOMUX_PAD(0x02A8, 0x00F8, 0x06, 0x04AC, 0x01, 0x00),

	MX91_PAD_ENET2_RD1__ENET2_RGMII_RD1                                             = IOMUX_PAD(0x02AC, 0x00FC, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET2_RD1__SPDIF_IN                                                    = IOMUX_PAD(0x02AC, 0x00FC, 0x01, 0x04E4, 0x01, 0x00),
	MX91_PAD_ENET2_RD1__FLEXIO2_FLEXIO25                                            = IOMUX_PAD(0x02AC, 0x00FC, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET2_RD1__GPIO4_IO25                                                  = IOMUX_PAD(0x02AC, 0x00FC, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET2_RD1__MEDIAMIX_CAM_DATA8                                          = IOMUX_PAD(0x02AC, 0x00FC, 0x06, 0x04B0, 0x01, 0x00),

	MX91_PAD_ENET2_RD2__ENET2_RGMII_RD2                                             = IOMUX_PAD(0x02B0, 0x0100, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET2_RD2__LPUART4_CTS_B                                               = IOMUX_PAD(0x02B0, 0x0100, 0x01, 0x0478, 0x01, 0x00),
	MX91_PAD_ENET2_RD2__SAI2_MCLK                                                   = IOMUX_PAD(0x02B0, 0x0100, 0x02, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET2_RD2__MQS2_RIGHT                                                  = IOMUX_PAD(0x02B0, 0x0100, 0x03, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET2_RD2__FLEXIO2_FLEXIO26                                            = IOMUX_PAD(0x02B0, 0x0100, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET2_RD2__GPIO4_IO26                                                  = IOMUX_PAD(0x02B0, 0x0100, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET2_RD2__MEDIAMIX_CAM_DATA9                                          = IOMUX_PAD(0x02B0, 0x0100, 0x06, 0x04B4, 0x01, 0x00),

	MX91_PAD_ENET2_RD3__ENET2_RGMII_RD3                                             = IOMUX_PAD(0x02B4, 0x0104, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET2_RD3__SPDIF_OUT                                                   = IOMUX_PAD(0x02B4, 0x0104, 0x01, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET2_RD3__SPDIF_IN                                                    = IOMUX_PAD(0x02B4, 0x0104, 0x02, 0x04E4, 0x02, 0x00),
	MX91_PAD_ENET2_RD3__MQS2_LEFT                                                   = IOMUX_PAD(0x02B4, 0x0104, 0x03, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET2_RD3__FLEXIO2_FLEXIO27                                            = IOMUX_PAD(0x02B4, 0x0104, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_ENET2_RD3__GPIO4_IO27                                                  = IOMUX_PAD(0x02B4, 0x0104, 0x05, 0x0000, 0x00, 0x00),

	MX91_PAD_SD1_CLK__FLEXIO1_FLEXIO8                                               = IOMUX_PAD(0x02B8, 0x0108, 0x04, 0x038C, 0x01, 0x00),
	MX91_PAD_SD1_CLK__GPIO3_IO8                                                     = IOMUX_PAD(0x02B8, 0x0108, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_SD1_CLK__USDHC1_CLK                                                    = IOMUX_PAD(0x02B8, 0x0108, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_SD1_CLK__LPSPI2_SCK                                                    = IOMUX_PAD(0x02B8, 0x0108, 0x03, 0x043C, 0x01, 0x00),

	MX91_PAD_SD1_CMD__USDHC1_CMD                                                    = IOMUX_PAD(0x02BC, 0x010C, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_SD1_CMD__FLEXIO1_FLEXIO9                                               = IOMUX_PAD(0x02BC, 0x010C, 0x04, 0x0390, 0x01, 0x00),
	MX91_PAD_SD1_CMD__GPIO3_IO9                                                     = IOMUX_PAD(0x02BC, 0x010C, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_SD1_CMD__LPSPI2_SIN                                                    = IOMUX_PAD(0x02BC, 0x010C, 0x03, 0x0440, 0x01, 0x00),

	MX91_PAD_SD1_DATA0__USDHC1_DATA0                                                = IOMUX_PAD(0x02C0, 0x0110, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_SD1_DATA0__FLEXIO1_FLEXIO10                                            = IOMUX_PAD(0x02C0, 0x0110, 0x04, 0x0394, 0x01, 0x00),
	MX91_PAD_SD1_DATA0__GPIO3_IO10                                                  = IOMUX_PAD(0x02C0, 0x0110, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_SD1_DATA0__LPSPI2_PCS0                                                 = IOMUX_PAD(0x02C0, 0x0110, 0x03, 0x0434, 0x01, 0x00),

	MX91_PAD_SD1_DATA1__USDHC1_DATA1                                                = IOMUX_PAD(0x02C4, 0x0114, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_SD1_DATA1__FLEXIO1_FLEXIO11                                            = IOMUX_PAD(0x02C4, 0x0114, 0x04, 0x0398, 0x01, 0x00),
	MX91_PAD_SD1_DATA1__GPIO3_IO11                                                  = IOMUX_PAD(0x02C4, 0x0114, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_SD1_DATA1__CCMSRCGPCMIX_INT_BOOT                                       = IOMUX_PAD(0x02C4, 0x0114, 0x06, 0x0000, 0x00, 0x00),
	MX91_PAD_SD1_DATA1__LPSPI2_SOUT                                                 = IOMUX_PAD(0x02C4, 0x0114, 0x03, 0x0444, 0x01, 0x00),

	MX91_PAD_SD1_DATA2__USDHC1_DATA2                                                = IOMUX_PAD(0x02C8, 0x0118, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_SD1_DATA2__FLEXIO1_FLEXIO12                                            = IOMUX_PAD(0x02C8, 0x0118, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_SD1_DATA2__GPIO3_IO12                                                  = IOMUX_PAD(0x02C8, 0x0118, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_SD1_DATA2__CCMSRCGPCMIX_PMIC_READY                                     = IOMUX_PAD(0x02C8, 0x0118, 0x06, 0x0000, 0x00, 0x00),
	MX91_PAD_SD1_DATA2__LPSPI2_PCS1                                                 = IOMUX_PAD(0x02C8, 0x0118, 0x03, 0x0438, 0x00, 0x00),

	MX91_PAD_SD1_DATA3__USDHC1_DATA3                                                = IOMUX_PAD(0x02CC, 0x011C, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_SD1_DATA3__FLEXSPI1_A_SS1_B                                            = IOMUX_PAD(0x02CC, 0x011C, 0x01, 0x0000, 0x00, 0x00),
	MX91_PAD_SD1_DATA3__FLEXIO1_FLEXIO13                                            = IOMUX_PAD(0x02CC, 0x011C, 0x04, 0x039C, 0x01, 0x00),
	MX91_PAD_SD1_DATA3__GPIO3_IO13                                                  = IOMUX_PAD(0x02CC, 0x011C, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_SD1_DATA3__LPSPI1_PCS1                                                 = IOMUX_PAD(0x02CC, 0x011C, 0x03, 0x0424, 0x00, 0x00),

	MX91_PAD_SD1_DATA4__USDHC1_DATA4                                                = IOMUX_PAD(0x02D0, 0x0120, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_SD1_DATA4__FLEXSPI1_A_DATA4                                            = IOMUX_PAD(0x02D0, 0x0120, 0x01, 0x0000, 0x00, 0x00),
	MX91_PAD_SD1_DATA4__FLEXIO1_FLEXIO14                                            = IOMUX_PAD(0x02D0, 0x0120, 0x04, 0x03A0, 0x01, 0x00),
	MX91_PAD_SD1_DATA4__GPIO3_IO14                                                  = IOMUX_PAD(0x02D0, 0x0120, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_SD1_DATA4__LPSPI1_PCS0                                                 = IOMUX_PAD(0x02D0, 0x0120, 0x03, 0x0420, 0x00, 0x00),

	MX91_PAD_SD1_DATA5__USDHC1_DATA5                                                = IOMUX_PAD(0x02D4, 0x0124, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_SD1_DATA5__FLEXSPI1_A_DATA5                                            = IOMUX_PAD(0x02D4, 0x0124, 0x01, 0x0000, 0x00, 0x00),
	MX91_PAD_SD1_DATA5__USDHC1_RESET_B                                              = IOMUX_PAD(0x02D4, 0x0124, 0x02, 0x0000, 0x00, 0x00),
	MX91_PAD_SD1_DATA5__FLEXIO1_FLEXIO15                                            = IOMUX_PAD(0x02D4, 0x0124, 0x04, 0x03A4, 0x01, 0x00),
	MX91_PAD_SD1_DATA5__GPIO3_IO15                                                  = IOMUX_PAD(0x02D4, 0x0124, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_SD1_DATA5__LPSPI1_SIN                                                  = IOMUX_PAD(0x02D4, 0x0124, 0x03, 0x042C, 0x00, 0x00),

	MX91_PAD_SD1_DATA6__USDHC1_DATA6                                                = IOMUX_PAD(0x02D8, 0x0128, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_SD1_DATA6__FLEXSPI1_A_DATA6                                            = IOMUX_PAD(0x02D8, 0x0128, 0x01, 0x0000, 0x00, 0x00),
	MX91_PAD_SD1_DATA6__USDHC1_CD_B                                                 = IOMUX_PAD(0x02D8, 0x0128, 0x02, 0x0000, 0x00, 0x00),
	MX91_PAD_SD1_DATA6__FLEXIO1_FLEXIO16                                            = IOMUX_PAD(0x02D8, 0x0128, 0x04, 0x03A8, 0x01, 0x00),
	MX91_PAD_SD1_DATA6__GPIO3_IO16                                                  = IOMUX_PAD(0x02D8, 0x0128, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_SD1_DATA6__LPSPI1_SCK                                                  = IOMUX_PAD(0x02D8, 0x0128, 0x03, 0x0428, 0x00, 0x00),

	MX91_PAD_SD1_DATA7__USDHC1_DATA7                                                = IOMUX_PAD(0x02DC, 0x012C, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_SD1_DATA7__FLEXSPI1_A_DATA7                                            = IOMUX_PAD(0x02DC, 0x012C, 0x01, 0x0000, 0x00, 0x00),
	MX91_PAD_SD1_DATA7__USDHC1_WP                                                   = IOMUX_PAD(0x02DC, 0x012C, 0x02, 0x0000, 0x00, 0x00),
	MX91_PAD_SD1_DATA7__FLEXIO1_FLEXIO17                                            = IOMUX_PAD(0x02DC, 0x012C, 0x04, 0x03AC, 0x01, 0x00),
	MX91_PAD_SD1_DATA7__GPIO3_IO17                                                  = IOMUX_PAD(0x02DC, 0x012C, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_SD1_DATA7__LPSPI1_SOUT                                                 = IOMUX_PAD(0x02DC, 0x012C, 0x03, 0x0430, 0x00, 0x00),

	MX91_PAD_SD1_STROBE__USDHC1_STROBE                                              = IOMUX_PAD(0x02E0, 0x0130, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_SD1_STROBE__FLEXSPI1_A_DQS                                             = IOMUX_PAD(0x02E0, 0x0130, 0x01, 0x0000, 0x00, 0x00),
	MX91_PAD_SD1_STROBE__FLEXIO1_FLEXIO18                                           = IOMUX_PAD(0x02E0, 0x0130, 0x04, 0x03B0, 0x01, 0x00),
	MX91_PAD_SD1_STROBE__GPIO3_IO18                                                 = IOMUX_PAD(0x02E0, 0x0130, 0x05, 0x0000, 0x00, 0x00),

	MX91_PAD_SD2_VSELECT__USDHC2_VSELECT                                            = IOMUX_PAD(0x02E4, 0x0134, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_SD2_VSELECT__USDHC2_WP                                                 = IOMUX_PAD(0x02E4, 0x0134, 0x01, 0x0000, 0x00, 0x00),
	MX91_PAD_SD2_VSELECT__LPTMR2_ALT3                                               = IOMUX_PAD(0x02E4, 0x0134, 0x02, 0x0450, 0x01, 0x00),
	MX91_PAD_SD2_VSELECT__FLEXIO1_FLEXIO19                                          = IOMUX_PAD(0x02E4, 0x0134, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_SD2_VSELECT__GPIO3_IO19                                                = IOMUX_PAD(0x02E4, 0x0134, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_SD2_VSELECT__CCMSRCGPCMIX_EXT_CLK1                                     = IOMUX_PAD(0x02E4, 0x0134, 0x06, 0x0368, 0x00, 0x00),

	MX91_PAD_SD3_CLK__USDHC3_CLK                                                    = IOMUX_PAD(0x02E8, 0x0138, 0x00, 0x04E8, 0x01, 0x00),
	MX91_PAD_SD3_CLK__FLEXSPI1_A_SCLK                                               = IOMUX_PAD(0x02E8, 0x0138, 0x01, 0x0000, 0x00, 0x00),
	MX91_PAD_SD3_CLK__LPUART1_CTS_B                                                 = IOMUX_PAD(0x02E8, 0x0138, 0x02, 0x0454, 0x00, 0x00),
	MX91_PAD_SD3_CLK__FLEXIO1_FLEXIO20                                              = IOMUX_PAD(0x02E8, 0x0138, 0x04, 0x03B4, 0x01, 0x00),
	MX91_PAD_SD3_CLK__GPIO3_IO20                                                    = IOMUX_PAD(0x02E8, 0x0138, 0x05, 0x0000, 0x00, 0x00),

	MX91_PAD_SD3_CMD__USDHC3_CMD                                                    = IOMUX_PAD(0x02EC, 0x013C, 0x00, 0x04EC, 0x01, 0x00),
	MX91_PAD_SD3_CMD__FLEXSPI1_A_SS0_B                                              = IOMUX_PAD(0x02EC, 0x013C, 0x01, 0x0000, 0x00, 0x00),
	MX91_PAD_SD3_CMD__LPUART1_RTS_B                                                 = IOMUX_PAD(0x02EC, 0x013C, 0x02, 0x0000, 0x00, 0x00),
	MX91_PAD_SD3_CMD__FLEXIO1_FLEXIO21                                              = IOMUX_PAD(0x02EC, 0x013C, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_SD3_CMD__GPIO3_IO21                                                    = IOMUX_PAD(0x02EC, 0x013C, 0x05, 0x0000, 0x00, 0x00),

	MX91_PAD_SD3_DATA0__USDHC3_DATA0                                                = IOMUX_PAD(0x02F0, 0x0140, 0x00, 0x04F0, 0x01, 0x00),
	MX91_PAD_SD3_DATA0__FLEXSPI1_A_DATA0                                            = IOMUX_PAD(0x02F0, 0x0140, 0x01, 0x0000, 0x00, 0x00),
	MX91_PAD_SD3_DATA0__LPUART2_CTS_B                                               = IOMUX_PAD(0x02F0, 0x0140, 0x02, 0x0460, 0x00, 0x00),
	MX91_PAD_SD3_DATA0__FLEXIO1_FLEXIO22                                            = IOMUX_PAD(0x02F0, 0x0140, 0x04, 0x03B8, 0x01, 0x00),
	MX91_PAD_SD3_DATA0__GPIO3_IO22                                                  = IOMUX_PAD(0x02F0, 0x0140, 0x05, 0x0000, 0x00, 0x00),

	MX91_PAD_SD3_DATA1__USDHC3_DATA1                                                = IOMUX_PAD(0x02F4, 0x0144, 0x00, 0x04F4, 0x01, 0x00),
	MX91_PAD_SD3_DATA1__FLEXSPI1_A_DATA1                                            = IOMUX_PAD(0x02F4, 0x0144, 0x01, 0x0000, 0x00, 0x00),
	MX91_PAD_SD3_DATA1__LPUART2_RTS_B                                               = IOMUX_PAD(0x02F4, 0x0144, 0x02, 0x0000, 0x00, 0x00),
	MX91_PAD_SD3_DATA1__FLEXIO1_FLEXIO23                                            = IOMUX_PAD(0x02F4, 0x0144, 0x04, 0x03BC, 0x01, 0x00),
	MX91_PAD_SD3_DATA1__GPIO3_IO23                                                  = IOMUX_PAD(0x02F4, 0x0144, 0x05, 0x0000, 0x00, 0x00),

	MX91_PAD_SD3_DATA2__USDHC3_DATA2                                                = IOMUX_PAD(0x02F8, 0x0148, 0x00, 0x04F8, 0x01, 0x00),
	MX91_PAD_SD3_DATA2__LPI2C4_SDA                                                  = IOMUX_PAD(0x02F8, 0x0148, 0x02, 0x03FC, 0x01, 0x00),
	MX91_PAD_SD3_DATA2__FLEXSPI1_A_DATA2                                            = IOMUX_PAD(0x02F8, 0x0148, 0x01, 0x0000, 0x00, 0x00),
	MX91_PAD_SD3_DATA2__FLEXIO1_FLEXIO24                                            = IOMUX_PAD(0x02F8, 0x0148, 0x04, 0x03C0, 0x01, 0x00),
	MX91_PAD_SD3_DATA2__GPIO3_IO24                                                  = IOMUX_PAD(0x02F8, 0x0148, 0x05, 0x0000, 0x00, 0x00),

	MX91_PAD_SD3_DATA3__USDHC3_DATA3                                                = IOMUX_PAD(0x02FC, 0x014C, 0x00, 0x04FC, 0x01, 0x00),
	MX91_PAD_SD3_DATA3__FLEXSPI1_A_DATA3                                            = IOMUX_PAD(0x02FC, 0x014C, 0x01, 0x0000, 0x00, 0x00),
	MX91_PAD_SD3_DATA3__LPI2C4_SCL                                                  = IOMUX_PAD(0x02FC, 0x014C, 0x02, 0x03F8, 0x01, 0x00),
	MX91_PAD_SD3_DATA3__FLEXIO1_FLEXIO25                                            = IOMUX_PAD(0x02FC, 0x014C, 0x04, 0x03C4, 0x01, 0x00),
	MX91_PAD_SD3_DATA3__GPIO3_IO25                                                  = IOMUX_PAD(0x02FC, 0x014C, 0x05, 0x0000, 0x00, 0x00),

	MX91_PAD_SD2_CD_B__USDHC2_CD_B                                                  = IOMUX_PAD(0x0300, 0x0150, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_SD2_CD_B__ENET_QOS_1588_EVENT0_IN                                      = IOMUX_PAD(0x0300, 0x0150, 0x01, 0x0000, 0x00, 0x00),
	MX91_PAD_SD2_CD_B__I3C2_SCL                                                     = IOMUX_PAD(0x0300, 0x0150, 0x02, 0x03CC, 0x01, 0x00),
	MX91_PAD_SD2_CD_B__FLEXIO1_FLEXIO0                                              = IOMUX_PAD(0x0300, 0x0150, 0x04, 0x036C, 0x01, 0x00),
	MX91_PAD_SD2_CD_B__GPIO3_IO0                                                    = IOMUX_PAD(0x0300, 0x0150, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_SD2_CD_B__LPI2C1_SCL                                                   = IOMUX_PAD(0x0300, 0x0150, 0x03, 0x03E0, 0x01, 0x00),

	MX91_PAD_SD2_CLK__USDHC2_CLK                                                    = IOMUX_PAD(0x0304, 0x0154, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_SD2_CLK__ENET_QOS_1588_EVENT0_OUT                                      = IOMUX_PAD(0x0304, 0x0154, 0x01, 0x0000, 0x00, 0x00),
	MX91_PAD_SD2_CLK__I2C1_SDA                                                      = IOMUX_PAD(0x0304, 0x0154, 0x03, 0x0000, 0x00, 0x00),
	MX91_PAD_SD2_CLK__I3C2_SDA                                                      = IOMUX_PAD(0x0304, 0x0154, 0x02, 0x03D0, 0x01, 0x00),
	MX91_PAD_SD2_CLK__FLEXIO1_FLEXIO1                                               = IOMUX_PAD(0x0304, 0x0154, 0x04, 0x0370, 0x01, 0x00),
	MX91_PAD_SD2_CLK__GPIO3_IO1                                                     = IOMUX_PAD(0x0304, 0x0154, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_SD2_CLK__CCMSRCGPCMIX_OBSERVE0                                         = IOMUX_PAD(0x0304, 0x0154, 0x06, 0x0000, 0x00, 0x00),
	MX91_PAD_SD2_CLK__LPI2C1_SDA                                                    = IOMUX_PAD(0x0304, 0x0154, 0x03, 0x03E4, 0x01, 0x00),

	MX91_PAD_SD2_CMD__USDHC2_CMD                                                    = IOMUX_PAD(0x0308, 0x0158, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_SD2_CMD__ENET2_1588_EVENT0_IN                                          = IOMUX_PAD(0x0308, 0x0158, 0x01, 0x0000, 0x00, 0x00),
	MX91_PAD_SD2_CMD__I3C2_PUR                                                      = IOMUX_PAD(0x0308, 0x0158, 0x02, 0x0000, 0x00, 0x00),
	MX91_PAD_SD2_CMD__I3C2_PUR_B                                                    = IOMUX_PAD(0x0308, 0x0158, 0x03, 0x0000, 0x00, 0x00),
	MX91_PAD_SD2_CMD__FLEXIO1_FLEXIO2                                               = IOMUX_PAD(0x0308, 0x0158, 0x04, 0x0374, 0x01, 0x00),
	MX91_PAD_SD2_CMD__GPIO3_IO2                                                     = IOMUX_PAD(0x0308, 0x0158, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_SD2_CMD__CCMSRCGPCMIX_OBSERVE1                                         = IOMUX_PAD(0x0308, 0x0158, 0x06, 0x0000, 0x00, 0x00),

	MX91_PAD_SD2_DATA0__USDHC2_DATA0                                                = IOMUX_PAD(0x030C, 0x015C, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_SD2_DATA0__ENET2_1588_EVENT0_OUT                                       = IOMUX_PAD(0x030C, 0x015C, 0x01, 0x0000, 0x00, 0x00),
	MX91_PAD_SD2_DATA0__CAN2_TX                                                     = IOMUX_PAD(0x030C, 0x015C, 0x02, 0x0000, 0x00, 0x00),
	MX91_PAD_SD2_DATA0__FLEXIO1_FLEXIO3                                             = IOMUX_PAD(0x030C, 0x015C, 0x04, 0x0378, 0x01, 0x00),
	MX91_PAD_SD2_DATA0__GPIO3_IO3                                                   = IOMUX_PAD(0x030C, 0x015C, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_SD2_DATA0__LPUART1_TX                                                  = IOMUX_PAD(0x030C, 0x015C, 0x03, 0x045C, 0x00, 0x00),
	MX91_PAD_SD2_DATA0__CCMSRCGPCMIX_OBSERVE2                                       = IOMUX_PAD(0x030C, 0x015C, 0x06, 0x0000, 0x00, 0x00),

	MX91_PAD_SD2_DATA1__USDHC2_DATA1                                                = IOMUX_PAD(0x0310, 0x0160, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_SD2_DATA1__ENET2_1588_EVENT1_IN                                        = IOMUX_PAD(0x0310, 0x0160, 0x01, 0x0000, 0x00, 0x00),
	MX91_PAD_SD2_DATA1__CAN2_RX                                                     = IOMUX_PAD(0x0310, 0x0160, 0x02, 0x0364, 0x03, 0x00),
	MX91_PAD_SD2_DATA1__FLEXIO1_FLEXIO4                                             = IOMUX_PAD(0x0310, 0x0160, 0x04, 0x037C, 0x01, 0x00),
	MX91_PAD_SD2_DATA1__GPIO3_IO4                                                   = IOMUX_PAD(0x0310, 0x0160, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_SD2_DATA1__LPUART1_RX                                                  = IOMUX_PAD(0x0310, 0x0160, 0x03, 0x0458, 0x00, 0x00),
	MX91_PAD_SD2_DATA1__CCMSRCGPCMIX_WAIT                                           = IOMUX_PAD(0x0310, 0x0160, 0x06, 0x0000, 0x00, 0x00),

	MX91_PAD_SD2_DATA2__USDHC2_DATA2                                                = IOMUX_PAD(0x0314, 0x0164, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_SD2_DATA2__ENET2_1588_EVENT1_OUT                                       = IOMUX_PAD(0x0314, 0x0164, 0x01, 0x0000, 0x00, 0x00),
	MX91_PAD_SD2_DATA2__MQS2_RIGHT                                                  = IOMUX_PAD(0x0314, 0x0164, 0x02, 0x0000, 0x00, 0x00),
	MX91_PAD_SD2_DATA2__FLEXIO1_FLEXIO5                                             = IOMUX_PAD(0x0314, 0x0164, 0x04, 0x0380, 0x01, 0x00),
	MX91_PAD_SD2_DATA2__GPIO3_IO5                                                   = IOMUX_PAD(0x0314, 0x0164, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_SD2_DATA2__LPUART2_TX                                                  = IOMUX_PAD(0x0314, 0x0164, 0x03, 0x0468, 0x00, 0x00),
	MX91_PAD_SD2_DATA2__CCMSRCGPCMIX_STOP                                           = IOMUX_PAD(0x0314, 0x0164, 0x06, 0x0000, 0x00, 0x00),

	MX91_PAD_SD2_DATA3__USDHC2_DATA3                                                = IOMUX_PAD(0x0318, 0x0168, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_SD2_DATA3__LPTMR2_ALT1                                                 = IOMUX_PAD(0x0318, 0x0168, 0x01, 0x0448, 0x01, 0x00),
	MX91_PAD_SD2_DATA3__MQS2_LEFT                                                   = IOMUX_PAD(0x0318, 0x0168, 0x02, 0x0000, 0x00, 0x00),
	MX91_PAD_SD2_DATA3__FLEXIO1_FLEXIO6                                             = IOMUX_PAD(0x0318, 0x0168, 0x04, 0x0384, 0x01, 0x00),
	MX91_PAD_SD2_DATA3__GPIO3_IO6                                                   = IOMUX_PAD(0x0318, 0x0168, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_SD2_DATA3__LPUART2_RX                                                  = IOMUX_PAD(0x0318, 0x0168, 0x03, 0x0464, 0x00, 0x00),
	MX91_PAD_SD2_DATA3__CCMSRCGPCMIX_EARLY_RESET                                    = IOMUX_PAD(0x0318, 0x0168, 0x06, 0x0000, 0x00, 0x00),

	MX91_PAD_SD2_RESET_B__USDHC2_RESET_B                                            = IOMUX_PAD(0x031C, 0x016C, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_SD2_RESET_B__LPTMR2_ALT2                                               = IOMUX_PAD(0x031C, 0x016C, 0x01, 0x044C, 0x01, 0x00),
	MX91_PAD_SD2_RESET_B__FLEXIO1_FLEXIO7                                           = IOMUX_PAD(0x031C, 0x016C, 0x04, 0x0388, 0x01, 0x00),
	MX91_PAD_SD2_RESET_B__GPIO3_IO7                                                 = IOMUX_PAD(0x031C, 0x016C, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_SD2_RESET_B__CCMSRCGPCMIX_SYSTEM_RESET                                 = IOMUX_PAD(0x031C, 0x016C, 0x06, 0x0000, 0x00, 0x00),

	MX91_PAD_I2C1_SCL__LPI2C1_SCL                                                   = IOMUX_PAD(0x0320, 0x0170, 0x00, 0x03E0, 0x02, 0x00),
	MX91_PAD_I2C1_SCL__I3C1_SCL                                                     = IOMUX_PAD(0x0320, 0x0170, 0x01, 0x0000, 0x00, 0x00),
	MX91_PAD_I2C1_SCL__LPUART1_DCB_B                                                = IOMUX_PAD(0x0320, 0x0170, 0x02, 0x0000, 0x00, 0x00),
	MX91_PAD_I2C1_SCL__TPM2_CH0                                                     = IOMUX_PAD(0x0320, 0x0170, 0x03, 0x0000, 0x00, 0x00),
	MX91_PAD_I2C1_SCL__GPIO1_IO0                                                    = IOMUX_PAD(0x0320, 0x0170, 0x05, 0x0000, 0x00, 0x00),

	MX91_PAD_I2C1_SDA__LPI2C1_SDA                                                   = IOMUX_PAD(0x0324, 0x0174, 0x00, 0x03E4, 0x02, 0x00),
	MX91_PAD_I2C1_SDA__I3C1_SDA                                                     = IOMUX_PAD(0x0324, 0x0174, 0x01, 0x0000, 0x00, 0x00),
	MX91_PAD_I2C1_SDA__LPUART1_RIN_B                                                = IOMUX_PAD(0x0324, 0x0174, 0x02, 0x0000, 0x00, 0x00),
	MX91_PAD_I2C1_SDA__TPM2_CH1                                                     = IOMUX_PAD(0x0324, 0x0174, 0x03, 0x0000, 0x00, 0x00),
	MX91_PAD_I2C1_SDA__GPIO1_IO1                                                    = IOMUX_PAD(0x0324, 0x0174, 0x05, 0x0000, 0x00, 0x00),

	MX91_PAD_I2C2_SCL__LPI2C2_SCL                                                   = IOMUX_PAD(0x0328, 0x0178, 0x00, 0x03E8, 0x01, 0x00),
	MX91_PAD_I2C2_SCL__I3C1_PUR                                                     = IOMUX_PAD(0x0328, 0x0178, 0x01, 0x0000, 0x00, 0x00),
	MX91_PAD_I2C2_SCL__LPUART2_DCB_B                                                = IOMUX_PAD(0x0328, 0x0178, 0x02, 0x0000, 0x00, 0x00),
	MX91_PAD_I2C2_SCL__TPM2_CH2                                                     = IOMUX_PAD(0x0328, 0x0178, 0x03, 0x0000, 0x00, 0x00),
	MX91_PAD_I2C2_SCL__SAI1_RX_SYNC                                                 = IOMUX_PAD(0x0328, 0x0178, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_I2C2_SCL__GPIO1_IO3                                                    = IOMUX_PAD(0x0328, 0x0178, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_I2C2_SCL__I3C1_PUR_B                                                   = IOMUX_PAD(0x0328, 0x0178, 0x06, 0x0000, 0x00, 0x00),

	MX91_PAD_I2C2_SDA__LPI2C2_SDA                                                   = IOMUX_PAD(0x032C, 0x017C, 0x00, 0x03EC, 0x01, 0x00),
	MX91_PAD_I2C2_SDA__LPUART2_RIN_B                                                = IOMUX_PAD(0x032C, 0x017C, 0x02, 0x0000, 0x00, 0x00),
	MX91_PAD_I2C2_SDA__TPM2_CH3                                                     = IOMUX_PAD(0x032C, 0x017C, 0x03, 0x0000, 0x00, 0x00),
	MX91_PAD_I2C2_SDA__SAI1_RX_BCLK                                                 = IOMUX_PAD(0x032C, 0x017C, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_I2C2_SDA__GPIO1_IO3                                                    = IOMUX_PAD(0x032C, 0x017C, 0x05, 0x0000, 0x00, 0x00),

	MX91_PAD_UART1_RXD__LPUART1_RX                                                  = IOMUX_PAD(0x0330, 0x0180, 0x00, 0x0458, 0x01, 0x00),
	MX91_PAD_UART1_RXD__ELE_UART_RX                                                 = IOMUX_PAD(0x0330, 0x0180, 0x01, 0x0000, 0x00, 0x00),
	MX91_PAD_UART1_RXD__LPSPI2_SIN                                                  = IOMUX_PAD(0x0330, 0x0180, 0x02, 0x0440, 0x02, 0x00),
	MX91_PAD_UART1_RXD__TPM1_CH0                                                    = IOMUX_PAD(0x0330, 0x0180, 0x03, 0x0000, 0x00, 0x00),
	MX91_PAD_UART1_RXD__GPIO1_IO4                                                   = IOMUX_PAD(0x0330, 0x0180, 0x05, 0x0000, 0x00, 0x00),

	MX91_PAD_UART1_TXD__LPUART1_TX                                                  = IOMUX_PAD(0x0334, 0x0184, 0x00, 0x045C, 0x01, 0x00),
	MX91_PAD_UART1_TXD__ELE_UART_TX                                                 = IOMUX_PAD(0x0334, 0x0184, 0x01, 0x0000, 0x00, 0x00),
	MX91_PAD_UART1_TXD__LPSPI2_PCS0                                                 = IOMUX_PAD(0x0334, 0x0184, 0x02, 0x0434, 0x02, 0x00),
	MX91_PAD_UART1_TXD__TPM1_CH1                                                    = IOMUX_PAD(0x0334, 0x0184, 0x03, 0x0000, 0x00, 0x00),
	MX91_PAD_UART1_TXD__GPIO1_IO5                                                   = IOMUX_PAD(0x0334, 0x0184, 0x05, 0x0000, 0x00, 0x00),

	MX91_PAD_UART2_RXD__LPUART2_RX                                                  = IOMUX_PAD(0x0338, 0x0188, 0x00, 0x0464, 0x01, 0x00),
	MX91_PAD_UART2_RXD__LPUART1_CTS_B                                               = IOMUX_PAD(0x0338, 0x0188, 0x01, 0x0454, 0x01, 0x00),
	MX91_PAD_UART2_RXD__LPSPI2_SOUT                                                 = IOMUX_PAD(0x0338, 0x0188, 0x02, 0x0444, 0x02, 0x00),
	MX91_PAD_UART2_RXD__TPM1_CH2                                                    = IOMUX_PAD(0x0338, 0x0188, 0x03, 0x0000, 0x00, 0x00),
	MX91_PAD_UART2_RXD__SAI1_MCLK                                                   = IOMUX_PAD(0x0338, 0x0188, 0x04, 0x04D4, 0x00, 0x00),
	MX91_PAD_UART2_RXD__GPIO1_IO6                                                   = IOMUX_PAD(0x0338, 0x0188, 0x05, 0x0000, 0x00, 0x00),

	MX91_PAD_UART2_TXD__LPUART2_TX                                                  = IOMUX_PAD(0x033C, 0x018C, 0x00, 0x0468, 0x01, 0x00),
	MX91_PAD_UART2_TXD__LPUART1_RTS_B                                               = IOMUX_PAD(0x033C, 0x018C, 0x01, 0x0000, 0x00, 0x00),
	MX91_PAD_UART2_TXD__LPSPI2_SCK                                                  = IOMUX_PAD(0x033C, 0x018C, 0x02, 0x043C, 0x02, 0x00),
	MX91_PAD_UART2_TXD__TPM1_CH3                                                    = IOMUX_PAD(0x033C, 0x018C, 0x03, 0x0000, 0x00, 0x00),
	MX91_PAD_UART2_TXD__GPIO1_IO7                                                   = IOMUX_PAD(0x033C, 0x018C, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_UART2_TXD__SAI3_TX_SYNC                                                = IOMUX_PAD(0x033C, 0x018C, 0x07, 0x04E0, 0x02, 0x00),

	MX91_PAD_PDM_CLK__PDM_CLK                                                       = IOMUX_PAD(0x0340, 0x0190, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_PDM_CLK__MQS1_LEFT                                                     = IOMUX_PAD(0x0340, 0x0190, 0x01, 0x0000, 0x00, 0x00),
	MX91_PAD_PDM_CLK__LPTMR1_ALT1                                                   = IOMUX_PAD(0x0340, 0x0190, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_PDM_CLK__GPIO1_IO8                                                     = IOMUX_PAD(0x0340, 0x0190, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_PDM_CLK__CAN1_TX                                                       = IOMUX_PAD(0x0340, 0x0190, 0x06, 0x0000, 0x00, 0x00),

	MX91_PAD_PDM_BIT_STREAM0__PDM_BIT_STREAM0                                       = IOMUX_PAD(0x0344, 0x0194, 0x00, 0x04C4, 0x02, 0x00),
	MX91_PAD_PDM_BIT_STREAM0__MQS1_RIGHT                                            = IOMUX_PAD(0x0344, 0x0194, 0x01, 0x0000, 0x00, 0x00),
	MX91_PAD_PDM_BIT_STREAM0__LPSPI1_PCS1                                           = IOMUX_PAD(0x0344, 0x0194, 0x02, 0x0424, 0x01, 0x00),
	MX91_PAD_PDM_BIT_STREAM0__TPM1_EXTCLK                                           = IOMUX_PAD(0x0344, 0x0194, 0x03, 0x0000, 0x00, 0x00),
	MX91_PAD_PDM_BIT_STREAM0__LPTMR1_ALT2                                           = IOMUX_PAD(0x0344, 0x0194, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_PDM_BIT_STREAM0__GPIO1_IO9                                             = IOMUX_PAD(0x0344, 0x0194, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_PDM_BIT_STREAM0__CAN1_RX                                               = IOMUX_PAD(0x0344, 0x0194, 0x06, 0x0360, 0x01, 0x00),

	MX91_PAD_PDM_BIT_STREAM1__PDM_BIT_STREAM1                                       = IOMUX_PAD(0x0348, 0x0198, 0x00, 0x04C8, 0x02, 0x00),
	MX91_PAD_PDM_BIT_STREAM1__LPSPI2_PCS1                                           = IOMUX_PAD(0x0348, 0x0198, 0x02, 0x0438, 0x01, 0x00),
	MX91_PAD_PDM_BIT_STREAM1__TPM2_EXTCLK                                           = IOMUX_PAD(0x0348, 0x0198, 0x03, 0x0000, 0x00, 0x00),
	MX91_PAD_PDM_BIT_STREAM1__LPTMR1_ALT3                                           = IOMUX_PAD(0x0348, 0x0198, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_PDM_BIT_STREAM1__GPIO1_IO10                                            = IOMUX_PAD(0x0348, 0x0198, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_PDM_BIT_STREAM1__CCMSRCGPCMIX_EXT_CLK1                                 = IOMUX_PAD(0x0348, 0x0198, 0x06, 0x0368, 0x01, 0x00),

	MX91_PAD_SAI1_TXFS__SAI1_TX_SYNC                                                = IOMUX_PAD(0x034C, 0x019C, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_SAI1_TXFS__SAI1_TX_DATA1                                               = IOMUX_PAD(0x034C, 0x019C, 0x01, 0x0000, 0x00, 0x00),
	MX91_PAD_SAI1_TXFS__LPSPI1_PCS0                                                 = IOMUX_PAD(0x034C, 0x019C, 0x02, 0x0420, 0x01, 0x00),
	MX91_PAD_SAI1_TXFS__LPUART2_DTR_B                                               = IOMUX_PAD(0x034C, 0x019C, 0x03, 0x0000, 0x00, 0x00),
	MX91_PAD_SAI1_TXFS__MQS1_LEFT                                                   = IOMUX_PAD(0x034C, 0x019C, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_SAI1_TXFS__GPIO1_IO11                                                  = IOMUX_PAD(0x034C, 0x019C, 0x05, 0x0000, 0x00, 0x00),

	MX91_PAD_SAI1_TXC__SAI1_TX_BCLK                                                 = IOMUX_PAD(0x0350, 0x01A0, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_SAI1_TXC__LPUART2_CTS_B                                                = IOMUX_PAD(0x0350, 0x01A0, 0x01, 0x0460, 0x01, 0x00),
	MX91_PAD_SAI1_TXC__LPSPI1_SIN                                                   = IOMUX_PAD(0x0350, 0x01A0, 0x02, 0x042C, 0x01, 0x00),
	MX91_PAD_SAI1_TXC__LPUART1_DSR_B                                                = IOMUX_PAD(0x0350, 0x01A0, 0x03, 0x0000, 0x00, 0x00),
	MX91_PAD_SAI1_TXC__CAN1_RX                                                      = IOMUX_PAD(0x0350, 0x01A0, 0x04, 0x0360, 0x02, 0x00),
	MX91_PAD_SAI1_TXC__GPIO1_IO12                                                   = IOMUX_PAD(0x0350, 0x01A0, 0x05, 0x0000, 0x00, 0x00),

	MX91_PAD_SAI1_TXD0__SAI1_TX_DATA0                                               = IOMUX_PAD(0x0354, 0x01A4, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_SAI1_TXD0__LPUART2_RTS_B                                               = IOMUX_PAD(0x0354, 0x01A4, 0x01, 0x0000, 0x00, 0x00),
	MX91_PAD_SAI1_TXD0__LPSPI1_SCK                                                  = IOMUX_PAD(0x0354, 0x01A4, 0x02, 0x0428, 0x01, 0x00),
	MX91_PAD_SAI1_TXD0__LPUART1_DTR_B                                               = IOMUX_PAD(0x0354, 0x01A4, 0x03, 0x0000, 0x00, 0x00),
	MX91_PAD_SAI1_TXD0__CAN1_TX                                                     = IOMUX_PAD(0x0354, 0x01A4, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_SAI1_TXD0__GPIO1_IO13                                                  = IOMUX_PAD(0x0354, 0x01A4, 0x05, 0x0000, 0x00, 0x00),
	MX91_PAD_SAI1_TXD0__SAI1_MCLK                                                   = IOMUX_PAD(0x0354, 0x01A4, 0x06, 0x04D4, 0x01, 0x00),

	MX91_PAD_SAI1_RXD0__SAI1_RX_DATA0                                               = IOMUX_PAD(0x0358, 0x01A8, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_SAI1_RXD0__SAI1_MCLK                                                   = IOMUX_PAD(0x0358, 0x01A8, 0x01, 0x04D4, 0x02, 0x00),
	MX91_PAD_SAI1_RXD0__LPSPI1_SOUT                                                 = IOMUX_PAD(0x0358, 0x01A8, 0x02, 0x0430, 0x01, 0x00),
	MX91_PAD_SAI1_RXD0__LPUART2_DSR_B                                               = IOMUX_PAD(0x0358, 0x01A8, 0x03, 0x0000, 0x00, 0x00),
	MX91_PAD_SAI1_RXD0__MQS1_RIGHT                                                  = IOMUX_PAD(0x0358, 0x01A8, 0x04, 0x0000, 0x00, 0x00),
	MX91_PAD_SAI1_RXD0__GPIO1_IO14                                                  = IOMUX_PAD(0x0358, 0x01A8, 0x05, 0x0000, 0x00, 0x00),

	MX91_PAD_WDOG_ANY__WDOG1_WDOG_ANY                                               = IOMUX_PAD(0x035C, 0x01AC, 0x00, 0x0000, 0x00, 0x00),
	MX91_PAD_WDOG_ANY__GPIO1_IO15                                                   = IOMUX_PAD(0x035C, 0x01AC, 0x05, 0x0000, 0x00, 0x00),
};
#endif  /* __ASM_ARCH_IMX91_PINS_H__ */
