/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.util.XPointerScheme;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.XdmNode;

public class XPointer {
    private static final QName _xmlns = new QName("", "xmlns");
    private static final QName _element = new QName("", "element");
    private static final QName _xpath = new QName("", "xpath");
    private static final QName _text = new QName("", "text");
    private Vector<XPointerScheme> parts = new Vector();

    public XPointer(String string) {
        String string2 = string;
        while (string2 != null) {
            string2 = this.parse(string2);
        }
    }

    public Hashtable<String, String> xpathNamespaces() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        for (XPointerScheme xPointerScheme : this.parts) {
            if (!_xmlns.equals((Object)xPointerScheme.getName())) continue;
            XPointerXmlnsScheme xPointerXmlnsScheme = (XPointerXmlnsScheme)xPointerScheme;
            hashtable.put(xPointerXmlnsScheme.getPrefix(), xPointerXmlnsScheme.getURI());
        }
        return hashtable;
    }

    public Vector<XdmNode> selectNodes(XProcRuntime xProcRuntime, XdmNode xdmNode) {
        Vector<XdmNode> vector = null;
        for (XPointerScheme xPointerScheme : this.parts) {
            String string = xPointerScheme.xpathEquivalent();
            if (vector != null || string == null) continue;
            try {
                vector = xPointerScheme.selectNodes(xProcRuntime, xdmNode, this.xpathNamespaces());
            }
            catch (XProcException xProcException) {
                vector = null;
            }
        }
        return vector;
    }

    public String selectText(InputStreamReader inputStreamReader, int n) {
        String string = null;
        for (XPointerScheme xPointerScheme : this.parts) {
            String string2 = xPointerScheme.textEquivalent();
            if (string != null || string2 == null) continue;
            try {
                string = xPointerScheme.selectText(inputStreamReader, n);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                string = null;
            }
            catch (XProcException xProcException) {
                string = null;
                try {
                    inputStreamReader.reset();
                }
                catch (IOException iOException) {
                    throw new XProcException(iOException);
                }
            }
        }
        return string;
    }

    private String parse(String string) {
        if (string.startsWith("/") && !string.contains("(")) {
            string = "element(" + string + ")";
        }
        if ((string = string.trim()).matches("^[\\w:]+\\s*\\(.*")) {
            Pattern pattern = Pattern.compile("^([\\w+:]+)\\s*(\\(.*)$");
            Matcher matcher = pattern.matcher(string);
            if (matcher.matches()) {
                QName qName = this.schemeName(matcher.group(1));
                String string2 = matcher.group(2);
                int n = this.indexOfEnd(string2);
                if (n < 0) {
                    throw new XProcException("Unparseable XPointer: " + string);
                }
                String string3 = string2.substring(n);
                string2 = string2.substring(1, n - 1);
                string2 = this.cleanup(string2);
                if (_xmlns.equals((Object)qName)) {
                    this.parts.add(new XPointerXmlnsScheme(qName, string2));
                } else if (_element.equals((Object)qName)) {
                    this.parts.add(new XPointerElementScheme(qName, string2));
                } else if (_xpath.equals((Object)qName)) {
                    this.parts.add(new XPointerXPathScheme(qName, string2));
                } else if (_text.equals((Object)qName)) {
                    this.parts.add(new XPointerTextScheme(qName, string2));
                } else {
                    this.parts.add(new XPointerScheme(qName, string2));
                }
                if ("".equals(string3)) {
                    string3 = null;
                }
                return string3;
            }
            pattern = Pattern.compile("^([\\w+:]+)\\s*\\(\\)\\s*(.*)$");
            matcher = pattern.matcher(string);
            if (matcher.matches()) {
                QName qName = this.schemeName(matcher.group(1));
                String string4 = this.cleanup(matcher.group(2));
                this.parts.add(new XPointerScheme(qName, string4));
                String string5 = matcher.group(3);
                if ("".equals(string5)) {
                    string5 = null;
                }
                return string5;
            }
            throw new XProcException("Unparseable XPointer: " + string);
        }
        if (string.matches("^[\\w:]+\\s*$")) {
            this.parts.add(new XPointerScheme(_element, string));
            return null;
        }
        throw new XProcException("Unparseable XPointer: " + string);
    }

    private QName schemeName(String string) {
        if (string.contains(":")) {
            int n = string.indexOf(":");
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            Object var5_5 = null;
            for (n = this.parts.size() - 1; var5_5 == null && n >= 0; --n) {
                XPointerScheme xPointerScheme = this.parts.get(n);
                if (!(xPointerScheme instanceof XPointerXmlnsScheme)) continue;
                String string4 = ((XPointerXmlnsScheme)xPointerScheme).prefix;
                String string5 = ((XPointerXmlnsScheme)xPointerScheme).uri;
                if (!string2.equals(string4)) continue;
                return new QName(string2, string5, string3);
            }
        } else {
            return new QName("", string);
        }
        throw new XProcException("Scheme name without bound prefix: " + string);
    }

    private int indexOfEnd(String string) {
        int n;
        string = string.replaceAll("\\^[\\(\\)]", "xx");
        int n2 = 0;
        boolean bl = false;
        for (n = 0; n < string.length() && !bl; ++n) {
            String string2 = string.substring(n, n + 1);
            if ("(".equals(string2)) {
                ++n2;
            } else if (")".equals(string2)) {
                --n2;
            }
            bl = ")".equals(string2) && n2 == 0;
        }
        if (n2 != 0) {
            return -1;
        }
        return n;
    }

    private String cleanup(String string) {
        String string2 = string.replaceAll("\\^([\\(\\)\\^])", "$1");
        return string2;
    }

    private class XPointerTextScheme
    extends XPointerScheme {
        public XPointerTextScheme(QName qName, String string) {
            super(qName, string);
        }

        @Override
        public String textEquivalent() {
            return this.schemeData;
        }
    }

    private class XPointerXPathScheme
    extends XPointerScheme {
        public XPointerXPathScheme(QName qName, String string) {
            super(qName, string);
        }

        @Override
        public String xpathEquivalent() {
            return this.schemeData;
        }
    }

    private class XPointerElementScheme
    extends XPointerScheme {
        public XPointerElementScheme(QName qName, String string) {
            super(qName, string);
        }

        @Override
        public String xpathEquivalent() {
            String string = "";
            String string2 = this.schemeData;
            int n = string2.indexOf("/");
            if (n < 0) {
                return "id('" + string2 + "')";
            }
            if (n > 0) {
                string = "id('" + string2.substring(0, n) + "')";
                string2 = string2.substring(n);
            }
            Pattern pattern = Pattern.compile("^/(\\d+)(.*)$");
            Matcher matcher = pattern.matcher(string2);
            while (matcher.matches()) {
                string = string + "/*[" + matcher.group(1) + "]";
                string2 = matcher.group(2);
                matcher = pattern.matcher(string2);
            }
            if (!"".equals(string2)) {
                throw new XProcException("Element pointer didn't parse.");
            }
            return string;
        }
    }

    private class XPointerXmlnsScheme
    extends XPointerScheme {
        protected String prefix;
        protected String uri;

        public XPointerXmlnsScheme(QName qName, String string) {
            super(qName, string);
            this.prefix = null;
            this.uri = null;
            Pattern pattern = Pattern.compile("([\\w:]+)\\s*=\\s*([^=]+)$");
            Matcher matcher = pattern.matcher(string);
            if (!matcher.matches()) {
                throw new XProcException("Unparseable xmlns(): " + string);
            }
            this.prefix = matcher.group(1);
            this.uri = matcher.group(2);
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getURI() {
            return this.uri;
        }
    }
}

