/*
 * Kylin-video
 *
 * Copyright (C) 2021, Tianjin KYLIN Information Technology Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Authors: Liu Cong <liucong1@kylinos.cn>
 *
 */

#ifndef KVSQLITE_H
#define KVSQLITE_H

#include <QString>
#include <QVector>

class QSqlDatabase;

class KPlaylistRecord
{
public:
    QString path;
    QString name;
    QString mark;
    QString viewPath;
    int lastTime;
    int duration;
};

struct MarkRecord {
    QString path;
    int     duration;
    int     pos;
    QString desc;
    QString preview;
};

class KVSqlite
{
public:
    static KVSqlite *getInstance(QString path = "");
    QVector<KPlaylistRecord> getPlayList();
    int     getLastTime     (QString path);
    bool    insertPlayList  (QString path, QString name, int duration, QString view);
    bool    updateLastTime  (QString path, int lasttime);
    bool    updateDuration  (QString path, int duration);
    bool    deletePlayList  (QString path);
    bool    clearPlayList   ();

    bool    insertBookMark  (QString path, int duration, int pos, QString desc, QString view);
    void    deleteBookMark  (QString path, int pos);
    QVector<MarkRecord> getMarks();
    QString getMarkCharacter(QString path);

    QString lastError       (){return m_lastErrorMessage;}

private:
    static KVSqlite* instance;
    KVSqlite(QString);
    ~KVSqlite();

    QString m_lastErrorMessage;
};

#endif // KVSQLITE_H
