# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class AbstractContextItem(Object):
    r"""
    AbstractContextItem - base class for items that are part of a
    ContextScene.
    
    Superclass: Object
    
    This class is the common base for all context scene items. You should
    generally derive from ContextItem, rather than this class, as it
    provides most of the commonly used API.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkAbstractContextItem, obj, update, **traits)
    
    interactive = traits.Bool(True, enter_set=True, auto_set=False, desc=\
        r"""
        Set if the item is interactive (should respond to mouse events).
        """
    )

    def _interactive_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetInteractive,
                        self.interactive)

    def _get_parent(self):
        return wrap_vtk(self._vtk_obj.GetParent())
    def _set_parent(self, arg):
        old_val = self._get_parent()
        self._wrap_call(self._vtk_obj.SetParent,
                        deref_vtk(arg))
        self.trait_property_changed('parent', old_val, arg)
    parent = traits.Property(_get_parent, _set_parent, desc=\
        r"""
        Get the parent item. The parent will be set for all items except
        top level items in a tree.
        """
    )

    def _get_scene(self):
        return wrap_vtk(self._vtk_obj.GetScene())
    def _set_scene(self, arg):
        old_val = self._get_scene()
        self._wrap_call(self._vtk_obj.SetScene,
                        deref_vtk(arg))
        self.trait_property_changed('scene', old_val, arg)
    scene = traits.Property(_get_scene, _set_scene, desc=\
        r"""
        Get the ContextScene for the item, always set for an item in a
        scene.
        """
    )

    visible = traits.Bool(True, enter_set=True, auto_set=False, desc=\
        r"""
        Set the visibility of the item (should it be drawn). Visible by
        default.
        """
    )

    def _visible_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetVisible,
                        self.visible)

    def get_item(self, *args):
        """
        get_item(self, index:int) -> AbstractContextItem
        C++: AbstractContextItem *get_item(IdType index)
        Get the item at the specified index.
        \\return the item at the specified index (null if index is
            invalid).
        """
        ret = self._wrap_call(self._vtk_obj.GetItem, *args)
        return wrap_vtk(ret)

    def get_item_index(self, *args):
        """
        get_item_index(self, item:AbstractContextItem) -> int
        C++: IdType get_item_index(AbstractContextItem *item)
        Get the index of the specified item in itemIndex.
        \\return the item index if found or -1 if not.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetItemIndex, *my_args)
        return ret

    def _get_number_of_items(self):
        return self._vtk_obj.GetNumberOfItems()
    number_of_items = traits.Property(_get_number_of_items, desc=\
        r"""
        Get the number of child items.
        """
    )

    def get_picked_item(self, *args):
        """
        get_picked_item(self, mouse:ContextMouseEvent)
            -> AbstractContextItem
        C++: virtual AbstractContextItem *get_picked_item(
            const ContextMouseEvent &mouse)
        Return the item under the mouse. If no item is under the mouse,
        the method returns a null pointer.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetPickedItem, *my_args)
        return wrap_vtk(ret)

    def add_item(self, *args):
        """
        add_item(self, item:AbstractContextItem) -> int
        C++: IdType add_item(AbstractContextItem *item)
        Add child items to this item. Increments reference count of item.
        \\return the index of the child item.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.AddItem, *my_args)
        return ret

    def clear_items(self):
        """
        clear_items(self) -> None
        C++: void clear_items()
        Remove all child items from this item.
        """
        ret = self._vtk_obj.ClearItems()
        return ret
        

    def hit(self, *args):
        """
        hit(self, mouse:ContextMouseEvent) -> bool
        C++: virtual bool hit(const ContextMouseEvent &mouse)
        Return true if the supplied x, y coordinate is inside the item.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Hit, *my_args)
        return ret

    def key_press_event(self, *args):
        """
        key_press_event(self, key:ContextKeyEvent) -> bool
        C++: virtual bool key_press_event(const ContextKeyEvent &key)
        Key press event.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.KeyPressEvent, *my_args)
        return ret

    def key_release_event(self, *args):
        """
        key_release_event(self, key:ContextKeyEvent) -> bool
        C++: virtual bool key_release_event(const ContextKeyEvent &key)
        Key release event.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.KeyReleaseEvent, *my_args)
        return ret

    def lower(self, *args):
        """
        lower(self, index:int) -> int
        C++: IdType lower(IdType index)
        Lowers the child to the bottom of the item's stack.
        \\return The new index of the item
        \\sa stack_under(), Raise(), stack_above()
        """
        ret = self._wrap_call(self._vtk_obj.Lower, *args)
        return ret

    def map_from_parent(self, *args):
        """
        map_from_parent(self, point:Vector2f) -> Vector2f
        C++: virtual Vector2f map_from_parent(const Vector2f &point)
        Maps the point from the parent coordinate system.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.MapFromParent, *my_args)
        return wrap_vtk(ret)

    def map_from_scene(self, *args):
        """
        map_from_scene(self, point:Vector2f) -> Vector2f
        C++: virtual Vector2f map_from_scene(const Vector2f &point)
        Maps the point from the scene coordinate system.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.MapFromScene, *my_args)
        return wrap_vtk(ret)

    def map_to_parent(self, *args):
        """
        map_to_parent(self, point:Vector2f) -> Vector2f
        C++: virtual Vector2f map_to_parent(const Vector2f &point)
        Maps the point to the parent coordinate system.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.MapToParent, *my_args)
        return wrap_vtk(ret)

    def map_to_scene(self, *args):
        """
        map_to_scene(self, point:Vector2f) -> Vector2f
        C++: virtual Vector2f map_to_scene(const Vector2f &point)
        Maps the point to the scene coordinate system.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.MapToScene, *my_args)
        return wrap_vtk(ret)

    def mouse_button_press_event(self, *args):
        """
        mouse_button_press_event(self, mouse:ContextMouseEvent) -> bool
        C++: virtual bool mouse_button_press_event(
            const ContextMouseEvent &mouse)
        Mouse button down event Return true if the item holds the event,
        false if the event can be propagated to other items.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.MouseButtonPressEvent, *my_args)
        return ret

    def mouse_button_release_event(self, *args):
        """
        mouse_button_release_event(self, mouse:ContextMouseEvent) -> bool
        C++: virtual bool mouse_button_release_event(
            const ContextMouseEvent &mouse)
        Mouse button release event. Return true if the item holds the
        event, false if the event can be propagated to other items.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.MouseButtonReleaseEvent, *my_args)
        return ret

    def mouse_double_click_event(self, *args):
        """
        mouse_double_click_event(self, mouse:ContextMouseEvent) -> bool
        C++: virtual bool mouse_double_click_event(
            const ContextMouseEvent &mouse)
        Mouse button double click event. Return true if the item holds
        the event, false if the event can be propagated to other items.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.MouseDoubleClickEvent, *my_args)
        return ret

    def mouse_enter_event(self, *args):
        """
        mouse_enter_event(self, mouse:ContextMouseEvent) -> bool
        C++: virtual bool mouse_enter_event(
            const ContextMouseEvent &mouse)
        Mouse enter event. Return true if the item holds the event, false
        if the event can be propagated to other items.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.MouseEnterEvent, *my_args)
        return ret

    def mouse_leave_event(self, *args):
        """
        mouse_leave_event(self, mouse:ContextMouseEvent) -> bool
        C++: virtual bool mouse_leave_event(
            const ContextMouseEvent &mouse)
        Mouse leave event. Return true if the item holds the event, false
        if the event can be propagated to other items.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.MouseLeaveEvent, *my_args)
        return ret

    def mouse_move_event(self, *args):
        """
        mouse_move_event(self, mouse:ContextMouseEvent) -> bool
        C++: virtual bool mouse_move_event(
            const ContextMouseEvent &mouse)
        Mouse move event. Return true if the item holds the event, false
        if the event can be propagated to other items.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.MouseMoveEvent, *my_args)
        return ret

    def mouse_wheel_event(self, *args):
        """
        mouse_wheel_event(self, mouse:ContextMouseEvent, delta:int)
            -> bool
        C++: virtual bool mouse_wheel_event(
            const ContextMouseEvent &mouse, int delta)
        Mouse wheel event, positive delta indicates forward movement of
        the wheel. Return true if the item holds the event, false if the
        event can be propagated to other items.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.MouseWheelEvent, *my_args)
        return ret

    def paint(self, *args):
        """
        paint(self, painter:Context2D) -> bool
        C++: virtual bool paint(Context2D *painter)
        Paint event for the item, called whenever the item needs to be
        drawn.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Paint, *my_args)
        return ret

    def paint_children(self, *args):
        """
        paint_children(self, painter:Context2D) -> bool
        C++: virtual bool paint_children(Context2D *painter)
        Paint the children of the item, should be called whenever the
        children need to be rendered.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.PaintChildren, *my_args)
        return ret

    def raise_(self, *args):
        """
        raise(self, index:int) -> int
        C++: IdType raise(IdType index)
        Raises the child to the top of the item's stack.
        \\return The new index of the item
        \\sa stack_above(), Lower(), lower_under()
        """
        ret = self._wrap_call(self._vtk_obj.Raise, *args)
        return ret

    def release_graphics_resources(self):
        """
        release_graphics_resources(self) -> None
        C++: virtual void release_graphics_resources()
        Release graphics resources hold by the item. The default
        implementation is empty.
        """
        ret = self._vtk_obj.ReleaseGraphicsResources()
        return ret
        

    def remove_item(self, *args):
        """
        remove_item(self, item:AbstractContextItem) -> bool
        C++: bool remove_item(AbstractContextItem *item)
        remove_item(self, index:int) -> bool
        C++: bool remove_item(IdType index)
        Remove child item from this item. Decrements reference count of
        item.
        \\param item the item to be removed.
        \\return true on success, false otherwise.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.RemoveItem, *my_args)
        return ret

    def stack_above(self, *args):
        """
        stack_above(self, index:int, under:int) -> int
        C++: virtual IdType stack_above(IdType index,
            IdType under)
        Raises the child above the under sibling. If under is invalid,
        the item is raised to the top of the item's stack.
        \\return The new index of the item
        \\sa Raise(), Lower(), stack_under()
        """
        ret = self._wrap_call(self._vtk_obj.StackAbove, *args)
        return ret

    def stack_under(self, *args):
        """
        stack_under(self, child:int, above:int) -> int
        C++: virtual IdType stack_under(IdType child,
            IdType above)
        Lowers the child under the above sibling. If above is invalid,
        the item is lowered to the bottom of the item's stack
        \\return The new index of the item
        \\sa Lower(), Raise(), stack_above()
        """
        ret = self._wrap_call(self._vtk_obj.StackUnder, *args)
        return ret

    def update(self):
        """
        update(self) -> None
        C++: virtual void update()
        Perform any updates to the item that may be necessary before
        rendering. The scene should take care of calling this on all
        items before their Paint function is invoked.
        """
        ret = self._vtk_obj.Update()
        return ret
        

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('interactive', 'GetInteractive'),
    ('visible', 'GetVisible'), ('object_name', 'GetObjectName'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'interactive', 'object_name',
    'visible'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(AbstractContextItem, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit AbstractContextItem properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['interactive', 'object_name', 'visible']),
            title='Edit AbstractContextItem properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit AbstractContextItem properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

