# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.unstructured_grid_algorithm import UnstructuredGridAlgorithm


class ConvertToPolyhedra(UnstructuredGridAlgorithm):
    r"""
    ConvertToPolyhedra - convert 3D linear cells to Polyhedra
    
    Superclass: UnstructuredGridAlgorithm
    
    ConvertToPolyhedra is a filter that takes a UnstructuredGrid as
    input and produces a UnstructuredGrid on output, converting 3D
    linear cells such as tetrahedra, hexahedra, wedges, and pyramids into
    Polyhedron.
    
    @warning
    Certain cells are skipped and not converted, this includes cells of
    dimension two or less (e.g., triangles, quads, lines, verts, and so
    on); and higher order cells that cannot easily be converted to
    Polyhedra. (TODO: tessellate high-order 3D cell faces and then use
    these to form the polyhedra.)
    
    @warning
    This filter is typically used for testing. In general, processing
    linear cells is preferrable to processing polyhedra due to
    differences in speed of processing, and memory requirements.
    
    @sa
    UnstructuredGrid Polyhedron
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkConvertToPolyhedra, obj, update, **traits)
    
    output_all_cells = tvtk_base.false_bool_trait(desc=\
        r"""
        Indicate whether to include non-polyhedral cells in the filter
        output. Non-polyhedral cells are cells which cannot be converted
        to polyhedra, for example cells of dimension < 3, and
        higher-order cells. If enabled, the output will contain a mix of
        polyhedra and non-polyhedra cells. If disabled, only polyhedra
        cells will be output. By default, this is disabled.
        """
    )

    def _output_all_cells_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOutputAllCells,
                        self.output_all_cells_)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)
        get_input(self) -> DataObject
        C++: DataObject *get_input()"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    _updateable_traits_ = \
    (('output_all_cells', 'GetOutputAllCells'), ('abort_execute',
    'GetAbortExecute'), ('release_data_flag', 'GetReleaseDataFlag'),
    ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('progress_text', 'GetProgressText'),
    ('object_name', 'GetObjectName'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'output_all_cells', 'release_data_flag', 'object_name',
    'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ConvertToPolyhedra, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ConvertToPolyhedra properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['output_all_cells'], [], ['object_name']),
            title='Edit ConvertToPolyhedra properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ConvertToPolyhedra properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

