# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.render_window import RenderWindow


class OpenGLRenderWindow(RenderWindow):
    r"""
    OpenGLRenderWindow - open_gl rendering window
    
    Superclass: RenderWindow
    
    OpenGLRenderWindow is a concrete implementation of the abstract
    class RenderWindow. OpenGLRenderer interfaces to the open_gl
    graphics library. Application programmers should normally use
    RenderWindow instead of the open_gl specific version.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkOpenGLRenderWindow, obj, update, **traits)
    
    framebuffer_flip_y = tvtk_base.false_bool_trait(desc=\
        r"""
        Enable/Disable flipping the Y axis of the rendered texture.
        """
    )

    def _framebuffer_flip_y_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFramebufferFlipY,
                        self.framebuffer_flip_y_)

    frame_blit_mode = tvtk_base.RevPrefixMap({'blit_to_current': 1, 'blit_to_hardware': 0, 'no_blit': 2}, default_value='blit_to_current', desc=\
        r"""
        set_get how to handle blits at the end of a Frame() call. Only
        happens when swap_buffers is true.
        """
    )

    def _frame_blit_mode_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFrameBlitMode,
                        self.frame_blit_mode_)

    global_maximum_number_of_multi_samples = traits.Int(8, enter_set=True, auto_set=False, desc=\
        r"""
        Set/Get the maximum number of multisamples
        """
    )

    def _global_maximum_number_of_multi_samples_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetGlobalMaximumNumberOfMultiSamples,
                        self.global_maximum_number_of_multi_samples)

    def get_pixel_data(self, *args):
        """
        get_pixel_data(self, x:int, y:int, x2:int, y2:int, front:int,
            right:int) -> Pointer
        C++: unsigned char *get_pixel_data(int x, int y, int x2, int y2,
            int front, int right) override;
        get_pixel_data(self, x:int, y:int, x2:int, y2:int, front:int,
            data:UnsignedCharArray, right:int) -> int
        C++: int get_pixel_data(int x, int y, int x2, int y2, int front,
            UnsignedCharArray *data, int right) override;
        Set/Get the pixel data of an image, transmitted as RGBRGB...
        front in this context indicates that the read should come from
        the display buffer versus the render buffer
        """
        my_args = deref_array(args, [('int', 'int', 'int', 'int', 'int', 'int'), ('int', 'int', 'int', 'int', 'int', 'vtkUnsignedCharArray', 'int')])
        ret = self._wrap_call(self._vtk_obj.GetPixelData, *my_args)
        return ret

    def set_pixel_data(self, *args):
        """
        set_pixel_data(self, x:int, y:int, x2:int, y2:int, data:[int, ...],
            front:int, right:int) -> int
        C++: int set_pixel_data(int x, int y, int x2, int y2,
            unsigned char *data, int front, int right) override;
        set_pixel_data(self, x:int, y:int, x2:int, y2:int,
            data:UnsignedCharArray, front:int, right:int) -> int
        C++: int set_pixel_data(int x, int y, int x2, int y2,
            UnsignedCharArray *data, int front, int right) override;
        Set/Get the pixel data of an image, transmitted as RGBRGBRGB. The
        front argument indicates if the front buffer should be used or
        the back buffer. It is the caller's responsibility to delete the
        resulting array. It is very important to realize that the memory
        in this array is organized from the bottom of the window to the
        top. The origin of the screen is in the lower left corner. The y
        axis increases as you go up the screen. So the storage of pixels
        is from left to right and from bottom to top. (x,y) is any corner
        of the rectangle. (x2,y2) is its opposite corner on the diagonal.
        """
        my_args = deref_array(args, [('int', 'int', 'int', 'int', ['int', Ellipsis], 'int', 'int'), ('int', 'int', 'int', 'int', 'vtkUnsignedCharArray', 'int', 'int')])
        ret = self._wrap_call(self._vtk_obj.SetPixelData, *my_args)
        return ret

    def get_rgba_char_pixel_data(self, *args):
        """
        get_rgba_char_pixel_data(self, x:int, y:int, x2:int, y2:int,
            front:int, right:int=0) -> Pointer
        C++: unsigned char *get_rgba_char_pixel_data(int x, int y, int x2,
            int y2, int front, int right=0) override;
        get_rgba_char_pixel_data(self, x:int, y:int, x2:int, y2:int,
            front:int, data:UnsignedCharArray, right:int=0) -> int
        C++: int get_rgba_char_pixel_data(int x, int y, int x2, int y2,
            int front, UnsignedCharArray *data, int right=0) override;"""
        my_args = deref_array(args, [('int', 'int', 'int', 'int', 'int', 'int'), ('int', 'int', 'int', 'int', 'int', 'vtkUnsignedCharArray', 'int')])
        ret = self._wrap_call(self._vtk_obj.GetRGBACharPixelData, *my_args)
        return ret

    def set_rgba_char_pixel_data(self, *args):
        """
        set_rgba_char_pixel_data(self, x:int, y:int, x2:int, y2:int,
            data:[int, ...], front:int, blend:int=0, right:int=0) -> int
        C++: int set_rgba_char_pixel_data(int x, int y, int x2, int y2,
            unsigned char *data, int front, int blend=0, int right=0)
            override;
        set_rgba_char_pixel_data(self, x:int, y:int, x2:int, y2:int,
            data:UnsignedCharArray, front:int, blend:int=0,
            right:int=0) -> int
        C++: int set_rgba_char_pixel_data(int x, int y, int x2, int y2,
            UnsignedCharArray *data, int front, int blend=0,
            int right=0) override;"""
        my_args = deref_array(args, [('int', 'int', 'int', 'int', ['int', Ellipsis], 'int', 'int', 'int'), ('int', 'int', 'int', 'int', 'vtkUnsignedCharArray', 'int', 'int', 'int')])
        ret = self._wrap_call(self._vtk_obj.SetRGBACharPixelData, *my_args)
        return ret

    def get_rgba_pixel_data(self, *args):
        """
        get_rgba_pixel_data(self, x:int, y:int, x2:int, y2:int, front:int,
            right:int=0) -> Pointer
        C++: float *get_rgba_pixel_data(int x, int y, int x2, int y2,
            int front, int right=0) override;
        get_rgba_pixel_data(self, x:int, y:int, x2:int, y2:int, front:int,
            data:FloatArray, right:int=0) -> int
        C++: int get_rgba_pixel_data(int x, int y, int x2, int y2, int front,
             FloatArray *data, int right=0) override;
        Set/Get the pixel data of an image, transmitted as RGBARGBA...
        """
        my_args = deref_array(args, [('int', 'int', 'int', 'int', 'int', 'int'), ('int', 'int', 'int', 'int', 'int', 'vtkFloatArray', 'int')])
        ret = self._wrap_call(self._vtk_obj.GetRGBAPixelData, *my_args)
        return ret

    def set_rgba_pixel_data(self, *args):
        """
        set_rgba_pixel_data(self, x:int, y:int, x2:int, y2:int, data:[float,
            ...], front:int, blend:int=0, right:int=0) -> int
        C++: int set_rgba_pixel_data(int x, int y, int x2, int y2,
            float *data, int front, int blend=0, int right=0) override;
        set_rgba_pixel_data(self, x:int, y:int, x2:int, y2:int,
            data:FloatArray, front:int, blend:int=0, right:int=0)
            -> int
        C++: int set_rgba_pixel_data(int x, int y, int x2, int y2,
            FloatArray *data, int front, int blend=0, int right=0)
            override;"""
        my_args = deref_array(args, [('int', 'int', 'int', 'int', ['float', Ellipsis], 'int', 'int', 'int'), ('int', 'int', 'int', 'int', 'vtkFloatArray', 'int', 'int', 'int')])
        ret = self._wrap_call(self._vtk_obj.SetRGBAPixelData, *my_args)
        return ret

    def get_zbuffer_data(self, *args):
        """
        get_zbuffer_data(self, x1:int, y1:int, x2:int, y2:int) -> Pointer
        C++: float *get_zbuffer_data(int x1, int y1, int x2, int y2)
            override;
        get_zbuffer_data(self, x1:int, y1:int, x2:int, y2:int, z:[float,
            ...]) -> int
        C++: int get_zbuffer_data(int x1, int y1, int x2, int y2, float *z)
            override;
        get_zbuffer_data(self, x1:int, y1:int, x2:int, y2:int,
            buffer:FloatArray) -> int
        C++: int get_zbuffer_data(int x1, int y1, int x2, int y2,
            FloatArray *buffer) override;
        Set/Get the zbuffer data from an image
        """
        my_args = deref_array(args, [('int', 'int', 'int', 'int'), ('int', 'int', 'int', 'int', ['float', Ellipsis]), ('int', 'int', 'int', 'int', 'vtkFloatArray')])
        ret = self._wrap_call(self._vtk_obj.GetZbufferData, *my_args)
        return ret

    def set_zbuffer_data(self, *args):
        """
        set_zbuffer_data(self, x1:int, y1:int, x2:int, y2:int,
            buffer:[float, ...]) -> int
        C++: int set_zbuffer_data(int x1, int y1, int x2, int y2,
            float *buffer) override;
        set_zbuffer_data(self, x1:int, y1:int, x2:int, y2:int,
            buffer:FloatArray) -> int
        C++: int set_zbuffer_data(int x1, int y1, int x2, int y2,
            FloatArray *buffer) override;"""
        my_args = deref_array(args, [('int', 'int', 'int', 'int', 'tuple'), ('int', 'int', 'int', 'int', 'vtkFloatArray')])
        ret = self._wrap_call(self._vtk_obj.SetZbufferData, *my_args)
        return ret

    def _get_back_buffer(self):
        return self._vtk_obj.GetBackBuffer()
    back_buffer = traits.Property(_get_back_buffer, desc=\
        r"""
        
        """
    )

    def _get_back_left_buffer(self):
        return self._vtk_obj.GetBackLeftBuffer()
    back_left_buffer = traits.Property(_get_back_left_buffer, desc=\
        r"""
        
        """
    )

    def _get_back_right_buffer(self):
        return self._vtk_obj.GetBackRightBuffer()
    back_right_buffer = traits.Property(_get_back_right_buffer, desc=\
        r"""
        
        """
    )

    def _get_buffer_needs_resolving(self):
        return self._vtk_obj.GetBufferNeedsResolving()
    buffer_needs_resolving = traits.Property(_get_buffer_needs_resolving, desc=\
        r"""
        
        """
    )

    def get_color_buffer_internal_format(self, *args):
        """
        get_color_buffer_internal_format(self, attachmentPoint:int) -> int
        C++: int get_color_buffer_internal_format(int attachmentPoint)
        Get the internal format of current attached texture or render
        buffer. attachmentPoint is the index of attachment. Returns 0 if
        not able to determine.
        """
        ret = self._wrap_call(self._vtk_obj.GetColorBufferInternalFormat, *args)
        return ret

    def _get_context_creation_time(self):
        return self._vtk_obj.GetContextCreationTime()
    context_creation_time = traits.Property(_get_context_creation_time, desc=\
        r"""
        Get the time when the open_gl context was created.
        """
    )

    def get_default_texture_internal_format(self, *args):
        """
        get_default_texture_internal_format(self, vtktype:int,
            numComponents:int, needInteger:bool, needFloat:bool,
            needSRGB:bool) -> int
        C++: int get_default_texture_internal_format(int vtktype,
            int numComponents, bool needInteger, bool needFloat,
            bool needSRGB)
        Get a mapping of vtk data types to native texture formats for
        this window we put this on the render_window so that every texture
        does not have to build these structures themselves
        """
        ret = self._wrap_call(self._vtk_obj.GetDefaultTextureInternalFormat, *args)
        return ret

    def _get_display_framebuffer(self):
        return wrap_vtk(self._vtk_obj.GetDisplayFramebuffer())
    display_framebuffer = traits.Property(_get_display_framebuffer, desc=\
        r"""
        Returns the display framebuffer object.
        """
    )

    def _get_front_buffer(self):
        return self._vtk_obj.GetFrontBuffer()
    front_buffer = traits.Property(_get_front_buffer, desc=\
        r"""
        
        """
    )

    def _get_front_left_buffer(self):
        return self._vtk_obj.GetFrontLeftBuffer()
    front_left_buffer = traits.Property(_get_front_left_buffer, desc=\
        r"""
        
        """
    )

    def _get_front_right_buffer(self):
        return self._vtk_obj.GetFrontRightBuffer()
    front_right_buffer = traits.Property(_get_front_right_buffer, desc=\
        r"""
        
        """
    )

    def _get_maximum_hardware_line_width(self):
        return self._vtk_obj.GetMaximumHardwareLineWidth()
    maximum_hardware_line_width = traits.Property(_get_maximum_hardware_line_width, desc=\
        r"""
        Return the largest line width supported by the hardware
        """
    )

    def _get_noise_texture_unit(self):
        return self._vtk_obj.GetNoiseTextureUnit()
    noise_texture_unit = traits.Property(_get_noise_texture_unit, desc=\
        r"""
        
        """
    )

    def _get_off_screen_framebuffer(self):
        return wrap_vtk(self._vtk_obj.GetOffScreenFramebuffer())
    off_screen_framebuffer = traits.Property(_get_off_screen_framebuffer, desc=\
        r"""
        
        """
    )

    def _get_open_gl_support_message(self):
        return self._vtk_obj.GetOpenGLSupportMessage()
    open_gl_support_message = traits.Property(_get_open_gl_support_message, desc=\
        r"""
        Return a message profiding additional details about the results
        of calling supports_open_gl()  This can be used to retrieve more
        specifics about what failed
        """
    )

    def get_open_gl_version(self, *args):
        """
        get_open_gl_version(self, major:int, minor:int) -> None
        C++: void get_open_gl_version(int &major, int &minor)
        Get the major and minor version numbers of the open_gl context we
        are using ala 3.2, 3.3, 4.0, etc... returns 0,0 if opengl has not
        been initialized yet
        """
        ret = self._wrap_call(self._vtk_obj.GetOpenGLVersion, *args)
        return ret

    def _get_render_framebuffer(self):
        return wrap_vtk(self._vtk_obj.GetRenderFramebuffer())
    render_framebuffer = traits.Property(_get_render_framebuffer, desc=\
        r"""
        Returns the render framebuffer object.
        """
    )

    def _get_shader_cache(self):
        return wrap_vtk(self._vtk_obj.GetShaderCache())
    shader_cache = traits.Property(_get_shader_cache, desc=\
        r"""
        Returns an Shader Cache object
        """
    )

    def _get_state(self):
        return wrap_vtk(self._vtk_obj.GetState())
    state = traits.Property(_get_state, desc=\
        r"""
        
        """
    )

    def _get_t_quad2dvbo(self):
        return wrap_vtk(self._vtk_obj.GetTQuad2DVBO())
    t_quad2dvbo = traits.Property(_get_t_quad2dvbo, desc=\
        r"""
        
        """
    )

    def get_texture_unit_for_texture(self, *args):
        """
        get_texture_unit_for_texture(self, __a:TextureObject) -> int
        C++: int get_texture_unit_for_texture(TextureObject *)
        Get the texture unit for a given texture object
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetTextureUnitForTexture, *my_args)
        return ret

    def _get_texture_unit_manager(self):
        return wrap_vtk(self._vtk_obj.GetTextureUnitManager())
    texture_unit_manager = traits.Property(_get_texture_unit_manager, desc=\
        r"""
        Returns its texture unit manager object. A new one will be
        created if one hasn't already been set up.
        """
    )

    def _get_using_srgb_color_space(self):
        return self._vtk_obj.GetUsingSRGBColorSpace()
    using_srgb_color_space = traits.Property(_get_using_srgb_color_space, desc=\
        r"""
        Is this window/fo in sRGB colorspace
        """
    )

    def _get_vbo_cache(self):
        return wrap_vtk(self._vtk_obj.GetVBOCache())
    vbo_cache = traits.Property(_get_vbo_cache, desc=\
        r"""
        Returns the VBO Cache
        """
    )

    def activate_texture(self, *args):
        """
        activate_texture(self, __a:TextureObject) -> None
        C++: void activate_texture(TextureObject *)
        Activate a texture unit for this texture
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ActivateTexture, *my_args)
        return ret

    def blit_display_framebuffer(self, *args):
        """
        blit_display_framebuffer(self) -> None
        C++: void blit_display_framebuffer()
        blit_display_framebuffer(self, right:int, srcX:int, srcY:int,
            srcWidth:int, srcHeight:int, destX:int, destY:int,
            destWidth:int, destHeight:int, bufferMode:int,
            interpolation:int) -> None
        C++: void blit_display_framebuffer(int right, int srcX, int srcY,
            int srcWidth, int srcHeight, int destX, int destY,
            int destWidth, int destHeight, int bufferMode,
            int interpolation)
        Blit a display framebuffer into a currently bound draw
        destination
        """
        ret = self._wrap_call(self._vtk_obj.BlitDisplayFramebuffer, *args)
        return ret

    def blit_to_render_framebuffer(self, *args):
        """
        blit_to_render_framebuffer(self, includeDepth:bool) -> None
        C++: void blit_to_render_framebuffer(bool includeDepth)
        blit_to_render_framebuffer(self, srcX:int, srcY:int, srcWidth:int,
            srcHeight:int, destX:int, destY:int, destWidth:int,
            destHeight:int, bufferMode:int, interpolation:int) -> None
        C++: void blit_to_render_framebuffer(int srcX, int srcY,
            int srcWidth, int srcHeight, int destX, int destY,
            int destWidth, int destHeight, int bufferMode,
            int interpolation)
        Blit the currently bound read buffer to the renderbuffer. This is
        useful for taking rendering from an external system and then
        having VTK draw on top of it.
        """
        ret = self._wrap_call(self._vtk_obj.BlitToRenderFramebuffer, *args)
        return ret

    def deactivate_texture(self, *args):
        """
        deactivate_texture(self, __a:TextureObject) -> None
        C++: void deactivate_texture(TextureObject *)
        Deactivate a previously activated texture
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.DeactivateTexture, *my_args)
        return ret

    def draw_pixels(self, *args):
        """
        draw_pixels(self, x1:int, y1:int, x2:int, y2:int,
            numComponents:int, dataType:int, data:Pointer) -> None
        C++: virtual void draw_pixels(int x1, int y1, int x2, int y2,
            int numComponents, int dataType, void *data)
        draw_pixels(self, dstXmin:int, dstYmin:int, dstXmax:int,
            dstYmax:int, srcXmin:int, srcYmin:int, srcXmax:int,
            srcYmax:int, srcWidth:int, srcHeight:int, numComponents:int,
            dataType:int, data:Pointer) -> None
        C++: virtual void draw_pixels(int dstXmin, int dstYmin,
            int dstXmax, int dstYmax, int srcXmin, int srcYmin,
            int srcXmax, int srcYmax, int srcWidth, int srcHeight,
            int numComponents, int dataType, void *data)
        draw_pixels(self, srcWidth:int, srcHeight:int, numComponents:int,
            dataType:int, data:Pointer) -> None
        C++: virtual void draw_pixels(int srcWidth, int srcHeight,
            int numComponents, int dataType, void *data)
        Replacement for the old gldraw_pixels function
        """
        ret = self._wrap_call(self._vtk_obj.DrawPixels, *args)
        return ret

    def initialize(self):
        """
        initialize(self) -> None
        C++: virtual void initialize(void)
        Initialize the rendering window.  This will setup all
        system-specific resources.  This method and Finalize() must be
        symmetric and it should be possible to call them multiple times,
        even changing window_id in-between.  This is what window_remap
        does.
        """
        ret = self._vtk_obj.Initialize()
        return ret
        

    def is_point_sprite_bug_present(self):
        """
        is_point_sprite_bug_present(self) -> bool
        C++: virtual bool is_point_sprite_bug_present()
        Returns true if driver has an EGL/open_gl bug that makes
        ChartsCoreCxx-TestChartDoubleColors and other tests to fail
        because point sprites don't work correctly (gl_point_coord is
        undefined) unless glEnable(GL_POINT_SPRITE)
        """
        ret = self._vtk_obj.IsPointSpriteBugPresent()
        return ret
        

    def open_gl_init(self):
        """
        open_gl_init(self) -> None
        C++: virtual void open_gl_init()
        Initialize open_gl for this window.
        """
        ret = self._vtk_obj.OpenGLInit()
        return ret
        

    def open_gl_init_context(self):
        """
        open_gl_init_context(self) -> None
        C++: virtual void open_gl_init_context()"""
        ret = self._vtk_obj.OpenGLInitContext()
        return ret
        

    def open_gl_init_state(self):
        """
        open_gl_init_state(self) -> None
        C++: virtual void open_gl_init_state()"""
        ret = self._vtk_obj.OpenGLInitState()
        return ret
        

    def pop_context(self):
        """
        pop_context(self) -> None
        C++: virtual void pop_context()"""
        ret = self._vtk_obj.PopContext()
        return ret
        

    def push_context(self):
        """
        push_context(self) -> None
        C++: virtual void push_context()
        Ability to push and pop this window's context as the current
        context. The idea being to if needed make this window's context
        current and when done releasing resources restore the prior
        context.  The default implementation here is only meant as a
        backup for subclasses that lack a proper implementation.
        """
        ret = self._vtk_obj.PushContext()
        return ret
        

    def register_graphics_resources(self, *args):
        """
        register_graphics_resources(self,
            cb:GenericOpenGLResourceFreeCallback) -> None
        C++: void register_graphics_resources(
            GenericOpenGLResourceFreeCallback *cb)"""
        ret = self._wrap_call(self._vtk_obj.RegisterGraphicsResources, *args)
        return ret

    def set_swap_control(self, *args):
        """
        set_swap_control(self, __a:int) -> bool
        C++: virtual bool set_swap_control(int)
        Set the number of vertical syncs required between frames. A value
        of 0 means swap buffers as quickly as possible regardless of the
        vertical refresh. A value of 1 means swap buffers in sync with
        the vertical refresh to eliminate tearing. A value of -1 means
        use a value of 1 unless we missed a frame in which case swap
        immediately. Returns true if the call succeeded.
        """
        ret = self._wrap_call(self._vtk_obj.SetSwapControl, *args)
        return ret

    def texture_depth_blit(self, *args):
        """
        texture_depth_blit(self, source:TextureObject) -> None
        C++: virtual void texture_depth_blit(TextureObject *source)
        texture_depth_blit(self, source:TextureObject, srcX:int,
            srcY:int, srcX2:int, srcY2:int) -> None
        C++: virtual void texture_depth_blit(TextureObject *source,
            int srcX, int srcY, int srcX2, int srcY2)
        texture_depth_blit(self, source:TextureObject, srcX:int,
            srcY:int, srcX2:int, srcY2:int, destX:int, destY:int,
            destX2:int, destY2:int) -> None
        C++: virtual void texture_depth_blit(TextureObject *source,
            int srcX, int srcY, int srcX2, int srcY2, int destX,
            int destY, int destX2, int destY2)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.TextureDepthBlit, *my_args)
        return ret

    def unregister_graphics_resources(self, *args):
        """
        unregister_graphics_resources(self,
            cb:GenericOpenGLResourceFreeCallback) -> None
        C++: void unregister_graphics_resources(
            GenericOpenGLResourceFreeCallback *cb)"""
        ret = self._wrap_call(self._vtk_obj.UnregisterGraphicsResources, *args)
        return ret

    _updateable_traits_ = \
    (('framebuffer_flip_y', 'GetFramebufferFlipY'), ('borders',
    'GetBorders'), ('full_screen', 'GetFullScreen'), ('line_smoothing',
    'GetLineSmoothing'), ('point_smoothing', 'GetPointSmoothing'),
    ('polygon_smoothing', 'GetPolygonSmoothing'), ('stencil_capable',
    'GetStencilCapable'), ('stereo_capable_window',
    'GetStereoCapableWindow'), ('stereo_render', 'GetStereoRender'),
    ('swap_buffers', 'GetSwapBuffers'), ('use_srgb_color_space',
    'GetUseSRGBColorSpace'), ('double_buffer', 'GetDoubleBuffer'),
    ('erase', 'GetErase'), ('off_screen_rendering',
    'GetOffScreenRendering'), ('show_window', 'GetShowWindow'),
    ('use_off_screen_buffers', 'GetUseOffScreenBuffers'), ('debug',
    'GetDebug'), ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('frame_blit_mode', 'GetFrameBlitMode'), ('stereo_type',
    'GetStereoType'), ('global_maximum_number_of_multi_samples',
    'GetGlobalMaximumNumberOfMultiSamples'), ('abort_render',
    'GetAbortRender'), ('alpha_bit_planes', 'GetAlphaBitPlanes'),
    ('anaglyph_color_mask', 'GetAnaglyphColorMask'),
    ('anaglyph_color_saturation', 'GetAnaglyphColorSaturation'),
    ('current_cursor', 'GetCurrentCursor'), ('cursor_file_name',
    'GetCursorFileName'), ('desired_update_rate', 'GetDesiredUpdateRate'),
    ('device_index', 'GetDeviceIndex'), ('in_abort_check',
    'GetInAbortCheck'), ('multi_samples', 'GetMultiSamples'),
    ('number_of_layers', 'GetNumberOfLayers'), ('dpi', 'GetDPI'),
    ('position', 'GetPosition'), ('size', 'GetSize'), ('tile_scale',
    'GetTileScale'), ('tile_viewport', 'GetTileViewport'), ('window_name',
    'GetWindowName'), ('object_name', 'GetObjectName'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['borders', 'debug', 'double_buffer', 'erase', 'framebuffer_flip_y',
    'full_screen', 'global_warning_display', 'line_smoothing',
    'off_screen_rendering', 'point_smoothing', 'polygon_smoothing',
    'show_window', 'stencil_capable', 'stereo_capable_window',
    'stereo_render', 'swap_buffers', 'use_off_screen_buffers',
    'use_srgb_color_space', 'frame_blit_mode', 'stereo_type',
    'abort_render', 'alpha_bit_planes', 'anaglyph_color_mask',
    'anaglyph_color_saturation', 'current_cursor', 'cursor_file_name',
    'desired_update_rate', 'device_index', 'dpi',
    'global_maximum_number_of_multi_samples', 'in_abort_check',
    'multi_samples', 'number_of_layers', 'object_name', 'position',
    'size', 'tile_scale', 'tile_viewport', 'window_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(OpenGLRenderWindow, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit OpenGLRenderWindow properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['borders', 'double_buffer', 'erase', 'framebuffer_flip_y',
            'full_screen', 'line_smoothing', 'off_screen_rendering',
            'point_smoothing', 'polygon_smoothing', 'show_window',
            'stencil_capable', 'stereo_capable_window', 'stereo_render',
            'swap_buffers', 'use_off_screen_buffers', 'use_srgb_color_space'],
            ['frame_blit_mode', 'stereo_type'], ['abort_render',
            'alpha_bit_planes', 'anaglyph_color_mask',
            'anaglyph_color_saturation', 'current_cursor', 'cursor_file_name',
            'desired_update_rate', 'device_index', 'dpi',
            'global_maximum_number_of_multi_samples', 'in_abort_check',
            'multi_samples', 'number_of_layers', 'object_name', 'position',
            'size', 'tile_scale', 'tile_viewport', 'window_name']),
            title='Edit OpenGLRenderWindow properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit OpenGLRenderWindow properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

