# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.multi_block_data_set_algorithm import MultiBlockDataSetAlgorithm


class PIOReader(MultiBlockDataSetAlgorithm):
    r"""
    PIOReader - class for reading PIO (Parallel Input Output) data
    files
    
    Superclass: MultiBlockDataSetAlgorithm
    
    This class reads in dump files generated from xRage, a LANL physics
    code. The PIO (Parallel Input Output) library is used to create the
    dump files.
    
    @sa
    MultiBlockReader
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkPIOReader, obj, update, **traits)
    
    active_time_data_array_name = traits.String('CycleIndex', enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _active_time_data_array_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetActiveTimeDataArrayName,
                        self.active_time_data_array_name)

    def get_cell_array_status(self, *args):
        """
        get_cell_array_status(self, name:str) -> int
        C++: int get_cell_array_status(const char *name)"""
        ret = self._wrap_call(self._vtk_obj.GetCellArrayStatus, *args)
        return ret

    def set_cell_array_status(self, *args):
        """
        set_cell_array_status(self, name:str, status:int) -> None
        C++: void set_cell_array_status(const char *name, int status)"""
        ret = self._wrap_call(self._vtk_obj.SetCellArrayStatus, *args)
        return ret

    current_time_step = traits.Int(-1, enter_set=True, auto_set=False, desc=\
        r"""
        Specify the timestep to be loaded
        """
    )

    def _current_time_step_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCurrentTimeStep,
                        self.current_time_step)

    file_name = tvtk_base.vtk_file_name("", desc=\
        r"""
        Specify file name of PIO data file to read.
        """
    )

    def _file_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFileName,
                        self.file_name)

    float64 = traits.Bool(False, enter_set=True, auto_set=False, desc=\
        r"""
        Specify the use of float64 for data
        """
    )

    def _float64_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFloat64,
                        self.float64)

    hyper_tree_grid = traits.Bool(False, enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _hyper_tree_grid_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetHyperTreeGrid,
                        self.hyper_tree_grid)

    tracers = traits.Bool(False, enter_set=True, auto_set=False, desc=\
        r"""
        Specify the creation of tracer data
        """
    )

    def _tracers_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTracers,
                        self.tracers)

    def get_cell_array_name(self, *args):
        """
        get_cell_array_name(self, index:int) -> str
        C++: const char *get_cell_array_name(int index)"""
        ret = self._wrap_call(self._vtk_obj.GetCellArrayName, *args)
        return ret

    def _get_cell_data_array_selection(self):
        return wrap_vtk(self._vtk_obj.GetCellDataArraySelection())
    cell_data_array_selection = traits.Property(_get_cell_data_array_selection, desc=\
        r"""
        
        """
    )

    def _get_number_of_cell_arrays(self):
        return self._vtk_obj.GetNumberOfCellArrays()
    number_of_cell_arrays = traits.Property(_get_number_of_cell_arrays, desc=\
        r"""
        The following methods allow selective reading of solutions
        fields. By default, ALL data fields on the nodes are read, but
        this can be modified.
        """
    )

    def _get_number_of_time_data_arrays(self):
        return self._vtk_obj.GetNumberOfTimeDataArrays()
    number_of_time_data_arrays = traits.Property(_get_number_of_time_data_arrays, desc=\
        r"""
        Getters for time data array candidates.
        """
    )

    def get_time_data_array(self, *args):
        """
        get_time_data_array(self, idx:int) -> str
        C++: const char *get_time_data_array(int idx)"""
        ret = self._wrap_call(self._vtk_obj.GetTimeDataArray, *args)
        return ret

    def _get_time_data_string_array(self):
        return wrap_vtk(self._vtk_obj.GetTimeDataStringArray())
    time_data_string_array = traits.Property(_get_time_data_string_array, desc=\
        r"""
        
        """
    )

    def disable_all_cell_arrays(self):
        """
        disable_all_cell_arrays(self) -> None
        C++: void disable_all_cell_arrays()"""
        ret = self._vtk_obj.DisableAllCellArrays()
        return ret
        

    def enable_all_cell_arrays(self):
        """
        enable_all_cell_arrays(self) -> None
        C++: void enable_all_cell_arrays()"""
        ret = self._vtk_obj.EnableAllCellArrays()
        return ret
        

    _updateable_traits_ = \
    (('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('active_time_data_array_name', 'GetActiveTimeDataArrayName'),
    ('current_time_step', 'GetCurrentTimeStep'), ('file_name',
    'GetFileName'), ('float64', 'GetFloat64'), ('hyper_tree_grid',
    'GetHyperTreeGrid'), ('tracers', 'GetTracers'), ('progress_text',
    'GetProgressText'), ('object_name', 'GetObjectName'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'active_time_data_array_name',
    'current_time_step', 'file_name', 'float64', 'hyper_tree_grid',
    'object_name', 'progress_text', 'tracers'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(PIOReader, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit PIOReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['active_time_data_array_name', 'current_time_step',
            'file_name', 'float64', 'hyper_tree_grid', 'object_name', 'tracers']),
            title='Edit PIOReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit PIOReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

