# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.non_linear_cell import NonLinearCell


class QuadraticPyramid(NonLinearCell):
    r"""
    QuadraticPyramid - cell represents a parabolic, 13-node
    isoparametric pyramid
    
    Superclass: NonLinearCell
    
    QuadraticPyramid is a concrete implementation of NonLinearCell
    to represent a three-dimensional, 13-node isoparametric parabolic
    pyramid. The interpolation is the standard finite element, quadratic
    isoparametric shape function. The cell includes a mid-edge node. The
    ordering of the thirteen points defining the cell is point ids
    (0-4,5-12) where point ids 0-4 are the five corner vertices of the
    pyramid; followed by eight midedge nodes (5-12). Note that these
    midedge nodes lie on the edges defined by (0,1), (1,2), (2,3), (3,0),
    (0,4), (1,4), (2,4), (3,4), respectively. The parametric location of
    vertex #4 is [0, 0, 1].
    
    @sa
    QuadraticEdge QuadraticTriangle QuadraticTetra
    QuadraticHexahedron QuadraticQuad QuadraticWedge
    
    @par Thanks: The shape functions and derivatives could be implemented
    thanks to the report Pyramid Solid Elements Linear and Quadratic
    Iso-P Models From Center For Aerospace Structures
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkQuadraticPyramid, obj, update, **traits)
    
    def get_edge_array(self, *args):
        """
        get_edge_array(edgeId:int) -> Pointer
        C++: static const IdType *get_edge_array(IdType edgeId)
        Return the ids of the vertices defining edge/face
        (`edgeId`/`faceId'). Ids are related to the cell, not to the
        dataset.
        
        ote The return type changed. It used to be int*, it is now const
        IdType*. This is so ids are unified between Cell and
        Points.
        """
        ret = self._wrap_call(self._vtk_obj.GetEdgeArray, *args)
        return ret

    def get_face_array(self, *args):
        """
        get_face_array(faceId:int) -> Pointer
        C++: static const IdType *get_face_array(IdType faceId)"""
        ret = self._wrap_call(self._vtk_obj.GetFaceArray, *args)
        return ret

    def interpolation_derivs(self, *args):
        """
        interpolation_derivs(pcoords:(float, float, float), derivs:[float,
            float, float, float, float, float, float, float, float, float,
             float, float, float, float, float, float, float, float,
            float, float, float, float, float, float, float, float, float,
             float, float, float, float, float, float, float, float,
            float, float, float, float]) -> None
        C++: static void interpolation_derivs(const double pcoords[3],
            double derivs[39])"""
        ret = self._wrap_call(self._vtk_obj.InterpolationDerivs, *args)
        return ret

    def interpolation_functions(self, *args):
        """
        interpolation_functions(pcoords:(float, float, float),
            weights:[float, float, float, float, float, float, float,
            float, float, float, float, float, float]) -> None
        C++: static void interpolation_functions(const double pcoords[3],
            double weights[13])"""
        ret = self._wrap_call(self._vtk_obj.InterpolationFunctions, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('object_name', 'GetObjectName'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'object_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(QuadraticPyramid, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit QuadraticPyramid properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['object_name']),
            title='Edit QuadraticPyramid properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit QuadraticPyramid properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

