//------------------------------------------------------------------------------
// This file is part of the OpenStructure project <www.openstructure.org>
//
// Copyright (C) 2008-2020 by the OpenStructure authors
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License as published by the Free
// Software Foundation; either version 3.0 of the License, or (at your option)
// any later version.
// This library is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
// details.
//
// You should have received a copy of the GNU Lesser General Public License
// along with this library; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
//------------------------------------------------------------------------------

#include "subst_weight_matrix.hh"
#include <ost/base.hh>
#include <iostream>

namespace{

// The data for the following matrices can be reproduced by running generate_blosum_data.py
// in OST_SOURCE/modules/seq/alg/src/data

short RAW_BLOSUM45_DATA[23][23]={
  { 5, -1, -1, -2, -1, -2,  0, -2, -1, -1, -1, -1, -1, -1, -1, -2,  1,  0,  0, -2,  0, -2, -1},
  {-1,  4, -2,  5,  1, -3, -1,  0, -3,  0, -3, -2,  4, -2,  0, -1,  0,  0, -3, -4, -1, -2,  2},
  {-1, -2, 12, -3, -3, -2, -3, -3, -3, -3, -2, -2, -2, -4, -3, -3, -1, -1, -1, -5, -2, -3, -3},
  {-2,  5, -3,  7,  2, -4, -1,  0, -4,  0, -3, -3,  2, -1,  0, -1,  0, -1, -3, -4, -1, -2,  1},
  {-1,  1, -3,  2,  6, -3, -2,  0, -3,  1, -2, -2,  0,  0,  2,  0,  0, -1, -3, -3, -1, -2,  4},
  {-2, -3, -2, -4, -3,  8, -3, -2,  0, -3,  1,  0, -2, -3, -4, -2, -2, -1,  0,  1, -1,  3, -3},
  { 0, -1, -3, -1, -2, -3,  7, -2, -4, -2, -3, -2,  0, -2, -2, -2,  0, -2, -3, -2, -1, -3, -2},
  {-2,  0, -3,  0,  0, -2, -2, 10, -3, -1, -2,  0,  1, -2,  1,  0, -1, -2, -3, -3, -1,  2,  0},
  {-1, -3, -3, -4, -3,  0, -4, -3,  5, -3,  2,  2, -2, -2, -2, -3, -2, -1,  3, -2, -1,  0, -3},
  {-1,  0, -3,  0,  1, -3, -2, -1, -3,  5, -3, -1,  0, -1,  1,  3, -1, -1, -2, -2, -1, -1,  1},
  {-1, -3, -2, -3, -2,  1, -3, -2,  2, -3,  5,  2, -3, -3, -2, -2, -3, -1,  1, -2, -1,  0, -2},
  {-1, -2, -2, -3, -2,  0, -2,  0,  2, -1,  2,  6, -2, -2,  0, -1, -2, -1,  1, -2, -1,  0, -1},
  {-1,  4, -2,  2,  0, -2,  0,  1, -2,  0, -3, -2,  6, -2,  0,  0,  1,  0, -3, -4, -1, -2,  0},
  {-1, -2, -4, -1,  0, -3, -2, -2, -2, -1, -3, -2, -2,  9, -1, -2, -1, -1, -3, -3, -1, -3, -1},
  {-1,  0, -3,  0,  2, -4, -2,  1, -2,  1, -2,  0,  0, -1,  6,  1,  0, -1, -3, -2, -1, -1,  4},
  {-2, -1, -3, -1,  0, -2, -2,  0, -3,  3, -2, -1,  0, -2,  1,  7, -1, -1, -2, -2, -1, -1,  0},
  { 1,  0, -1,  0,  0, -2,  0, -1, -2, -1, -3, -2,  1, -1,  0, -1,  4,  2, -1, -4,  0, -2,  0},
  { 0,  0, -1, -1, -1, -1, -2, -2, -1, -1, -1, -1,  0, -1, -1, -1,  2,  5,  0, -3,  0, -1, -1},
  { 0, -3, -1, -3, -3,  0, -3, -3,  3, -2,  1,  1, -3, -3, -3, -2, -1,  0,  5, -3, -1, -1, -3},
  {-2, -4, -5, -4, -3,  1, -2, -3, -2, -2, -2, -2, -4, -3, -2, -2, -4, -3, -3, 15, -2,  3, -2},
  { 0, -1, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  0,  0, -1, -2, -1, -1, -1},
  {-2, -2, -3, -2, -2,  3, -3,  2,  0, -1,  0,  0, -2, -3, -1, -1, -2, -1, -1,  3, -1,  8, -2},
  {-1,  2, -3,  1,  4, -3, -2,  0, -3,  1, -2, -1,  0, -1,  4,  0,  0, -1, -3, -2, -1, -2,  4},
};

short RAW_BLOSUM62_DATA[23][23]={
  { 4, -2,  0, -2, -1, -2,  0, -2, -1, -1, -1, -1, -2, -1, -1, -1,  1,  0,  0, -3,  0, -2, -1},
  {-2,  4, -3,  4,  1, -3, -1,  0, -3,  0, -4, -3,  3, -2,  0, -1,  0, -1, -3, -4, -1, -3,  1},
  { 0, -3,  9, -3, -4, -2, -3, -3, -1, -3, -1, -1, -3, -3, -3, -3, -1, -1, -1, -2, -2, -2, -3},
  {-2,  4, -3,  6,  2, -3, -1, -1, -3, -1, -4, -3,  1, -1,  0, -2,  0, -1, -3, -4, -1, -3,  1},
  {-1,  1, -4,  2,  5, -3, -2,  0, -3,  1, -3, -2,  0, -1,  2,  0,  0, -1, -2, -3, -1, -2,  4},
  {-2, -3, -2, -3, -3,  6, -3, -1,  0, -3,  0,  0, -3, -4, -3, -3, -2, -2, -1,  1, -1,  3, -3},
  { 0, -1, -3, -1, -2, -3,  6, -2, -4, -2, -4, -3,  0, -2, -2, -2,  0, -2, -3, -2, -1, -3, -2},
  {-2,  0, -3, -1,  0, -1, -2,  8, -3, -1, -3, -2,  1, -2,  0,  0, -1, -2, -3, -2, -1,  2,  0},
  {-1, -3, -1, -3, -3,  0, -4, -3,  4, -3,  2,  1, -3, -3, -3, -3, -2, -1,  3, -3, -1, -1, -3},
  {-1,  0, -3, -1,  1, -3, -2, -1, -3,  5, -2, -1,  0, -1,  1,  2,  0, -1, -2, -3, -1, -2,  1},
  {-1, -4, -1, -4, -3,  0, -4, -3,  2, -2,  4,  2, -3, -3, -2, -2, -2, -1,  1, -2, -1, -1, -3},
  {-1, -3, -1, -3, -2,  0, -3, -2,  1, -1,  2,  5, -2, -2,  0, -1, -1, -1,  1, -1, -1, -1, -1},
  {-2,  3, -3,  1,  0, -3,  0,  1, -3,  0, -3, -2,  6, -2,  0,  0,  1,  0, -3, -4, -1, -2,  0},
  {-1, -2, -3, -1, -1, -4, -2, -2, -3, -1, -3, -2, -2,  7, -1, -2, -1, -1, -2, -4, -2, -3, -1},
  {-1,  0, -3,  0,  2, -3, -2,  0, -3,  1, -2,  0,  0, -1,  5,  1,  0, -1, -2, -2, -1, -1,  3},
  {-1, -1, -3, -2,  0, -3, -2,  0, -3,  2, -2, -1,  0, -2,  1,  5, -1, -1, -3, -3, -1, -2,  0},
  { 1,  0, -1,  0,  0, -2,  0, -1, -2,  0, -2, -1,  1, -1,  0, -1,  4,  1, -2, -3,  0, -2,  0},
  { 0, -1, -1, -1, -1, -2, -2, -2, -1, -1, -1, -1,  0, -1, -1, -1,  1,  5,  0, -2,  0, -2, -1},
  { 0, -3, -1, -3, -2, -1, -3, -3,  3, -2,  1,  1, -3, -2, -2, -3, -2,  0,  4, -3, -1, -1, -2},
  {-3, -4, -2, -4, -3,  1, -2, -2, -3, -3, -2, -1, -4, -4, -2, -3, -3, -2, -3, 11, -2,  2, -3},
  { 0, -1, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -2, -1, -1,  0,  0, -1, -2, -1, -1, -1},
  {-2, -3, -2, -3, -2,  3, -3,  2, -1, -2, -1, -1, -2, -3, -1, -2, -2, -2, -1,  2, -1,  7, -2},
  {-1,  1, -3,  1,  4, -3, -2,  0, -3,  1, -3, -1,  0, -1,  3,  0,  0, -1, -2, -3, -1, -2,  4},
};

short RAW_BLOSUM80_DATA[23][23]={
  { 7, -3, -1, -3, -2, -4,  0, -3, -3, -1, -3, -2, -3, -1, -2, -3,  2,  0, -1, -5, -1, -4, -2},
  {-3,  6, -6,  6,  1, -6, -2, -1, -6, -1, -7, -5,  5, -4, -1, -2,  0, -1, -6, -8, -3, -5,  0},
  {-1, -6, 13, -7, -7, -4, -6, -7, -2, -6, -3, -3, -5, -6, -5, -6, -2, -2, -2, -5, -4, -5, -7},
  {-3,  6, -7, 10,  2, -6, -3, -2, -7, -2, -7, -6,  2, -3, -1, -3, -1, -2, -6, -8, -3, -6,  1},
  {-2,  1, -7,  2,  8, -6, -4,  0, -6,  1, -6, -4, -1, -2,  3, -1, -1, -2, -4, -6, -2, -5,  6},
  {-4, -6, -4, -6, -6, 10, -6, -2, -1, -5,  0,  0, -6, -6, -5, -5, -4, -4, -2,  0, -3,  4, -6},
  { 0, -2, -6, -3, -4, -6,  9, -4, -7, -3, -7, -5, -1, -5, -4, -4, -1, -3, -6, -6, -3, -6, -4},
  {-3, -1, -7, -2,  0, -2, -4, 12, -6, -1, -5, -4,  1, -4,  1,  0, -2, -3, -5, -4, -2,  3,  0},
  {-3, -6, -2, -7, -6, -1, -7, -6,  7, -5,  2,  2, -6, -5, -5, -5, -4, -2,  4, -5, -2, -3, -6},
  {-1, -1, -6, -2,  1, -5, -3, -1, -5,  8, -4, -3,  0, -2,  2,  3, -1, -1, -4, -6, -2, -4,  1},
  {-3, -7, -3, -7, -6,  0, -7, -5,  2, -4,  6,  3, -6, -5, -4, -4, -4, -3,  1, -4, -2, -2, -5},
  {-2, -5, -3, -6, -4,  0, -5, -4,  2, -3,  3,  9, -4, -4, -1, -3, -3, -1,  1, -3, -2, -3, -3},
  {-3,  5, -5,  2, -1, -6, -1,  1, -6,  0, -6, -4,  9, -4,  0, -1,  1,  0, -5, -7, -2, -4, -1},
  {-1, -4, -6, -3, -2, -6, -5, -4, -5, -2, -5, -4, -4, 12, -3, -3, -2, -3, -4, -7, -3, -6, -2},
  {-2, -1, -5, -1,  3, -5, -4,  1, -5,  2, -4, -1,  0, -3,  9,  1, -1, -1, -4, -4, -2, -3,  5},
  {-3, -2, -6, -3, -1, -5, -4,  0, -5,  3, -4, -3, -1, -3,  1,  9, -2, -2, -4, -5, -2, -4,  0},
  { 2,  0, -2, -1, -1, -4, -1, -2, -4, -1, -4, -3,  1, -2, -1, -2,  7,  2, -3, -6, -1, -3, -1},
  { 0, -1, -2, -2, -2, -4, -3, -3, -2, -1, -3, -1,  0, -3, -1, -2,  2,  8,  0, -5, -1, -3, -2},
  {-1, -6, -2, -6, -4, -2, -6, -5,  4, -4,  1,  1, -5, -4, -4, -4, -3,  0,  7, -5, -2, -3, -4},
  {-5, -8, -5, -8, -6,  0, -6, -4, -5, -6, -4, -3, -7, -7, -4, -5, -6, -5, -5, 16, -5,  3, -5},
  {-1, -3, -4, -3, -2, -3, -3, -2, -2, -2, -2, -2, -2, -3, -2, -2, -1, -1, -2, -5, -2, -3, -1},
  {-4, -5, -5, -6, -5,  4, -6,  3, -3, -4, -2, -3, -4, -6, -3, -4, -3, -3, -3,  3, -3, 11, -4},
  {-2,  0, -7,  1,  6, -6, -4,  0, -6,  1, -5, -3, -1, -2,  5,  0, -1, -2, -4, -5, -1, -4,  6},
};

short RAW_BLOSUM100_DATA[23][23]={
  { 8, -4, -2, -5, -3, -5, -1, -4, -4, -2, -4, -3, -4, -2, -2, -3,  1, -1, -2, -6, -2, -5, -2},
  {-4,  6, -7,  6,  0, -7, -3, -2, -8, -2, -8, -7,  5, -5, -2, -4, -1, -2, -7, -9, -4, -6,  0},
  {-2, -7, 14, -8, -9, -4, -7, -8, -3, -8, -5, -4, -5, -8, -7, -8, -3, -3, -3, -7, -5, -6, -8},
  {-5,  6, -8, 10,  2, -8, -4, -3, -8, -3, -8, -8,  1, -5, -2, -5, -2, -4, -8,-10, -4, -7,  0},
  {-3,  0, -9,  2, 10, -8, -6, -2, -7,  0, -7, -5, -2, -4,  2, -2, -2, -3, -5, -8, -3, -7,  7},
  {-5, -7, -4, -8, -8, 11, -8, -4, -2, -6,  0, -1, -7, -7, -6, -6, -5, -5, -3,  0, -4,  4, -7},
  {-1, -3, -7, -4, -6, -8,  9, -6, -9, -5, -8, -7, -2, -6, -5, -6, -2, -5, -8, -7, -4, -8, -5},
  {-4, -2, -8, -3, -2, -4, -6, 13, -7, -3, -6, -5,  0, -5,  1, -1, -3, -4, -7, -5, -4,  1, -1},
  {-4, -8, -3, -8, -7, -2, -9, -7,  8, -6,  2,  1, -7, -7, -6, -7, -5, -3,  4, -6, -3, -4, -7},
  {-2, -2, -8, -3,  0, -6, -5, -3, -6, 10, -6, -4, -1, -3,  2,  3, -2, -3, -5, -8, -3, -5,  0},
  {-4, -8, -5, -8, -7,  0, -8, -6,  2, -6,  8,  3, -7, -7, -5, -6, -6, -4,  0, -5, -3, -4, -6},
  {-3, -7, -4, -8, -5, -1, -7, -5,  1, -4,  3, 12, -5, -5, -2, -4, -4, -2,  0, -4, -3, -5, -4},
  {-4,  5, -5,  1, -2, -7, -2,  0, -7, -1, -7, -5, 11, -5, -1, -2,  0, -1, -7, -8, -3, -5, -2},
  {-2, -5, -8, -5, -4, -7, -6, -5, -7, -3, -7, -5, -5, 12, -4, -5, -3, -4, -6, -8, -4, -7, -4},
  {-2, -2, -7, -2,  2, -6, -5,  1, -6,  2, -5, -2, -1, -4, 11,  0, -2, -3, -5, -5, -2, -4,  5},
  {-3, -4, -8, -5, -2, -6, -6, -1, -7,  3, -6, -4, -2, -5,  0, 10, -3, -3, -6, -7, -3, -5, -1},
  { 1, -1, -3, -2, -2, -5, -2, -3, -5, -2, -6, -4,  0, -3, -2, -3,  9,  2, -4, -7, -2, -5, -2},
  {-1, -2, -3, -4, -3, -5, -5, -4, -3, -3, -4, -2, -1, -4, -3, -3,  2,  9, -1, -7, -2, -5, -3},
  {-2, -7, -3, -8, -5, -3, -8, -7,  4, -5,  0,  0, -7, -6, -5, -6, -4, -1,  8, -5, -3, -5, -5},
  {-6, -9, -7,-10, -8,  0, -7, -5, -6, -8, -5, -4, -8, -8, -5, -7, -7, -7, -5, 17, -6,  2, -7},
  {-2, -4, -5, -4, -3, -4, -4, -4, -3, -3, -3, -3, -3, -4, -2, -3, -2, -2, -3, -6, -3, -4, -2},
  {-5, -6, -6, -7, -7,  4, -8,  1, -4, -5, -4, -5, -5, -7, -4, -5, -5, -5, -5,  2, -4, 12, -6},
  {-2,  0, -8,  0,  7, -7, -5, -1, -7,  0, -6, -4, -2, -4,  5, -1, -2, -3, -5, -7, -2, -6,  6},
};

short RAW_NUC44_DATA[16][16]={
  { 5, -4, -4, -4, -4, -4,  1,  1, -4, -4,  1, -4, -1, -1, -1, -2},
  {-4,  5,  5, -4, -4, -4,  1, -4,  1,  1, -4, -1, -4, -1, -1, -2},
  {-4,  5,  5, -4, -4, -4,  1, -4,  1,  1, -4, -1, -4, -1, -1, -2},
  {-4, -4, -4,  5, -4,  1, -4,  1, -4,  1, -4, -1, -1, -4, -1, -2},
  {-4, -4, -4, -4,  5,  1, -4, -4,  1, -4,  1, -1, -1, -1, -4, -2},
  {-4, -4, -4,  1,  1, -1, -4, -2, -2, -2, -2, -1, -1, -3, -3, -1},
  { 1,  1,  1, -4, -4, -4, -1, -2, -2, -2, -2, -3, -3, -1, -1, -1},
  { 1, -4, -4,  1, -4, -2, -2, -1, -4, -2, -2, -3, -1, -3, -1, -1},
  {-4,  1,  1, -4,  1, -2, -2, -4, -1, -2, -2, -1, -3, -1, -3, -1},
  {-4,  1,  1,  1, -4, -2, -2, -2, -2, -1, -4, -1, -3, -3, -1, -1},
  { 1, -4, -4, -4,  1, -2, -2, -2, -2, -4, -1, -3, -1, -1, -3, -1},
  {-4, -1, -1, -1, -1, -1, -3, -3, -1, -1, -3, -1, -2, -2, -2, -1},
  {-1, -4, -4, -1, -1, -1, -3, -1, -3, -3, -1, -2, -1, -2, -2, -1},
  {-1, -1, -1, -4, -1, -3, -1, -3, -1, -3, -1, -2, -2, -1, -2, -1},
  {-1, -1, -1, -1, -4, -3, -1, -1, -3, -1, -3, -2, -2, -2, -1, -1},
  {-2, -2, -2, -2, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
};

void FillData(ost::seq::alg::SubstWeightMatrix* subst, short (&data)[23][23]){
  char chars[23] = {'A','B','C','D','E','F','G','H','I','K','L','M','N','P','Q',
                    'R','S','T','V','W','X','Y','Z'};
  for(uint i = 0; i < 23; ++i){
    for(uint j = 0; j < 23; ++j){
      subst->SetWeight(chars[i],chars[j],data[i][j]);
    }
  }
}

void FillNucData(ost::seq::alg::SubstWeightMatrix* subst,
                 short (&data)[16][16]) {
  char chars[16] = {'A','T','U','G','C','S','W','R','Y','K','M','B','V','H',
                    'D','N'};
  for(uint i = 0; i < 16; ++i){
    for(uint j = 0; j < 16; ++j){
      subst->SetWeight(chars[i],chars[j],data[i][j]);
    }
  }
}

}

namespace ost { namespace seq { namespace alg {

void SubstWeightMatrix::AssignPreset(SubstWeightMatrix::Preset p)
{
  max_weight_ = 0;
  min_weight_ = 0;
  memset(weights_, 0, sizeof(WeightType)*ALPHABET_SIZE*ALPHABET_SIZE);

  switch(p){
    case BLOSUM45:{
      FillData(this,RAW_BLOSUM45_DATA);
      this->SetName("blosum45");
      break;
    }
    case BLOSUM62:{
      FillData(this,RAW_BLOSUM62_DATA);
      this->SetName("blosum62");
      break;
    }
    case BLOSUM80:{
      FillData(this,RAW_BLOSUM80_DATA);
      this->SetName("blosum80");
      break;
    }
    case BLOSUM100:{
      FillData(this,RAW_BLOSUM100_DATA);
      this->SetName("blosum100");
      break;
    }
    case NUC44:{
      FillNucData(this,RAW_NUC44_DATA);
      this->SetName("nuc44");
      break;
    }
  }
}

}}}
