%feature("docstring") OT::Cobyla
"Constrained Optimization BY Linear Approximations solver.

Available constructors:
    Cobyla(*problem*)

    Cobyla(*problem, rhoBeg*)

Parameters
----------
problem : :class:`~openturns.OptimizationProblem`
    Optimization problem to solve.
rhoBeg : float
    A reasonable initial change to the variables.

Notes
-----
It constructs successive linear approximations of the objective function and
constraints via a simplex of :math:`d+1` points, and optimizes these
approximations in a trust region at each step.
This solver use no derivative information and supports all types of constraints.

See also
--------
AbdoRackwitz, SQP, TNC, NLopt

Examples
--------
>>> import openturns as ot
>>> model = ot.SymbolicFunction(['E', 'F', 'L', 'I'], ['-F*L^3/(3*E*I)'])
>>> problem = ot.NearestPointProblem(model, 5.0)
>>> algo = ot.Cobyla(problem)
>>> algo.setMaximumCallsNumber(10000)
>>> algo.setStartingPoint([1.0] * 4)
>>> algo.run()
>>> result = algo.getResult()"

// ---------------------------------------------------------------------

%feature("docstring") OT::Cobyla::getRhoBeg
"Accessor to rhoBeg parameter.

Returns
-------
rhoBeg : float
    A reasonable initial change to the variables."

// ---------------------------------------------------------------------

%feature("docstring") OT::Cobyla::setRhoBeg
"Accessor to rhoBeg parameter.

Parameters
----------
rhoBeg : float
    A reasonable initial change to the variables."
