#!/bin/bash
# bbou@ac-toulouse.fr
# 2007-06-23 09:04:36 
# _install-core.sh

### P A R A M S

MYVERBOSE=
if [ "$1" = "-v" ]; then
	MYVERBOSE="-v"
	shift
fi
MYNOSHARES=
if [ "$1" = "-noshares" ]; then
	MYNOSHARES="$1"
	shift
fi
MYREALM="$1"
MYDNS="$2"
MYKDC="$3"
MYDOMAIN="$4"
MYSERVER="$5"
MYOU="$6"
MYADMIN="$7"
MYADMINPWD="$8"
MYUSERS="$9"
shift
MYHOSTALLOW="$9"
shift
MYWINSSERVER="$9"

### I N C L U D E

. ./_include.sh

### S T A R T

# P R I V I L E G E
if [ "$(whoami)" != "root" ]; then
	echo "User is $(whoami)"
	echo "This must be run as root" >&2
	exit 1
fi

# S T A T U S
[ -d /var/lib/sadms ] || mkdir -p /var/lib/sadms
echo '0' > /var/lib/sadms/domain

# make sure realm is uppercase
realm=`echo "${MYREALM}" | tr '[:lower:]' '[:upper:]'`

# make sure real is uppercase
pushd conf > /dev/null
./config.sh ${MYVERBOSE} ${MYNOSHARES} "${realm}" "${MYDNS}" "${MYKDC}" "${MYDOMAIN}" "${MYSERVER}" "${MYOU}" "${MYADMIN}" "${MYADMINPWD}" "${MYUSERS}" "${MYHOSTALLOW}" "${MYWINSSERVER}"
result=$?
popd > /dev/null

# S T A T U S
if [ "${result}" == "0" ]; then
	echo '1' > /var/lib/sadms/domain
fi
exit ${result}
