#!/bin/bash
# bbou@ac-toulouse.fr
# 2004-10-16 07:06:37   
# sadms.sh
# shell main entry point

function readlink2()
{
	[ ! -L $1 ] || ls -l $1 | sed s/.*-\>\ *//g
}

function followlink()
{
	prg="$1"
	while [ -h "${prg}" ] ; do
		ls=`ls -ld "${prg}"`
		link=`expr "${ls}" : '.*-> \(.*\)$'`
		if expr "${link}" : '.*/.*' > /dev/null; then
			prg="${link}"
		else
			prg=`dirname "${prg}"`/"${link}"
		fi
	done
	echo ${prg}
}

function absdir() 
{ 
	[ -n "$1" ] && ( cd "$1" 2> /dev/null && pwd ; ) 
}

where=`followlink $0`
where=`dirname ${where}`
where=`absdir ${where}`
cd ${where}

./sadms.py
