# Widelands C++ Source Code

Here's a brief overview of what each directory contains:

| Directory | Contents |
| --- | --- |
| ai | Computer Players |
| base | Basic functionality, like i18n, vector classes, logger, macros |
| chat | Chat backend |
| commands | Synchronized game logic events |
| economy | Economy component of the game logic |
| editor | The Widelands map editor |
| game_io | Game saveloading |
| graphic | Graphics backend (image loading, font renderer, animations, UI templating, ...) |
| io | Filesystem functions and file formats |
| logic | The main Game logic (map, player, tribes, world, ...) |
| map_io | Map saveloading |
| network | Networking backend for multiplayer games |
| notifications | Notification system for decoupling code (Observer pattern) |
| scripting | Lua scripting interface |
| sound | Sound & music backend |
| third_party | Third-party sources (eris, gettext, libmd, minizip) |
| ui_basic | UI Widgets |
| ui_fsmenu | Main ("Full Screen") menus |
| website | Utilities used by https://github.com/widelands/widelands-website |
| wui | In-game/In-editor GUI ("Widelands UI") |
