/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import java.io.Serializable;
import net.sf.saxon.event.Builder;
import net.sf.saxon.tinytree.TinyBuilder;
import net.sf.saxon.tinytree.TinyBuilderCondensed;
import net.sf.saxon.tree.TreeBuilder;

public abstract class TreeModel
implements Serializable {
    public static final TreeModel TINY_TREE = new TinyTree();
    public static final TreeModel TINY_TREE_CONDENSED = new TinyTreeCondensed();
    public static final TreeModel LINKED_TREE = new LinkedTree();

    public abstract Builder makeBuilder();

    public int getSymbolicValue() {
        return -1;
    }

    public static TreeModel getTreeModel(int symbolicValue) {
        switch (symbolicValue) {
            case 1: {
                return TINY_TREE;
            }
            case 2: {
                return TINY_TREE_CONDENSED;
            }
            case 0: {
                return LINKED_TREE;
            }
        }
        throw new IllegalArgumentException("tree model " + symbolicValue);
    }

    public boolean isMutable() {
        return false;
    }

    private static class LinkedTree
    extends TreeModel {
        private LinkedTree() {
        }

        public Builder makeBuilder() {
            return new TreeBuilder();
        }

        public int getSymbolicValue() {
            return 0;
        }

        public boolean isMutable() {
            return true;
        }
    }

    private static class TinyTreeCondensed
    extends TreeModel {
        private TinyTreeCondensed() {
        }

        public Builder makeBuilder() {
            return new TinyBuilderCondensed();
        }

        public int getSymbolicValue() {
            return 2;
        }
    }

    private static class TinyTree
    extends TreeModel {
        private TinyTree() {
        }

        public Builder makeBuilder() {
            return new TinyBuilder();
        }

        public int getSymbolicValue() {
            return 1;
        }
    }
}

