(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18607,        532]
NotebookOptionsPosition[     17482,        490]
NotebookOutlinePosition[     17819,        505]
CellTagsIndexPosition[     17776,        502]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{"real", "=",
  RowBox[{"Element", "[",
   RowBox[{
    RowBox[{"{",
     RowBox[{"f", ",", "g", ",", "h"}], "}"}], ",", "Reals"}],
   "]"}]}], "\[IndentingNewLine]",
 RowBox[{
  RowBox[{"B", "=",
   RowBox[{"{",
    RowBox[{
     RowBox[{"{",
      RowBox[{"f", ",", "g"}], "}"}], ",",
     RowBox[{"{",
      RowBox[{"0", ",", "h"}], "}"}]}], "}"}]}],
  ";"}], "\[IndentingNewLine]",
 RowBox[{"B", "//", "MatrixForm"}], "\[IndentingNewLine]",
 RowBox[{
  RowBox[{"T", "=",
   RowBox[{
    RowBox[{"B", "\[Transpose]"}], ".", "B"}]}],
  ";"}], "\[IndentingNewLine]",
 RowBox[{"T", "//", "MatrixForm"}], "\[IndentingNewLine]",
 RowBox[{
  RowBox[{
   RowBox[{"PKT", "[", "y_", "]"}], "=",
   RowBox[{"Collect", "[",
    RowBox[{
     RowBox[{"CharacteristicPolynomial", "[",
      RowBox[{"T", ",", "y"}], "]"}], ",", "y"}], "]"}]}],
  ";"}], "\[IndentingNewLine]",
 RowBox[{"PKT", "[", "x", "]"}]}], "Input",
 CellChangeTimes->{{3.446956856090171*^9, 3.446956893134967*^9}, {
  3.446956959305511*^9, 3.446957031534079*^9}, {3.446957326431201*^9,
  3.446957328504242*^9}, {3.446957385076174*^9, 3.4469574027806063`*^9}, {
  3.446957646920095*^9, 3.446957659420877*^9}, {3.4469582502810917`*^9,
  3.446958259286667*^9}, {3.446958330251533*^9, 3.446958377228405*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(",
   RowBox[{"f", "|", "g", "|", "h"}], ")"}], "\[Element]",
  "Reals"}]], "Output",
 CellChangeTimes->{{3.446957020201147*^9, 3.446957033158008*^9},
   3.4469573302283897`*^9, 3.446957404732697*^9, {3.446957651790984*^9,
   3.4469576607935047`*^9}, 3.446957806006545*^9, 3.446958157345051*^9,
   3.4469582619075537`*^9, 3.446958303902754*^9, {3.446958341613489*^9,
   3.446958380320176*^9}, 3.446983583696807*^9}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"f", "g"},
     {"0", "h"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]},
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]},
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$,
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.446957020201147*^9, 3.446957033158008*^9},
   3.4469573302283897`*^9, 3.446957404732697*^9, {3.446957651790984*^9,
   3.4469576607935047`*^9}, 3.446957806006545*^9, 3.446958157345051*^9,
   3.4469582619075537`*^9, 3.446958303902754*^9, {3.446958341613489*^9,
   3.446958380320176*^9}, 3.4469835837015963`*^9}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      SuperscriptBox["f", "2"],
      RowBox[{"f", " ", "g"}]},
     {
      RowBox[{"f", " ", "g"}],
      RowBox[{
       SuperscriptBox["g", "2"], "+",
       SuperscriptBox["h", "2"]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]},
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]},
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$,
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.446957020201147*^9, 3.446957033158008*^9},
   3.4469573302283897`*^9, 3.446957404732697*^9, {3.446957651790984*^9,
   3.4469576607935047`*^9}, 3.446957806006545*^9, 3.446958157345051*^9,
   3.4469582619075537`*^9, 3.446958303902754*^9, {3.446958341613489*^9,
   3.446958380320176*^9}, 3.44698358370547*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["f", "2"], " ",
   SuperscriptBox["h", "2"]}], "+",
  RowBox[{
   RowBox[{"(",
    RowBox[{
     RowBox[{"-",
      SuperscriptBox["f", "2"]}], "-",
     SuperscriptBox["g", "2"], "-",
     SuperscriptBox["h", "2"]}], ")"}], " ", "x"}], "+",
  SuperscriptBox["x", "2"]}]], "Output",
 CellChangeTimes->{{3.446957020201147*^9, 3.446957033158008*^9},
   3.4469573302283897`*^9, 3.446957404732697*^9, {3.446957651790984*^9,
   3.4469576607935047`*^9}, 3.446957806006545*^9, 3.446958157345051*^9,
   3.4469582619075537`*^9, 3.446958303902754*^9, {3.446958341613489*^9,
   3.446958380320176*^9}, 3.446983583709125*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"rl", "=",
   RowBox[{"l", "\[Rule]", " ",
    RowBox[{
     RowBox[{"(",
      RowBox[{
       RowBox[{"Abs", "[", "f", "]"}], "-",
       RowBox[{"Abs", "[", "h", "]"}]}], ")"}], "/",
     RowBox[{"Abs", "[", "f", "]"}]}]}]}], ";"}], "\[IndentingNewLine]",
 RowBox[{
  RowBox[{"rm", "=",
   RowBox[{"m", "\[Rule]",
    RowBox[{"g", "/", "f"}]}]}], ";"}], "\[IndentingNewLine]",
 RowBox[{
  RowBox[{"irm", "=",
   RowBox[{"g", "\[Rule]",
    RowBox[{"m", " ", "f"}]}]}], ";"}], "\[IndentingNewLine]",
 RowBox[{
  RowBox[{"rt", "=",
   RowBox[{"t", "\[Rule]",
    RowBox[{"2", "-", "l"}]}]}], ";"}], "\[IndentingNewLine]",
 RowBox[{
  RowBox[{"rs", "=",
   RowBox[{"s", "\[Rule]",
    RowBox[{"Sqrt", "[",
     RowBox[{
      RowBox[{"t", "^", "2"}], "+",
      RowBox[{"m", "^", "2"}]}], "]"}]}]}], ";"}], "\[IndentingNewLine]",
 RowBox[{
  RowBox[{"rr", " ", "=",
   RowBox[{"r", "\[Rule]",
    RowBox[{"Sqrt", "[",
     RowBox[{
      RowBox[{"l", "^", "2"}], "+",
      RowBox[{"m", "^", "2"}]}], "]"}]}]}], ";"}], "\[IndentingNewLine]",
 RowBox[{
  RowBox[{"ra", "=",
   RowBox[{"a", "\[Rule]",
    RowBox[{
     RowBox[{"(",
      RowBox[{"s", "+", "r"}], ")"}], "/", "2"}]}]}],
  ";"}], "\[IndentingNewLine]",
 RowBox[{
  RowBox[{"rsig", "=",
   RowBox[{"{",
    RowBox[{
     RowBox[{"s0", "\[Rule]",
      RowBox[{
       RowBox[{"Abs", "[", "h", "]"}], "/", "a"}]}], ",",
     RowBox[{"s1", "\[Rule]",
      RowBox[{
       RowBox[{"Abs", "[", "f", "]"}], "a"}]}]}], "}"}]}],
  ";"}], "\[IndentingNewLine]",
 RowBox[{
  RowBox[{"irsig", "=",
   RowBox[{"{",
    RowBox[{
     RowBox[{
      RowBox[{"h", "^", "2"}], "\[Rule]",
      RowBox[{
       RowBox[{"(",
        RowBox[{"a", " ", "s0"}], ")"}], "^", "2"}]}], ",",
     RowBox[{
      RowBox[{"f", "^", "2"}], "\[Rule]",
      RowBox[{
       RowBox[{"(",
        RowBox[{"s1", "/", "a"}], ")"}], "^", "2"}]}]}], "}"}]}],
  ";"}], "\[IndentingNewLine]",
 RowBox[{
  RowBox[{"rall", "=",
   RowBox[{"Flatten", "[",
    RowBox[{"{",
     RowBox[{
     "rsig", ",", "ra", ",", "rr", ",", "rs", ",", "rt", ",", "rm", ",",
      "rl"}], "}"}], "]"}]}],
  ";"}], "\[IndentingNewLine]", "\"\<OK\>\""}], "Input",
 CellChangeTimes->{{3.446957041908022*^9, 3.446957255249422*^9}, {
   3.446957315360136*^9, 3.446957322889594*^9}, {3.446957355411119*^9,
   3.446957357925486*^9}, {3.446957811919318*^9, 3.446957820828554*^9},
   3.446958420899625*^9, {3.44695999095378*^9, 3.446960030221951*^9}, {
   3.446960173780116*^9, 3.446960186577547*^9}, {3.4469834667933197`*^9,
   3.446983607829988*^9}, {3.4469837839437723`*^9, 3.446983801680324*^9},
   3.4469838988846817`*^9, {3.446984108922718*^9, 3.4469841904113817`*^9}, {
   3.446984244196659*^9, 3.446984436471591*^9}, {3.446984497753628*^9,
   3.446984737320344*^9}, {3.446985027169592*^9, 3.446985103067403*^9}, {
   3.446985143626687*^9, 3.446985158913012*^9}, {3.446985198276463*^9,
   3.44698521427085*^9}, 3.446986363241798*^9}],

Cell[BoxData["\<\"OK\"\>"], "Output",
 CellChangeTimes->{
  3.446957359969063*^9, 3.446957410221629*^9, 3.446957688903953*^9,
   3.446957826531488*^9, 3.44695816603397*^9, 3.4469583915495577`*^9,
   3.446958423585203*^9, {3.4469600102965803`*^9, 3.4469600262177353`*^9},
   3.446960188078844*^9, 3.446983601105462*^9, {3.446983895915937*^9,
   3.446983901043769*^9}, {3.446984147713909*^9, 3.44698419186615*^9},
   3.446984439383133*^9, {3.446984502632272*^9, 3.4469845086134033`*^9}, {
   3.4469845575797653`*^9, 3.4469846177800293`*^9}, 3.4469846502425127`*^9, {
   3.446984682933679*^9, 3.446984732006062*^9}, {3.446985099888068*^9,
   3.446985103871681*^9}, 3.4469851601727943`*^9, 3.446985216169341*^9,
   3.446986364176709*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Simplify", "[",
  RowBox[{
   RowBox[{
    RowBox[{"PKT", "[",
     RowBox[{
      RowBox[{"s0", "^", "2"}], "//.", "rall"}], "]"}], "\[Equal]", "0"}],
   ",",
   RowBox[{"Assumptions", "\[Rule]", "real"}]}],
  "]"}], "\[IndentingNewLine]",
 RowBox[{"Simplify", "[",
  RowBox[{
   RowBox[{
    RowBox[{"PKT", "[",
     RowBox[{
      RowBox[{"s1", "^", "2"}], "//.", "rall"}], "]"}], "\[Equal]", "0"}],
   ",",
   RowBox[{"Assumptions", "\[Rule]", "real"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.446958171526092*^9, 3.446958234222612*^9}, {
  3.446958288019986*^9, 3.4469583174407*^9}, {3.446958395119907*^9,
  3.446958517203347*^9}, {3.4469600615369797`*^9, 3.446960065796607*^9}, {
  3.446983766628628*^9, 3.446983820438116*^9}, {3.446985162792049*^9,
  3.44698516661201*^9}}],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.446958175791768*^9, 3.44695823543668*^9}, {
   3.446958267435328*^9, 3.446958318716419*^9}, {3.446958396454794*^9,
   3.4469585190807657`*^9}, {3.446960045478084*^9, 3.446960067366349*^9},
   3.4469838317935133`*^9, 3.446983905549203*^9, {3.446984173619033*^9,
   3.446984194491969*^9}, 3.446985167742787*^9}],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.446958175791768*^9, 3.44695823543668*^9}, {
   3.446958267435328*^9, 3.446958318716419*^9}, {3.446958396454794*^9,
   3.4469585190807657`*^9}, {3.446960045478084*^9, 3.446960067366349*^9},
   3.4469838317935133`*^9, 3.446983905549203*^9, {3.446984173619033*^9,
   3.446984194491969*^9}, 3.446985167753536*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Tau]num", "=",
   RowBox[{
    RowBox[{"(",
     RowBox[{
      RowBox[{"m", "/",
       RowBox[{"(",
        RowBox[{"s", "+", "t"}], ")"}]}], "+",
      RowBox[{"m", "/",
       RowBox[{"(",
        RowBox[{"r", "+", "l"}], ")"}]}]}], ")"}],
    RowBox[{"(",
     RowBox[{"1", "+", "a"}], ")"}]}]}], ";"}], "\[IndentingNewLine]",
 RowBox[{
  RowBox[{"\[Tau]", "=",
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], "/", "m"}],
    RowBox[{"(",
     RowBox[{"1", "-",
      RowBox[{"a", "^", "2"}]}], ")"}]}]}], ";"}], "\[IndentingNewLine]",
 RowBox[{"FullSimplify", "[",
  RowBox[{
   RowBox[{
    RowBox[{"(",
     RowBox[{"\[Tau]", "-", "\[Tau]num"}], ")"}], "//.",
    RowBox[{"{",
     RowBox[{"ra", ",", "rr", ",", "rs", ",", "rt"}], "}"}]}], ",",
   RowBox[{"Assumptions", "\[Rule]",
    RowBox[{"Element", "[",
     RowBox[{
      RowBox[{"{",
       RowBox[{"l", ",", "m"}], "}"}], ",", "Reals"}], "]"}]}]}],
  "]"}]}], "Input",
 CellChangeTimes->{{3.4469598890958233`*^9, 3.446959980887033*^9}, {
  3.44696007508949*^9, 3.4469601448071737`*^9}, {3.446960191396901*^9,
  3.446960218843555*^9}, {3.446983929418565*^9, 3.446983976274621*^9}, {
  3.446985385239952*^9, 3.446985396480372*^9}}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.4469599322730017`*^9, 3.4469599699292927`*^9, 3.446960079065507*^9, {
   3.446960121861973*^9, 3.446960149305118*^9}, {3.4469601941368103`*^9,
   3.446960219858893*^9}, {3.446983969461566*^9, 3.446983977447551*^9},
   3.446984200643147*^9, 3.4469853980008497`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"ClearAll", "[",
  RowBox[{"cv", ",", "sv"}], "]"}], "\[IndentingNewLine]",
 RowBox[{
  RowBox[{"rv1", "=",
   RowBox[{"{",
    RowBox[{
     RowBox[{"cv", "\[Rule]",
      RowBox[{"2", "/",
       RowBox[{"Sqrt", "[",
        RowBox[{
         RowBox[{"\[Tau]", "^", "2"}], "+", "4"}], "]"}]}]}], ",",
     RowBox[{"sv", "\[Rule]",
      RowBox[{"\[Tau]", "/",
       RowBox[{"Sqrt", "[",
        RowBox[{
         RowBox[{"\[Tau]", "^", "2"}], "+", "4"}], "]"}]}]}]}], "}"}]}],
  ";"}], "\[IndentingNewLine]",
 RowBox[{
  RowBox[{"v1", "=",
   RowBox[{"{",
    RowBox[{"cv", ",", "sv"}], "}"}]}], ";"}], "\[IndentingNewLine]",
 RowBox[{
  RowBox[{"Tm", "=",
   RowBox[{"Simplify", "[",
    RowBox[{
     RowBox[{"(",
      RowBox[{"T", "-",
       RowBox[{
        RowBox[{"s1", "^", "2"}], " ",
        RowBox[{"IdentityMatrix", "[", "2", "]"}]}]}], ")"}], "//.",
     RowBox[{"Flatten", "[",
      RowBox[{"{",
       RowBox[{"irm", ",", "irsig"}], "}"}], "]"}]}], "]"}]}],
  ";"}], "\[IndentingNewLine]",
 RowBox[{
  RowBox[{"Tm", "//", "MatrixForm"}], ";"}], "\[IndentingNewLine]",
 RowBox[{"FullSimplify", "[",
  RowBox[{
   RowBox[{
    RowBox[{"(",
     RowBox[{
      RowBox[{
       RowBox[{"(",
        RowBox[{"Tm", ".", "v1"}], ")"}], "[",
       RowBox[{"[", "1", "]"}], "]"}], "/.", "rv1"}], ")"}], "\[Equal]",
    "0"}], ",",
   RowBox[{"Assumptions", "\[Rule]",
    RowBox[{"{",
     RowBox[{
      RowBox[{"a", ">", "0"}], ",",
      RowBox[{"m", " ", "\[Epsilon]", " ", "Reals"}], ",",
      RowBox[{"s0", ">", "0"}], ",",
      RowBox[{"s1", ">", "0"}]}], "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.446960253246092*^9, 3.446960370904969*^9}, {
   3.446960429541995*^9, 3.4469604481403933`*^9}, {3.4469839878373203`*^9,
   3.446983996497814*^9}, {3.446984032993473*^9, 3.446984070948057*^9}, {
   3.4469842185690727`*^9, 3.446984232047552*^9}, {3.446985111662174*^9,
   3.446985130773539*^9}, {3.446985182554841*^9, 3.4469851838852167`*^9}, {
   3.446985220139859*^9, 3.4469852707307043`*^9}, {3.4469854382063828`*^9,
   3.446985457251931*^9}, {3.446985489069264*^9, 3.446985577667902*^9}, {
   3.44698565292869*^9, 3.446985653455284*^9}, 3.446985833759035*^9, {
   3.446985928898143*^9, 3.446985965831067*^9}, {3.4469864086922483`*^9,
   3.446986420185792*^9}, {3.446986480235176*^9, 3.446986497762805*^9}, {
   3.446986565817765*^9, 3.446986582035994*^9}, {3.4469866361838493`*^9,
   3.4469866401006517`*^9}}],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.446960361460239*^9, 3.4469604262578077`*^9, 3.446960767912444*^9, {
   3.446985119089162*^9, 3.446985132349647*^9}, {3.4469851743787203`*^9,
   3.4469851849887753`*^9}, {3.4469852222167873`*^9, 3.446985258643797*^9},
   3.4469854911887207`*^9, {3.44698554893601*^9, 3.446985582280492*^9},
   3.446985655684002*^9, 3.446985835284676*^9, {3.4469859369403477`*^9,
   3.446985968089904*^9}, 3.446986422033078*^9, {3.446986570975772*^9,
   3.4469866086595078`*^9}, 3.4469866547965193`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"rsign", "=",
   RowBox[{"{",
    RowBox[{
     RowBox[{"x_", "/",
      RowBox[{"Abs", "[", "x_", "]"}]}], "\[RuleDelayed]",
     RowBox[{"\[Epsilon]", "[", "x", "]"}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.4469870966616287`*^9, 3.4469871358170958`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"u1", "=",
  RowBox[{"{",
   RowBox[{"cu", ",", "su"}], "}"}]}], "\[IndentingNewLine]",
 RowBox[{
  RowBox[{"Simplify", "[",
   RowBox[{
    RowBox[{"Solve", "[",
     RowBox[{
      RowBox[{
       RowBox[{"B", ".", "v1"}], "==",
       RowBox[{"s1", " ", "u1"}]}], ",",
      RowBox[{"{",
       RowBox[{"cu", ",", "su"}], "}"}]}], "]"}], "/.",
    RowBox[{"Flatten", "[",
     RowBox[{"{",
      RowBox[{"rsig", ",", "irm"}], "}"}], "]"}]}], "]"}], "/.",
  "rsign"}]}], "Input",
 CellChangeTimes->{{3.446986395989442*^9, 3.446986447415085*^9}, {
  3.446986665794139*^9, 3.446986873148058*^9}, {3.4469869339380407`*^9,
  3.446987074169999*^9}, {3.446987143357095*^9, 3.4469871473310633`*^9}}],

Cell[BoxData[
 RowBox[{"{",
  RowBox[{"cu", ",", "su"}], "}"}]], "Output",
 CellChangeTimes->{
  3.4469864491944838`*^9, 3.446986695087696*^9, {3.4469867596782217`*^9,
   3.4469867885824633`*^9}, 3.4469868208854923`*^9, {3.446986869074039*^9,
   3.446986875311243*^9}, 3.446986937369157*^9, {3.446986973711945*^9,
   3.446986992964406*^9}, {3.446987035973722*^9, 3.446987075851811*^9},
   3.4469871511275883`*^9}],

Cell[BoxData[
 RowBox[{"{",
  RowBox[{"{",
   RowBox[{
    RowBox[{"cu", "\[Rule]",
     FractionBox[
      RowBox[{
       RowBox[{"(",
        RowBox[{"cv", "+",
         RowBox[{"m", " ", "sv"}]}], ")"}], " ",
       RowBox[{"\[Epsilon]", "[", "f", "]"}]}], "a"]}], ",",
    RowBox[{"su", "\[Rule]",
     FractionBox[
      RowBox[{"h", " ", "sv"}],
      RowBox[{"a", " ",
       RowBox[{"Abs", "[", "f", "]"}]}]]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{
  3.4469864491944838`*^9, 3.446986695087696*^9, {3.4469867596782217`*^9,
   3.4469867885824633`*^9}, 3.4469868208854923`*^9, {3.446986869074039*^9,
   3.446986875311243*^9}, 3.446986937369157*^9, {3.446986973711945*^9,
   3.446986992964406*^9}, {3.446987035973722*^9, 3.446987075851811*^9},
   3.446987151131425*^9}]
}, Open  ]]
},
WindowSize->{640, 750},
WindowMargins->{{Automatic, 54}, {Automatic, 26}},
FrontEndVersion->"6.0 for Mac OS X x86 (32-bit) (April 20, 2007)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 1312, 36, 118, "Input"],
Cell[1905, 61, 457, 9, 27, "Output"],
Cell[2365, 72, 919, 22, 57, "Output"],
Cell[3287, 96, 1083, 28, 63, "Output"],
Cell[4373, 126, 676, 17, 33, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5086, 148, 3033, 87, 178, "Input"],
Cell[8122, 237, 740, 11, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8899, 253, 819, 22, 43, "Input"],
Cell[9721, 277, 366, 5, 27, "Output"],
Cell[10090, 284, 366, 5, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10493, 294, 1262, 38, 73, "Input"],
Cell[11758, 334, 319, 5, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12114, 344, 2506, 65, 118, "Input"],
Cell[14623, 411, 545, 8, 27, "Output"]
}, Open  ]],
Cell[15183, 422, 305, 8, 27, "Input"],
Cell[CellGroupData[{
Cell[15513, 434, 731, 20, 58, "Input"],
Cell[16247, 456, 418, 8, 27, "Output"],
Cell[16668, 466, 798, 21, 47, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
