#include "ipstore"

unsigned IPStore::anticipated(unsigned b) {
    if (!onoff || b >= balancer.nbackends())
	return 0;

    // Weed store for decisions later
    weed();

    // Get number of anticipated clients for given back end
    unsigned ret = 0;
    static int lock;

    mutex_lock(&lock);
    for (StoreMap::iterator iter = store.begin();
	 iter != store.end();
	 iter++)
	if ((*iter).second.targetbackend == (int)b)
	    ret++;
    mutex_unlock(&lock);

    debugmsg("Anticipated connections for back end " << b << ": " <<
	     ret << '\n');
    return ret;
}
   
	
