// Copyright (c) .NET Foundation. All rights reserved.
// Licensed under the Apache License, Version 2.0. See License.txt in the project root for license information.

using System;
using Newtonsoft.Json;

namespace NuGet.Protocol
{
    public class PackageVulnerabilityMetadata
    {
        [JsonProperty(PropertyName = JsonProperties.AdvisoryUrl, ItemConverterType = typeof(SafeUriConverter))]
        public Uri AdvisoryUrl { get; internal set; }

        [JsonProperty(PropertyName = JsonProperties.Severity)]
        public int Severity { get; internal set; }

        public PackageVulnerabilityMetadata(Uri advisoryUrl, int severity)
        {
            AdvisoryUrl = advisoryUrl;
            Severity = severity;
        }

        public PackageVulnerabilityMetadata()
        {
        }
    }
}
