// Font generated by stb_font_inl_generator.c (4/1 bpp)
//
// Following instructions show how to use the only included font, whatever it is, in
// a generic way so you can replace it with any other font by changing the include.
// To use multiple fonts, replace STB_SOMEFONT_* below with STB_FONT_arial_40_latin_ext_*,
// and separately install each font. Note that the CREATE function call has a
// totally different name; it's just 'stb_font_arial_40_latin_ext'.
//
/* // Example usage:

static stb_fontchar fontdata[STB_SOMEFONT_NUM_CHARS];

static void init(void)
{
    // optionally replace both STB_SOMEFONT_BITMAP_HEIGHT with STB_SOMEFONT_BITMAP_HEIGHT_POW2
    static unsigned char fontpixels[STB_SOMEFONT_BITMAP_HEIGHT][STB_SOMEFONT_BITMAP_WIDTH];
    STB_SOMEFONT_CREATE(fontdata, fontpixels, STB_SOMEFONT_BITMAP_HEIGHT);
    ... create texture ...
    // for best results rendering 1:1 pixels texels, use nearest-neighbor sampling
    // if allowed to scale up, use bilerp
}

// This function positions characters on integer coordinates, and assumes 1:1 texels to pixels
// Appropriate if nearest-neighbor sampling is used
static void draw_string_integer(int x, int y, char *str) // draw with top-left point x,y
{
    ... use texture ...
    ... turn on alpha blending and gamma-correct alpha blending ...
    glBegin(GL_QUADS);
    while (*str) {
        int char_codepoint = *str++;
        stb_fontchar *cd = &fontdata[char_codepoint - STB_SOMEFONT_FIRST_CHAR];
        glTexCoord2f(cd->s0, cd->t0); glVertex2i(x + cd->x0, y + cd->y0);
        glTexCoord2f(cd->s1, cd->t0); glVertex2i(x + cd->x1, y + cd->y0);
        glTexCoord2f(cd->s1, cd->t1); glVertex2i(x + cd->x1, y + cd->y1);
        glTexCoord2f(cd->s0, cd->t1); glVertex2i(x + cd->x0, y + cd->y1);
        // if bilerping, in D3D9 you'll need a half-pixel offset here for 1:1 to behave correct
        x += cd->advance_int;
    }
    glEnd();
}

// This function positions characters on float coordinates, and doesn't require 1:1 texels to pixels
// Appropriate if bilinear filtering is used
static void draw_string_float(float x, float y, char *str) // draw with top-left point x,y
{
    ... use texture ...
    ... turn on alpha blending and gamma-correct alpha blending ...
    glBegin(GL_QUADS);
    while (*str) {
        int char_codepoint = *str++;
        stb_fontchar *cd = &fontdata[char_codepoint - STB_SOMEFONT_FIRST_CHAR];
        glTexCoord2f(cd->s0f, cd->t0f); glVertex2f(x + cd->x0f, y + cd->y0f);
        glTexCoord2f(cd->s1f, cd->t0f); glVertex2f(x + cd->x1f, y + cd->y0f);
        glTexCoord2f(cd->s1f, cd->t1f); glVertex2f(x + cd->x1f, y + cd->y1f);
        glTexCoord2f(cd->s0f, cd->t1f); glVertex2f(x + cd->x0f, y + cd->y1f);
        // if bilerping, in D3D9 you'll need a half-pixel offset here for 1:1 to behave correct
        x += cd->advance;
    }
    glEnd();
}
*/

#ifndef STB_FONTCHAR__TYPEDEF
#define STB_FONTCHAR__TYPEDEF
typedef struct
{
    // coordinates if using integer positioning
    float s0,t0,s1,t1;
    signed short x0,y0,x1,y1;
    int   advance_int;
    // coordinates if using floating positioning
    float s0f,t0f,s1f,t1f;
    float x0f,y0f,x1f,y1f;
    float advance;
} stb_fontchar;
#endif

#define STB_FONT_arial_40_latin_ext_BITMAP_WIDTH         512
#define STB_FONT_arial_40_latin_ext_BITMAP_HEIGHT        398
#define STB_FONT_arial_40_latin_ext_BITMAP_HEIGHT_POW2   512

#define STB_FONT_arial_40_latin_ext_FIRST_CHAR            32
#define STB_FONT_arial_40_latin_ext_NUM_CHARS            560

#define STB_FONT_arial_40_latin_ext_LINE_SPACING          26

static unsigned int stb__arial_40_latin_ext_pixels[]={
    0x99999991,0x99999999,0x00199999,0x00000000,0x00000180,0x00000000,
    0xcc880000,0x0000003c,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x4cccccc4,0x99880099,0x40099981,0x99881cca,0x31000009,
    0x33326033,0x88002ccc,0x32a00999,0x001ccccc,0x31001710,0x99999975,
    0x2a399999,0x880001cc,0xffffffff,0xffffffff,0x0000ffff,0x000dfff1,
    0x3a200162,0xf910000f,0x7fc401ff,0xfff10001,0x03fec00d,0x407fff20,
    0x0004eff8,0x7bdfdb73,0x05fb8015,0x7fed4000,0x00ffb3de,0x7f765cc0,
    0x001ceeff,0xfeec9800,0x0000bdef,0x7fff6dc4,0xa8000acd,0x00cefffd,
    0xfffffa80,0xfd004fff,0x077fd49f,0x260fff20,0x80005fff,0xf505fff8,
    0x009fffff,0x404ffe88,0x2ffffffc,0x809f7000,0xfffffffa,0xffffffff,
    0x0007ff92,0xffffff10,0xffffffff,0x01ffffff,0x03fff200,0x001fee00,
    0x44000ffe,0x200fffff,0x2e0005fc,0x36000fff,0x3fe2007f,0x3ffe202f,
    0xfd1000ef,0xffffffff,0x03fe807f,0xffff5000,0x01ff6bff,0x3ffff6a0,
    0xffffffff,0x540000be,0xfffffffe,0x4000bfff,0xffffffd8,0x004fffff,
    0xffffffd1,0xea8007ff,0x3eeeeeee,0x13fff100,0xf9003fff,0x3ffea07f,
    0x7fe40000,0xffff500e,0xfd8009ff,0xfffc802f,0xb0002fff,0x3ffa203f,
    0xffffffff,0x92ffffff,0x100007ff,0x55555555,0x5555dffd,0x20005555,
    0x0001fff8,0xf9800fff,0x3ff60005,0xff300dff,0x7ffc0003,0x03fec002,
    0x8809ff70,0x803ffffd,0xfffffff9,0x04ffffff,0x00003fea,0x3ffbfffe,
    0x5400ffb3,0xceeffffe,0xfffedcbb,0xf90001ef,0xffdfffff,0x001dffff,
    0x3fffffea,0xffffffef,0x7fff401e,0x2ffffdcf,0x20000000,0x2ffdeffa,
    0x407ff900,0x20004ffc,0x2001fff8,0x2a004ffb,0xff9000de,0xff100009,
    0x7ffffe40,0xfbaaafff,0xff90aaef,0x20000007,0x00004ffd,0x0007ff70,
    0x2a003ffc,0xff0004df,0x09fd003f,0x01ffdc00,0xf003fec0,0xff9800df,
    0x7fffcc07,0x7ff5441b,0x017fa06f,0x43fff300,0x200ffb08,0x01cffffb,
    0x4fffeb88,0x7ffff400,0xfffea80b,0xffffb806,0x7ed441ad,0xff702fff,
    0xfffd883f,0x90bd5000,0xffc8007d,0x000004ff,0x20001ffb,0x5c003ffb,
    0x2f5404ff,0xff901f64,0xbf500009,0x3ffffe60,0x7fc47fff,0x003ffc86,
    0x9ffb0000,0x3b600000,0x3ffc0004,0x01fff200,0x2017fe60,0x20000ffb,
    0xfb0004ed,0x004cc00f,0x9007ff40,0x3ee00dff,0x5ff501ff,0x2ffe4000,
    0xf900ffb0,0x5c0007ff,0xf9004fff,0x3f2009ff,0x3fe604ff,0xff5002ff,
    0x13ff60df,0x8017ffc4,0x04fd87fa,0x004ccc80,0x0b322000,0x001e5c00,
    0x2a027fdc,0x204fd87f,0x80004ffc,0xfff903fc,0x88ffffff,0x3ffc86ff,
    0xfb000000,0x3000009f,0x40003bfb,0x7e4007ff,0xffa8007f,0x005ff804,
    0xb04c0000,0x000000ff,0xff807ff6,0x3ff6000f,0x001bfa04,0x3603ffe8,
    0x77fec07f,0xfe980001,0x7ffd402f,0x7ffec004,0x0effe880,0x0fffcc00,
    0xfb00fff4,0x17aa009f,0x00000fb2,0x00000000,0xffb80000,0x642f5404,
    0x13ff203e,0x403fe000,0xfffffffd,0x437fc47f,0x00003ffc,0x009ffb00,
    0xf939f000,0x7e64c001,0x400cccff,0xa8004cca,0x7fdc04ff,0xeec98002,
    0x981bceff,0x00ffb0ef,0xfc8000d4,0x0fff301f,0x206ffa80,0xf0001ffc,
    0x3fec03ff,0x001dff50,0x07ffc400,0x000dffd0,0xf909fff1,0x360003ff,
    0x4ffc85ff,0x32202620,0xc98000cc,0x0777444c,0x95009dd7,0x0eee8839,
    0xe8813bae,0x13bae0ee,0x6453fee0,0xc98000cc,0x009ff94c,0x6fefec98,
    0x3fffffe0,0x7fc47fff,0x733ffc86,0x00017bfb,0x0013ff60,0x03d8f500,
    0x3ffffea0,0x00001fff,0x2027fd40,0x754007fe,0xffffffff,0xdff10cff,
    0x2a01ff61,0x4000efef,0xff301ffc,0x6f44001f,0x0bff300c,0x3ff332e0,
    0x7ec2cccf,0x403ffa07,0x20bdedb8,0x3fea1aa9,0x05fff305,0x20f7f200,
    0x20004fff,0xffa85ff9,0xff88002f,0xffa8001f,0x90fffc47,0xff900bff,
    0x21fff887,0x3e205ffc,0x17ff21ff,0x7c53fee0,0xfa8001ff,0x009ff97f,
    0x3fffffee,0xffe80dff,0x47ffffff,0xffc86ff8,0xffffffab,0x6c0000ef,
    0x400004ff,0x3001ec6a,0xdddfffdd,0x3fb2e201,0x059930bd,0xfa80ffea,
    0x3ff2005f,0xffffffff,0xffebffff,0x3a01ff60,0xc8007b14,0x3ffe02ff,
    0xfd000004,0xfffd001f,0x85ffffff,0x5ff907fd,0x3ffffee0,0x87ff91ff,
    0xffc80ffd,0x98020007,0x40001fff,0x27ffec01,0x07ffe200,0x11ffea00,
    0x7fe43fff,0x43ffc805,0x3f21fff8,0x3ffe205f,0x2017ff21,0xfff14ffb,
    0xfff50003,0x36013ff2,0xffcdffff,0x7fec1eff,0x47ffffff,0xffc86ff8,
    0xfdcdfffe,0x6c0005ff,0x800004ff,0x000fb8cf,0xf300fff0,0x3fffffff,
    0x3ea07ff5,0x0bff203f,0x5ffffec0,0x3ff66209,0x7ec1ffff,0xd507cc07,
    0x02ffc800,0x0033fff6,0x05ff9000,0xffffddd0,0x7fd83ddd,0xf904ff98,
    0xfffbbfff,0xf983ffd3,0x06ffe83f,0xfff90000,0xd0000001,0x2003dfff,
    0x8001fff8,0x77447ffa,0x013bae0e,0xdd10fff2,0x02775c1d,0x75c1ddd1,
    0x4ffb804e,0x0003fff1,0x3ff2fff5,0x5fffdc04,0xbffdff10,0xffffffb8,
    0x37fc47ff,0x42ffffe4,0x0004ffe9,0x00013ff6,0x017ffee0,0x5407ff80,
    0xfeceffff,0x703ffdff,0x7fec07ff,0xefffc800,0xfffe9800,0xf807fd84,
    0xf7001322,0x7ffcc05f,0x0001beff,0x4004ffa8,0x7ec03ffd,0xc80ffc87,
    0x7ec43fff,0xdfd07fff,0x000bfff0,0x01bff600,0xff910000,0x1009ffff,
    0x50003fff,0x00000fff,0x0001ffe4,0x2e000000,0x3fff14ff,0x2fff5000,
    0x3e204ffc,0x567d45ff,0x7ff40fff,0x447fffff,0xfffc86ff,0x0bffe205,
    0x027fec00,0x7ffe4000,0x1ffe0006,0x40dfff88,0x03ffffe8,0x7fc05ff7,
    0x4fff9807,0x7fffe400,0x6403fec0,0x4001fdcf,0x74403ffb,0xdfffffff,
    0xff98001b,0x17ff4005,0x3fa1ff60,0x03fff985,0x641bfffa,0x03fff87f,
    0xbffd0000,0x74c00000,0xffffa9ff,0x3ffe202e,0x7ffa8001,0x3f200000,
    0x0000003f,0xa7fdc000,0x8001fff8,0x9ff97ffa,0x2077fcc0,0x89ffd2fd,
    0xfffffff9,0x6437fc47,0x7e400fff,0xffb0005f,0xff000009,0x20003fff,
    0x3ff207ff,0x3fffa205,0x203ffb03,0xfe806ff8,0x3ee000ff,0x7ec3ffff,
    0x039b5007,0x009ff300,0xffffff91,0x4007dfff,0x7c006ff8,0x3fec00ff,
    0x3fa0bfe6,0x7ffd404f,0xf88ff704,0x000002ff,0x00007fff,0xb1077f40,
    0x101bffff,0x50003fff,0x00000fff,0x0001ffe4,0x2e000000,0x3fff14ff,
    0x2fff5000,0x3ee04ffc,0x310ff84f,0x3fff6201,0x37fc47ff,0x4402ffe4,
    0xfb0006ff,0xa800009f,0x005ffdff,0x3e20fff0,0x7fd401ff,0x06ff883f,
    0xf3017fe6,0x7d4007ff,0x20fffccf,0x000007fd,0x4003ffe0,0xfffffdb8,
    0xf000dfff,0x3e6001ff,0x46ec807f,0xfff987fc,0x17ffcc00,0x3e20ffb8,
    0x000002ff,0xf3007fff,0xffffffff,0x413fe29f,0x40effffb,0x8001fff8,
    0x39957ffa,0x20399700,0x39953ffc,0x2a399700,0xccb801cc,0x229ff701,
    0xa8001fff,0x09ff97ff,0x3e61ffe4,0xfdb98006,0x437fc47f,0xff003ffc,
    0xffb0001f,0xfd800009,0x000fff8f,0xff507ff8,0x0fffa00d,0x5c07ffb3,
    0x7fe404ff,0x57fe6006,0x3f63fff9,0x3b72a207,0x2000bcef,0x8000dffb,
    0xfffffdb9,0x1ffe801e,0x00dff500,0x7ec37ec0,0xfff8805f,0xf88ff901,
    0x000003ff,0xf3007fff,0xffffffff,0x80bfee9f,0x446fffd8,0xa8001fff,
    0x07ffb7ff,0x3205ffd0,0x07ffb3ff,0x3f65ffd0,0x2ffe803f,0x3e29ff70,
    0xfa8001ff,0x409ff97f,0x1fe41ffe,0x11ffa000,0x5ff90dff,0x007ffa00,
    0x0013ff60,0xf96ff880,0xfff0007f,0x4013fee0,0x3ffa3ffc,0x1ffe403f,
    0x4013ffa0,0x7ff46ff9,0x7541ff64,0xffffffff,0x3fea003f,0x7540006f,
    0xfd807fff,0x9ff7002f,0x42ff4000,0xf8802fff,0x21bfa07f,0x00005fff,
    0x3009ffd0,0xffffffff,0x17fea9ff,0x893fff20,0xa8001fff,0x07ffb7ff,
    0x3205ffd0,0x07ffb3ff,0x3f65ffd0,0x2ffe803f,0x3e29ff70,0xfa8001ff,
    0x409ff97f,0x0ff40fff,0x11ffa000,0x3ff90dff,0x00bff600,0x0013ff60,
    0xf34ffb80,0xfff000df,0x400fff60,0x3ffe3ffb,0x03ffd802,0x4401fffc,
    0x7fe40eff,0x3f21ff65,0xfeddffff,0x2a003fff,0x900007ff,0xfc805fff,
    0x7ffb004f,0x227f4000,0xa800fff8,0x9ff105ff,0x000dffd0,0x017ff600,
    0x453ff600,0xfc800fff,0x07ffe27f,0x6dffea00,0xffe803ff,0x367ff902,
    0xffe803ff,0xd007ffb2,0x3fee05ff,0x003fff14,0x3f2fff50,0x87ffe04f,
    0xe80007f8,0x437fc47f,0xfd001ffc,0xffb0003f,0x7f400009,0x00bffe1f,
    0x3fa0fff0,0x7ff7002f,0x6c02fffc,0x3fe203ff,0x7ff4402f,0x367ffb80,
    0x67ffcc7f,0x06ffe980,0x22fffd10,0xfb0002aa,0x4ffd809f,0x003ffd00,
    0x3e627fc0,0x9ff7007f,0x320ffea0,0x220007ff,0x3fee0ace,0x7ec0000f,
    0x07fff64f,0x221fff10,0xa8001fff,0x07ffb7ff,0x3205ffd0,0x07ffb3ff,
    0x3f65ffd0,0x2ffe803f,0x3e29ff70,0xfa8001ff,0x409ff97f,0x13ea2fff,
    0x11ffa000,0x5ff90dff,0x003ffe00,0x0013ff60,0x323ffcc0,0x7fc005ff,
    0x007ffb07,0xfca8ffee,0x3ff200ef,0x07ffe604,0x2a03ffd0,0x8ffb0fff,
    0x7c406ffc,0x7fcc01ff,0x1fff11cf,0x0dff7000,0xf003ffe8,0x7c0001ff,
    0x037fd44f,0xfb02ffe8,0x3fff301f,0x3ffee000,0x00fffe20,0x449ffb00,
    0x7404fffe,0x3fff10ff,0x2fff5000,0xfe803ffd,0x27ff902f,0xfe803ffd,
    0x007ffb2f,0x3ee05ffd,0x03fff14f,0x32fff500,0x3ffa04ff,0x9b10bf63,
    0x11ffa007,0x7ff90dff,0x00dff100,0x0013ff60,0x2627fec0,0x3e000fff,
    0x4ffc80ff,0x707ff900,0x7fe40bff,0x03ffe606,0x2a02ffd8,0x8ffb0fff,
    0xfe801ffd,0x17fec01f,0x4001fff4,0x7fc05ffa,0x7ff9802f,0xfe833100,
    0x403ffc45,0xfb80fffa,0x17ffe04f,0x42fff400,0x0000fffd,0xfd313ff6,
    0xff105dff,0x00fffc4f,0xfdbffd40,0x2ffe803f,0x3f67ff90,0x2ffe803f,
    0xfd007ffb,0x53fee05f,0x8001fff8,0x9ff97ffa,0xff2ffe40,0x005ffa81,
    0x6ff88ffd,0xb806ffc8,0xfb0005ff,0xf100009f,0x7ffd03ff,0x407ffc00,
    0xfd005ffa,0x03ffa07f,0xf103ffdc,0x3ff203ff,0xb3ffdc02,0x6c0020ff,
    0x3fe202ff,0x00dff905,0x4407ffb0,0xfa801fff,0x8ffb005f,0x0ffe86fd,
    0x5437ff40,0x7fdc06ff,0x7fdc001f,0x5fff982f,0x13ff6000,0x37ffff62,
    0xf88fff60,0xfa8001ff,0x007ffb7f,0x3f205ffd,0x007ffb3f,0x3ff65ffd,
    0x02ffe803,0x3fe29ff7,0xffa8001f,0x4c09ff97,0x85f99fff,0xfd002ffe,
    0xc86ff88f,0x7f402fff,0xffb0003f,0xff700009,0x01ffee0d,0xf882fff8,
    0x7fcc01ff,0x05ff903f,0xf803ffea,0x3ffb82ff,0x367ffc80,0xca88007f,
    0x3ea02fff,0xdfff303f,0x3ffea001,0x03ffea00,0x4013fee0,0x43fe47fd,
    0x3f604ffd,0x7ffcc5ff,0x1fffe801,0x0dfff300,0x0077ffdc,0x09fffd30,
    0x5fffffd4,0x7fc44ffe,0xffb8001f,0xd007ffb7,0x3ff205ff,0xd007ffb3,
    0x0fff65ff,0x5c0bffa0,0x3fff14ff,0x2fff7000,0x7ec04ffc,0x7e43fcef,
    0xffd000ff,0xfc86ff88,0xffb01eff,0x7fec000d,0xffe80004,0x05fff103,
    0x3b7fffa0,0xb017ff21,0x3ee07fff,0x07ffe02f,0x7d43fff8,0xdffb004f,
    0x75103fec,0xffffffdb,0x17fdc05f,0x15ffffd0,0x1bfff620,0x200dff70,
    0xfb003ffd,0x542ffa8f,0x3620cfff,0xf916ffff,0x3e6009ff,0x9102cfff,
    0xd801ffff,0x80acffff,0xfffffda8,0x7ffe4402,0xff880dff,0xffc8001f,
    0xd007ffb6,0x3ff205ff,0xd007ffb3,0x0fff65ff,0x5c0bffa0,0x3fff14ff,
    0x2dff9000,0x7c404ffc,0xfc9affff,0x3a001fff,0x437fc47f,0xacfffffc,
    0x02fffeb9,0x013ff600,0x01fff300,0xb802ffec,0x223fffff,0x6c40dfff,
    0xf703ffff,0x17fec07f,0x7ccdffb0,0x3ffe005f,0x3221ff64,0xffffffff,
    0x3202fffe,0x3fa202ff,0xecdfffff,0x805fffff,0xfd003ffc,0x1ff6003f,
    0xff70bff1,0xbbffb9ff,0xffffffff,0xfffa8007,0xfdcbdfff,0x9001ffff,
    0xbfffffff,0xfffffffb,0x7f540019,0x3ffe06ff,0x6ffc8002,0xfd007ffb,
    0x4fff205f,0xfe803ffd,0x007ffb2f,0x3ee05ffd,0x00bffe4f,0x7e5bff20,
    0xffe9804f,0x2fffffff,0x223ff400,0xcffc86ff,0xfffffffe,0x7ec0002f,
    0x7e40004f,0x7ffd405f,0xfffd7000,0xeffffa89,0xffefffec,0x407ff503,
    0x3ea04ffb,0x06ff99ff,0xd87ffee0,0x7fffc47f,0xfb1aceff,0x17fe405f,
    0x3ffff620,0xffffffff,0x03ffb004,0x4003ffe0,0x1ffd87fd,0xffffffc8,
    0xffffff54,0x3a60003d,0xffffffff,0x4001efff,0xfffffffa,0x1effffff,
    0x3fff6000,0x007fff05,0x3f6bffb0,0x2fff803f,0x3f67ff90,0x2fff803f,
    0xff007ffb,0x93fee05f,0xd8003fff,0x09ff95ff,0x3ffff620,0xe8000dff,
    0x437fc47f,0xfff93ffc,0x000017df,0xfff80000,0xcccccccd,0x4004fffc,
    0xfff30098,0xfb3dffff,0x13fea07f,0x7406ff88,0x00effdff,0xd8dfff10,
    0x5ffff47f,0x80bffa01,0x93002ffc,0xdfffffff,0x3fe20059,0x0fff1006,
    0x7cc3fec0,0x9df9506f,0xacefeb85,0x80155440,0xffffffda,0x540002ef,
    0xfffffffd,0x700002ce,0xffb07fff,0x7fff000b,0xf100fff2,0x3ff205ff,
    0x8807ff93,0x7ff92fff,0x02fff880,0x7fec9ff7,0x3fff8005,0x74009ff9,
    0x0009aabf,0xff11ffa0,0x987ff90d,0x0000000a,0xffff5000,0xffffffff,
    0x0000ffff,0x7bfd9710,0x540bff61,0x7fe404ff,0x3fffea02,0x3ff2000f,
    0xf33fec2f,0xfff003ff,0x00ffe405,0x00efecc0,0x003ffb80,0x6c00bff5,
    0x0bff507f,0x7f440000,0xefc8002f,0x3000001a,0x40003ff7,0x42ffe400,
    0x2001fffb,0xff91fffb,0x2fff9809,0x3f27ffb0,0x7ffcc04f,0x9809ff92,
    0xff702fff,0x00fffdc9,0x323fff70,0xff1004ff,0x7f400001,0x6437fc47,
    0x000003ff,0x0009ddb0,0x7fffffec,0xffffffff,0xee8802ff,0xffe80006,
    0x809ff502,0x7f406ff8,0x3f2004ff,0x27fd84ff,0xf9805ffb,0x3ff202ff,
    0x3bff0001,0x01bfe000,0x2004ffb8,0x3ff207fd,0xd8800004,0xfd0004ff,
    0x8000001b,0x54001efc,0x7fcc06ff,0x0efff987,0x27ffe880,0x7ec06ffb,
    0x5ffb02ff,0xfb01bfee,0x1bfee5ff,0x205fffb0,0x3fe64ffb,0xfe8800ef,
    0x013ff27f,0x00002fd4,0xdff11ffa,0x0007ff90,0x17ffa000,0x57ffc400,
    0x99999999,0x805ffe99,0x0d447ff8,0x201fff00,0xfb804ff9,0x3fff601f,
    0x3fa600df,0x7fd80eff,0x3601bff2,0x3f602fff,0xdc88001f,0x7dc005ff,
    0x3ffa001f,0x01ff6002,0x0003dffd,0x017ffea0,0x04ffee80,0x3fb20000,
    0xff1000ef,0x37fd403f,0x0aefffc8,0x45ffff50,0xf903fff9,0x3fa05fff,
    0x07fff31f,0x4cbffff2,0xff903fff,0x3fee05ff,0x577ffe44,0x5ffff500,
    0xc8027fe4,0x7400003f,0x437fc47f,0x00003ffc,0x00bffd00,0x001bfee0,
    0x8803fff7,0x0fff87ff,0x103ffd40,0x3fa00fff,0xfffffb05,0xfb97bdff,
    0x201bffff,0x3ffee7fd,0x3ffff602,0x001ffe03,0x8003ff20,0x3e6005fe,
    0x3f6000ff,0x7fff4407,0xfb50001d,0x00001bff,0x00003ff9,0x003ffa80,
    0xfe81bffa,0xfffd104f,0xffdb9dff,0xffd09fff,0xffd957df,0x6cd45ffb,
    0x3ffa0fff,0xffecabef,0x3ffa2ffd,0xffecabef,0x55512ffd,0xfe889ffb,
    0xedceffff,0x644fffff,0x00aaadff,0x800001ff,0x37fc47fe,0x0001ffe4,
    0x05fcb800,0x007ffd00,0x404fff88,0xffe87ea8,0x13ffe204,0x037bffd0,
    0x3f20ffd4,0xfffff73f,0x7fffffff,0x3e27fd80,0xba8acfff,0x44fffffe,
    0x005ffeb9,0x03ffea20,0x5007fd40,0x0dffd557,0x5007fd80,0x57bffffd,
    0x36aa6233,0x001effff,0x03ffb100,0x7e440000,0x3fe6003f,0xfec9acff,
    0x3f6201ff,0xffffffff,0xfd303fff,0x3fffffff,0x3fe65ff7,0x7f4c5fff,
    0x9fffffff,0x3fa62ffb,0x9fffffff,0xfff52ffb,0xfb109fff,0xffffffff,
    0xff907fff,0xf305ffff,0xfd00000d,0xc86ff88f,0x000003ff,0x2000fe60,
    0x8000fff9,0xbf007ffc,0x37bfff70,0x1ffffb71,0xfffffa80,0xf993f600,
    0x7ff6443f,0x00beffff,0x7fd47fd8,0xefffffff,0x3e26ff9a,0x8002ffff,
    0x03ffffff,0xfd013fa0,0x005fffff,0x5c007fd8,0xffffffff,0xffffffff,
    0xed80003f,0x0005ffff,0xffffeb80,0xfffb8006,0x2fffffff,0xffffb500,
    0x8039ffff,0xdfffffd8,0x3ee5ff71,0xfb105fff,0x2e3bffff,0x7fec42ff,
    0xff71dfff,0x3ffffea5,0x3ff6a04f,0x1cffffff,0xffffff90,0x0009d505,
    0xf88ffd00,0x03ffc86f,0x3f200000,0x6ffc8001,0x5fff3000,0xfb02fc80,
    0xffffffff,0x3ee003df,0x3e600fff,0x26012e0f,0x6c0009aa,0xfffe987f,
    0x7ffc4fff,0x07ffff11,0xfffff100,0x07fd4007,0x3fffffe0,0x07fd8004,
    0xffedb880,0xffffffff,0xf00000bd,0x001bffff,0xffffb000,0x3660003d,
    0x1effffff,0xaa998800,0x35300019,0x06aea200,0x0000d4c0,0x26200353,
    0x80099999,0x019aa998,0x99999988,0x40000000,0x80998198,0x00000998,
    0x000bfb00,0x8000fffe,0x3e206ffe,0x7fff5402,0x000bdfff,0x20065d44,
    0x000001cb,0x2204ca80,0x220009a9,0x40000abc,0x59500018,0x03753300,
    0x00265400,0xaaba9880,0x3000001a,0x00001353,0x00cd4c40,0x1baa8800,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0xa8002640,0x20000fff,0x0201fffb,0x01baa980,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0x05ffd800,0x27ffc400,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x82620000,0x26000198,0x00000099,0x00000000,
    0x10000000,0x30003999,0x00000799,0x1f774c00,0x22099100,0x3bae004c,
    0x332a001e,0x00000001,0x00033322,0x66453326,0xcccccccc,0xcccccccc,
    0xa8000001,0x000003cc,0x11776400,0x98000ddd,0x40002ccc,0xccccccc8,
    0xabcccccc,0x776c4000,0x00000005,0xc882cca8,0x0099933c,0xa8999950,
    0x4c0002cc,0x02ff8aff,0x07ffea00,0xff880000,0x5000005f,0x9800dfff,
    0x4c006fff,0xa8006fff,0x7cc006ff,0xd10005ff,0x4005ffff,0x06fc83fe,
    0x1fffff30,0x00fff600,0x6c3fffa0,0x7c400fff,0xfa8001ff,0xfffff17f,
    0xffffffff,0x005fffff,0xffe9bffe,0x06ffb80f,0x05dd7100,0x98fff600,
    0x640007ff,0x40006fff,0xfffffff8,0xffffffff,0xffb000df,0xf10009ff,
    0x64000dff,0x6ff983ff,0xa800fff5,0x7e41ffff,0xfa80003f,0x80003fef,
    0x0000efe9,0x01fff900,0xfff10000,0xfa800bff,0x3e6002ff,0x54004fff,
    0x7ec006ff,0xfb0000ef,0x001fff9f,0x36ab3fee,0xff8803ff,0xb006ffbf,
    0xf98007ff,0x5fff11ff,0x03fff100,0x22fff500,0xffffffff,0xffffffff,
    0xffb802ff,0x03fff30f,0x4001bfee,0x002fbaec,0x3e63ffd8,0x7fc0007f,
    0x20001fff,0xfffffff8,0xffffffff,0x7dc00eff,0x002ffddf,0x002fff98,
    0xf307ff90,0x01ffeadf,0x81ffffa8,0x00003ffc,0x00007dd7,0x00003ec8,
    0x001fff88,0xb5ffd000,0xfb8007ff,0x3fe6006f,0x2a001fff,0x3e2006ff,
    0xf70000ff,0x03bfeadf,0x7ffffec0,0x9ffb005f,0x36017ff2,0x7ec003ff,
    0x017ff23f,0x000fffc4,0xff8bffd4,0xaaaaaabf,0xaaaaaaaa,0x22ffe800,
    0x3ee03ffd,0x1f88006f,0x3b20016e,0x01bba22e,0xffdffa80,0x3fe20005,
    0x999999af,0xfffeba99,0x1fff300f,0x0003fff1,0x2000dff5,0xff983ffc,
    0x200fff56,0x900efffa,0x540007ff,0x003ec85e,0x3ec85ea8,0x7ff70000,
    0x3f200000,0x05fff15f,0x001ffd80,0x1dfffff3,0x01bfea00,0x0002ffc8,
    0x7ec3fff3,0x3b6a005f,0xff9002de,0x01fff44d,0x8800fff6,0x3bfe25ff,
    0x3fff1000,0x2fff5000,0x0001fff8,0x993fe600,0x7fdc05ff,0x21f88006,
    0x0000006a,0xf8ffd800,0xf10000ff,0xfb8003ff,0xfff883ff,0x003bfee3,
    0x000bff20,0x3ffd4000,0x077ffd40,0x7d400000,0x8004fd87,0x04fd87fa,
    0x009db000,0x3bba6000,0x0037baa0,0x26009db0,0x04ffffff,0x200dff50,
    0x20003ed8,0x4cc40998,0x30000001,0x19988133,0x001ffec0,0x77541bd7,
    0x3ffe2001,0x7ffa8001,0x0003fff1,0x2e2f5c00,0x7fdc00de,0x31bb0006,
    0x0000007d,0x96ff8800,0x220007ff,0xd8001fff,0x199885ff,0x00009998,
    0x000009d9,0x501ffea0,0x0001dfff,0x217aa000,0xea8003ec,0x0003ec85,
    0x00000000,0x80000000,0xfffcfff9,0x06ffa801,0x00000000,0x00000000,
    0x07ffb000,0x44000000,0xa8001fff,0x3fff17ff,0x00000000,0x006ffb80,
    0x019ffb10,0x80000000,0xdff34ffb,0x3ffe2000,0x7ffa8001,0x00000000,
    0xf5000000,0x7ffd40ff,0x8800000e,0x98000ccc,0x199914cc,0x09993000,
    0x3ffb2e60,0x00001cee,0x100ccc88,0x30001999,0x5ffe6999,0x5400effe,
    0x199916ff,0x29993000,0x2a004cc9,0x36e601cc,0x59930bdf,0x5efedcc0,
    0xfb059930,0xcb98007f,0x01ceeffe,0x003fff10,0x3e2fff50,0x880001ff,
    0x98000ccc,0x1bfee4cc,0x88066644,0x26999300,0x32a004cc,0x3ffd001c,
    0x40017ffc,0x8001fff8,0x5401fff9,0x730001cc,0x39ddffd9,0x20b32a00,
    0xfff53cc8,0x03bffea0,0x40166540,0x8001fff8,0xfff17ffa,0xfff50003,
    0xffffd880,0x1dffffff,0x3fe60000,0x3fff100f,0x2fff5000,0xfff37ff9,
    0x16ffa809,0x50003fff,0x17ffcfff,0xa80fff80,0xffffffff,0xfa83ffa9,
    0x9fffffff,0xffd83ffa,0xfffb1003,0xbfffffff,0x1fff8803,0x17ffa800,
    0x00003fff,0x0003fff1,0x7fdcfff5,0x03fff106,0x7cfff500,0xfff002ff,
    0x8fff3001,0x88005ffc,0xb8001fff,0x7e400fff,0x7ec4003f,0xffffffff,
    0x7fe401df,0xf56ff983,0xdfff50ff,0x1ffe4001,0x00fffc40,0xf8bffd40,
    0xfa8001ff,0x3ffea07f,0xffffffff,0x00003fff,0x2201fff3,0xa8001fff,
    0x4fff37ff,0x2a01fffc,0x3fff16ff,0x4fff5000,0xfa805ffc,0xffff886f,
    0xfdfffece,0x7fffc43f,0xfdfffece,0x03ffd83f,0xffffffa8,0xffffffff,
    0x07ffe203,0x45ffea00,0x80001fff,0x8001fff8,0x3fee7ffa,0x03fff106,
    0x64fff500,0xffa805ff,0x89ffb006,0x4000fff9,0x8001fff8,0xfc807ffe,
    0x3fea003f,0xffffffff,0x3203ffff,0x6ff983ff,0xffa8fff5,0x7e4000ef,
    0xfff8803f,0x7ffa8001,0x0003fff1,0x3f60fff5,0x2609cfff,0x05ffffeb,
    0x0fff9800,0x003fff10,0x3e6fff50,0x077ff47f,0xff16ffa8,0xff50003f,
    0x007ffccf,0x3fa0fff6,0x7ff440df,0x6fff43ff,0x7ffff440,0x403ffd83,
    0x09cffffd,0x3ffffae6,0x03fff105,0x22fff500,0x80001fff,0x8001fff8,
    0x3fee7ffa,0x03fff106,0x4cfff500,0x7ec00fff,0xfff8803f,0x003ffe81,
    0x000fffc4,0x007fffd1,0x36007ff9,0x209cffff,0x5ffffeb9,0xf307ff90,
    0xa9ffeadf,0x8000efff,0xf8803ffc,0xfa8001ff,0x03fff17f,0x50fff500,
    0x1003dfff,0x0007fffd,0x100fff98,0x50003fff,0x1ffe6fff,0x2a09fff3,
    0x3fff16ff,0x8fff5000,0x3e202ffe,0x2ffe40ff,0xc8ffffa0,0x7ff405ff,
    0x03ffd83f,0x007bffea,0x20ffffa2,0x8001fff8,0xfff17ffa,0xdddddddd,
    0x45dddddd,0x8001fff8,0x3fee7ffa,0x03fff106,0xe8fff500,0x3fe202ff,
    0x6ffb800f,0x800fff70,0xaaabfff8,0xfdcaaaaa,0xf9006fff,0xfff5007f,
    0xffd1003d,0x07ff907f,0x3feadff3,0x1fffff57,0x07ff9000,0x003fff10,
    0x3e2fff50,0xfa8001ff,0x2fffc47f,0x3fff6200,0x3fe60000,0x3fff100f,
    0x2fff5000,0xffc87ff9,0x16ffa82f,0x50003fff,0x5ffb8fff,0x3e17fea0,
    0x7fd401ff,0x007ffe3f,0xfb07fff5,0x3ffe207f,0x7fec4005,0x0fffc40f,
    0x8bffd400,0xffffffff,0xffffffff,0x07ffe22f,0xb9ffea00,0xfff106ff,
    0xfff50003,0x2a05ffb8,0xffd005ff,0x0bffe207,0xfffff880,0xffffffff,
    0x000dffff,0xf8807ff9,0x6c4005ff,0x7fe40fff,0xf56ff983,0xfffff5ff,
    0xff9000df,0x3fff1007,0x2fff5000,0x8001fff8,0x7fe47ffa,0xff88000f,
    0x3e60005f,0xfff100ff,0xfff50003,0x7f41ffe6,0xb7fd40ef,0x8001fff8,
    0x7fc47ffa,0x85ffb00f,0xfd005ff9,0x017fe67f,0x7ec1fff4,0x1fff903f,
    0xbfff1000,0x001fff88,0xff17ffa8,0xffffffff,0x5fffffff,0x000fffc4,
    0xff73ffd4,0x07ffe20d,0x11ffea00,0x3f601fff,0xfff9802f,0x017ff600,
    0xffffff88,0xffffffff,0x7e4002df,0x7ffe403f,0xfff88000,0x4c1ffe45,
    0xffff56ff,0x9fff7bff,0x03ffc800,0x001fff88,0xff17ffa8,0xff50003f,
    0x01fffccf,0x01fff700,0x03ffe600,0x000fffc4,0xff9bffd4,0x89fff307,
    0xfff16ffa,0xfff50003,0xf107ffb0,0x09ff50ff,0x7d4fff20,0x7ff9004f,
    0xf307ffb0,0x5c0007ff,0x3fe20fff,0xffa8001f,0x335fff17,0x33333333,
    0x7fc41333,0xffa8001f,0x441bfee7,0xa8001fff,0x3ffd87ff,0x9007ff88,
    0xffa80bff,0xfff1000f,0xffb9999b,0x640009ff,0x3fe603ff,0x3ee0003f,
    0x0fff20ff,0x7fd5bfe6,0x3ff65fff,0x3ff2002f,0x1fff8803,0x17ffa800,
    0x50003fff,0x3ffdcfff,0x3ffe2000,0xfff30003,0x07ffe201,0x4dffea00,
    0x3ff207ff,0x45bfea2f,0xa8001fff,0x6ffa87ff,0xfc84ffb8,0x7ff7003f,
    0x5c00fff2,0x3ffd83ff,0x0007ffb8,0xf11fffc4,0xf70003ff,0x07ffe2ff,
    0x3ffe2000,0x7ffa8001,0x7c41bfee,0xfa8001ff,0x86ffa87f,0xff004ffb,
    0x999999bf,0x009fff99,0xb807ffe2,0x8000dfff,0x3ee03ffc,0x7c40007f,
    0x0fff23ff,0x7fd5bfe6,0x7ffc44ff,0x7ff9000f,0x03fff100,0x22fff500,
    0xa8001fff,0x17ff27ff,0x1bffe000,0x07ffcc00,0x001fff88,0xff37ffa8,
    0x0effe80f,0x3fe2dff5,0xffa8001f,0xe83fff07,0x2ffd81ff,0x367ff700,
    0xff7002ff,0x907ffb07,0xf0000bff,0x1fff8dff,0x16ffc800,0x00003fff,
    0x0003fff1,0x7fdcfff5,0x03fff106,0x20fff500,0x7ff41fff,0xffffa801,
    0xffffffff,0xf1007fff,0xffa803ff,0xffc8006f,0x017ff203,0xc9bffe00,
    0x6ff983ff,0x2a09fff5,0xf9005fff,0xfff1007f,0xfff50003,0x0007ffe2,
    0xffe9ffea,0xffd80004,0xfff30007,0x07ffe201,0x4dffea00,0x7fcc07ff,
    0x22dff54f,0xa8001fff,0x9ff907ff,0xfd837fcc,0x7ff7003f,0x5c00fff6,
    0x3ffd83ff,0x0004ffe8,0x7fc7ffd8,0xffc8002f,0x003fff15,0x03fff100,
    0x5cfff500,0xfff106ff,0xfff50003,0xf993ff20,0xfffb006f,0xffffffff,
    0x005fffff,0x7003fff1,0xc800bfff,0x3ffa03ff,0xffd80004,0x260fff27,
    0x0fff56ff,0x803fffc8,0xf8803ffc,0xfa8001ff,0x03fff17f,0x7cfff500,
    0xc80003ff,0xf30007ff,0x3fe201ff,0xffa8001f,0x900fff37,0xdff55fff,
    0x0007ffe2,0x7cc1ffea,0x40fff26f,0xf9004ffc,0x013ff27f,0x7ec1ffe4,
    0x03fff83f,0x47ffc800,0xd8003ffe,0x3fff14ff,0xfff10000,0xfff50003,
    0xf8837fdc,0xfa8001ff,0x4dff307f,0xf8803ffc,0x99999aff,0xffe99999,
    0x1fff8805,0x07fffb00,0xf01ffe40,0x900007ff,0x1ffe4fff,0xffab7fcc,
    0x1fffe807,0x401ffe40,0x8001fff8,0xfff17ffa,0xfff50003,0x000bffe2,
    0x003ffea0,0x403ffe60,0x8001fff8,0xfff37ffa,0x2bfffa00,0x3fff16ff,
    0x0fff5000,0xffe8fff4,0x00bff700,0x7fdcfffa,0x07ffd005,0xff887ffb,
    0xfa80002f,0x17ff60ff,0x44fffe00,0x80001fff,0x8001fff8,0x3fee7ffa,
    0x03fff106,0x40fff500,0x1ffd1ffe,0x00dff700,0x401fffb8,0x1001fff8,
    0x2003ffff,0xff103ffc,0xf500005f,0x0fff21ff,0x7fd5bfe6,0xefff9807,
    0x00fff200,0x0007ffe2,0x7fc5ffea,0xffa8001f,0x003fff37,0x03fff300,
    0x01fff300,0x0007ffe2,0x7fcdffea,0xdfff3007,0x3ffe2dff,0x7ffa8001,
    0x3e6ffee0,0x3ffe205f,0x9fffcc01,0x4c01fff8,0xffd83fff,0x00fffcc3,
    0x0fffcc00,0x4003fff7,0xff12fffb,0xf100003f,0xf50003ff,0x837fdcff,
    0x8001fff8,0x3ee07ffa,0x005ff9bf,0x88007ffd,0x7c404fff,0x3ea001ff,
    0xff9006ff,0x07ffe607,0x3ffe6000,0xf307ff91,0x01ffeadf,0x902fffdc,
    0xff1007ff,0xff50003f,0x007ffe2f,0x7c5ffea0,0xa80002ff,0x98000fff,
    0xff100fff,0xff50003f,0x801ffe6f,0x16fffffc,0x50003fff,0x7fc40fff,
    0x6402ffbe,0x7fec05ff,0x017ff23f,0xfb07fffb,0x2fff887f,0xfffa8000,
    0x03fffe20,0x89bffa20,0x80001fff,0x8001fff8,0x3fee7ffa,0x03fff106,
    0x40fff500,0x2ffbeff8,0x00fff980,0x407ffc80,0x4001fff8,0xc803fffd,
    0xfff103ff,0xff500005,0x20fff21f,0xfff56ff9,0x1ffff400,0x8803ffc8,
    0xb8001fff,0x3fff17ff,0x4fff7000,0x80003fff,0x30007ffc,0x3e201fff,
    0xfb8001ff,0x00fff37f,0xb7ffff44,0x8001fff8,0x7ec07ffb,0xf8807fff,
    0x7ec40dff,0x3fe23fff,0x7fec40df,0x3ffd83ff,0x0003fff8,0xfc87ffc8,
    0xf500aeff,0x7fc47fff,0xf880001f,0xfb8001ff,0x41bfee7f,0x8001fff8,
    0x7ec07ffb,0xf9007fff,0x3e6000df,0x3fe202ff,0x7fc4001f,0x7fe400ff,
    0x00fffe03,0xc9fff200,0x6ff983ff,0x4400fff5,0xfc81ffff,0xfff8803f,
    0x6ffc8001,0x0003fff1,0x7ffcdff9,0xffd80004,0xfff30006,0x07ffe201,
    0x4dbff200,0x7cc007ff,0xfff16fff,0xdff90003,0x4ffffa80,0xdffff500,
    0xffdfffd9,0xeffffa87,0xffefffec,0xf83ffd83,0xd80004ff,0xffe886ff,
    0xfedcefff,0x7c44ffff,0xffffffff,0xffffffff,0x03fff17f,0x5cdff900,
    0xfff106ff,0xdff90003,0x4ffffa80,0x007fff00,0x1037ff40,0x70003fff,
    0xfc80bfff,0x13ffe03f,0x9bff6000,0xff983ffc,0x800fff56,0xfc86fffa,
    0x5fff003f,0x4dff9000,0xc8002fff,0x1bff26ff,0x13ffa000,0x07ffcc00,
    0x0005fff0,0x3fe6dff9,0xfffc8007,0x000bffe6,0x3e01bff2,0x26001fff,
    0xefffffff,0xf983ffd9,0x9effffff,0xffd83ffd,0x006ffc83,0x204ffe80,
    0xfffffffc,0x884fffff,0xffffffff,0xffffffff,0x0bffe7ff,0xb9bff200,
    0x3ffe06ff,0x6ffc8002,0x01ffff80,0x000fffa8,0x407ffee0,0x0001fff8,
    0x6405fffd,0x3ff203ff,0xffe80006,0x260fff24,0x0fff56ff,0x89fffb00,
    0xff003ffc,0xffb0007f,0x001fffcb,0xff32ffec,0x7d40003f,0x065d41ff,
    0x401fff50,0xd8003fff,0x0fff35ff,0x4dffd100,0xd8003fff,0xffc805ff,
    0xecb88006,0x5ffb0bdf,0x37fb2e20,0xb05ffb0b,0xfff307ff,0x7fd40003,
    0x7f65401f,0x0cffffff,0xffffff10,0xffffffff,0x7fcfffff,0xffd8003f,
    0xf81bfee5,0xfd8003ff,0x6ffc805f,0x00bffb00,0x04fff880,0x0003fff1,
    0x403fffe6,0x3e603ffc,0x2a0001ff,0x3ff21fff,0xf56ff983,0xff1000ff,
    0x1ffe45ff,0x005ffd80,0x3f63fff8,0xfff8005f,0x0037ffc3,0xfd0dffd0,
    0x3ffd403f,0x0017ff60,0x1000fffe,0x5ffd8003,0x03fff800,0x0003ffb8,
    0x005ffb00,0x4c17fec0,0x037ffc00,0x00dffd00,0x009efc88,0x06f98000,
    0x4002ffec,0x0ff23fff,0x000bffb0,0xf7007fff,0x0000007f,0x0000ff10,
    0x64000062,0x7ffc03ff,0x3ffa0006,0x37fcc006,0x20002600,0x3ee002fd,
    0x3ee001ff,0x3ffee1ff,0x3ffee001,0x01fffd41,0x41fffdc0,0x3ee02ffd,
    0x7ffdc07f,0x3ffee001,0x77fec001,0x1fffb802,0x07ffee00,0x2003ffa0,
    0x3fa001a8,0x4003511f,0x7fcc1ffe,0xfffa80df,0xfffb8003,0x03fb8003,
    0x17ea0000,0x003fff70,0xfb0fffdc,0x1fffb803,0x07ffee00,0x0003ffa0,
    0x17e60000,0x77fec000,0x3ff60002,0x1fffd403,0x1fffdc00,0x01bfea00,
    0x00dfff98,0x4c001ff0,0x8800efff,0x7fcc7ffe,0xfe8800ef,0x9fffb07f,
    0x2fffe400,0x3a05ffc8,0x7fcc05ff,0xfe8800ef,0xfeb8007f,0x7fcc01ff,
    0xfe8800ef,0x4ffa807f,0x003ffe00,0xfff8fff7,0x43ffdc00,0xb05ffed8,
    0x64009fff,0x90005fff,0x4000007f,0x7fcc03fb,0xfe8800ef,0x2007fc7f,
    0x800efff9,0xa807ffe8,0x000004ff,0x000bf500,0x07fffae0,0x017fec00,
    0x0027ffec,0x000bfff9,0x4400bff5,0x8805ffed,0xffc8007f,0xff500aef,
    0xfff905ff,0x3fea015d,0xffd102ff,0x7f4c03df,0xff500fff,0xfffc819f,
    0xefffc802,0xffff500a,0x7fcc0005,0xefffc805,0xffff500a,0x1ffe8805,
    0x813ffa00,0x7f44fff8,0x3ffe204f,0x40ffe404,0x01efffe8,0x03ffffa6,
    0x002fec00,0x00dfb000,0x015dfff9,0x88bfffea,0xffc803ff,0xff500aef,
    0xfe8805ff,0x0000001f,0x0001ff70,0x002ffcc0,0x8801ffe8,0x201efffe,
    0x00ffffe9,0x004ffc80,0x8803ffb0,0x744002ff,0xdcefffff,0x04fffffe,
    0xdfffffd1,0xfffffdb9,0xfffe8809,0xffdccdff,0x6c00efff,0xffddffff,
    0xfd1005ff,0xdb9dffff,0x009fffff,0x804ffb80,0xefffffe8,0xfffffedc,
    0xfffb9b04,0xfffb800b,0xffdb89bd,0xdfffb85f,0xfffdb89b,0x0fff4405,
    0xfffffe88,0xffffdccd,0x2e0000ef,0x03a88bff,0x17ff5000,0xfffd10ea,
    0xffdb9dff,0xdfd09fff,0xfd106e25,0xdb9dffff,0x209fffff,0x05fffdcd,
    0x22000000,0x05b8adff,0x013fee00,0x07ffd9a8,0x3ffffa20,0xfffdccdf,
    0x26000eff,0x002fffb9,0x801ffe88,0x03711efe,0xfffffd88,0x3fffffff,
    0x7fffec40,0xffffffff,0x3fff2003,0xffffffff,0xfff3004f,0x0bffffff,
    0xffffd880,0xffffffff,0xfeea8003,0xb1000fff,0xffffffff,0x7c07ffff,
    0x000effff,0xffffffd8,0x3605ffff,0xffffffff,0xffdb05ff,0xff900bff,
    0xffffffff,0x100009ff,0x0dffffff,0x3ffe2000,0xfd886fff,0xffffffff,
    0xff503fff,0xb107ffff,0xffffffff,0x7c07ffff,0x000effff,0x7f400000,
    0x2007ffff,0x0ffffeea,0xfffff300,0xfff90009,0xffffffff,0xffd0009f,
    0x36001fff,0x005ffffe,0x7ffffff7,0x3fff6a00,0x01cfffff,0x3ffff6a0,
    0x001cffff,0xfffffb88,0x4000bfff,0xefffffc8,0x3f6a0004,0xcfffffff,
    0xfff90001,0xb50005df,0xffffffff,0xfffe8039,0x3aa0000e,0x4dffffff,
    0xffffea80,0x3fe04dff,0x1000dfff,0xfffffff7,0x4000017f,0x02dfffeb,
    0x3ffaa000,0x3f6a03ff,0xcfffffff,0x7fffe401,0x3ff6a01c,0x1cffffff,
    0x077fff40,0x40000000,0x02efffc9,0x3bffff20,0x3ffee002,0x710000df,
    0xffffffff,0xff100017,0x7c003dff,0x000dffff,0x19dfff91,0xaa998800,
    0x4c400019,0x00019aa9,0x026aa620,0x04d4c000,0x53310000,0x10000335,
    0x00003353,0x03355331,0x0005d440,0x03775300,0x06eea600,0x004d4cc0,
    0x13553100,0x29800000,0x54c00000,0x2a662001,0x1a80019a,0x554cc400,
    0x2ea20019,0x00000000,0x22000300,0x880019a9,0x00001aba,0x0026aa62,
    0x026eaa00,0x01353300,0x00005400,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x02cca800,0x00999300,0xeeea8000,0x00000002,
    0x00000000,0x26201000,0x0a980000,0xa8002644,0x00005fff,0x00000000,
    0xf31fffc4,0x220003ff,0x05e980ee,0x00000000,0x00000000,0x00000000,
    0x32000000,0x00003fff,0x20000000,0x2002eeea,0x4c001998,0x0000efff,
    0x27ffd400,0x001ffe40,0x0007ffa8,0x02fff400,0x0dfff500,0x7ffd4000,
    0xfff98004,0xfd98000f,0x013f61cf,0xdfffea80,0x8005fc8a,0x04fffff8,
    0xfff98000,0x3fff2005,0x7ffd4003,0x0007ffd0,0x5fd84fe8,0x03fffb80,
    0x37ffd400,0x7c400000,0x000005ff,0x000bfff1,0x002fffe8,0xfffff500,
    0x7e400005,0x000002ff,0x800fffee,0x22007ffe,0x005fffff,0x2fff4000,
    0x003ffc80,0x000fff50,0x07ffd400,0xffff8800,0xfd00005f,0xfd1000bf,
    0x8800dfff,0xefffffff,0x3a0001ff,0xffffffff,0xffe8003f,0x0002ffeb,
    0x0037fec0,0x40037fec,0x5ffbdffc,0xeffa8000,0x801ffecc,0x40004fff,
    0x05fffff9,0x7fe40000,0x9000000e,0x40001fff,0x01fffffc,0x57ffc400,
    0x00000fff,0x0001bffa,0x03fffb80,0x801fffa0,0x4ffcbffe,0xff500000,
    0x3ff2001d,0xfff50003,0x7f400000,0x3fa0001f,0x003ffdaf,0x007ffcc0,
    0x7de7fec0,0x3bea004f,0x6ffffda9,0x43fe6000,0x00dfffca,0xf8affe40,
    0x300001ff,0x10001fff,0xb0005ffd,0x000dffff,0x7ffffdc0,0x6ffb803f,
    0x7ff44000,0x0003ffda,0x03fff100,0x3fe20000,0x3ea0001f,0x00eff9ef,
    0x54fffa00,0x00000eff,0x0003fff1,0x0fffee00,0x007ffe80,0x3fa2dff9,
    0xd800002f,0x3f2001ff,0xff50003f,0x2a00000f,0x360003ff,0x3fff15ff,
    0x0ffec000,0xd37fdc00,0x3b2007ff,0x000e5c43,0x0540aa20,0x07ffd400,
    0x0001dff7,0x0005ff90,0x40037fc4,0x000ffff8,0x5e65c400,0x01ffd000,
    0x15ffd800,0x00003fff,0x0007ff90,0x01ffdc00,0x23fff300,0xb0005ffc,
    0x5ffd8dff,0x3fe60000,0x31000005,0x76c00133,0xeee9805e,0x0037baa1,
    0x02ee8800,0x001ffe40,0x0007ffa8,0x00033100,0xd506f74c,0xd10001bd,
    0xdd10005d,0x06f74c3d,0x00000000,0x00000000,0x7dd10000,0x3dd30000,
    0x00000000,0x774c0000,0x77540002,0x037baa0d,0x09db0000,0x4ed80000,
    0x1f76c000,0x0000bbb6,0xa8000000,0x000000ee,0x00000000,0x00000000,
    0x003ffc80,0x000fff50,0x00000000,0x00000000,0xb9800000,0x1ceeffec,
    0x01999100,0x80999300,0xbdefedb9,0x0000000a,0x73000000,0x39ddffd9,
    0x03332200,0x01332600,0x00000000,0x00000000,0x00000000,0xdd930000,
    0x0017bdff,0x00000000,0x3bffbb26,0x665400bd,0xfd973003,0x00039ddf,
    0x3ffbb260,0x7e400bde,0x3332203f,0x001ffea3,0x2004cc98,0x99911cca,
    0x99930001,0xefedb980,0x54000abd,0x6c4003cc,0xffffffff,0x7c401dff,
    0xfa8001ff,0xfffd107f,0x7fffffff,0x00e66540,0x03999500,0xb1007995,
    0xffffffff,0xf8803bff,0xfa8001ff,0x30f32a7f,0x64400999,0x664004cc,
    0x9999910c,0x99999999,0x99100157,0x99999999,0x99999999,0x33333223,
    0xcccccccc,0x401ccccc,0xffffffea,0x000bffff,0x016664c0,0xfffea800,
    0xbfffffff,0x80bff900,0xffffffd8,0x001dffff,0xfffffd50,0x017fffff,
    0x7440fff2,0x3fea0eff,0x7ffc0007,0x21fff002,0x8001fff8,0xfd107ffa,
    0xffffffff,0x7fe4007f,0x3ffea005,0xffffffff,0x3e203fff,0xfa8001ff,
    0xffff987f,0xffffffff,0xdfff104f,0x3ffe2000,0x80bff906,0xfffffffa,
    0x3fffffff,0x007ffe20,0xfc9ffea0,0x07ffcc5f,0x2ffffa80,0x21fff300,
    0xfffffff8,0xffffffff,0x3fe200df,0xffffffff,0xffffffff,0xffffff12,
    0xffffffff,0x6405ffff,0xfeffffff,0x00efffff,0x1bfff200,0x3fff2000,
    0xffffefff,0xffc80eff,0x3fffea05,0xffffffff,0x7e4003ff,0xffefffff,
    0xc80effff,0xffe883ff,0x03ffd40e,0x017ff200,0xff89bfea,0xffa8001f,
    0xfffff987,0xffffffff,0x0bff9004,0x33ffff60,0x3ffae609,0xfff105ff,
    0xfff50003,0x1bffff98,0x37fff544,0x004fffb8,0x900fffd8,0x7fec0bff,
    0x2e609cff,0x105ffffe,0x50003fff,0x2ffe4fff,0xc8017ffc,0x7004ffff,
    0x7ffc4dff,0xffffffff,0x0effffff,0xffffff10,0xffffffff,0x3e25ffff,
    0xffffffff,0xffffffff,0xffffd02f,0xfffd5017,0x7ffc000d,0x3a0001ff,
    0xa80bffff,0xfc86fffe,0xffffb05f,0x7f5cc139,0xfd005fff,0xd5017fff,
    0xff90dfff,0x0effe887,0x0007ffa8,0x2007ffcc,0x3fe23ffd,0xffa8001f,
    0x5ffffcc7,0x7fff5441,0x05ffc806,0x01efffa8,0x83fffe88,0x8001fff8,
    0x7fe47ffa,0x3fff7006,0x007fffa0,0x203fffa8,0xff505ffc,0xfd1003df,
    0xfff107ff,0xfff50003,0x7ec2ffe4,0xffff004f,0x3ff600df,0x26bffe23,
    0xa9999999,0x80ffffeb,0xaaabfff8,0xaaaaaaaa,0xfff10aaa,0x55555557,
    0x15555555,0x009fff90,0x0013fff2,0x17ff7fea,0x27ffe400,0x44fffc80,
    0xffa85ffc,0xfe8801ef,0x7fe403ff,0xfff9004f,0x223ffc89,0xf500dffe,
    0xfd0000ff,0x7ffc405f,0x007ffe20,0xf91ffea0,0x3fee00df,0x2ffe401f,
    0x017ffe20,0x81fffb10,0x8001fff8,0x7ffc7ffa,0x13ff6000,0x8037ffc4,
    0x6405fff8,0xfff885ff,0x7fec4005,0x0fffc40f,0x93ffd400,0xdff70bff,
    0xfd9ff300,0x3fff001f,0x000fffc4,0x220fffee,0x80001fff,0x0001fff8,
    0x013ffea0,0x001fffb0,0xfff8ffd8,0x7ffd4000,0x7ffec004,0xf117ff20,
    0xd8800bff,0xff500fff,0xffd8009f,0x44fff20f,0x7d405ffe,0xfb80007f,
    0x17fea05f,0x0003fff1,0xfff8fff5,0x13ff6000,0xc80bff90,0x88000fff,
    0x7fc45fff,0xffa8001f,0x001ffe67,0x7dc0dff5,0xffd804ff,0x2ffe400f,
    0x0007ffe4,0x222fffc4,0xa8001fff,0x17ff27ff,0x7003ffe6,0x07ff95ff,
    0x7c47ff98,0xfd8001ff,0x1fff885f,0xfff88000,0x3fa00001,0xff88006f,
    0x3fe2004f,0x8007ff96,0x88006ffe,0x3ff24fff,0x007ffe45,0x82fffc40,
    0x88006ffe,0x3ff24fff,0x805ffe8b,0x80007ffa,0xfb00fff8,0x1fff885f,
    0x27ffa800,0x54007ff9,0x7fe406ff,0x0fffe605,0x0fffb800,0x0007ffe2,
    0xff99ffea,0x37a2000f,0x3fffa00c,0x0bffea01,0xf317ff20,0x5c0007ff,
    0x3fe20fff,0xffa8001f,0x7c17ff27,0x7fec02ff,0x5c05ff98,0x7ffc45ff,
    0x7ffa8001,0x001fff88,0x01fff880,0x5fff3000,0x0f7f2000,0xf34ffb80,
    0x7fcc00df,0xbf90002f,0xf32ffe47,0x5c0007ff,0x7fcc0fff,0xbf90002f,
    0x7f67fe47,0xffa800ff,0xffb00007,0x10fff107,0x50003fff,0x7ffccfff,
    0x337a2000,0x817ff200,0x40007ffb,0x3e23fff8,0xfa8001ff,0x027ffc7f,
    0xfff88000,0x0bfff106,0xf717ff20,0xf88000ff,0x3ffe23ff,0x7ffa8001,
    0x7ec17ff2,0xf37fc03f,0x3ffd80ff,0x000fffc4,0x220fffcc,0x80001fff,
    0x0001fff8,0x000fff90,0xffe80004,0x400bffe1,0x20007ffc,0x5cbff900,
    0x440007ff,0x7fe43fff,0x64020007,0x5fffffff,0x007ffa80,0x70dff500,
    0xfff109ff,0xfff50003,0x0004fff8,0x40bff900,0x80005ffc,0x3fe26fff,
    0xffa8001f,0x067ffec7,0x7fdc0000,0x0fffd83f,0xc8bff900,0xf80005ff,
    0x3ffe26ff,0x7ffa8001,0x7d417ff2,0x93fea05f,0x3fe01ffd,0x0fffc40f,
    0x07ffdc00,0x0007ffe2,0x007ffe20,0x037ff400,0x3e600000,0x02ffe47f,
    0x0006ffe8,0x325ffc80,0xf80005ff,0x37ff46ff,0x7fe40000,0x02fffeff,
    0x0003ffd4,0xfe83fff0,0x1fff881f,0x47ffa800,0x000cfffd,0x02ffe400,
    0x00009ffd,0x7fc4fffb,0xffa8001f,0x7ffffcc7,0x200001be,0x3e60fffe,
    0x3f2002ff,0x027ff45f,0x13ffec00,0x50003fff,0x2ffe4fff,0x3207ff88,
    0x13fee1ff,0x7c437fcc,0xfe8001ff,0x1fff887f,0xfff88000,0xfff00001,
    0x8000000b,0x7fcc4ffd,0x5fff800f,0xffc80000,0x0013ffa5,0xff1fff60,
    0x900000bf,0x3ff2bfff,0x1ffea00f,0x4ffc8000,0x7c41bfe6,0xfa8001ff,
    0x7fffcc7f,0x80001bef,0x3fe05ffc,0xfc80003f,0x07ffe27f,0x21ffea00,
    0xffffffe8,0x20001bdf,0x3fa5fff8,0x7fe4004f,0x001fffc5,0xf13ffe40,
    0xf50003ff,0x02ffe4ff,0x3fa03ffd,0xb837fcc7,0xfff884ff,0x3ffa2001,
    0x1fff883f,0xfff88000,0xfff00001,0x40000007,0xfe81fff8,0x3fff803f,
    0xffc80000,0x000fffe5,0xff1fff20,0x9000007f,0x7ff44bff,0x01ffea05,
    0x26ff9800,0xff103ffc,0xff50003f,0xffffd10f,0x0037bfff,0x220bff90,
    0x80002fff,0xff10fffa,0xff50003f,0x3fff220f,0x3effffff,0x5fff7000,
    0x9000dff7,0x7ffc4bff,0xffa80002,0x03fff10f,0x64fff500,0x3ff205ff,
    0xf85ff883,0x2ffd80ff,0xaabfff88,0xdcaaaaaa,0xf106ffff,0xddddddff,
    0xdddddddd,0x777ffc45,0xeeeeeeee,0x3e22eeee,0x000002ff,0x5c1bfee0,
    0x7fc407ff,0xc800002f,0x5fff15ff,0xfff50000,0x00bffe21,0x0fff2000,
    0x2a05fff5,0x400007ff,0x1ffd1ffe,0x007ffe20,0x441ffea0,0xfffffffc,
    0x32003eff,0xfff305ff,0xff300003,0x07ffe23f,0x01ffea00,0xfffffb71,
    0x0001bfff,0x3fffdffd,0x4bff9000,0x0001fff9,0xf11fff98,0xf50003ff,
    0x02ffe4ff,0xff70bff5,0xf05ff907,0xfff101ff,0xffffffff,0x1bffffff,
    0x3ffffe20,0xffffffff,0x3e22ffff,0xffffffff,0xffffffff,0x00bffe22,
    0xffe80000,0x05fff103,0x0017ffc4,0x9affe400,0x80001fff,0xff11fff9,
    0x9000005f,0xfffb07ff,0x00fff501,0x9bffb800,0x3fe205ff,0xffa8001f,
    0x7fedc407,0x0dffffff,0x105ffc80,0x00005fff,0x3e21fff5,0xfa8001ff,
    0x6dcc007f,0x01efffff,0x7ffffcc0,0xbff90004,0x0017ffc4,0x887ffd40,
    0xa8001fff,0x17ff27ff,0xfd87ff88,0x45ffa80f,0xff106ff9,0xffffffff,
    0x05bfffff,0xffffff88,0xffffffff,0x3fe22fff,0xffffffff,0x2fffffff,
    0x000fffe2,0x7ffcc000,0x817ff600,0x0003fff8,0xf15ffc80,0x500005ff,
    0x3fe21fff,0xc800003f,0xfff883ff,0x007ffa85,0x5f7fc400,0x3fe202ff,
    0xffa8001f,0x7edcc007,0x401effff,0x3fe05ffc,0xfc80003f,0x07ffe27f,
    0x01ffee00,0xffffd500,0xdfff7000,0x2ffe4000,0x0000fffe,0xff89fff2,
    0xffb8001f,0xd017ff27,0x06ff81ff,0xffb8fff1,0x9bfff103,0xffffb999,
    0x7ffc4009,0x9999999a,0x20999999,0x999afff8,0x99999999,0x2fffc099,
    0xfc800000,0x7ffd405f,0x017ffe00,0x97ff2000,0x80003fff,0x7ffc7ffc,
    0xfc800005,0x5fff503f,0x0007ffa8,0x7ffffd80,0x00fffc40,0x003ffdc0,
    0x1ffffaa0,0x7c0bff90,0xd80004ff,0x3ffe26ff,0x6ffc8001,0xfff90000,
    0x5fff0005,0x2ffe4000,0x00013ffe,0xff89bff6,0xffc8001f,0x9017ff26,
    0x27fcc5ff,0x7ec1ffd0,0x3fff101f,0x06fffdc0,0x00fffc40,0x0fffc400,
    0x6ffe8000,0xff000000,0x999999bf,0x409fff99,0x00006ffe,0x3fe5ffc8,
    0xfd80004f,0x037ff46f,0x1ffe4000,0x541fffb0,0xffffffff,0x4fffffff,
    0x27fffd40,0x007ffe20,0x001bff20,0x017ffe40,0x7e40bff9,0xfe80006f,
    0x017ffc4f,0xa8b7fe40,0xffb0002a,0x5fff0009,0x2ffe4000,0x0001bff2,
    0xfff13ffa,0xdff90005,0x2602ffe4,0x0bff24ff,0x3fe2ffc8,0x07ffe207,
    0x00dfff50,0x0003fff1,0x003fff10,0x01fff200,0x00ace880,0xfffffff5,
    0xffffffff,0x03ffe40f,0x2159d100,0x3ff25ffc,0xffe80006,0x003ffe44,
    0x32159d10,0x3fe203ff,0x3fffea5f,0xffffffff,0xff804fff,0xfff801ff,
    0x6ffc8002,0x20005551,0x3f204ffd,0x3ffe605f,0x3fea0001,0x01fffc1f,
    0xf8affec0,0xfb8000ff,0xfff8006f,0x3ff20002,0x00fffcc5,0x83fff500,
    0xd8003fff,0x17ff25ff,0xffe9bfe0,0x453fe600,0x3fe205ff,0xfffb801f,
    0x0fffc405,0x7ffc4000,0xff300001,0x3ee0003f,0xfffb00ff,0xffffffff,
    0x205fffff,0x0001fff9,0x3f21fff7,0x07ffe65f,0x1fffa800,0x000fffcc,
    0xf90fffb8,0xfffb807f,0xffffff52,0xffffffff,0xdff9009f,0x00fffe00,
    0x7c57ff60,0xfb8000ff,0x17ff206f,0x000dfff0,0x7ec37ff4,0xfff8005f,
    0x000fffa3,0x20017fea,0x20002fff,0xfff85ffc,0x3ffa0006,0x005ffd86,
    0x3f23fff8,0x8ffd805f,0xff805ff8,0x4405ff56,0xfb001fff,0x7fc407ff,
    0xf880001f,0x200001ff,0xd0005fff,0x3fe20bff,0x999999af,0x5ffe9999,
    0x0017ffe0,0xff92fff4,0x006fff8b,0x7c1bffa0,0xfd0005ff,0x002600bf,
    0x00013100,0xb003ffb8,0xff000bff,0x01fff47f,0x902ffd40,0xffa80bff,
    0xffb8003f,0x1fffb83f,0x87ffee00,0xd8006ffc,0xff8003ff,0x3f20002f,
    0x3fffa85f,0x3fffb800,0x001fffb8,0xfc87ffee,0x9ffb805f,0xfd803ffa,
    0x4401ff97,0xf1001fff,0x3e203fff,0x880001ff,0x00001fff,0x0007ffee,
    0x2e05fff7,0x7dc006ff,0xfff701ff,0xfffb8003,0xf517ff22,0xf70007ff,
    0x3fee07ff,0x7fdc001f,0xfff9802f,0xffa8000d,0xfe8000cf,0xfff7000f,
    0x7ffdc003,0x001bff21,0xfc80fff6,0xfffd805f,0x3fff2004,0x1dfff305,
    0x8fffd100,0x000efff9,0x0001fff5,0x40005fff,0xffb05ffc,0x7fe4009f,
    0xdfff305f,0xfffd1001,0x9805ffc8,0x01ffcbff,0x6fe9ffb8,0x00fffc40,
    0x20dfff50,0x0001fff8,0x001fff88,0x0ffff400,0x06fff980,0x1000fffa,
    0x7f409fff,0xff3001ff,0x85ffc8df,0x2004fffd,0x7405fffc,0xf3001fff,
    0x36200dff,0x98005ffe,0x4004ffed,0x26004ffa,0x8800efff,0x7fcc7ffe,
    0xff5000ef,0x2ffe401f,0x77fff440,0x3fffa601,0x3fff200f,0xfff500ae,
    0xffffd05f,0x3ff62015,0xfff0006f,0x7fe40005,0xdfffd105,0x7fff4c03,
    0x3fff200f,0xfff500ae,0x05ffc85f,0x0ffdbff0,0x3feffe60,0x0fffc404,
    0x0ffff600,0x0007ffe2,0x007ffe20,0xffff3000,0x3ff22059,0xfff300ff,
    0xfff90001,0x67fffcc0,0xffff9102,0x885ffc81,0x201efffe,0x00ffffe9,
    0x167fffcc,0x0ffffc88,0x01ffc800,0x003ff600,0x000fff44,0x02bbfff2,
    0x417fffd4,0x00affffe,0x80dfffb1,0xd1005ffc,0x99bfffff,0x1dfffffb,
    0xffffe880,0xfffedcef,0xffd104ff,0xfd9bffff,0x000bffff,0x00017ffc,
    0x7440bff9,0xccdfffff,0x0efffffd,0x7ffff440,0xfffedcef,0x5ffc84ff,
    0x9ffffb00,0x7ffffc00,0x0fffc402,0x3fffe200,0x00fffc40,0x0fffc400,
    0x7fd40000,0xdcbdffff,0x201fffff,0x30006ffc,0x7d405fff,0xcbdfffff,
    0x81fffffd,0xfd105ffc,0xb99bffff,0x01dfffff,0x3ffffea0,0xfffdcbdf,
    0xe88001ff,0xf10001ff,0x6e6c01ff,0x88005fff,0xcefffffe,0x4fffffed,
    0xfffffd10,0xffffd9bf,0xbff900bf,0xffffc800,0xffffffff,0x3ff62004,
    0xffffffff,0x7ec403ff,0xffffffff,0x40004fff,0x20002fff,0xfc805ffc,
    0xffffffff,0x22004fff,0xfffffffd,0x903fffff,0x3ee00bff,0x32002fff,
    0x4400ffff,0xb8001fff,0x7fc45fff,0xffffffff,0xffffffff,0xffffff17,
    0xffffffff,0x4c0fffff,0xfffffffe,0x401effff,0x20003fff,0x74c06ffe,
    0xffffffff,0xf901efff,0xfffc80bf,0xffffffff,0xfe98004f,0xffffffff,
    0x36001eff,0x005ffffe,0x27ffff74,0x3bffffe0,0xffb10000,0xffffffff,
    0xfd8807ff,0xffffffff,0xf9004fff,0xf71000bf,0x7fffffff,0x3f6a0001,
    0xcfffffff,0x3ff26001,0x2cefffff,0x2fff8000,0x17ff2000,0x7fffdc40,
    0x000bffff,0xfffffb50,0x64039fff,0xff3005ff,0x7d4001ff,0xff8805ff,
    0xffd0001f,0x7fffc45f,0xffffffff,0x17ffffff,0xffffffff,0xffffffff,
    0xfb500fff,0x5dffffff,0x01fff500,0x0fffdc00,0x7fffed40,0x6402efff,
    0xfb8805ff,0xbfffffff,0x7ed40000,0x2effffff,0xfffff800,0x3fe2000d,
    0x7400cfff,0x0000efff,0xfffffda8,0x2001cfff,0xffffffc9,0x32002cef,
    0x440005ff,0x00009aa9,0x26aa6620,0xa9980001,0xf800001a,0x320002ff,
    0x988005ff,0x000009aa,0x066aa662,0x002ffe40,0x8800dfff,0xf8803fff,
    0xf30001ff,0x3fe21fff,0xffffffff,0xffffffff,0xffffff17,0xffffffff,
    0x800fffff,0x4001aa99,0x40005ffd,0x4004fff8,0x0001aa99,0x35531000,
    0x26000001,0x40001aa9,0x00009a99,0x20013533,0x00000ba8,0x19aa9988,
    0xaa998000,0x00000001,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x6c000000,0x005fd03f,
    0x21fffa80,0x0000effc,0x00000000,0xffe80000,0x0000000f,0x1ed80000,
    0x00003db0,0x00000000,0x745ffd80,0x3a0003ff,0x000005ee,0x3ffa2000,
    0x00bffe24,0x00000000,0x00000000,0x00000000,0x88000000,0xcccccccc,
    0xfe8002cc,0x0fffe25f,0x77fe4000,0x801bff20,0x2001eeec,0x3fdc0ffb,
    0x6ffc8000,0x0001fff3,0x0017ffe6,0x0bfffa00,0x7fe40000,0x400006ff,
    0x0004fffc,0xfb86fc80,0xfff98007,0x001bff21,0x007fff60,0x64fffa20,
    0x7c0005ff,0xf00006ff,0x20001dff,0xffb1fff9,0x7dc00009,0x320003ff,
    0x00001fff,0x0009fffb,0x00ffff44,0xfff90000,0xf1000005,0xffffffff,
    0xff1000bf,0x013ff65f,0x29ffb000,0x1000fff9,0x88009fff,0xffecdffe,
    0x3fa00003,0x002ffebf,0x00fffd40,0xffff9000,0xb800003f,0x05ffbeff,
    0xffff5000,0x9800007f,0xffdbbeff,0xdff70004,0x0003ffe6,0x007fff10,
    0x7d7ffcc0,0x7c0000ef,0xb80006ff,0x40001fff,0x6ffaeffb,0x7ffc0000,
    0x3fe20004,0xf700003f,0x0005ffff,0x03fffff6,0x3fe20000,0x1000004f,
    0xffffffff,0x2a000bff,0x06ffafff,0xfff88000,0x2001ffea,0x30005ffc,
    0x09fffffd,0xfff88000,0x900003ff,0x20000bff,0xfff9effa,0xff300000,
    0x00fffa3f,0xd3fff300,0x800003ff,0x5ffffffb,0x67fec000,0x80001ffe,
    0x80005ffc,0x00fffffb,0x06fff800,0x02ffe800,0xffffb000,0x5c00001f,
    0x640006ff,0x300005ff,0x3fff3fff,0xadffb800,0x800006ff,0x00005ffb,
    0x80000000,0x00fffffb,0xfff30000,0x7c4007ff,0x540000ef,0x00001acb,
    0x00bfff30,0x01ffd800,0x8fffcc00,0x80006ffb,0x3e64ffe8,0xd10001ff,
    0x3ffe67ff,0x64400000,0x80002cdd,0x03ffffe8,0x06ff8800,0x3fff6000,
    0x33300002,0xffa80001,0x3a200004,0x00001fff,0x00007ff4,0x0001dff1,
    0x2a5fff10,0xf3000eff,0x17ff21ff,0x1fff0000,0x00000000,0x3ff60000,
    0x4000001f,0x4004fffb,0x00001ffc,0x00000000,0x3b620000,0x77640003,
    0x001f76c3,0x40000000,0x77645eeb,0x00000004,0x3bba6000,0xdd500004,
    0x00000001,0x80000000,0x000005ec,0x74c00000,0x7540002e,0xd900001e,
    0x03eec89d,0x6c47ddb0,0x500002ee,0x000003dd,0xdffd9730,0x0000039d,
    0x00000000,0x26000000,0xceeffecb,0xd9300001,0x017bdffd,0x00000000,
    0x22000000,0xcdfffedb,0x0000000a,0xdb710000,0x0159bfff,0x00000000,
    0x2e600000,0x0abdefed,0xdfdb9800,0x0059930b,0xccc88000,0x4cc98000,
    0x00000000,0x00000000,0x00000000,0x10000000,0xfffffffb,0x8803bfff,
    0xcccccccc,0x0abccccc,0x33260000,0xcca8002c,0x3ff62001,0xffffffff,
    0xfd50001d,0xffffffff,0x3322017f,0xcccccccc,0xcccccccc,0x00399951,
    0x00e66540,0x3fffff62,0x04ffffff,0x2ccc9800,0xffb10000,0xffffffff,
    0x6664409f,0x3cc98001,0x6666665c,0xcccccccc,0xfd102ccc,0xffffffff,
    0x3fea007f,0xa9ffffff,0x399913ff,0x27993000,0x8001fff8,0x4c007ffa,
    0x4c002ccc,0x220004cc,0x98000ccc,0x039954cc,0x32e00000,0xcccccccc,
    0xcccccccc,0x3ea01ccc,0xffffffff,0x203fffff,0xfffffff8,0xffffffff,
    0xc80000df,0xd8006fff,0xff5003ff,0xffffffff,0x8007ffff,0xeffffffc,
    0x0effffff,0xffffff88,0xffffffff,0xff12ffff,0x3e2000df,0x7fd406ff,
    0xffefffff,0x001effff,0x01bfff20,0x3fffea00,0xffffefff,0xff981eff,
    0xffa8006f,0x7ffffec6,0xffffffff,0xf984ffff,0xffffffff,0x4404ffff,
    0xfeceffff,0xf33ffdff,0xf5000dff,0x07ffe2df,0x01ffea00,0x00dfff90,
    0x0007ffa8,0x0007ffe2,0x7fe5ffea,0x98000003,0xffffffff,0xffffffff,
    0xb02fffff,0x4139ffff,0x5ffffeb9,0xffffff10,0xffffffff,0x0001dfff,
    0x01fffff8,0x401ffec0,0x09cffffd,0x3ffffae6,0xffffd005,0xfffd5017,
    0xfffff10d,0xffffffff,0x5c5fffff,0xd8004fff,0x3ee00fff,0x441adfff,
    0x02ffffda,0x3fffff00,0x7ffdc000,0x6d441adf,0x7cc2ffff,0x54004fff,
    0x7ffec6ff,0xffffffff,0x44ffffff,0x41bffff9,0x06fffea8,0xd1037ffa,
    0x3e67ffff,0x54004fff,0x3fff16ff,0x0fff5000,0x1fffff80,0x01ffea00,
    0x01fff880,0xf97ffa80,0x0000007f,0xfffffff9,0xffffffff,0x05ffffff,
    0x003dfff5,0x107fffd1,0x33335fff,0xfd753333,0x20001fff,0x05ffdffa,
    0x201ffec0,0x801efffa,0x403fffe8,0x9004fffc,0xff889fff,0xaaaaaabf,
    0xaaaaaaaa,0x00ffff40,0x407fff50,0x002ffff9,0x000dfff5,0x0bffbff5,
    0x3fffe600,0xdfff5002,0x1fffff98,0x51bfea00,0x55555555,0xffd55555,
    0x06ffc85f,0x903fff70,0xffe80bff,0xfffff33f,0xb7fd4003,0x8001fff8,
    0x2a007ffa,0x005ffdff,0x8001ffea,0x8001fff8,0x7ff97ffa,0xf8800000,
    0xfffaacff,0xaaaaaaad,0x440aaaaa,0x44005fff,0x7c40fffd,0x7dc001ff,
    0xfb0003ff,0x001fff1f,0xf101ffec,0xd8800bff,0xff500fff,0xffd8009f,
    0x07ffe20f,0xfff88000,0xbfff1006,0x077ff440,0x07ffe600,0xff1ffb00,
    0xfe88001f,0x7cc000ef,0x3ffe61ff,0xf5000eff,0xf70000df,0x1fff09ff,
    0x427fec00,0x7d401fff,0xffff33ff,0x3ea001df,0x03fff16f,0x00fff500,
    0x7ffc7fec,0x0fff5000,0x0fffc400,0xcbffd400,0x000003ff,0x3fa3ffe4,
    0xfc80003f,0xf88000ff,0x7ffc45ff,0x5ffd8001,0x96ff8800,0x7ec007ff,
    0x3fff203f,0xfff88000,0x00dffd05,0x449fff10,0x00001fff,0x4027ffdc,
    0x3200fffd,0xb0001fff,0x7c400bff,0x007ff96f,0x001fffc8,0x7ccbffb0,
    0x004fffff,0x8000dff5,0xf986fffa,0x7fd4007f,0x802ffcc6,0xfff33ffe,
    0x2a009fff,0x3fff16ff,0x0fff5000,0x7e5bfe20,0xfff5003f,0x7ffc4000,
    0x7ffa8001,0x00007ff9,0x21fffc40,0x40003ffe,0x0003fff9,0xf883ffee,
    0xfa8001ff,0xffb8007f,0x400dff34,0xff303ffd,0x7dc0007f,0x7ffcc0ff,
    0x7bf90002,0x000fffc4,0x0ffff400,0x805fff50,0x20004fff,0x2e005ff9,
    0x0dff34ff,0x004fff80,0xf997fe60,0x01fffcff,0x0006ffa8,0x203fffe6,
    0x2000fff9,0x3ea0cde8,0x7ff9004f,0x3ff3ffe6,0x6ffa801f,0x0003fff1,
    0x2e00fff5,0x0dff34ff,0x001ffea0,0x001fff88,0xff97ffa8,0x64000007,
    0x7ff40fff,0x7fdc0003,0x7fc40007,0x07ffe23f,0x07ffe600,0x7c3ffd00,
    0xffb002ff,0x01ffee07,0x87fff100,0x20007ffc,0x03fff100,0xfff10000,
    0x17ffe20d,0x003fff30,0xfe800180,0x00bffe1f,0x000fffcc,0x5ffe6060,
    0x5400effe,0xd10006ff,0x7fc03fff,0xf900004f,0x3fee007f,0x3fafff33,
    0x7fd400ef,0x003fff16,0x200fff50,0x3ffe1ffe,0x07ffa802,0x07ffe200,
    0x65ffea00,0xdd9713ff,0xf1000179,0x7ffd09ff,0x5ffc8000,0x6fff8000,
    0x0007ffe2,0x8003ffee,0x7fe47ff9,0x07ffb005,0x00017ff2,0xffd1bffe,
    0xf100000d,0x000003ff,0x360fffee,0x7e400fff,0x000000ff,0x323ffcc0,
    0xff9005ff,0x3000001f,0x3ffe6fff,0x037fd404,0x03fffd80,0x0067ffec,
    0x00bff600,0xff99ffdc,0x809fff37,0xfff16ffa,0xfff50003,0xc8fff300,
    0xffa805ff,0x3fe20007,0xffa8001f,0xfd37ff97,0x03ffffff,0x80fffb80,
    0x40003ffe,0x80004ffe,0x3fe27ffd,0xffe8001f,0x27fec007,0x2003ffe6,
    0xffd03ffd,0xffb00009,0x005fff8f,0x1fff8800,0x3fa00000,0x3ffe60ff,
    0x06ffd802,0xfd800000,0x07ffcc4f,0x0037fec0,0x27ff9800,0x2a01fffc,
    0xfc8006ff,0xff9804ff,0x001befff,0x7003ffd8,0x9ffe67ff,0x2a01fffc,
    0x3fff16ff,0x0fff5000,0xf989ffb0,0x7fd400ff,0x3fe20007,0xffa8001f,
    0xfffdff97,0x3fffffdf,0x13ffe200,0x0001fff4,0x0000fffe,0xff89fff2,
    0x3fa2001f,0x3e2003ff,0x3ffe81ff,0xf03ffd80,0x900007ff,0x3fff8fff,
    0xff880000,0x2000001f,0x3fa5fff8,0xbffd004f,0x88000000,0xffe81fff,
    0x05ffe803,0xfff30000,0x500effe8,0xfa800dff,0x3a2006ff,0xdfffffff,
    0x4ffc801b,0x267ff900,0x77ff47ff,0x22dff500,0xa8001fff,0x7fc407ff,
    0x03ffe81f,0x0003ffd4,0x3335fff1,0x33333333,0x3f2fff73,0x2e21dfff,
    0xf7007fff,0x3ffa01ff,0x3fe20003,0xfa80002f,0x7fff10ff,0x55555555,
    0x0dffffb9,0x706ffb80,0xffb00fff,0x05fff107,0x1fff5000,0x000bffe2,
    0x3bffe200,0xeeeeeeee,0x002eeeee,0xff75fff7,0x1fffc00d,0x2e000000,
    0xfff706ff,0x007fff00,0x1ffe6000,0x2a09fff3,0x3e6006ff,0x44000fff,
    0xfffffffc,0x3ee03eff,0x7ffd005f,0xff31ffe6,0x5bfea09f,0x8001fff8,
    0x7dc07ffa,0x0fff706f,0x0007ffa8,0x3fffffe2,0xffffffff,0xf97fffff,
    0x7fcc0dff,0x4fff801f,0x3bbbffa0,0xeeeeeeee,0x07ffe62e,0x3ffe6000,
    0xffffff11,0xffffffff,0x8001bfff,0xff103ffe,0x3ffd805f,0x001fff98,
    0x11fff980,0x00005fff,0xffffff10,0xffffffff,0x74005fff,0x01fffeff,
    0x200fffe0,0xfffffff9,0x7f404fff,0x5fff103f,0x803fff80,0xfffffff9,
    0xfff34fff,0x505fff90,0x3a200dff,0x20001fff,0xfffffdb8,0xf880dfff,
    0x7fcc01ff,0x90fff33f,0xff505fff,0x007ffe2d,0xd01ffea0,0x3fe207ff,
    0x1ffea02f,0xffff8800,0xffffffff,0x7fffffff,0xe801fff9,0x7fdc02ff,
    0x3fffa00f,0xffffffff,0x3fe23fff,0xfa80002f,0xffff10ff,0xffffffff,
    0x0005bfff,0x6c01fff3,0x7fec05ff,0x02fff883,0x0fffa800,0x0007fff1,
    0xfffff100,0xffffffff,0x4005ffff,0x04fffff9,0x401fffc0,0xfffffff9,
    0x3e604fff,0x3ff600ff,0x01fffc05,0x7fffffcc,0xff34ffff,0x03bffa0f,
    0x3600dff5,0x00002fff,0x7fffedcc,0x5ffc81ef,0x99fffec0,0xdffd07ff,
    0xf16ffa81,0xf50003ff,0x7ffcc0ff,0x817ff600,0x20007ffa,0xfffffff8,
    0xffffffff,0xff97ffff,0x05ffb00d,0x7404ffe8,0xffffffff,0x43ffffff,
    0x80003fff,0x3fe27ffc,0xfdccccdf,0x40004fff,0x7d405ffc,0x3ff600ff,
    0x007fff03,0xf8fff900,0x800005ff,0x999afff8,0x99999999,0x7dc00099,
    0xfe8006ff,0xfff9804f,0x4fffffff,0x5017ff20,0x7f401fff,0xfff9804f,
    0x4fffffff,0x3e60fff3,0x37fd44ff,0x027ffe40,0x7f540000,0xfff887ff,
    0x7ffec40d,0x20fff33f,0x7d44fff9,0x03fff16f,0x40fff700,0x7d405ffc,
    0xfff500ff,0x7ffc4000,0x7ffa8001,0xf900bff9,0x7ffd407f,0x4e7ff400,
    0x99999999,0x27ffc099,0x37fec000,0x5c03fff1,0x0000dfff,0x9999bfff,
    0x9fff9999,0xf81ffec0,0xd80004ff,0x37ff46ff,0x7fc40000,0x0000001f,
    0x2000bffe,0x80005ffd,0x3fe04ffd,0xccccccdf,0x204fffcc,0x80005ffd,
    0xfff34ffd,0x517ffe40,0xffa80dff,0x0000005f,0x5417ffe4,0xfeceffff,
    0xf33ffeff,0x7ffe40ff,0x7c5bfea2,0xfc8001ff,0x37ffe06f,0xcccccccc,
    0xff504fff,0x7fc4000f,0xffa8001f,0x9009ff97,0x7ff407ff,0xaaaaaaae,
    0x0003fffa,0x00037fe4,0xff127ff4,0xfffa803f,0xfffa8006,0xffffffff,
    0x3607ffff,0xdff903ff,0x9ffd0000,0x0007ffc8,0x7c42b3a2,0x000001ff,
    0x000bffe0,0x0003ffee,0x2a09ffb0,0xffffffff,0x7fffffff,0x003ffee0,
    0x269ffb00,0x7ff407ff,0x40dff50e,0x000efff9,0x80015544,0xff304ffd,
    0xb3dfffff,0x1ffe67ff,0x2a1dffd0,0x0bffe6ff,0x41bff200,0xfffffffa,
    0xffffffff,0x00fff507,0x00fffc40,0xfcbffd40,0x3ffc803f,0xffffff50,
    0xffffffff,0xf980007f,0x2a0001ff,0x3fe21fff,0xfffb801f,0x7ffec005,
    0xffffffff,0xb02fffff,0x3fe607ff,0x3ea0001f,0x7ffcc1ff,0xfff70001,
    0x007ffe21,0xfff80000,0xfff88002,0x7fec0003,0xfffffb04,0xffffffff,
    0x3e205fff,0x6c0003ff,0x0fff34ff,0xf54fff98,0x3ffa20df,0xff88001f,
    0xffb8000f,0x3fb2e206,0x25ffb0bd,0x7cc07ff9,0x4dff54ff,0xd8003fff,
    0xfffb05ff,0xffffffff,0x505fffff,0x44000fff,0xa8001fff,0x07ff97ff,
    0x3a07ff90,0xffffffff,0x3fffffff,0x6fff8000,0x1bffa000,0x2003fff1,
    0x1003fffd,0x33335fff,0xfd333333,0x0fff60bf,0x0006fff8,0x7fc1bffa,
    0xffd0005f,0x00fffc4b,0xfff00000,0x3ff60005,0x3f60000f,0xafff884f,
    0x99999999,0x205ffe99,0x0000fffd,0x7fcd3ff6,0xafffc807,0xffb06ffa,
    0x7f40005f,0xffa8003f,0x7fec0005,0x900fff32,0xdff55fff,0x4002ffec,
    0xff883fff,0x999999af,0x5ffe9999,0x0007ffa8,0x0007ffe2,0x7fe5ffea,
    0x83ffc803,0xccccfffa,0xffcccccc,0xfa80003f,0xfb8003ff,0x7ffc43ff,
    0xffff1001,0x0dff7003,0x81fffb80,0x3ea03ffd,0xfb8003ff,0xfff703ff,
    0xfffb8003,0x007ffe22,0xfff80000,0xfff30002,0x7fec000b,0x006ffb84,
    0x980fffdc,0x20005fff,0xfff34ffd,0x2bfffa00,0xfffb86ff,0x7fe40004,
    0x3ffd8006,0xfe8006a2,0x00fff31f,0x3febfffa,0x007ffee6,0xb81fffb8,
    0x7dc006ff,0x3ffd41ff,0x3fff1000,0x2fff5000,0xfc803ffc,0x05ffe83f,
    0x000fffa0,0x027ffec0,0x10bfff90,0x54003fff,0xfe806fff,0x7fc4003f,
    0x03ffd84f,0x0027ffec,0xe80bfff9,0xf3001fff,0xfff88dff,0x20000001,
    0x20002fff,0x000efffb,0x213fffa6,0x44003ffe,0x3ee04fff,0x26000eff,
    0xff34fffe,0x3ffe600f,0x7fd46ffe,0xf980005f,0xf5000eff,0x0fff81ff,
    0xf33ffdc0,0x3fe600ff,0x3e66ffef,0xe8800eff,0x7ffd07ff,0x4fff8800,
    0x0003ffd4,0x0003fff1,0x3ff2fff5,0x43ffc803,0x2001fff9,0x00003ffe,
    0x03dfffd1,0x07ffff4c,0x000fffc4,0x980ffff6,0xc8000fff,0x3ffd87ff,
    0x77fff440,0x3fffa601,0x7ffcc00f,0xff9102cf,0xfff881ff,0x20000001,
    0x40002fff,0x0acffffd,0xffffda88,0x07ffcc2f,0x03ffe400,0x2b3ffff6,
    0xfffda880,0x0fff32ff,0x7ffffe40,0x03bffe26,0x7fff4000,0xffb100af,
    0x09ffd0df,0xf327ffc4,0x7fe400ff,0x7fe46fff,0xff500aef,0xfff305ff,
    0xfff90001,0x0007ffa8,0x0007ffe2,0x7fe5ffea,0x43ffc803,0x74006ffd,
    0x200003ff,0xdfffffe8,0xfffffdcc,0x3fff100e,0xffff8800,0x00dff900,
    0xb0bffe60,0xfd1007ff,0xb99bffff,0x01dfffff,0x3ffffea0,0xfffdcbdf,
    0xfff881ff,0x20000001,0x80002fff,0xfffffffc,0xffffffdd,0x6ffc80cf,
    0x5fff3000,0xfffffc80,0xffffddff,0x3e60cfff,0x3fa2007f,0xffd16fff,
    0x4400001d,0xdffffffe,0x5fffffec,0x37bfff70,0x8bfffb71,0x22007ff9,
    0x446ffffe,0xcefffffe,0x4fffffed,0x000dff90,0xfa8bffe6,0x3e20007f,
    0xfa8001ff,0x007ff97f,0x7fcc7ff9,0x7ff4002f,0xfc800003,0xffffffff,
    0x7c404fff,0xfb8001ff,0x7fff05ff,0x37ff4000,0xc800fff6,0xffffffff,
    0x8004ffff,0xffffffe9,0x01efffff,0xfffffff1,0xffffffff,0xf800ffff,
    0x500002ff,0xffffffff,0x03dfffff,0x0001fffc,0xf500dffd,0xffffffff,
    0x303dffff,0xf9800fff,0xfff36fff,0xffffffff,0xffffffff,0xffffb10f,
    0xffffffff,0xffffd809,0x85ffffff,0x4c007ff9,0xd886ffff,0xffffffff,
    0x3e03ffff,0x3a0003ff,0x3ffea6ff,0xffffffff,0xff14ffff,0xff50003f,
    0x200fff2f,0x3ff63ffc,0xfffe8006,0xffffffff,0x8806ffff,0xfffffffb,
    0xff8800bf,0xffd0001f,0x0fffa85f,0x3ffee000,0x000fff61,0xffffff71,
    0x800017ff,0xffffffda,0x7fc402ef,0xffffffff,0xffffffff,0x17ffc007,
    0x3f6a0000,0xceffffff,0x07ffd402,0x3fff7000,0x3fff6a00,0x02ceffff,
    0x2001ffe6,0xff36fffc,0xffffffff,0xffffffff,0x7fe4c0ff,0x2cefffff,
    0xffffd500,0x3e609bff,0xffc8007f,0x3ff6a06f,0x1cffffff,0x003ffea0,
    0x51fffb80,0xffffffff,0x9fffffff,0x0007ffe2,0x7fe5ffea,0x33ffc803,
    0xd0005fff,0xffffffff,0xdfffffff,0x9aa98800,0x7ffc4000,0xfff30001,
    0x02ffec1f,0x93ffe200,0x20003ffd,0x0009aa98,0x35533000,0x7fffc400,
    0xffffffff,0x07ffffff,0x0017ffc0,0x15533000,0x05ffd800,0x27ffc400,
    0x0554cc00,0x00fff300,0x26dffd10,0xffffffff,0xffffffff,0x33007fff,
    0x98000355,0xf9801bba,0xfe88007f,0xa998806f,0xffb0019a,0xff88000b,
    0xfffff54f,0xffffffff,0x3ffe29ff,0x7ffa8001,0xf9007ff9,0x01bff67f,
    0x7fffff40,0xffffffff,0x000006ff,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0xcccccca8,0x7cc0cccc,0x3ffe62ff,
    0x8bffe601,0x0000fffa,0x98000bf1,0x99999999,0x26200009,0x3e200019,
    0x3ffe63ff,0x1dff7001,0x2002ffec,0x05fd03fd,0x13100800,0x00000000,
    0x0aa80554,0x7f46ffd8,0xe880004f,0x000bd305,0xdd507774,0x776c0009,
    0x0013baa1,0x07ffec00,0x5c0dcc00,0x4c02001c,0x26660001,0x9dd70000,
    0x8001eee8,0x776c5ee9,0x77740002,0x2013baa0,0x3baa1eed,0xfffffc85,
    0xb81fffff,0x5ffd0fff,0x11fff500,0x20003fff,0x000aefb8,0xffffff88,
    0x0005ffff,0x0007fff2,0xfd0fffa8,0xffd8005f,0x001dff54,0x7dc0ffb8,
    0xfb30000f,0x01fec39d,0x1dfd9800,0xa84fd800,0x7ffd107f,0x00017fee,
    0x5fd83ff8,0x87ffe000,0x20005ffb,0x3fee1fff,0xfb000006,0x744001ff,
    0xfaacffff,0x7fdc401f,0x00ff30ad,0x013ffe60,0x3e2ffe40,0xfa8001ff,
    0x01fff46f,0xb87ffe00,0xfff805ff,0x321bfea2,0xffffffff,0x9ffb01ff,
    0x64009ff9,0x03ffcdff,0xfffffb80,0x22001eff,0xffffffff,0x320005ff,
    0x40001fff,0x4ffcdffc,0xafff8800,0x88000fff,0xffecdffe,0xfff10004,
    0x3ffdffff,0x273e0000,0x7d4000fc,0x5feb99cf,0x3ebffe60,0x200000ef,
    0xfebbdffb,0x3fe0001f,0x017fee1f,0x2e1fff80,0x000006ff,0x4001fffb,
    0xffffeffb,0xffd806ff,0x4ffeffff,0x9fff3000,0x17ff2000,0x50003fff,
    0x3ffe8dff,0x0fffc000,0xff00bff7,0x037fd45f,0xfffd0000,0xffd000bf,
    0xe8800bff,0xffffffff,0x2aa002ff,0xaaaaaaaa,0x3ff20001,0xfd80001f,
    0x20005fff,0x02fffff9,0x3fffa600,0x2e0004ff,0xfffda9ef,0xf500006f,
    0xfd8003d8,0x00efffff,0x0fffffd4,0x7fec0000,0x0003ffff,0xdd507774,
    0x776c0009,0x0013baa1,0x07ffec00,0x2a27fd00,0xf801dffd,0xffffc9bf,
    0xff30001f,0x3ae0009f,0x00f7744e,0x362f74c0,0x740002ee,0x13baa0ee,
    0xea87bb60,0x2000005e,0x000efff8,0x006fff88,0xfaefffd8,0x01ffffce,
    0x20000000,0x0000eeeb,0x00efff88,0x1fffdc00,0xacba8000,0x1f640001,
    0x000072e2,0x001ec6a8,0x0ceffea8,0x05fff900,0x6e4c0000,0x000000cd,
    0x00000000,0x00000000,0x002202aa,0x5e542f4c,0x3ba60000,0x0000003e,
    0x00000000,0x00000000,0xb83bba20,0x000004ee,0xff700000,0x7457e25f,
    0x666446ff,0x4cc98000,0x00000000,0x00000000,0x00000000,0x7c000000,
    0x0000fb8c,0x00000000,0x88000000,0x98000ccc,0x973004cc,0x039ddffd,
    0x3b6e2000,0x00acdfff,0x00000000,0x88000000,0xcccccccc,0xcccccccc,
    0x64c001cc,0x654002cc,0x2a0001cc,0xcca81ccc,0x0fffc403,0x9500bff9,
    0x33322079,0xcccccccc,0xcccccccc,0x897ff60c,0x83ffea5f,0x8001fff8,
    0x665c7ffa,0xcccccccc,0x2ccccccc,0x6666665c,0xcccccccc,0x99912ccc,
    0x99999999,0x39999999,0x33333322,0xcccccccc,0x4001cccc,0x0002ccc9,
    0x0bfff700,0x03cca800,0x99999991,0x01579999,0x6664c000,0x7ffc4002,
    0x7ffa8001,0x7fffec40,0x1dffffff,0xfffb1000,0xffffffff,0x3cca8009,
    0x00399910,0x32279930,0xcccccccc,0xcccccccc,0xfffff11c,0xffffffff,
    0x005fffff,0x006fffc8,0x0037ffc4,0x906fff88,0xff880bff,0x017ff21f,
    0x7c417ff2,0xffffffff,0xffffffff,0x3ffe0fff,0xfff17e21,0x00fffc45,
    0x363ffd40,0xffffffff,0xffffffff,0x7fffec4f,0xffffffff,0xf14fffff,
    0xffffffff,0xffffffff,0x3fffe25f,0xffffffff,0x02ffffff,0x037ffe40,
    0xfffc8000,0x7fe40006,0xfffff305,0xffffffff,0x9000019f,0x8800dfff,
    0xa8001fff,0x3fea07ff,0xffffffff,0x4003ffff,0xfffffffa,0xeffffffe,
    0x0bff9001,0x001bffe6,0x7fc5bfea,0xffffffff,0xffffffff,0xffffff12,
    0xffffffff,0x8005ffff,0x001fffff,0x0027ffdc,0xc807ffec,0x774405ff,
    0x013bae0e,0x7c417ff2,0xffffffff,0xffffffff,0xfff10fff,0x40445f88,
    0x8001fff8,0x7fec7ffa,0xffffffff,0x4fffffff,0x7fffffec,0xffffffff,
    0xfff14fff,0xffffffff,0x5fffffff,0x3fffffe2,0xffffffff,0x4002ffff,
    0x001fffff,0xfffff800,0x3ff20001,0xfffff305,0xffffffff,0x80009fff,
    0x001fffff,0x0007ffe2,0x7ec1ffea,0x2609cfff,0x05ffffeb,0x5bffff70,
    0xfffda883,0x5ffc802f,0x09ffff30,0xf16ffa80,0xffffffff,0xffffffff,
    0x2fffe25f,0xaaaaaaaa,0x00aaaaaa,0x3ff7fea0,0xfffe8005,0x3ffea001,
    0x017ff203,0xffc80000,0x55555105,0x5dffd555,0x85555555,0x17e22fff,
    0x00fffc40,0x2a3ffd40,0xaaaaaaaa,0xffeaaaaa,0x5555542f,0xaaaaaaaa,
    0xf12fffea,0x555557ff,0x55555555,0x2fffe215,0xaaaaaaaa,0x00aaaaaa,
    0x3ff7fea0,0x7d400005,0x0005ffdf,0x7cc17ff2,0xaaaaabff,0xffffecba,
    0xbff50005,0x7c400bff,0xfa8001ff,0xefffa87f,0xfffe8801,0x7fffcc03,
    0xdfff5002,0x20bff900,0x01fffff9,0x7c5bfea0,0xaaaaabff,0xaaaaaaaa,
    0x03fff10a,0x3f600000,0x000fff8f,0x8037ffc4,0x6405fff8,0x000005ff,
    0x0017ff20,0x4004ffd8,0x17e24ffd,0x00fffc40,0x003ffd40,0x027ffdc0,
    0x4fffb800,0x0007ffe2,0x007ffe20,0x7fec0000,0x0000fff8,0x3fe3ff60,
    0xff90000f,0x03ffe60b,0x27fff4c0,0x7c7fec00,0xff1000ff,0xff50003f,
    0x05fff88f,0x07ffec40,0x00effe88,0x00fffcc0,0x7cc17ff2,0x000effff,
    0x3fe2dff5,0xf880001f,0x000001ff,0xff96ff88,0xfff70007,0x1fffb009,
    0x005ffc80,0x3ff20000,0x3ff60005,0x7ffdc004,0x2200bf13,0xa8001fff,
    0x540007ff,0x00006fff,0xf88dfff5,0x880001ff,0x00001fff,0xf96ff880,
    0x2200007f,0x07ff96ff,0x417ff200,0x2000fff9,0x000fffe8,0x7fe5bfe2,
    0x3fff1003,0x8fff5000,0x8000fffc,0xf905fff8,0x360003ff,0x7fe405ff,
    0xfffff305,0x3fea009f,0x003fff16,0x03fff100,0xff700000,0x001bfe69,
    0x500ffff4,0xf9005fff,0x0732a0bf,0x640732e0,0x360005ff,0x744004ff,
    0x05fbefff,0x003fff10,0x000fff50,0x007fffcc,0x7fffcc00,0x00fffc40,
    0x0fffc400,0x7dc00000,0x00dff34f,0x4d3fee00,0xf90006ff,0x3ffe60bf,
    0x7ffc4000,0x53fee005,0xf1006ff9,0xf50003ff,0x1fffccff,0x1fff7000,
    0x0009fff0,0x3202ffcc,0xfff305ff,0x5003fff9,0x3ffe2dff,0xff880001,
    0x8000001f,0x3ffe1ffe,0xfff88002,0x0bfff106,0x6c17ff20,0xffe803ff,
    0x00bff902,0x0027fec0,0x7fffff44,0x7fc401bf,0xffa8001f,0xffd10007,
    0xd100003f,0xff103fff,0xf100003f,0x000003ff,0x7fc3ffd0,0xfe80002f,
    0x00bffe1f,0x4c17ff20,0xc8000fff,0x3fa007ff,0x00bffe1f,0x0007ffe2,
    0xffb9ffea,0x7fc40007,0x0fffcc3f,0x64006000,0xfff305ff,0x5003bffa,
    0x3ffe2dff,0xff880001,0x4000001f,0x7fe47ff9,0xfff70005,0x01fffb07,
    0x6c17ff20,0xffe803ff,0x00bff902,0x0027fec0,0xfffffc88,0xff103fff,
    0xff50003f,0x3ff6000f,0xfb00003f,0x3fe207ff,0xf880001f,0x000001ff,
    0x3f23ffcc,0x7cc0005f,0x02ffe47f,0x982ffe40,0x98000fff,0xf9801fff,
    0x02ffe47f,0x000fffc4,0xff93ffd4,0xfff0000b,0x00fffc8d,0xff900000,
    0x4dffe60b,0x7d404fff,0x03fff16f,0x3fff1000,0xfd800000,0x07ffcc4f,
    0x0fffe800,0x800bffe6,0xffb05ffc,0x05ffd007,0x80017ff2,0x80004ffd,
    0xffffffda,0x0fffc40d,0x03ffd400,0x027ffe40,0x4fffc800,0x007ffe20,
    0x07ffe200,0xffb00000,0x00fff989,0x313ff600,0xc8001fff,0xfff305ff,
    0x3ffa0001,0x44ffd802,0x4400fff9,0xa8001fff,0x13ffa7ff,0x1fff6000,
    0x0000dffb,0x82ffe400,0x3ff27ff9,0x5bfea01f,0x0001fff8,0x001fff88,
    0x3ffe2000,0x003ffe81,0x74bfff10,0x7e4004ff,0x07ffb05f,0x3205ffd0,
    0x360005ff,0x100004ff,0xbffff9df,0x001fff88,0x4007ffa8,0x0006fffa,
    0x80dfff50,0x0001fff8,0x001fff88,0x3ffe2000,0x003ffe81,0xd03fff10,
    0xfc8007ff,0x1fff305f,0x0fff6000,0xd03fff10,0xff8807ff,0xffa8001f,
    0x000fffe7,0xfd1fff20,0x000000bf,0xf982ffe4,0x077ff47f,0xff16ffa8,
    0xf100003f,0xddddddff,0xdddddddd,0x0dff7005,0x8001ffee,0xffbafffb,
    0x5ffc8006,0xd007ffb0,0x3ff205ff,0x3ff60005,0xbf100004,0x88ffff22,
    0xa8001fff,0x3e6007ff,0x80000fff,0x400ffff9,0xeeeefff8,0xeeeeeeee,
    0x3ffe22ee,0xeeeeeeee,0x02eeeeee,0xf706ffb8,0x3ee000ff,0x0fff706f,
    0x305ffc80,0x20001fff,0x7dc05ffd,0x0fff706f,0x001fff88,0xff17ffa8,
    0xf500005f,0x1fffc1ff,0xf9000000,0x1ffe60bf,0x2a09fff3,0xdfff16ff,
    0xdddddddd,0x445ddddd,0xffffffff,0xffffffff,0x3ffe802f,0x005fff10,
    0x7ff7ff40,0xffc8001f,0x007ffb05,0x3f205ffd,0x3f60005f,0xf100004f,
    0x226ffd8b,0xa8001fff,0xfd1007ff,0x100003ff,0x1003fffd,0xffffffff,
    0xffffffff,0x7fffc45f,0xffffffff,0x802fffff,0xff103ffe,0xffd0005f,
    0x0bffe207,0x305ffc80,0x20001fff,0x7f406ffc,0x5fff103f,0x00fffc40,
    0xf9bffd40,0x980001ff,0x3ffe1fff,0xffff9803,0x04ffffff,0x7cc17ff2,
    0x2fffc87f,0xff16ffa8,0xffffffff,0x5fffffff,0x7fffffc4,0xffffffff,
    0x7cc02fff,0x3ff600ff,0x3fe60005,0x90004fff,0x3ff60bff,0x02ffe803,
    0x4000bff9,0x00004ffd,0x7ffb8bf1,0x0007ffe2,0x6c01ffea,0x00002fff,
    0x2005fffb,0xfffffff8,0xffffffff,0x3ffe22ff,0xffffffff,0x02ffffff,
    0xb007ffcc,0xf9800bff,0x3ff600ff,0x17ff2005,0x0007ffcc,0x2606ffc8,
    0x3f600fff,0x3ffe205f,0x7ffa8001,0x0005fff1,0x7c1fff50,0xff9803ff,
    0xffffffff,0x417ff204,0xffd07ff9,0x16ffa81d,0xffffffff,0xffffffff,
    0x57ffc45f,0x99999999,0x40099999,0x7d405ffc,0x2e0000ff,0x20006fff,
    0xffb05ffc,0x05ffd007,0x80017ff2,0x22004ffd,0x22fc42ba,0xff10fff8,
    0xff70003f,0x9fff900f,0x3ff20000,0x3fe2004f,0x999999af,0x09999999,
    0x266bffe2,0x99999999,0x7e400999,0x7ffd405f,0x17ff2000,0x001fff50,
    0x7cc17ff2,0xfb0000ff,0x2ffe40bf,0x403ffea0,0x8001fff8,0x3ffe7ffb,
    0xffc80003,0x4027ff47,0xfffffff9,0x3f204fff,0x0fff305f,0xf513ffe6,
    0x2bffe2df,0x99999999,0x22099999,0x00001fff,0x999bfff0,0xfff99999,
    0xfff80009,0x3ff20002,0x007ffb05,0x3f205ffd,0x3f60005f,0x3fee004f,
    0x3e62fc45,0x3fff10ff,0x0dff9000,0x005fffa8,0x0bfff500,0x01fff880,
    0x1fff8800,0xfff00000,0x9999999b,0x4009fff9,0xccccdfff,0x4fffcccc,
    0x20bff900,0x0000fff9,0x7fc09ffd,0xccccccdf,0x104fffcc,0x90003fff,
    0x27ffcdff,0x37fec000,0x00017ff6,0xfc813ff6,0x0fff305f,0xf517ffe4,
    0x07ffe2df,0x3ffe2000,0xfa800001,0xffffffff,0x07ffffff,0x017ffc00,
    0x20bff900,0xfe803ffd,0x0bff902f,0x027fec00,0xf88fff30,0x3e3ffe45,
    0xfc8002ff,0x3ffe606f,0xf980000e,0x44000eff,0x80001fff,0x0001fff8,
    0xfffffa80,0xffffffff,0xff5007ff,0xffffffff,0x00ffffff,0x7cc17ff2,
    0xff0000ff,0x3ffea07f,0xffffffff,0x3e07ffff,0xfc8002ff,0x01bff26f,
    0x713ffa00,0x80001fff,0x3f204ffd,0x0fff305f,0xf50effe8,0x07ffe2df,
    0x3ffe2000,0xfd800001,0xffffffff,0x2fffffff,0x0bffe000,0x05ffc800,
    0xff007ffb,0x17ff205f,0x04ffd800,0xf11fffc0,0x7c5ffe8b,0xfd8003ff,
    0xfffd105f,0xfd100003,0xf10003ff,0x100003ff,0x00003fff,0xffffffb0,
    0xffffffff,0xffb005ff,0xffffffff,0x05ffffff,0x260bff90,0x88000fff,
    0xffb02fff,0xffffffff,0x05ffffff,0x2000fffe,0x3fe65ffd,0x3ea0001f,
    0x7ffc41ff,0x7fec0003,0x417ff204,0x7cc07ff9,0x2dff54ff,0x0001fff8,
    0x001fff88,0x57ffc400,0x99999999,0x005ffe99,0x000bffe0,0xf905ffc8,
    0xfff8807f,0x00bff902,0x0027fec0,0x7c47fff2,0x83fff915,0xf8005ffd,
    0xfffb03ff,0x3f600005,0xf10002ff,0x100003ff,0x00003fff,0x99afff88,
    0x99999999,0x7c405ffe,0x99999aff,0xffe99999,0x05ffc805,0x0001fff3,
    0xf101fff7,0x333335ff,0xffd33333,0x017ff60b,0xff0fffe0,0x7f4000df,
    0x1fffb06f,0x27fec000,0x260bff90,0xffc807ff,0xf16ffaaf,0x100003ff,
    0x00003fff,0x4006ffb8,0x0001fffb,0x40005fff,0xff905ffc,0x2fff9809,
    0x000bff90,0x20027fec,0xfacfffe8,0x84ffffbe,0x2001fffb,0xfb81fffb,
    0x700004ff,0x40009fff,0x0001fff8,0x001fff88,0x037fdc00,0x807ffee0,
    0x5c006ffb,0x7e401fff,0x1fff305f,0x4fff8800,0x800dff70,0xfb81fffb,
    0x3ee001ff,0x7ffd41ff,0xfffb8003,0x0bfff303,0x027fec00,0x3e60bff9,
    0xfffd007f,0x3fe2dff5,0xf880001f,0x400001ff,0x44003ffe,0xf0004fff,
    0x640005ff,0xdff705ff,0x02fffd80,0x4000bff9,0x88004ffd,0xfffffffe,
    0xff304fff,0xfd1001df,0xbfff50ff,0x3fea0000,0x7c40005f,0x880001ff,
    0x00001fff,0x2001fff4,0x3a04fff8,0x7c4003ff,0x7fe404ff,0x01fff305,
    0x01fffd80,0x88007ffd,0xff984fff,0xfe8800ef,0x9fffb07f,0x2fffe400,
    0x03bffee0,0x4fffe980,0x4c17ff20,0xff3007ff,0x3e2dffdf,0x880001ff,
    0x00001fff,0x0003ffe6,0x4001fff2,0x20002fff,0xff305ffc,0x3fff207f,
    0x0bff902f,0x027fec00,0xfffec880,0x6402efff,0x500aefff,0xf885ffff,
    0x80000eff,0x000efff8,0x00fffc40,0x0fffc400,0xfff30000,0xfff90001,
    0x003ffe60,0x901fff20,0x3fe60bff,0xff91000f,0x3ffe60bf,0x7ffc8000,
    0x15dfff90,0x0bfffea0,0x0f7fff44,0x1ffffd30,0x9ffffb00,0xffb51015,
    0x7e405fff,0x0fff305f,0x7ffffe40,0x003fff16,0x03fff100,0x37fe4000,
    0x2fff9800,0x02fff800,0x817ff200,0xcabefffe,0x02ffdffe,0x4000bff9,
    0x80004ffd,0x000aefb8,0xdfffffd1,0xfffffdb9,0x0effe889,0xffe88000,
    0xf880000e,0x880001ff,0x00001fff,0x4001bff2,0xfc82fff9,0xff30006f,
    0x2ffe405f,0x100fff98,0xdffff753,0x01bff201,0x417ffcc0,0xefffffe8,
    0xfffffedc,0x7fff4404,0xffdccdff,0x2000efff,0xfffffffc,0xffffffdd,
    0x7fe400cf,0x00fff305,0xb7ffff44,0x0001fff8,0xffffff88,0xffffffff,
    0x7fc7ffff,0x3fa0003f,0xfff8006f,0x3ff20002,0x3fffa605,0xfb9fffff,
    0x0bff902f,0x027fec00,0x005f8800,0xfffffd88,0x3fffffff,0xffffff98,
    0xffffffff,0xf37fffff,0xffffffff,0xffffffff,0x3ffe2fff,0xffffffff,
    0x7fffffff,0xfffffff1,0xffffffff,0xfff8ffff,0x3ffa0003,0x003fff86,
    0xc81bffa0,0xfff305ff,0xffffffff,0x01dfffff,0x0001fffc,0x3620dffd,
    0xffffffff,0x2003ffff,0xfffffffc,0x004fffff,0xffffff50,0xdfffffff,
    0x17ff2003,0x2003ffcc,0xf16ffff9,0xffffffff,0xffffffff,0x3fffe2ff,
    0xffffffff,0x27ffffff,0x0000fffa,0x0007ffee,0x40005fff,0x6c405ffc,
    0x71dfffff,0x3ff205ff,0x3ff60005,0xbf100004,0x7fed4000,0x1cffffff,
    0xffffff30,0xffffffff,0x26ffffff,0xffffffff,0xffffffff,0xfff17fff,
    0xffffffff,0xffffffff,0x3fffffe2,0xffffffff,0x3ea7ffff,0x2e0000ff,
    0x3fea1fff,0x3ee0000f,0xbff901ff,0x3ffffe60,0xffffffff,0x3ea00cff,
    0x2e0000ff,0x36a01fff,0xffffffff,0xfb88001c,0xbfffffff,0xfda80000,
    0xceffffff,0x2ffe4002,0x8007ff98,0xff16fffc,0xffffffff,0xffffffff,
    0x3ffffe2f,0xffffffff,0x367fffff,0x440005ff,0x7c004fff,0x320002ff,
    0x2a6005ff,0xbff90001,0x27fec000,0x00790000,0x35533100,0xffff3003,
    0xffffffff,0xffffffff,0x3fffffe6,0xffffffff,0xf17fffff,0xffffffff,
    0xffffffff,0x3fffe2ff,0xffffffff,0x27ffffff,0x40005ffd,0x3f64fff8,
    0x7c40005f,0xbff904ff,0x3ffffe60,0xcdefffff,0x0bffb002,0x4fff8800,
    0x9aa99880,0x26200001,0x000009aa,0x002aa660,0x20bff900,0x88007ff9,
    0xfff16ffe,0xffffffff,0xffffffff,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x2e199500,0x2a601ced,0xaaaaaaaa,
    0x99988002,0x01999999,0xffffffb8,0x0002ffff,0x00009800,0x00000000,
    0xa8000000,0x3ae00001,0x000002ee,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x3bfb2e60,0x333260ac,
    0xcccccccc,0x0bfd0ccc,0xfdb71000,0x40039ddf,0xfffb8ffc,0xfffb01ff,
    0x1fffffff,0xffffd800,0x00ffffff,0x7fffffdc,0x3002ffff,0x79dffdd9,
    0x001df303,0x3bfffb26,0x332000bd,0x7fee540c,0x20000cef,0x77d405fd,
    0xf80000ef,0xca8805ff,0x0000beee,0x64401dfb,0x2000cefe,0x730006fd,
    0x157bdfdb,0x3fae2000,0x1000bdff,0x260005fd,0x730004ff,0x39ddffd9,
    0x0bff0000,0xfd101bf6,0x77ec0005,0xedb88000,0x001ceeff,0x7ffffec0,
    0xff51ffff,0xffffffff,0x3f21ffff,0x3f220007,0xffffffff,0xffc803ef,
    0x06fffffa,0x3ffffff6,0x4000ffff,0xfffffffd,0x64c00fff,0xcccccccc,
    0x7ff5401c,0xffffffff,0x01dff10c,0xfffffeb8,0x00dfffff,0xfa8fffc4,
    0xffffffff,0x7ff0004f,0x07b14e80,0x0effb800,0xfffffd80,0xffb8005f,
    0x3fffa601,0xf9801fff,0x7f44002f,0xffffffff,0x7fdc003f,0x2fffffff,
    0x017ffcc0,0x8006fe80,0xffffffd8,0x001dffff,0x3e07ff10,0x3ffe604f,
    0x3ff70002,0xfffc8800,0xefffffff,0x7fec4003,0xfffedfff,0xfffffa9f,
    0xffffffff,0x003ff30f,0x57dfff50,0xfffb5333,0x7ffe401b,0x203dabdf,
    0x99999998,0xa9800199,0xaaaaaaaa,0x0000000a,0xfffffff9,0x7fffffff,
    0xfd801ffd,0xffefffff,0x202fffff,0xffc9fff8,0xffffefff,0x7cc005ff,
    0xa83e601f,0x7ff40006,0x8affb801,0x2001ffd8,0x7f404ff8,0x06ffc9cf,
    0x4c006fd8,0xffffffff,0x004fffff,0xf9bdfff7,0x7105ffff,0x0005ffff,
    0xa8001ff9,0xffffffff,0x03ffffff,0x981ffa80,0xffb883ff,0xf88002ff,
    0x7fd4004f,0xa999abef,0x800dfffd,0x42dfffe8,0xffcfffc8,0xaaaaaaae,
    0x1ffc2aaa,0x077ff600,0x07ffee20,0x002fffe4,0x00000000,0x3cca8000,
    0x7ffffb00,0x7fecc413,0x2201ffff,0x09bffffe,0x3ffffb2a,0xfdfff103,
    0xfb9859df,0x32004fff,0x322f807f,0x3fea0004,0x88797002,0x3fa004ff,
    0x21ffd406,0x3e603ffa,0x3fe6001f,0x75441bff,0x7d406fff,0xffda84ff,
    0x37ffe20f,0x7cc002ff,0x7fec003f,0x2e609cff,0x005ffffe,0x7d407fdc,
    0x6fffc41f,0xfe8002ff,0x6ffec006,0xfffb8801,0x1fffe401,0x3ffffea0,
    0x1bf60005,0x003ffc80,0xc80ffe98,0x32200fff,0xcccccccc,0xcccccccc,
    0x664c001c,0x7e40002c,0xfffc805f,0xffe9800e,0x7ffec04f,0xfff9800d,
    0xffff881f,0xfff9806f,0x09fd001f,0x03fb9f90,0x000cc400,0x800ffe40,
    0x7e400ffc,0x205ff80f,0x7e4006fd,0xfff7006f,0x037ff403,0x7c49fff1,
    0x002ff98c,0x50017fa2,0x1003dfff,0x4007fffd,0x0ff906fd,0x5ff319f1,
    0x00ffc800,0x000fff20,0x4403ffa6,0xf7003fff,0x4000bfff,0xfa800ffb,
    0x7f40002f,0x406ffc86,0xfffffff8,0xffffffff,0x64002fff,0x40006fff,
    0x7cc05ffc,0x7e4004ff,0xff500fff,0xfe88009f,0x7ffc40ef,0xff1000ef,
    0x5ff100bf,0x00736a00,0x80350000,0x3002fffc,0xffb007ff,0x7cc1bfa0,
    0x7ffc001f,0x13ff6000,0x201fffc4,0xf3046ffc,0x7fec005f,0x3ffe2000,
    0x7fec4005,0x0bff000f,0xf3041bf6,0x7fcc005f,0x0bfea003,0x37f40188,
    0x000fffb8,0x0017fffe,0x4402ff88,0x3bbaa4ff,0x880bcdee,0x2ffe44ff,
    0x3ffffe20,0xffffffff,0x002fffff,0x00fffffc,0x80bff900,0x2000fffe,
    0x03fffffb,0x2000dfff,0x7c44fff9,0x6c000fff,0x7d400fff,0x0000000f,
    0x337bf726,0x7c03ff10,0xe8801dff,0x0dfd005f,0x2ff41ff6,0x01ffe600,
    0x260dff50,0x7c400fff,0x5ff300ce,0x00bfea00,0x001fff90,0x00bfff10,
    0x3fe07ff1,0x02ff9804,0x400bfd10,0xec984ff8,0x440adfff,0x4ffe84ff,
    0x2fffdc00,0x013fa000,0xfffb8df9,0x81efffff,0x3ff20ffa,0x5fffc404,
    0xaaaaaaaa,0x00aaaaaa,0x3ff7fea0,0x3ff20005,0x0fffe605,0xfccffa80,
    0x7ffd40ff,0x3ff60002,0x02fffc47,0x017ffcc0,0x95101bf2,0x0179dfdb,
    0xfffffb10,0x0bfdbfff,0x03ffca98,0xe8007fec,0x50ffb06f,0xf98003ff,
    0x3a2000ff,0x7ffa80cd,0x3fe60000,0x04ff8802,0x01fffcc0,0x41fff700,
    0xffdcccca,0xffcccccd,0xff301cce,0x03ff6005,0xf986fc80,0x5fffdeff,
    0x3e20ffa8,0x7c4002ff,0x640005ff,0x217fc06f,0xb9999efb,0x47fd06ff,
    0x7c403ffc,0x000001ff,0xfff1ffb0,0x3ff20001,0x01bff205,0xff35ff98,
    0x05ffd87f,0x0fffd400,0x0009fff1,0xff013ffa,0x7fff5409,0x03ffffff,
    0x37ffffe6,0x0efffffe,0xa81ff600,0x3f6002ff,0xfd0bfd07,0x3ffe000b,
    0x7d400004,0x300000ff,0xdfd005ff,0x0fff7000,0x3fff8800,0x3ffffff2,
    0xffffffff,0xf303ffff,0x5ff5005f,0x4c2ff800,0x7fd40dff,0x3e63fe82,
    0xff8000ff,0x7d40005f,0x70ff501f,0x07fe60bf,0x3ffc9bee,0x00fffc40,
    0x7fc40000,0x0007ff96,0xfe817ff2,0xdff3004f,0x7fc4ffe8,0x7c40003f,
    0x3ffe24ff,0xbffb0003,0xc80ffcc0,0xeddfffff,0xfd03ffff,0xffb883ff,
    0x4055446f,0xff881ffc,0x0ffdc004,0xff513fe2,0x3ff60003,0x100000cf,
    0x00003fff,0xf700bfe6,0xff90003f,0xfff0000b,0x7ffffe4d,0xffffffff,
    0x303fffff,0xff8805ff,0x43fd4004,0x3fea05fe,0xff537dc0,0x3ffa000f,
    0x7fc40005,0xf709f903,0x207fe20b,0x7ff90ff8,0x01fff880,0xffb80000,
    0x000dff34,0xff817ff2,0xeff8803f,0xf12ffe40,0xf00005ff,0x7ffc4bff,
    0xdff90002,0xf983fdc0,0xfe980cff,0x0fffb86f,0x47ffff30,0x7fc45fe8,
    0x000dfd07,0x3623dff1,0x02ff40ff,0xfffff300,0xe800037d,0x300004ff,
    0x7fcc05ff,0x9ffd0003,0xfffb0000,0xfd04ff80,0x0bfe600d,0x9000dfb0,
    0x01ff889f,0x87fc404c,0xb0006ffb,0xdddddfff,0x201ddddd,0x07fb05fd,
    0x1bf20bf7,0x7ff91ff8,0x01fff880,0xffe80000,0x000bffe1,0x7c417ff2,
    0x7f4402ff,0x27ffb80f,0x0001fff9,0x3e26ffd8,0xf90002ff,0x82fec0df,
    0x7c406ffc,0x3ffe21ff,0xffdfd103,0xdcfffa8f,0xffb83fff,0xfff70001,
    0xfa87fffd,0x7440001f,0xdfffffff,0xfb33001b,0x133333df,0x02ff9800,
    0x4000bfd1,0x80003fff,0x3e207ffc,0x009ff03f,0xfb80bfe6,0x3fd8001f,
    0x20003fcc,0x0dff91ff,0x3ffff200,0xffffffff,0x20ff701f,0xcefb82fe,
    0x02ffeccc,0x1ffe4bfa,0x007ffe20,0xfff30000,0x8005ffc8,0xff305ffc,
    0x1ffe803f,0x2a1fff50,0x80000fff,0x3fe27ffc,0xff70001f,0x40ffe20f,
    0xfe801ffd,0x81ffe61f,0x1fff8efd,0x7fffffe4,0x003ff983,0x7ffffd40,
    0x0005fe82,0xfffff910,0x407dffff,0xfffffff9,0x4002ffff,0xff902ff9,
    0x3fe20001,0xfa80002f,0x3ff500ff,0x2005ff30,0xff302ff9,0x0bfa0007,
    0xe8000df7,0x00bffb2f,0x3fffff20,0xffffffff,0xd03ff301,0xffff703f,
    0xe8019fff,0x807ff92f,0x0001fff8,0x227fec00,0x4000fff9,0xff305ffc,
    0x17fec01f,0x2a1fff50,0x80000fff,0x3fe27ffb,0xff70001f,0x003fea0f,
    0x8bff6001,0xff705ffa,0x220bff61,0xe8809aaa,0x02cb805f,0x2a026a62,
    0xabb980ff,0x3f6e2000,0xdfffffff,0xfffff980,0x02ffffff,0xfa809980,
    0xacba882f,0x01fff981,0x1fff9800,0xf701ff90,0x04cc003f,0xcb805fe8,
    0x3f20ff42,0x97f40005,0xb0006ffc,0x33333dff,0xf8033333,0xb82fd84f,
    0x1efdbaef,0xff91ff80,0x1fff8807,0x3e200000,0x3ffe81ff,0x82ffe400,
    0xf901fff8,0x7ffb805f,0x0007ffea,0xf89bff20,0xf70001ff,0x01bf20df,
    0xfff95100,0x4c27fdc5,0x0fff22ff,0x00ffc800,0x0001ffe4,0xffd113fa,
    0x20003dff,0xfffffdb9,0x7555441e,0x0aaaadff,0x3fe20000,0xfffffb84,
    0x17ffc45f,0x7ffd4000,0x320dfb00,0x3200007f,0x7fdc00ff,0x3ee17ec3,
    0x8ffc0006,0xd0007ffb,0x20000bff,0x83fc86fc,0x07fdc5fb,0x7fe43fe0,
    0x77ffc403,0xeeeeeeee,0x802eeeee,0xff706ffb,0x5ffc800f,0x2e0bffe0,
    0xffc803ff,0x00bffe67,0x893ff600,0x90001fff,0x13fa0bff,0x7f6dd440,
    0x22ffffff,0x7fc43ffc,0x0027fe44,0x5402ffa8,0x20003fff,0x3fe20ffb,
    0x01fffdef,0xfffea800,0x02ffe407,0x3bf60000,0x6677fcc0,0x7ffc3fff,
    0xffc80003,0x7413fe07,0xf500005f,0xfffa805f,0x3e61fe43,0xf80bb807,
    0x01fff50f,0x00bfff00,0x703fea00,0xb0bf70df,0x93fd40bf,0xff8807ff,
    0xffffffff,0x2fffffff,0x103ffe80,0x64005fff,0x3ffe05ff,0x8027fd43,
    0x3fe26ffd,0xff80003f,0x07ffe23f,0x427fe400,0x64402ff8,0xffffffff,
    0x3f22fffe,0x642fec4f,0xf88003ff,0x7ffcc04f,0x3fe0003f,0xf31ffdc4,
    0x640000df,0x3ee02fff,0x2000005f,0x6fe81ffb,0x7ffc6ff8,0xffd80004,
    0x3ff332a6,0xffccccce,0x001cccce,0x26027fc4,0x7dc3ffff,0x301ffc46,
    0x27fa85ff,0x8000fff9,0x00005fff,0xff885ff1,0x7c42fdc1,0x649fb03f,
    0x7fc403ff,0xffffffff,0x2fffffff,0x007ffcc0,0x6400bffb,0x3ff605ff,
    0x8017fe66,0x7ff44fff,0x7fc40004,0x07ffe22f,0x427ff400,0x7fc407fb,
    0x1aceffff,0x7fdc5ffb,0x3603ff26,0xfd8002ff,0x3bfe200e,0xf70003ff,
    0xb85ff81f,0x055511ff,0x813ff600,0x00003ffd,0x2607ff30,0x647fd81a,
    0xe80006ff,0x3fff24ff,0xffffffff,0x3fffffff,0x0077ec00,0x87ffdff1,
    0x7fdc1ff8,0xd87fe882,0x0fffe24f,0x0bfff500,0x42ff4000,0x82fdc4fd,
    0x7fc41ffb,0x22009880,0x9999afff,0x99999999,0x2ffe4009,0x003ffea0,
    0xf502ffe4,0x0dff33ff,0x20fffdc0,0x0000fffb,0xf883ffee,0xff0001ff,
    0x80bfb07f,0x201bfffe,0x3fea2ffe,0x3e03ff57,0x7dc001ff,0x3bfa201f,
    0x88003ff8,0x1ffc44ff,0xff897fcc,0xffb8000f,0x007ffe06,0x037f4000,
    0x2627fc40,0x20001fff,0x3f21fffa,0xffffffff,0xffffffff,0x3fee003f,
    0x23bfa201,0x84fd83ff,0xfebbdffd,0x07fc41ff,0xd001bff2,0x0000bfff,
    0x7fcc3fdc,0xfe817ee2,0xfc82ff45,0xfff883ff,0xff000001,0x999999bf,
    0x009fff99,0xfd017ff2,0x001dffbf,0x221bffe2,0x6dc05fff,0x227ffcc0,
    0x8001fff8,0xff80fffa,0x07ffe603,0xf88bffe0,0x503ffaff,0xf9800fff,
    0x87fec03f,0xfb8003ff,0x41ffcc0f,0x3ffa3ff8,0x5ffa8003,0x000dff30,
    0x003ff200,0xf03ffd10,0x74000dff,0x1bf606ff,0x20003fe4,0x7ec03ff9,
    0xf307ff0f,0xffff705f,0xbfd03dff,0x005fff10,0x017fffe6,0x81ff9800,
    0x03530ffc,0xffc8554c,0x5fffb500,0x001fff88,0xffffa800,0xffffffff,
    0xf9007fff,0xfffa80bf,0x3f2000ff,0xfff902ff,0x867ff403,0x7c40fffe,
    0xfe8001ff,0x01ff985f,0x26017fee,0x7ff42fff,0x3ffa05ff,0x037f4005,
    0x3ff87ff2,0x427fc400,0xff882ff9,0x001bff24,0x7e40fff6,0xa800000f,
    0x7cc002ff,0xfff502ff,0xfff70007,0xe827fc07,0x7f40005f,0xf0ffe406,
    0x03ff207f,0x40af32a2,0xffb00ffc,0xffe8803d,0x400005ff,0x3ffd03ff,
    0x0bff2000,0xf11bfe20,0x000003ff,0xfffffffb,0xffffffff,0xbff9005f,
    0x09fffd00,0x027ffe40,0x640ffffa,0xfffeffff,0x01fff882,0x417ffdc0,
    0x7fe407fc,0x2fffd806,0x807fffcc,0x2000fffd,0x3ee00ffc,0x001ffc2f,
    0x3e203ff2,0x23ff983f,0x000efff9,0xf501fff5,0x1000007f,0xfb800bff,
    0x7fec01ef,0x3ff2004f,0x0ffe205f,0x80013fe2,0x3ee00ffc,0xd01ffc2f,
    0x320003ff,0x3fe602ff,0xffd302ff,0x0000bffb,0xfd106fd8,0x3a60017f,
    0xff5003ff,0x01fff88d,0x7ffc4000,0x9999999a,0x05ffe999,0xd805ffc8,
    0x200dffff,0x00efffe9,0x06ffffcc,0x7ffffdc4,0x03fff105,0xffff7062,
    0xf7013fa0,0x7fec05ff,0xfffd83ff,0xffeb99cf,0x3fea002f,0x7fffec02,
    0x02ffffff,0x3e04ff88,0x42ffa84f,0x00affffe,0x70dfffb1,0x59997fff,
    0xb0051013,0x362001df,0xe8800dff,0x2601efff,0x200ffffe,0xff981ffa,
    0x5ff30002,0xfffffd80,0x882fffff,0x3000bffe,0xf3007ffd,0xb757bfff,
    0xfff57fff,0xffffffff,0xfb809fff,0x3fff600f,0x7f54c09c,0x3ba601ff,
    0x7c41ffff,0x400001ff,0x5c006ffb,0x7e401fff,0x7ffec05f,0xcbdeffff,
    0x0dfffffd,0xffffd300,0xfffd97bd,0xf1019fff,0x3ff603ff,0x82fffffd,
    0x7c402ff8,0xba8acfff,0x44fffffe,0xfffffff9,0x003fffff,0x32017fe2,
    0xffeeeeee,0xffc801ee,0xd03ff600,0xfffd10ff,0xffd9bfff,0xff50bfff,
    0xffffffff,0x3ffd9bdf,0x000ffdc0,0x88009ffd,0xcdfffffe,0xefffffdc,
    0xb83fe400,0xf88000ff,0xeeec805f,0x1eeffeee,0x273fff60,0x7fff54c0,
    0x3ffa2001,0x3fffffff,0xfffffff5,0x9fffffff,0x402ff880,0xefffffea,
    0x00dfffff,0x1fffffd4,0x000fffc4,0x00fffa00,0x809fff10,0x3f205ffc,
    0xfffff73f,0x7fffffff,0xfffb1000,0xffffffff,0x887fffff,0xffa81fff,
    0x01ffffff,0xf5001ff5,0xffffffff,0x44dff35d,0xfffd9cfe,0x4000dfff,
    0x40000efd,0xff1003ff,0xcfff9807,0xb102ffea,0xffffffff,0x2209ffff,
    0xffffffff,0xffffffff,0x09ff104f,0x6677fec0,0x6400cccc,0xffffffff,
    0xb004ffff,0x01ff20df,0x00077ec0,0x5400ffe0,0xfefffffe,0x000dffff,
    0xffffdb88,0x3ffea2df,0xffffffff,0xfe804fff,0xfffb5004,0x0017dfff,
    0x88066a62,0x00001fff,0x0003ffe6,0xf901fff2,0x0ffe60bf,0xfffffd91,
    0x800017df,0xffffffc9,0xffd88bef,0x3fff11ef,0xffffd730,0x037ec03b,
    0xfffffd30,0x11fff89f,0x1aa988dd,0x03ff7000,0x007ff000,0x2a003ff2,
    0x04ffffff,0xfffffc98,0x6c02ceff,0x75cc09cf,0x03efffff,0x7cc00dfd,
    0xffffffff,0xffb8801f,0x0bffffff,0x7413fe00,0xffa8005f,0x3ff80001,
    0x7ffed400,0x000befff,0x0006a600,0x154c0000,0x004cc400,0x7fc40000,
    0x3200001f,0xf30006ff,0x7fe405ff,0x26012e05,0x000009aa,0x01355330,
    0x0003ffa6,0xaa800d44,0x9a988001,0x00008000,0x004ff880,0x10059900,
    0x64c007ff,0x98002cee,0x44001aa9,0x15551000,0x000ffe40,0x99999995,
    0x88001999,0x00009aa9,0x06aa0355,0x009ff100,0x000b3200,0x00009988,
    0x00000000,0x00000000,0xff100000,0xffffffff,0xffffffff,0x003fff8f,
    0xc81bffa0,0x000005ff,0x00000000,0x00000254,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0xf1000000,0xffffffff,0xffffffff,
    0x07ffd4ff,0x3fff7000,0x0017ff20,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x10000000,0xffffffff,
    0xffffffff,0x2ffecfff,0x3ffe2000,0x00000004,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00035000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x03eeea80,0xd97bba20,0x3baa05ee,
    0x037baa0d,0x2732e000,0xd9004cc8,0x664003dd,0x44019900,0x3bae0eee,
    0xedca8804,0x0000bcef,0x072e0397,0x00fbbae0,0x0acdca80,0xb80e5c00,
    0x1eee801c,0x10013baa,0x88006a60,0x00004eed,0x2003ddd9,0x0004eee9,
    0x80799700,0x2defedb9,0xdfdf5000,0x3fae0001,0x00000cef,0x3fffb6e2,
    0x40000acd,0xdeffecb9,0x37fdc00c,0xfffeca80,0x300002ce,0x7bdffdd9,
    0xffe80001,0x7ffdc006,0x805fff51,0xfff14ffd,0x3f600003,0x807ff8af,
    0x00effffa,0xff709fb0,0x21fff880,0x75405ffc,0xffffffff,0x6fc8003f,
    0xb000ffa8,0xd5000fff,0x1dffffff,0x2a1bf200,0xfff800ff,0x4017fee1,
    0xd0adffea,0x7ff4007f,0x440003ff,0x5c004fff,0x10001fff,0x81bffa0b,
    0xfffffffb,0x9f4000df,0x74c003d8,0x1fffffff,0x7fec4000,0xffffffff,
    0xfd88004f,0xffffffff,0xdff700cf,0xffffeb80,0x03efffff,0xffffd500,
    0x17ffffff,0x1fff5000,0x23ffe800,0xf8804ffd,0x03ffdaff,0x2bff6000,
    0x7c407ff8,0x005ffbff,0xf955bff5,0xfff8809f,0xc817ff21,0xeddfffff,
    0x4003ffff,0xfcabdff9,0x3fa2005f,0x3fee003f,0xefffffff,0xbdff9800,
    0xf005ffca,0x2ffdc3ff,0x7ffffcc0,0x000fffff,0x3ffdbff9,0x37fe4000,
    0x05ffd800,0xfd07fb80,0x3ffee0df,0x5ffffddf,0x6a83e600,0x3fffe200,
    0x00ffffdd,0xfffff500,0xfffffdff,0x3ea003df,0xffffffff,0xb83fffff,
    0x3ff606ff,0xffffffff,0x64005fff,0xfeffffff,0x00efffff,0x000fff40,
    0xff997fea,0x3ffe6006,0x400004ff,0x7ec8affd,0xfd9fff40,0xfffb004f,
    0xd100bfff,0x2775c1dd,0x80cfff98,0x8006ffe9,0xeffffffb,0x37fcc000,
    0x0cfff980,0x003bffaa,0x3fffffee,0x3ddd000e,0x5c027754,0xfffda8df,
    0xfff5004f,0x001fff31,0x001fff10,0x000fff40,0x7ff41ffe,0x0bfffa86,
    0x000fffdc,0xb002645f,0x7f441bff,0xffb8004f,0x5441adff,0x402ffffd,
    0x09bffffd,0x3ffffae6,0xd82ff543,0x221bffff,0x0efffea9,0xbffffe80,
    0x6fffea80,0x00ffe600,0xfd83bf60,0x7fdc000f,0xd800006f,0xd81b62ff,
    0x3ffe26ff,0xbddb5002,0x20000005,0x7c406ffc,0xd98001ff,0x20003dee,
    0xfe802ffa,0x7ffd104f,0x37bb6600,0x00000003,0x01750397,0xc8bffe20,
    0xfb8006ff,0x7c40001f,0x3ffc005f,0x04ffd800,0xc800fffa,0x2001fdcf,
    0xffb82fff,0x7ffcc006,0xfff5002f,0x77ffd40d,0xfffe8800,0xffb84f83,
    0xfff9005f,0x4fffc80b,0x09fff900,0x40006620,0x004cc099,0x00099980,
    0x22ffd800,0x0266604f,0x00001331,0xfb000000,0x3ffd003f,0x00000000,
    0xff500262,0x37fd401f,0x00000000,0x20000000,0x99981998,0x004c4000,
    0x00198800,0x44003ffc,0x3ee00fff,0x66d4003f,0x1ffe2000,0x1003ffcc,
    0x8001dffd,0xf881fff9,0xfd8005ff,0x20be60ff,0x54006fff,0xff502fff,
    0xffd8009f,0x0000000f,0x00000000,0x4bff6000,0x000002fd,0x00000000,
    0xffd80040,0x00000002,0x2ffec000,0x000fffc0,0x00000000,0x00000000,
    0x00000000,0x81ffe000,0x07ff8819,0x00017fec,0x03fff000,0x6400bff7,
    0xb0001fff,0xfff90bff,0xfff10001,0xf503ba29,0xfb0003ff,0x1bffa0ff,
    0x13ffe200,0x9bdd9510,0x7ee54001,0x44001bde,0x00cdeeca,0x8b3bae60,
    0x01e8affd,0xcdeeca88,0x3f72a000,0x32a01bde,0x1ccb801c,0x7fe54400,
    0x6dcc002f,0x2a01bdee,0xccb801cc,0x200bffa1,0x2a204ffc,0x0bcefedc,
    0x3bf72a00,0x654001bd,0x001bdefd,0x5ef7ee54,0x7ee54001,0x54001bde,
    0x01bdefdc,0x33fff326,0x30ff10cc,0x7fc40fff,0x00732a07,0x7f40732e,
    0x02ffd86f,0x0013ffe0,0x7cc5ff98,0x2a0004ff,0x81ffafff,0x30006fda,
    0xff985fff,0xbf90002f,0x3fffa207,0x404fffff,0xffffffd8,0xfe8804ff,
    0x4fffffff,0x7ffffd40,0x2ffd8eff,0xffffd100,0x8809ffff,0xfffffffd,
    0x07ffb04f,0x2205ffd0,0xffffedba,0x32002fff,0xffffffff,0x007ffb03,
    0x3fe25ffd,0x6ffa800f,0xfffffd50,0x8807ffff,0xfffffffd,0xffd8804f,
    0x04ffffff,0xfffffd88,0xd8804fff,0xffffffff,0xfffd8804,0x504fffff,
    0xffffffff,0xf303fe23,0x1ffe40df,0xd007ffb0,0x3fea05ff,0x0fffb14f,
    0x00fffcc0,0x7fdc0600,0x7fc0000f,0x00800dff,0x913ffa00,0x04000fff,
    0x3bfffe60,0x04ffffdd,0xbbdffff3,0x201dffff,0xddeffff9,0xf704ffff,
    0xffd9dfff,0x3005ffdd,0xfbbdffff,0x3e609fff,0xffddefff,0x7fec0eff,
    0x42ffe803,0xffffffc8,0x02fffeff,0xdefffe88,0x40efffed,0xfe803ffd,
    0x00fff32f,0x3f21ffe6,0xfeddffff,0xff303fff,0xfffbbdff,0x3fe601df,
    0xfffddeff,0xfff300ef,0xffffbbdf,0x3ffe601d,0xffffddef,0xffff300e,
    0xdffffbbd,0xfffee981,0x1ff30eee,0xf106ffa8,0x3ffd80ff,0x202ffe80,
    0xffecfffc,0x3ff2000e,0x9000000f,0xb0000bff,0x00000dff,0xfd1fff20,
    0x400000df,0x6441fffe,0xffe82fff,0x5fffa81e,0x883fffd0,0x7c42fffc,
    0x7f4c0dff,0xfe802fff,0x7fe441ff,0x1effe82f,0x6c5fffa8,0xffe803ff,
    0x3ffffe22,0xffb1acef,0x3dffb005,0xd89fff30,0xffe803ff,0x200fff52,
    0x3e60fff9,0xfe980cff,0x3dffd06f,0x20bfff50,0xfa81effe,0xdffd05ff,
    0x0bfff503,0x2a07bffa,0xffd05fff,0xbfff503d,0xf983ffc0,0x837fd41f,
    0x7ec03ffd,0x2ffe803f,0x7fffff40,0x6ffd8004,0x3fa00000,0xfb80004f,
    0x0000007f,0xfff8fff7,0xf7000005,0x7ff401ff,0x0077fe45,0xfb85fff3,
    0x3ffa00ff,0x1037fec5,0xb805fffd,0x3fa00fff,0x077fe45f,0x6c5fff30,
    0xffe803ff,0x06ffffa2,0x5402ffe8,0x3e200fff,0x0fff61ff,0x7d4bffa0,
    0xfff1006f,0x2037fe41,0x7e41fff8,0x3fe600ef,0x077fe42f,0xc85fff30,
    0x3e600eff,0x77fe42ff,0x0bffe600,0x4c01dff9,0xfff02fff,0xf507fea0,
    0x1fff10df,0x803ffd80,0x36202ffe,0x0003ffff,0x0000bffd,0x001fffc0,
    0x983ffd40,0xeeeeeeee,0xeeeeeeee,0x0fffeeee,0x0000fffe,0x201ffec0,
    0xff10fff9,0xdff9005f,0x4c03ffd8,0x3ffe0fff,0x17ffdc02,0x300fff60,
    0x3fe21fff,0x6ffc802f,0x3a00fff6,0x3fff32ff,0x805fff00,0xfb802ffe,
    0x00fff65f,0x7fdcbffa,0x1fff1006,0x7400ffec,0x3ffe21ff,0x26ffc802,
    0xc802fff8,0x3ffe26ff,0x26ffc802,0xc802fff8,0x3ffe26ff,0x06ffc802,
    0x3fea0fff,0x4c37fd42,0x7ec00fff,0x2ffe803f,0xffffff70,0x3ffe000d,
    0xf1000003,0x500005ff,0xff301fff,0xffffffff,0xffffffff,0x223fffff,
    0x00002fff,0x2600fff0,0x8037fcc0,0x3fe0fff8,0xf8813007,0x5fff006f,
    0x3007ff80,0x006ff981,0x3f61fff1,0x2ffe803f,0xf300bff7,0x7fcc05ff,
    0x4fff1007,0xfe803ffd,0x00bff72f,0x00407ffc,0x3e62ffd8,0xfff1006f,
    0x401bfe61,0xff30fff8,0x3ffe200d,0x200dff30,0xff30fff8,0x3ffe200d,
    0xf707ff80,0x06ffa87f,0xfd80bfff,0x2ffe803f,0xfcefffd8,0xff8005ff,
    0xfff9803f,0x4fffffff,0x0003fff3,0x303fff30,0xffffffff,0xffffffff,
    0x3fffffff,0x000bffe2,0x01bfe200,0x005ffb80,0x7fc47ffe,0x3fea0006,
    0x05ffd005,0x00037fc4,0x7c00bff7,0x07ffb1ff,0x3f25ffd0,0xfffd806f,
    0x01bfea02,0xffb0fff8,0x25ffd007,0xf1005ffa,0xa88001ff,0x3ee2fffc,
    0x3ffe005f,0x400bff71,0xbff71fff,0xb8fffc00,0x3fe005ff,0x00bff71f,
    0x7fc0fffc,0xa87ff707,0xfff706ff,0x0fff601d,0xfb0bffa0,0x7ffec9ff,
    0x202f7e23,0xf9803fff,0xffffffff,0x05fff14f,0x1fff7000,0x266fffe0,
    0x99999999,0xffa99999,0x07fff10f,0xbff50000,0x27fe4000,0x2a5ffd00,
    0x2e0005ff,0xffb004ff,0x02ffd405,0x009ff900,0xffd97ff4,0x72ffe803,
    0x7ec05fff,0x3ee03fff,0xffffffff,0x1fffffff,0xfd007ffb,0x01bfe65f,
    0x8807ffc4,0xffffedba,0x3ff22fff,0x4bffa004,0x3a004ffc,0x09ff92ff,
    0xfc97ff40,0x3ffa004f,0x4009ff92,0x7ff82ffe,0xfa89ff90,0x3fff206f,
    0x03ffd82f,0x3ea2ffe8,0x7ff443ff,0x20fff71f,0xf9804ffe,0xffffffff,
    0x00fffe4f,0x81fff200,0x40003fff,0x7ffc7ffa,0xfb800005,0x3f60004f,
    0x3ff6003f,0x0009ff73,0xc801ffec,0x3fee02ff,0x3ff60004,0x4fff6003,
    0xfe803ffd,0x9ffff12f,0xfffd7515,0x7fe409ff,0xffffffff,0xb2ffffff,
    0xffd007ff,0x401ffe65,0xfc887ff9,0xefffffff,0x3ff62fff,0x4fff6003,
    0x36003ffd,0x07ffb3ff,0xfd9ffec0,0x3ff6003f,0x4007ffb3,0x7ff83ffd,
    0xfa89ff90,0x7ffdc06f,0x01ffec4f,0xfff17ff4,0x3fffe60b,0xfb04ffe8,
    0xfb0000bf,0x027ffc9f,0x037fec00,0x80009ffd,0x7ff46ffc,0xfb800006,
    0x3f60005f,0x3ff6003f,0x000bff73,0xc8027fe4,0x3fee02ff,0x3ff60005,
    0x4fff6003,0xfe803ffd,0x3fffea2f,0x9aefffff,0x3ff206ff,0xccccccce,
    0xb1cccccc,0xffd007ff,0x401ffe25,0x7fc47ffa,0x1aceffff,0x7fec5ffb,
    0x4fff6003,0x36003ffd,0x07ffb3ff,0xfd9ffec0,0x3ff6003f,0x4007ffb3,
    0x7ff83ffd,0xfa8bffb0,0xffe9806f,0x00fff64f,0x7fccbffa,0x3ffea02f,
    0xf700fffe,0xd80001ff,0x1bff24ff,0x13ffa000,0x0006ffd8,0x3f22ffec,
    0x3a20007f,0x0dff50ac,0x027fe400,0x3ea5ffd0,0x3ea0006f,0x5ffb005f,
    0x0037fd40,0x4009ff90,0x7ffb2ffe,0x985fff00,0x4ffffffe,0xfb80fffc,
    0x7ec0005f,0x2fff803f,0x2a003ffe,0x7fff45ff,0x8bffa01b,0x3a004ffc,
    0x09ff92ff,0xfc97ff40,0x3ffa004f,0x4009ff92,0x9ff92ffe,0x417ff400,
    0xbffb07ff,0x1006ffa8,0x7fecfffb,0x52fff803,0xff900fff,0x7c40bfff,
    0x6c0003ff,0x3ffe64ff,0x3fea0002,0x3ffee01f,0xfff10000,0x01fff987,
    0x21fff700,0x97007ff9,0x017fea39,0xff31fff8,0x4732e00f,0xfd006ff9,
    0x3ffcc05f,0xf51ccb80,0x7ffc00bf,0x8807ff91,0x53102fff,0x803fe013,
    0x40007ff9,0x7c403ffc,0x0bffa2ff,0xf98fff60,0xfff801ff,0x8017fea2,
    0xbff51fff,0xa8fffc00,0x3fe005ff,0x00bff51f,0xffa8fffc,0x07ffe005,
    0x7ff41ffe,0x0037fd46,0x7fe4bffa,0x97ffc403,0xd801fffa,0x6c02ffff,
    0x20000fff,0x7ffc4ffd,0x3ffa0006,0x05fff806,0x01fff900,0x2000bfff,
    0x3fe25ffe,0x1ffe801f,0x5001fff3,0x7ffc4fff,0x21ffe801,0x7c400fff,
    0x3fe202ff,0x1ffe801f,0x5001fff3,0x27fe4fff,0x00bffe60,0x4406f880,
    0xf9801fff,0x09ff90ce,0x2e2fff98,0x7fc405ff,0x017fee1f,0xf98bffe6,
    0xffa800ff,0x003ffe67,0xff99ffea,0x7ffa800f,0x2003ffe6,0x3fe67ffa,
    0x7ffa800f,0xff01fff0,0x06ffa8ff,0xfca7fe40,0x7ffcc04f,0x009fff12,
    0x805ffff3,0x0005fff9,0xff513ff6,0xff70007f,0xfff7007f,0xfff98003,
    0x03fff704,0x42fffb80,0x7cc05ffd,0x02fff47f,0x3f62fff4,0x3ffcc05f,
    0xf9017ff6,0xffd805ff,0x23ffcc05,0xfe805ffe,0x01bfee5f,0x0005fffb,
    0x7ec037d4,0x6ffe806f,0xfb01bfee,0x0fff85ff,0xf91bfee0,0xfffb00df,
    0x805ffe85,0x7ff45ffe,0x45ffe805,0xfe805ffe,0x02fff45f,0x3fa2fff4,
    0x5ffe805f,0xff01fff0,0x46ffa8ff,0x9ffb00eb,0xfb01bfee,0x3fffc5ff,
    0x3ffffa20,0x7ffdc02f,0x3fa6000e,0xfffd84ff,0x3fff2004,0x3fffe005,
    0xfffd3001,0x0ffff401,0x86fff980,0xd103fff8,0xfff989ff,0x1fffb103,
    0x103fff88,0xff889ffd,0xffff503f,0x3fff8805,0x989ffd10,0xfb103fff,
    0x7ffcc1ff,0x5ffff903,0x0ffd4000,0x813ffe20,0x3e62fffc,0xfff903ff,
    0x0effc85f,0x5c2fffa8,0x3f602fff,0x7fcc3fff,0xfffb103f,0x03fff981,
    0x981fffb1,0xfb103fff,0xfff981ff,0x1fffb103,0x103fff98,0x3e01fffb,
    0x7fff82ff,0xff937fd4,0x25fff30d,0xf903fff9,0x7fd45fff,0xfffd305f,
    0xd805ffff,0x80acffff,0xfffffda8,0xeffff882,0x3fffa600,0x3fea000f,
    0x7fdc03ff,0x7fcc03ff,0xf9102cff,0x3ee01fff,0xfda9bdff,0xfff906ff,
    0xffd7337b,0x3ffee03f,0xfffda9bd,0x5bfff306,0xfffffb53,0xbfff7005,
    0xdfffb537,0x2f7fff20,0x1fffeb99,0xabefffe8,0x2ffdffec,0x67ffc000,
    0x7fe40fdb,0xfec99bef,0xfffe85ff,0xdffecabe,0x7ffc42ff,0xfffca9be,
    0xcffff885,0xfffeba8a,0xfffc84ff,0xffeb99bd,0xbfff901f,0xfffd7337,
    0x37fff203,0xfffeb99b,0x7bfff901,0x3fffd733,0x2f7fff20,0x1fffeb99,
    0x3b7fffa0,0xfa8ffff1,0x3bffa26f,0x45fffc9b,0xcabefffe,0x42ffdffe,
    0xcacefffd,0xfaaffffe,0x7e403fff,0xddffffff,0xcfffffff,0x3fffa200,
    0xffdccdff,0x8000efff,0xcefffff9,0xfffffdca,0xffff5002,0xffb97bff,
    0xfb803fff,0xffffffff,0x3ffee00e,0x1fffffff,0x7ffffdc0,0x200effff,
    0xfffffffb,0x002ffcbf,0xfffffff7,0x7dc01dff,0xffffffff,0xfffd301f,
    0xf73fffff,0xfc80005f,0xb80fffff,0xffffffff,0xffd305ff,0x73ffffff,
    0xffd305ff,0x0dffffff,0x7fffffd4,0xff9aefff,0xfffff706,0x803fffff,
    0xfffffffb,0x7dc01fff,0xffffffff,0x7ffdc01f,0x1fffffff,0x7ffffdc0,
    0x401fffff,0xf3fffffb,0x6ffa8fff,0x7fffffc4,0x7f4c0fff,0x9fffffff,
    0xffc82ffb,0xefffffff,0x017ffea0,0x3fffffea,0xefffffff,0x3fff2001,
    0xffffffff,0x7440004f,0xffffffff,0x4000efff,0xffffffe9,0x01efffff,
    0xfffffb30,0x3f66007f,0x00bdffff,0xfffffb30,0x3b26007f,0xff93efff,
    0x7fecc005,0x3003ffff,0x7bfffffb,0xfffd8801,0x5ff71dff,0xdfb50000,
    0x7fec4039,0x402effff,0xdfffffd8,0x2205ff71,0x3ffffffd,0xffffe980,
    0x0fffc4ff,0xfffffd98,0xfb3000bd,0x017bffff,0x3ffff660,0xb3000bdf,
    0x17bfffff,0x3fff6600,0x7000bdff,0x3fe9fffd,0x437fd47f,0xcffffec9,
    0xffffb100,0x0bfee3bf,0x7fffff54,0x00df304e,0xfffffda8,0x0002ceff,
    0xffffff91,0x000017ff,0x7ffff6dc,0x40003def,0xffffffda,0x260002ef,
    0x220000aa,0xa980001a,0x2a60000a,0xa9800000,0x2a20000a,0x06a60001,
    0x00000000,0x00135510,0x00003530,0x10003551,0x00001353,0x200006a2,
    0x880001a8,0xa880001a,0x1a880001,0x004c4000,0x04d44000,0x00035300,
    0x26003530,0x2a660000,0x8800000a,0x00009aa9,0x01353000,0x2a660000,
    0x0000001a,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x0b332200,0x3331002a,0x33333333,
    0x99700003,0x1776c403,0x9503ddb1,0x3bb2a219,0xeee800bd,0x0013baa1,
    0x0009ddb1,0x007bbb20,0x0027774c,0x37bb2a20,0x5d44000c,0x32a01acd,
    0x32e0003c,0x41ddd01c,0x04004eea,0x22001a98,0x00004eed,0x4003ddd9,
    0x0001eeec,0x2f7bb6e6,0x77744001,0x776c0004,0xeed8000d,0x3bb2000d,
    0xdb71000d,0x400379df,0x30aceeb9,0x4332a399,0x0aceeca8,0x79b75100,
    0xb9510003,0xddb10037,0x7fff300b,0xf9013faa,0xffffffff,0x80003fff,
    0x7d402ffe,0x09ffb0ff,0x3fa23ff2,0x02ffffff,0xff70fffc,0xfffe800b,
    0x7c40003f,0x7dc004ff,0xe88001ff,0xffffffff,0xffffb004,0xf9019fff,
    0x7f4000bf,0x43fff03f,0xd5005ffb,0x17f45bff,0x7ffffd00,0xfff88000,
    0x7ff44004,0xfff90005,0x007fffff,0x017ffff4,0x02fffa80,0x02fffa80,
    0x1bfffee0,0x3ffffea0,0x4c03ffff,0xefffffff,0xff92ffb8,0xfffffd13,
    0xffb805ff,0x01efffff,0xfffffc88,0x7fd404ff,0xffe8802f,0x7402efff,
    0xffffffff,0x7001ffff,0xfff99999,0x7fe4079b,0x3206ffad,0xeffffaff,
    0x202fffff,0x3fee1fff,0x37ff2005,0x20001ffe,0xb0005ffc,0xf9800bff,
    0xffddefff,0x3fa204ff,0xffffffff,0x005ffc86,0x7c0fffa0,0x17fee1ff,
    0x3ffffe60,0x000fffff,0x3ffdbff9,0x2ffe4000,0x1fff9800,0x3fffa200,
    0xefffedde,0x767fec00,0xfe8001ff,0xffd0004f,0x7ffcc009,0x3ea05ffc,
    0xffecdeff,0xfff105ff,0x9dffb9bf,0x2fff25ff,0xfffeeffe,0xfffb01ff,
    0x5fffffff,0x7ffff440,0x00dfffff,0x2201bfee,0x002ffffc,0xdddddfff,
    0x003ddddd,0x3ffffffa,0x7406ffff,0x200fffff,0x0beffffc,0xe81bffea,
    0x13baa1ee,0x4c7ffd40,0x88000fff,0x20000fff,0x3a001ffe,0x7e441fff,
    0xfff882ff,0xfff710be,0x005ffc89,0x740fffa0,0x13baa0ee,0x36a37f20,
    0x5004ffff,0xfff31fff,0xdff10001,0x7fd40001,0x3bff6005,0x04fff981,
    0x3e63bfee,0x3ea000ff,0xff30005f,0x7ff4400b,0x3a07ffb3,0xffc884ff,
    0x6fff440f,0x7ffff440,0x1bffff92,0xb87ffe98,0xd712dfff,0x3f601fff,
    0xff931cff,0x2ffd80df,0xfdfff910,0xdff1009f,0x99700000,0x9bfff999,
    0xffff8807,0x27ffe401,0x003fff50,0xfff98000,0x001bff22,0x00007ff2,
    0x2e009ff1,0x3fa00fff,0x0fffb85f,0x641fff50,0x3a0005ff,0x000003ff,
    0x2ea20e5c,0x5fff3000,0x40037fe4,0x80001ffc,0xfa800ffc,0x3fe200ff,
    0x1fff981f,0xe801bff2,0xfb0000ef,0x7fec001f,0x107ffe25,0xffe80dff,
    0x102ffec3,0x3f25ffff,0x3fe605ff,0x027ffc0f,0xff50bfff,0x3ffe203f,
    0xf837f402,0xffe88cff,0x02ffd401,0xffd00000,0x04cc4005,0x007ffe40,
    0x0000bffe,0x30333100,0x98800133,0x33100000,0x00fff600,0xff81fff3,
    0x1fff402f,0x4000bff9,0x00003ffe,0x22000000,0x09998199,0x0004c400,
    0xd0013300,0xff7005ff,0x3013310b,0x26600133,0x02660000,0x88133300,
    0x37fcc099,0xff06b260,0xfffb803f,0x801fff92,0x3fe61ffe,0x1ffee01f,
    0xfb013ff6,0x0198809f,0xfff98197,0x00ffee00,0xffe80000,0x32000002,
    0xffe805ff,0x00000002,0x00000000,0x1ffe0000,0x7fdc04c0,0x23eea804,
    0x20005ffc,0x00003ffe,0x00000000,0x00000000,0x7ff98000,0x00fff100,
    0x00000000,0x40000000,0x8004fff8,0xff006ff8,0x01bff25f,0xffb8bff6,
    0x07ffc406,0xf5007ffe,0x260000df,0x4ffc8abb,0x0007ff60,0x2ceeb980,
    0x2600bffa,0x01bdeedb,0x36013ff2,0x36e602ff,0x4001bdee,0x1bdeedb9,
    0x776dcc00,0x5cc001bd,0x201bdeed,0x40006ff8,0x20001ffe,0x20005ffc,
    0x95103ffe,0x0179dfdb,0x3fb72a20,0x51000bce,0x179dfdb9,0x3b72a200,
    0x1000bcef,0x79dfdb95,0x01bfea01,0x9950fff8,0x03997003,0x79dfdb71,
    0x00732a03,0x2e20732e,0x01bcefed,0x2b7ffff6,0x05ffa800,0x3f25ffb0,
    0x3ffc805f,0xf101ffea,0x005301ff,0x6540dff5,0xffff702c,0x03fffdff,
    0x00003ffa,0x3fffffea,0x02ffe8ef,0x7fffffe4,0x7ff903ff,0x207ffb00,
    0xfffffffc,0xfff9003f,0x007fffff,0x3ffffff2,0xff9003ff,0x07ffffff,
    0x00017fea,0xc8000fff,0x3a0005ff,0xffea83ff,0x3fffffff,0x7ffff540,
    0x403fffff,0xffffffea,0x75403fff,0xffffffff,0x7ff5403f,0x3fffffff,
    0xffffffb8,0xffffffff,0x07ffb1ff,0xfa85ffd0,0xffffffff,0x803ffd83,
    0x7fd42ffe,0x3fffffff,0xfffffd10,0x3ee037df,0x5ff9004f,0x32013ff2,
    0x17ffc3ff,0x000dff90,0x2e04ffc8,0x7fec44ff,0xfffffeff,0x56ff885f,
    0x0059dfd9,0xd9dffff7,0x05ffddff,0x37bfffa2,0x40efffed,0xfd803ffc,
    0x7fff443f,0xefffedde,0xdfffd100,0x1dfffdbb,0x3bfffa20,0x0efffedd,
    0xbdfffd10,0x81dfffdb,0x20004ffb,0x65445ff8,0x3ff2009b,0x3ffa0005,
    0x7ffffe43,0x3ffffedd,0xbfffff90,0x07ffffdb,0x37fffff2,0x03ffffed,
    0xbbfffff9,0x207ffffd,0xddfffffc,0x643ffffe,0xffffffff,0xffffffff,
    0xd007ffb2,0x7ffd45ff,0xffffecde,0x401ffec5,0x3fea2ffe,0xfffecdef,
    0x3fff205f,0x40efffff,0xf7003ffd,0x013ff25f,0xffb0fff2,0x0fffe20b,
    0x1fff9800,0xfb13fee0,0x7ecc17ff,0x7fcc0fff,0xffffffee,0xfff100df,
    0xfffe981b,0x3dffb02f,0xc89fff30,0xffd803ff,0x40f7fec3,0xfb04fff9,
    0xfff303df,0x07bff609,0x6c13ffe6,0xff981eff,0x02ffdc4f,0x229ff300,
    0x2ffffffe,0x000bff90,0xff31fff4,0xffd3019f,0x19fff30d,0x30dffd30,
    0xd3019fff,0xfff30dff,0xdffd3019,0x019fff30,0xfc8dffd3,0xccccccef,
    0x1ccccccc,0xfd007ffb,0x427ff45f,0x360fffc8,0xffe803ff,0x2213ffa2,
    0x2200fffc,0xffffffda,0x013ff22f,0xffc97fdc,0x43ffc804,0xa9cfffe8,
    0x000dfffd,0x1fffed44,0xfa93fee0,0x3ff201ff,0x7fffdc3f,0xfffffeff,
    0x05ffd81f,0x20bfffe2,0x2200fffa,0x3ff21fff,0x23ffd803,0x2200fffa,
    0x7fd41fff,0x3ffe200f,0x007ffd41,0xfa83fff1,0x3fe200ff,0x01bfea1f,
    0xf9cffa80,0xffffffff,0x005ffc85,0xfc8fffa0,0x7ffc406f,0x2037fe41,
    0x7e41fff8,0x7ffc406f,0x2037fe41,0x7e41fff8,0x7ffc406f,0x0017fee1,
    0xd007ffb0,0x1bfe25ff,0x7ec7ffd0,0x2ffe803f,0xfe80dff1,0x3ae6003f,
    0x3fee7fff,0x25ff9005,0xfc804ffc,0xffff703f,0x0005ffff,0x03fffffd,
    0x7f49ff70,0x6ffe803f,0x0577ffe4,0xf0dfff91,0xffb803ff,0x02ffe82f,
    0x3f25ffb8,0x3ffd803f,0x2e00bffa,0x17ff45ff,0x3a2ffdc0,0xffb802ff,
    0x4017ff45,0x3fe65ffb,0x23997007,0xbeffdffb,0x3fffeb99,0x0002ffe4,
    0x7fec7ffd,0x41ffe801,0xfe801ffd,0x00ffec1f,0x3f60fff4,0x1ffe801f,
    0x7400ffec,0x1ffe61ff,0x07ffb000,0x3e65ffd0,0x0d64c06f,0xfd007ffb,
    0x01bfe65f,0x20003593,0xff51fffb,0x4bff600d,0xfc804ffc,0xfffc883f,
    0x002effff,0x77ffffc4,0xa7fdc00b,0xa800fff9,0x3ffa0fff,0x27ffd405,
    0x3e00dff1,0x3ffcc2ff,0x327ff880,0xffd803ff,0x200fff33,0x3fe67ff8,
    0x4fff1007,0xf1007ff9,0x03ffccff,0x3e27ff88,0xffe801ff,0x0bffff91,
    0xf907ffe4,0x7f4000bf,0xfb00083f,0x6c00205f,0x200102ff,0x00102ffd,
    0x0040bff6,0x3e22ffd8,0xef9801ff,0x007ffb0c,0x3fe25ffd,0xffd8004f,
    0x12ffe803,0x70009fff,0xffd007fb,0x007ffe27,0x3f25fff1,0x3ffc804f,
    0x5effffd4,0x00efffdc,0xffd99b10,0x7fdc03ff,0x200bff54,0x0181fff8,
    0x7d4fff90,0x5ffd005f,0x2006ffa8,0x7ff90fff,0x2a7ffb00,0x3fe006ff,
    0x00dff50f,0xffa87ffc,0x43ffe006,0x3e006ffa,0x17ff60ff,0x7e4fff30,
    0xffe806ff,0x0017ff25,0x4003ffe8,0x02fffca8,0xfffca880,0xfca88002,
    0xa88002ff,0x8002fffc,0x42fffca8,0xfe806ffd,0x00fff66f,0xffd8bffa,
    0xd800adff,0xffe803ff,0x37ffff62,0x7ffb800a,0x90fffc40,0xffc80bff,
    0x009ff92f,0x7fcc7ff9,0xffe980df,0xfd30000e,0x3fee01ff,0x400bff74,
    0x20002fff,0xff70fff9,0x0bff6009,0xfffffff7,0xffffffff,0x00fff23f,
    0x7fdcfff6,0xffffffff,0x71ffffff,0xffffffff,0xffffffff,0x3ffffee3,
    0xffffffff,0xfff71fff,0xffffffff,0x443fffff,0xfd103fff,0x17ffdc9f,
    0xf937fd40,0x7f4000bf,0xdb75103f,0x5fffffff,0x7f6dd440,0x02ffffff,
    0x3ffb6ea2,0x202fffff,0xfffedba8,0x2202ffff,0xffffedba,0x7fc42fff,
    0x3fff204f,0x200fff62,0x3fa22ffe,0x1befffff,0xd007ffb0,0x7ff445ff,
    0x01beffff,0x5c07fff3,0x7ffc46ff,0x5ffff503,0x32013ff2,0x17ffa3ff,
    0x007fff10,0x827ffc40,0x9ff94ffb,0x01fff400,0x6cbffe00,0xff9003ff,
    0xfffffc85,0xffffffff,0x7ff92fff,0x327ffb00,0xffffffff,0xffffffff,
    0xffffff92,0xffffffff,0x3fff25ff,0xffffffff,0xf92fffff,0xffffffff,
    0x5fffffff,0x9bdfffb8,0x546fffda,0xf8800fff,0x0bff90ff,0x21fff400,
    0xffffffc8,0x82fffeff,0xffffffc8,0x82fffeff,0xffffffc8,0x82fffeff,
    0xffffffc8,0x82fffeff,0xffffffc8,0x82fffeff,0x99befffc,0x6c5fffec,
    0xffe803ff,0xfffffc82,0x7ec0efff,0x2ffe803f,0xffffffc8,0xffc80eff,
    0xfca9acef,0xfffb83ff,0xfffda9bd,0x09ff92ff,0x3e67ff90,0xffa800ff,
    0x7fdc0007,0x329ff707,0x3fa003ff,0x7f40002f,0x007ff92f,0xff90bff2,
    0x9999999d,0x23999999,0xfd803ffc,0x99dff93f,0x99999999,0x3ff23999,
    0xccccccce,0x91cccccc,0x99999dff,0x99999999,0x333bff23,0xcccccccc,
    0xffb81ccc,0xefffffff,0x003ffcc0,0x3ff23fff,0x3ffa0005,0x3ffffe23,
    0xffb1acef,0xfffff885,0xffb1acef,0xfffff885,0xffb1acef,0xfffff885,
    0xffb1acef,0xfffff885,0xffb1acef,0x3fffee05,0x85ffffff,0xfe803ffd,
    0xffb5102f,0x6c5fffff,0xffe803ff,0xfffb5102,0xfd05ffff,0xffffffff,
    0x7ffd405f,0xfecfffff,0x009ff92f,0x3fea7ff9,0x1fff1006,0x7ffcc000,
    0xf74ffb80,0x7ffc009f,0x7ffc0001,0x2009ff51,0x7fdc2ffd,0x7fe40005,
    0x73ffd803,0xb8000bff,0x5c0005ff,0x5c0005ff,0x400005ff,0xffffffd9,
    0x01fff103,0x7e43ffe0,0x00e54c5f,0xffe8bffe,0x3ffa01bf,0x0dffff42,
    0xfe85ffd0,0x3fa01bff,0x5ffff42f,0xd0bffa01,0x74037fff,0x3f6202ff,
    0x02efffff,0xff007ffb,0x3ae6005f,0x3ff67fff,0x02fff803,0xffffd730,
    0x3ffffaa0,0xd9801dff,0xfd3effff,0x013ff25f,0x7fdcfff2,0x07ffe005,
    0x7ffc4002,0xf54ffb81,0x3fe200df,0x00fdd50f,0x7cc3ffe2,0x5ffd005f,
    0x0007ff98,0x26003100,0x4c0007ff,0x4c0007ff,0x4c0007ff,0x000007ff,
    0xf0015ff3,0xff1005ff,0x2e2ffe4d,0x3fe204ff,0x03fff32f,0x7cc5fff0,
    0xfff801ff,0x007ffe62,0xff98bffe,0x2fff801f,0x2007ffe6,0xb1002fff,
    0xffc8017f,0x17ffc403,0x8fffdc00,0x7c403ffc,0xfb8002ff,0x3fe201ff,
    0x2a60000b,0x0017ff40,0xff53ffc8,0x87ffc00d,0xf3006fea,0x9ff701ff,
    0x2003ffe6,0x3fe27ffb,0x7ffb801f,0x22007ffc,0x7fc42fff,0xcef9801f,
    0x177ff400,0x003fff10,0x3e219df3,0xef9801ff,0x03fff10c,0x2219df30,
    0xf9801fff,0x7fe400ce,0x4ffc801c,0x324ffa80,0x2ffd45ff,0x2e3fff10,
    0xff9805ff,0x017fee2f,0xfb8bffe6,0xfff9805f,0x2017fee2,0x3ee2fff9,
    0xfff9805f,0x003fa002,0xf3013ff2,0x0ff6e5ff,0x7e4fffa0,0x7ffcc04f,
    0xd007fb72,0x7fc407ff,0xe800002d,0xf90002ff,0x03ffe67f,0xf89ffe60,
    0xffb800ff,0x749ff706,0x7fc404ff,0x027ff43f,0xfd0fffe2,0xfffc809f,
    0x806ffd82,0xec806ffe,0x3f600fff,0x6ffe806f,0x74037fec,0x37fec6ff,
    0x3637ff40,0xffe806ff,0xffeb9806,0x0fffc401,0xfc8bffa0,0x07ffcc5f,
    0x3f27ffb8,0xfffd806f,0x201bff22,0x3f22fffd,0xfffd806f,0x201bff22,
    0x3f22fffd,0xfffd806f,0x401fe002,0x7ec06ffb,0x0fff72ff,0xf71fff88,
    0xfffd80df,0x880fff72,0x2a201fff,0x00004ffc,0x80017ff4,0x3ffe2ffd,
    0x45ffd804,0x7c404ffe,0x9ff704ff,0x881fffd4,0xffb86ffd,0xdffd103f,
    0x207fff30,0x882ffffb,0x3f204fff,0x3ea002ff,0x3ffe204f,0x0bfff204,
    0x6409fff1,0x7fc42fff,0x3fff204f,0x027ffc42,0x4005fff9,0xfd805ff8,
    0xdffb00ff,0x7c2ffe41,0x7fd41dff,0x0bffee5f,0x23ffffd8,0x3602fffb,
    0x3ee3ffff,0x3ff602ff,0x3ffee3ff,0x3ffff602,0x80bffee3,0x003ffffd,
    0xf3005ff3,0x3ff207ff,0x7fff32ff,0xf337fdc0,0x3ff207ff,0x7fff32ff,
    0x0037fdc0,0x00001ffd,0x80017ff4,0x3fea1ffe,0x3ffee04f,0x81fffd41,
    0x700effd8,0xfffb89ff,0xfffb99ad,0xffffb01f,0xffff7539,0x37ffea03,
    0xffffda9a,0xdfff902f,0xfffd9337,0x3ffc800b,0x5f7ffe40,0x5fffec99,
    0x37dfff90,0x0bfffd93,0x26fbfff2,0x05fffec9,0x337dfff9,0x80bfffd9,
    0x2ffdb998,0xcffff880,0x0effeb9a,0x7dc2ffe4,0xffecefff,0x3ffe20ff,
    0xfeba8acf,0x3e24ffff,0xba8acfff,0x24fffffe,0x8acffff8,0xfffffeba,
    0x33fffe24,0xfffeba8a,0x3ffe24ff,0xfeba8acf,0x2004ffff,0x03711efe,
    0x957dfffd,0x45ffbffd,0x9acefffc,0x743fffca,0xecabefff,0x322ffdff,
    0xa9acefff,0x2603fffc,0x005ffca9,0x017ff400,0x1fffb350,0x9bdfffd8,
    0x03fffea9,0x539ffffb,0x403ffff7,0xffa84ffb,0xefffffff,0x3fff6201,
    0x0effffff,0x7ffffdc0,0x2ffcbfff,0x3ffffee0,0x805fffff,0x0ffffeeb,
    0xfffffb80,0x405fffff,0xfffffffb,0x7dc05fff,0xffffffff,0x7ffdc05f,
    0x5fffffff,0xfffffc80,0x3ffa2006,0x0fffffff,0xfb05ffc8,0xffffffff,
    0xfffff503,0xf35dffff,0xffffa8df,0x9aefffff,0x7ffd46ff,0xaeffffff,
    0x7fd46ff9,0xefffffff,0x7d46ff9a,0xffffffff,0x006ff9ae,0x3fffffee,
    0xffffe982,0xffb9ffff,0x7fffff42,0x982fffff,0xfffffffe,0x742ffb9f,
    0xffffffff,0x3fe602ff,0x0001ffff,0x8017ff40,0x84fffff9,0xffffffc8,
    0x6c03ffff,0xffffffff,0x7fdc02ef,0xffffb304,0x754009ff,0x04efffff,
    0x3fffb260,0x805ff93e,0xffffffd8,0xfffb002e,0x6c4005df,0x2effffff,
    0xffffb100,0x22005dff,0xeffffffd,0xfffb1002,0x2005dfff,0x00beffeb,
    0xffffec80,0xbff901ce,0x7ffffdc0,0x3fa601de,0x7c4fffff,0x7ff4c1ff,
    0x7fc4ffff,0x7fff4c1f,0x7ffc4fff,0x7ffff4c1,0x0fffc4ff,0x3fffffa6,
    0x00fffc4f,0xdffffd88,0xffffb100,0x0bfee3bf,0x3fffffaa,0x3f6201df,
    0xf71dffff,0xfffd505f,0x9803bfff,0x001deffe,0x02ffe800,0x1bffff70,
    0x7ffff4c0,0xd5000dff,0x09ffffff,0x2013fee0,0x20000aa8,0x00009a98,
    0x8000054c,0x40009aa8,0x00019a98,0x0004d544,0x00135510,0x004d5440,
    0x01355100,0x10000000,0x00000153,0x88001551,0x200009a9,0x00009a98,
    0x00026a62,0x0009a988,0x0026a620,0x026a2000,0x0001a980,0x0002aa62,
    0x880006a6,0x00000aa9,0x33100000,0x2aea2001,0x0d54c001,0x15531000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x97000000,0x0deea839,
    0x00037baa,0x55101100,0x13326000,0x951cca80,0x37f6e619,0xeed8800b,
    0x807bba22,0x019900cc,0xd307774c,0x2e6001bd,0x9930bdfd,0x437bb605,
    0x32a0eeec,0x1ccb801c,0x40000000,0xdd901ccb,0xa84eec89,0x220001cc,
    0x98000ccc,0x333224cc,0xeea80000,0x6644002e,0xcc98000c,0x40000004,
    0x00003ccb,0xc8866644,0x3cc8803c,0x2f36ea20,0x5ddd7000,0xd913bb20,
    0xddb0007d,0x5cb32a0b,0xe85881cc,0x5ffd82ff,0x5005fff1,0xbffb3009,
    0x4c13f217,0x3e2effec,0xfff002ff,0x3ea7ff21,0x0effffff,0xd877fdc0,
    0x27ec04ff,0x7e403fdc,0x00bffa5f,0x3fffffea,0x83ffa9ff,0xff12fff9,
    0x03ffd87f,0x2002ffe8,0x00effeca,0x40bffa00,0xff52fff8,0x07ff901f,
    0x0fffc400,0x33ffd400,0x00001fff,0x1000dffd,0x50003fff,0x76dc0fff,
    0x0002ceff,0x0000dffb,0xf30fff98,0xbff300df,0x3ffffee0,0x7fc00cff,
    0x3ffe205f,0x001dff52,0x901fffb8,0x0bff67ff,0x5ffd0ff7,0xf95ffd10,
    0x4fd8807f,0xffffff80,0xfa82ffef,0x321fffff,0xffa805ff,0x3ff3ff26,
    0x5fffdcdf,0xfacffd80,0xdffa805f,0x004ffcaa,0x9ff97ffd,0xdffff100,
    0xffbfffd9,0x649ffb07,0x3ffd85ff,0x002ffe80,0x0ffffff9,0x02ffe800,
    0x3fa7ffe6,0x07ff901f,0x0fffc400,0x33ffd400,0x80001fff,0x8000fffa,
    0x8001fff8,0xfea87ffa,0xefffffff,0x37fec001,0x3fe60000,0x00dff30f,
    0xfe88bff3,0xffffffff,0x1dff701e,0xf9fffa80,0xfe8001ff,0x4fff203f,
    0x3fe22ffd,0x302fdb87,0x00bfffff,0xfa809ff7,0xffffc99f,0xfffff886,
    0x3ffe60fe,0x91ffec00,0xd30bffff,0xfe8809ff,0x9000efff,0x0bffffff,
    0x7ffffc40,0x1bffd005,0x3ffffe88,0xff137fc4,0x07ffb01f,0x5005ffd0,
    0x0ddfffff,0x02ffe800,0x17ffffdc,0x0007ff90,0x000fffc4,0xff33ffd4,
    0xfe80001f,0xff10001f,0xff50003f,0xdffffa8f,0x1ffffecc,0x01bff600,
    0x1fff3000,0x2601bfe6,0x7ffec5ff,0x3fff660c,0x001ffe80,0x05fffff9,
    0x80bff500,0x5fb73ffc,0xfb83ffc4,0x3bffee00,0x04ffb800,0x0dcc1654,
    0x402fff98,0x3e202ffe,0x3fff20ff,0x0bffe205,0x03ffff30,0x2deeda80,
    0xefffa800,0x05ffc800,0x321ffff4,0x0bfee0ff,0x7401ffec,0xffc802ff,
    0x3a00001e,0xffd802ff,0x1ffe404f,0x3fff1000,0x0fff5000,0xfa8000f9,
    0x3e20003f,0xfa8001ff,0x3bffe27f,0x0effe981,0x80000000,0xff30fff9,
    0x4bff300d,0x3203fffa,0x17fd44ff,0x13fff600,0x0077f400,0x1fa8fff2,
    0x3e41ffe2,0x8004ccc0,0x00004ffb,0x201bfee0,0x3ea05ffb,0x07ffe45f,
    0x2017ff20,0x00000998,0x04cc4000,0x401fff80,0x4c43fffa,0xfb004c40,
    0x5ffd007f,0x009ffb00,0x02ffe800,0xf9003330,0x7c40007f,0xfa8001ff,
    0x0007d87f,0x20000cc4,0x8001fff8,0x3ff27ffa,0x3ffe200f,0x00000004,
    0xf30fff98,0xbff300df,0x2202fff4,0x06621fff,0x00666200,0xc8009980,
    0xf11f23ff,0x009f70ff,0x13fee000,0xffc80000,0x0fff8804,0xfc85ffb0,
    0x6ff8805f,0x00000000,0x7cc00000,0x7ffd005f,0x7fec0000,0x02ffe803,
    0x0001ffe8,0x0017ff40,0x01ffe400,0x03fff100,0xf0fff500,0x0000000b,
    0x007ffe20,0xff9ffea0,0x6ffb803f,0x00133100,0x0fff9800,0xf300dff3,
    0x03ffe2bf,0x000ffee0,0x00000000,0x9f73ffc8,0x33fff326,0x2203d8cc,
    0x1bcefedb,0x9dffb970,0x00e65479,0xffc8e65c,0x07ffb003,0xff90fff1,
    0x43ffe007,0xcb801cca,0x0039951c,0x65403997,0x201bdefd,0xf9004ffa,
    0x00732a7f,0x7fec732e,0x02ffe803,0x4001ffe8,0x3a2ceeb9,0xb95102ff,
    0x20179dfd,0xfb713ffc,0x7fc4059b,0xffa8001f,0x51007ec7,0x15bdffb9,
    0xcefedb98,0x07ffe201,0x4dffea00,0xf9800fff,0x9ff7007f,0xff980000,
    0x00dff30f,0x3fe6bff3,0x4bff5007,0x99502cca,0x99999999,0x65459999,
    0xbdd9510c,0x27ff9017,0x3fffea4c,0x5401ffff,0xffffffff,0xffffd83f,
    0x3ff66fff,0x92ffe803,0x3ea007ff,0x84ffb86f,0xfd002ffc,0x00fff63f,
    0x7fecbffa,0x82ffe803,0xffffffd8,0x7ff904ff,0x6cffee00,0xffe803ff,
    0xd007ffb2,0x332a05ff,0x03ccdfff,0x3fffffea,0x82ffe8ef,0xffffffea,
    0xffc83fff,0xffffffab,0xfff880df,0xfffa8001,0x2a01feb8,0xffffffff,
    0xffff70ef,0x220bffff,0xa8001fff,0x099517ff,0x401ffe60,0x00003ffc,
    0xf987ffcc,0x5ff9806f,0x2600dff7,0x13fee7ff,0x7fffffe4,0xffffffff,
    0x3a23ff24,0x2fffffff,0xe981ffe4,0x0eeefffe,0x37bffea0,0x45ffffec,
    0xeefffeec,0x200fff64,0x7ff92ffe,0x20fffc00,0xffc81ffe,0x25ffb001,
    0xfe803ffd,0x007ffb2f,0xff985ffd,0xfffddeff,0x17fec0ef,0xfb3ffb80,
    0x5ffd007f,0x3a00fff6,0xfff902ff,0x20dfffff,0xeceffffb,0x42ffeeff,
    0xddfffffc,0x643ffffe,0xcdfffeff,0x440efffe,0xa8001fff,0x00ceffff,
    0x33bffff6,0xfdffffed,0xffeddeff,0x1fff884f,0x07ffa800,0x017fee00,
    0x00017fec,0x4c3ffe60,0xffa807ff,0x200bff55,0xff70fff9,0x3ffff209,
    0xfeffffff,0x2bff23ff,0xfffeffff,0x0fff22ff,0x400fff10,0xfc884ffe,
    0x4ffb80ff,0xd007ffb0,0x0fff25ff,0x264ffc80,0x3ff906ff,0x6c7ffa00,
    0xffe803ff,0xd007ffb2,0xeffe85ff,0x45fffa81,0xf7003ffd,0x00fff67f,
    0x7fecbffa,0x02ffe803,0xddfffdd7,0xbfff10bd,0xffffe981,0x033ffe62,
    0xf91bffa6,0xf981bfff,0x7ffc45ff,0xfffa8001,0x2fff9800,0xffffff30,
    0x85ffd305,0x8001fff8,0x10007ffa,0xf1007fff,0x800001ff,0xff30fff9,
    0x2bff500f,0xf5007ff9,0x13fee3ff,0xbffd1000,0xbeffffc8,0xc9bffea0,
    0x7fc403ff,0x0dff1007,0xfb83ffe8,0x07ffb04f,0x3f25ffd0,0x3fe6003f,
    0x640fff26,0xfff002ff,0x200fff61,0x7ffb2ffe,0x645ffd00,0x3e600eff,
    0x13ff22ff,0xfd9ffe40,0x2ffe803f,0xff007ffb,0x3ffd005f,0x205ffd80,
    0x322ffff8,0x7fc406ff,0x17fff21f,0x221fff98,0xa8001fff,0xffb007ff,
    0xffffb805,0x83ffe201,0x8001fff8,0x88007ffa,0x4400effe,0x00005ffe,
    0xf30fff98,0xbff500ff,0x2007ffe2,0xff71fffd,0xffe80009,0x04fffc86,
    0x7e47ffea,0x3ffc403f,0x406ff980,0xffb81ac9,0x007ffb04,0x3ff25ffd,
    0x8fff4003,0xff900ffe,0x4dff1007,0xfe803ffd,0x007ffb2f,0x3fe25ffd,
    0x6ffc802f,0x74017fee,0x07ffb3ff,0x3f25ffd0,0x2fff803f,0x401ffe80,
    0x7dc01fff,0x07ff62ff,0xfc87ffa0,0x7fe400ff,0x007ffe25,0x201ffea0,
    0xf9807ff8,0xffb803ff,0x007ffe24,0x001ffea0,0x803fffd1,0x000fffe8,
    0x0fff9800,0xb801fff3,0x1bffa5ff,0x25ffff30,0x20004ffb,0xfc80effd,
    0x7ffc00ff,0x8807ff92,0xff1007ff,0x7dc0009f,0x07ffb04f,0x3f25ffd0,
    0x7fdc003f,0x3205ff9b,0xffb806ff,0x200fff65,0x7ffb2ffe,0x265ffd00,
    0xff1006ff,0x07ffe21f,0x367fff30,0xffe803ff,0x9809ff72,0xfe802fff,
    0x1bfe201f,0x0417ffc0,0x322ffd80,0xff9805ff,0x007ffe27,0x001ffea0,
    0x3fff3001,0x44dff100,0xa8001fff,0x3a2007ff,0x74401fff,0x00002fff,
    0x261fff30,0x7ec01fff,0x37ffe65f,0xfffffa80,0x0009ff71,0x6407fff2,
    0xffe805ff,0x8807ff92,0x3f6007ff,0x800adfff,0x99dffc98,0x200fff60,
    0x7ff92ffe,0xbeff8800,0x3ff202ff,0x1fff402f,0xfd007ffb,0x00fff65f,
    0x7fdcbffa,0x87ffe005,0x7ec05ffc,0x07ffb3ff,0x3ea5ffd0,0x7ffec06f,
    0x01ffe802,0x74017fea,0x544002ff,0x3f22fffc,0x1fff003f,0x0007ffe2,
    0x0001ffea,0x07ffdb98,0xff89ffe0,0xffa8001f,0xfffd1007,0xfffe8803,
    0x26000001,0xfff30fff,0x2fffcc0d,0x2f7ffff2,0xffecffec,0x0009ff71,
    0x6405fff7,0xffd804ff,0x8807ff92,0x3a2007ff,0xbeffffff,0xfffffb01,
    0x1ffecbff,0xfc97ff40,0xffd8003f,0x7fe407ff,0xdffb01ef,0xe803ffd8,
    0x07ffb2ff,0x3f25ffd0,0x3ffa004f,0x037ffe22,0x27ffffb1,0xfe803ffd,
    0x07fff32f,0x00bffff2,0xfb807ffa,0x5ffb004f,0x3fb6ea20,0x22ffffff,
    0xfd002ffc,0x07ffe23f,0x01ffee00,0x7ff6dd40,0xffffffff,0xffffffff,
    0x3fff10ff,0x0fff7000,0x007fff20,0x0007fff6,0x1fff3000,0x213fffe6,
    0xc85ffff8,0xffffffff,0x3ee1ffd3,0x7fd4004f,0x1ffe403f,0xfc9ffec0,
    0x3ffc403f,0x7fffe400,0x6c0effff,0x5fffffff,0x3a00fff6,0x07ff92ff,
    0x9ffff500,0xfffffc80,0xfffeb9ac,0x401ffec2,0x7ffb2ffe,0x365ffd00,
    0x3f6003ff,0x7fffd43f,0xfefffece,0x007ffb3f,0x7fec5ffd,0xfffcabef,
    0xfe802ffd,0x0fff601f,0x2217fe40,0xfffffffc,0x322fffef,0xffd001ff,
    0x007ffe25,0x801bff20,0xffffffd8,0xfffffeff,0xffffffff,0xfff12fff,
    0xdff90003,0x03fff100,0x005fff70,0xfff30000,0x3ffffe61,0xffffebcf,
    0xfffb305f,0x87ffc5bf,0x26004ffb,0xfc804fff,0x3ffd803f,0xf8807ff9,
    0xb510007f,0x5fffffff,0x3609ff70,0xffe803ff,0x0007ff92,0x9007fffe,
    0xffffd9ff,0xfb05ffff,0x5ffd007f,0x3a00fff6,0x07ffb2ff,0x4c1ffec0,
    0xefffffff,0xffb3ffd9,0x45ffd007,0xffffffe8,0x02ffb9ff,0x3201ffe8,
    0xff9003ff,0x7ffffc45,0xffb1acef,0x800ffe45,0x3ffe1ffe,0x6ffc8002,
    0xffffd100,0xff1157bd,0x9999999f,0x43999999,0xc8002fff,0xffa806ff,
    0x07ffb005,0x3e600000,0x9fff30ff,0x5fffffff,0x03300bff,0x7fdcfff1,
    0xbfff1004,0x00fff200,0x7fe4fff6,0x03ffc403,0xffeb9800,0x04ffb87f,
    0xff007ffb,0x00fff25f,0x4037fe40,0xfff93ffc,0x3f6017df,0x2fff803f,
    0xff007ffb,0x013ff25f,0x7102ffe8,0x3617bfd9,0x07ffb2ff,0xc885fff0,
    0x71dffffe,0xffd005ff,0x027fd403,0x3fa2ffd8,0x3fa01bff,0x00bff22f,
    0xfff07ffc,0xbffb0007,0x2fbffe00,0x00fff101,0x007fff00,0x900bffb0,
    0x3fe007ff,0x5013001f,0x7fd40197,0x32dff30f,0xff2effff,0x7fd4000b,
    0x2013fee5,0x000effe8,0xfb007ff9,0x00fff27f,0x0000fff1,0xb83fff70,
    0x7ff904ff,0x92fff880,0x2e0007ff,0xffc803ff,0x640054c3,0x7fc403ff,
    0x807ff92f,0xff52fff8,0x0fffc00b,0x25ffb000,0x7c403ffc,0x06a202ff,
    0x7f400ff2,0x17fe601f,0xf997ff40,0xfff801ff,0x200fff22,0x7fec7ff8,
    0x3fff8005,0x01fffa80,0x0007ffcc,0x0017ff60,0x3600fffe,0xff8802ff,
    0x1fff1007,0xf500fff4,0x237fccff,0x006000a9,0xff71ffe4,0x1fffd009,
    0x01ffe400,0xffc9ffec,0x03ffc403,0xe803fdb8,0x2ffdc3ff,0x4c04ffc8,
    0x7ff92fff,0x03ffa000,0x000fff20,0x4c04ffc8,0x9ff92fff,0x32fff980,
    0xf5001fff,0x000d44ff,0x3ff23ffd,0x17ffcc04,0x002fd800,0xff803ffd,
    0x7ffc400f,0x300bff72,0x7fe45fff,0x46ffb806,0x2001fffb,0xc801fffb,
    0xffb805ff,0xeffa802f,0x007ffee0,0x801fffb8,0xff001ccb,0xdff7003f,
    0x2e02ffd8,0x1bfe67ff,0x02ffe800,0xf70fffc4,0xfffd809f,0x1ffe4001,
    0xfc9ffec0,0x0fff803f,0x407ffb80,0x7d41fff8,0x0dff705f,0xf92fffd8,
    0xff50007f,0x0fff2009,0x06ffb800,0xfb97ffec,0x7ffec06f,0x2017ffa2,
    0x7ffc5ffe,0x73ffdc00,0xffd80dff,0x3fd0002f,0x007ffa00,0xfc809ffd,
    0x0dff92ff,0x645fffb0,0x7fc01fff,0x7fffcc2f,0x7ffe8800,0x80bffb00,
    0x00effff9,0x3e62fff4,0xe8800eff,0x000007ff,0x3a017ffa,0x2ffe44ff,
    0x7ccbffd0,0x3f20006f,0x2ffe405f,0xfc813fee,0xfc8002ff,0x3ffd803f,
    0xff007ff9,0xfff3003f,0x437fdc07,0xf980fffa,0xfff903ff,0x00fff25f,
    0x003ffd10,0x8000fff2,0xf903fff9,0x3fe65fff,0xffff903f,0x81fffcc5,
    0x740fffd8,0x3fe204ff,0x0fffe64f,0x017fffe4,0xd003ff80,0xff9803ff,
    0xffff703f,0x80bffee5,0x323ffffd,0xd881ffff,0xfff906ff,0x3fea015d,
    0xff7002ff,0x3ffa201f,0x3f205fff,0xfffc82ff,0xfff500ae,0x4000005f,
    0x3203fffb,0x7fd41fff,0x7ffe40cf,0x001bfe62,0x701fffa8,0xffb83fff,
    0x07fff704,0x00fff200,0x7fe4fff6,0xdfffe803,0x3fff201e,0xffca9ace,
    0xffff983f,0x77fff45d,0xfdffecab,0x007ff92f,0x0bfffb9b,0x001ffe40,
    0x2fbfffa0,0xffdffeca,0x2fbfffa2,0xffdffeca,0x5efffe42,0x1fffeb99,
    0x9bdfffb8,0x85fffdb8,0xcabefffe,0x02ffdffe,0x225dfb00,0x01ffe82a,
    0x9adfffa8,0x2fffffda,0x159ffff1,0xfffffd75,0x7ffffe49,0xfffeb9ac,
    0xffffd101,0xfffdb9df,0x7c4009ff,0xdb89ceff,0xfff9bfff,0xfffc9ace,
    0xfffd104f,0xffdb9dff,0x64009fff,0x3f6002cc,0xea98adff,0xffb03fff,
    0xffffbbff,0x006ff98b,0x56fffec0,0x83fffdb9,0xff984ffb,0xeedcccff,
    0x90eeeeee,0xffb007ff,0x200fff27,0x02fffffb,0x7ffffff4,0x3602ffff,
    0x74c7ffff,0xffffffff,0xff92ffb9,0xfffff007,0x7fe4001d,0x7f4c0003,
    0x9fffffff,0x3fa62ffb,0x9fffffff,0xffb82ffb,0xffffffff,0x3ffff601,
    0x05ffffff,0xffffffd3,0x05ff73ff,0x3fffea00,0x1ffe84ff,0xfffff700,
    0x5ff97fff,0x7fffffd4,0xff9aefff,0x3f6bff26,0x1effffff,0x7fffec40,
    0xffffffff,0xfffa8003,0x1effffff,0x3fffffa2,0x4404ffff,0xfffffffd,
    0x003fffff,0x10027ffc,0xfffffffb,0x7cc09fff,0xffffffff,0x006ff985,
    0x7ffff440,0x703fffff,0xfff309ff,0xffffffff,0x321fffff,0xffd803ff,
    0x2007ff93,0x804fffeb,0xffffffea,0x7fec401d,0x7fec41ff,0xff71dfff,
    0x200fff25,0x000efffe,0x0001ffe4,0x7ffffec4,0x885ff71d,0x1dfffffd,
    0x36605ff7,0x0bdfffff,0xffffea80,0x6c404dff,0x71dfffff,0x640005ff,
    0xe81dffff,0x326001ff,0xf93efffe,0xfffe985f,0x7ffc4fff,0x3f23ff91,
    0x000dffff,0x3fffff6a,0x0001cfff,0x3fffffa6,0xffd9103e,0x4003bfff,
    0xffffffda,0xf8001cff,0xea8004ff,0x1effffff,0xffffc880,0xdff304ef,
    0x3fee0000,0x201dffff,0xff984ffb,0xffffffff,0x90ffffff,0xffb007ff,
    0x000fff27,0x98800131,0x310000aa,0x20035300,0xa8803ffc,0x3310000b,
    0xa9800001,0x06a60001,0x006a2000,0x01bba980,0x00035300,0xe8035000,
    0x530001ff,0x35310001,0x2a600001,0x4cc40001,0x000019aa,0x2000d4c4,
    0x00009a98,0x066aa662,0x09fff000,0x4d54c400,0x13530000,0x00013300,
    0x009aa980,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00037bb6,0x00019991,0x2f76c000,0x85ddd700,0x32a04cc9,
    0x8000004c,0x819900cc,0x3622eed8,0x3b2002ee,0x000000ee,0x2a880880,
    0x0000e654,0x00005dd9,0x3332e000,0xcccccccc,0xcccccccc,0xcccc881c,
    0xbccccccc,0x3326000a,0x665c0004,0x66644002,0x00666442,0x002664c0,
    0x3bb62000,0x5c7bb622,0x2775c5ee,0x33260000,0x99100004,0x99999999,
    0x95001579,0x75c00039,0x665401ee,0xfffc8001,0x7fcc005f,0x0000000f,
    0x2003fff7,0xfa85fff8,0x1fff207f,0xffffff30,0x3a0bffff,0x507fb84f,
    0x3ff21fff,0x7ffec005,0xffff5000,0x07ffffff,0x42b7ff66,0x1ffe44fc,
    0x07ffd000,0xf3000000,0xffffffff,0xffffffff,0xf305ffff,0xffffffff,
    0x019fffff,0x000fff70,0x000fffa8,0xf103ffee,0xf50003ff,0xfffc80ff,
    0x2fffffff,0x361fff50,0x3ffa24ff,0x501fff33,0xffffffff,0x7ffa87ff,
    0xfff30000,0xffffffff,0x6c019fff,0x320003ff,0x7ec01fff,0x7fd4003f,
    0x2003ffce,0x0000fff9,0x07ffd000,0xa837fdc0,0x3ff207ff,0x7fffcc07,
    0x05ffffff,0xf955bff7,0x6ffe407f,0xd8006ffa,0xf5000fff,0xffffffff,
    0x3fffe07f,0x51ffefff,0x555bffb5,0xffd00555,0x00000007,0xfffffff9,
    0xffffffff,0x05ffffff,0xfffffff3,0xffffffff,0x7ffb809f,0x4ffe8000,
    0x09fff100,0x0003fff1,0xfc80fff5,0xffffffff,0x37ff202f,0xff986ffa,
    0x501ffe9f,0xffffffff,0x7ffa87ff,0xfff30000,0xffffffff,0x209fffff,
    0x20003ffd,0x6c01fffc,0x3e2003ff,0x05ffd1ff,0x003ffe60,0x3fea0000,
    0x07ffc005,0x3207ffa8,0x664407ff,0xcccccccc,0x3ffff602,0xffe805ff,
    0xd8000fff,0x93000fff,0x99999999,0x33df5059,0x74bffff9,0xffffffff,
    0xfec807ff,0x40000003,0xfaacfff8,0xaaaaadff,0x0aaaaaaa,0xaabfff98,
    0xfecaaaaa,0x3ee05fff,0xf980007f,0xffc801ff,0x1fff880f,0x07ffa800,
    0x66666654,0x7401cccc,0x700fffff,0x407fffff,0xccccccc9,0x7fd42ccc,
    0xff300007,0x5555557f,0xbffffd95,0x0007ffb0,0x200fffe4,0x3a003ffd,
    0x3ffe64ff,0x0fff9801,0xfe800000,0x3fee000e,0x01ffea02,0x000001ba,
    0x02deeda8,0x03ffff10,0x00666200,0x2ca80000,0x7ff41b98,0xffffffff,
    0x007f5007,0xffc80000,0x001fff47,0x00fff980,0x09ffff50,0x0001ffee,
    0x2202ffec,0x77543fff,0xeeeeefff,0xeeeeeeee,0x01eefffe,0x7fc40000,
    0x7fe401ff,0x2000005f,0x00007ffa,0x2001fff3,0x6c4ffffa,0x220003ff,
    0xffd80199,0x03331003,0xf3001331,0x555557ff,0x00013355,0x220004cc,
    0x3ffd4009,0x00017e20,0x88000000,0x00000099,0x00000000,0x001ffe40,
    0x00007f20,0x3fff8800,0x0001fff4,0x000fff98,0x203fffa2,0x00307ffb,
    0x202fff88,0xffb86ffd,0xffffffff,0xffffffff,0x01ffffff,0x99880000,
    0x00333000,0x7ffa8000,0xfff30000,0x7ff44001,0x00fff60f,0xffd80000,
    0x00000003,0xfffffff3,0xbfffffff,0x00000005,0x80fff500,0xca8803fb,
    0x00bcefed,0x00000000,0xcdeeca88,0x3f72a000,0x00001bde,0x0007ff90,
    0x00002fcc,0x03fff200,0x00007ffd,0x0003ffe6,0xf70bfff3,0x000b90ff,
    0x3e60dff9,0xfeea82ff,0xeeeeeeff,0xeeeeeeee,0x201eefff,0x1bdeedb9,
    0x80000000,0xcb801cca,0x00fff51c,0x03ffe600,0x4bfff300,0x98003ffd,
    0x01bdeedb,0xccb8fff6,0x01665c01,0x7fcc732a,0xffffffff,0x06ffffff,
    0x99999995,0x59999999,0xedb86654,0x81ffea1c,0x75400efb,0xffffffff,
    0x2cca803f,0x2a219950,0x400bdeec,0xffffffe8,0x7ec404ff,0x4fffffff,
    0x80599500,0xd9713ffc,0x32f4037d,0x7f654399,0xf88001bd,0x3ffe84ff,
    0xfff30000,0xfff90001,0xfd8fff70,0xfff88005,0x405ffd83,0x8001fff8,
    0xfc807ffa,0x3fffffff,0x40599500,0x9db70cca,0x401ffec3,0xfff52ffe,
    0x3fe60000,0xffc8000f,0x000fff67,0xfffffff9,0x8fff607f,0x7fc04ffc,
    0x8ffec06f,0xccccfff9,0xffeccccc,0xfffc85ff,0xffffffff,0x3ff24fff,
    0x1fffffb8,0x2cc0fff5,0x7ffffe40,0x3ffffedd,0xc827fdc0,0xfffe88ff,
    0xf302ffff,0xffbbdfff,0x3fe609ff,0xfffddeff,0x7fdc00ef,0x4dffe404,
    0xfffffffe,0x57fdc183,0xffffffe8,0x7fdc003f,0x03ffe80f,0x1fff3000,
    0x3fff3000,0xfd17ffb8,0x3ee0007f,0x3ffe60ff,0x0fffc401,0x03ffd400,
    0xbbdfffd1,0x801dfffd,0x3f203ffc,0xfffffb8f,0xd007ffb1,0x1ffea5ff,
    0x7ffcc000,0xfff98000,0x2007ffb1,0xddefffe8,0x6c0efffe,0x1bfe63ff,
    0x00ffff98,0x7fccfff1,0xffd3000f,0xffffc87f,0xfeffffff,0x2bff23ff,
    0x2a6fffff,0x4c0007ff,0xe980cfff,0x7fdc06ff,0xff5ff904,0xfffffdff,
    0x83fffd05,0xe82fffc8,0xffa81eff,0x27fdc05f,0x3ffbff20,0xffffeeef,
    0x75ffdc01,0xffffefff,0xfff1004f,0x00fffa09,0x07ffcc00,0x42fff800,
    0xffe9fffb,0x7ff40002,0x2013ffa3,0x8001fff8,0x3f607ffa,0xfff981ef,
    0x01ffe404,0xffff5ff9,0x01ffecdf,0xffa97ff4,0xff300007,0x3fe0001f,
    0x007ffb2f,0x2607bff6,0x7fec4fff,0xb80fffc3,0xf502ffff,0x07ffcc9f,
    0x0bfff100,0x17ffa200,0x57bffff9,0x03ffd47b,0x01bff200,0x5c03fff1,
    0xfff904ff,0x7fd417df,0x07ffdc6f,0xfc8bffd0,0x3fe600ef,0x13fee02f,
    0x1bffff90,0x406ffe98,0x0beffffb,0x003fffa6,0x7403ffee,0x300003ff,
    0x20001fff,0x7fdc3ffe,0x0001ffff,0xfa8fffa8,0xff8800ff,0x999999af,
    0xfb999999,0x1fff507f,0x00fffc40,0x7e407ff9,0x3dabdfff,0x3a00fff6,
    0x0fff52ff,0x3ffe6000,0x7ffd0000,0x2a00fff6,0x3e200fff,0x0fff61ff,
    0x3f607ff9,0xff904fff,0x007ffcc3,0x001fff20,0x7e437ff4,0x7fd405ff,
    0x7fec0007,0x01ffe801,0x7e413fee,0x3fea04ff,0x00fff61f,0x3e21fff3,
    0xffc802ff,0x013fee06,0x4c0bfff9,0x3ee00fff,0x3fe606ff,0x4fff802f,
    0x3bbbffa0,0xeeeeeeee,0x1fff302e,0x17ff6000,0x01dffff7,0x67fec000,
    0xf1003ffe,0xffffffff,0xffffffff,0x3ffa0fff,0x05ffb802,0xfc80fff2,
    0x7fec05ff,0x52ffe803,0x774c0fff,0x3ffe601e,0xbffb0000,0xeec8fff6,
    0x200bffa4,0x3ff65ffb,0xf82ffd43,0xff06ffcf,0x00fff98f,0x00fffd40,
    0x203bff60,0x5400fffc,0x100007ff,0x80bff600,0xff904ffb,0x2fff801f,
    0x04c01ffe,0x4401bfe6,0xff700fff,0x0fffc809,0x700fff40,0xfd803fff,
    0x7ffdc03f,0x3ffffa00,0xffffffff,0x7fffc3ff,0xffffffff,0x1bff201f,
    0x000bfff7,0xfa999988,0x999fffff,0xfff88099,0xffffffff,0xffffffff,
    0x007ff987,0x7e40fff1,0x3fff203f,0x01ffec00,0xffa97ff4,0x07ffea07,
    0x3ffffffe,0x01ffffff,0x7fedbff2,0x7cdbff63,0xfff1007f,0x3e21ffec,
    0xdaff987f,0x2ffcc0ff,0x0003ffe6,0x4003fff3,0xf901fffc,0xfff500df,
    0x51000000,0x5c05fff9,0xbff904ff,0x225ffd00,0x2e0006ff,0x3fe005ff,
    0x09ff701f,0xd805ffc8,0x3fee02ff,0x04ffc807,0x3a027ff4,0xffffffff,
    0x43ffffff,0xffffffff,0x201fffff,0x3f626ffc,0xfe80007f,0xffffffff,
    0x5fffffff,0xffffff88,0xffffffff,0xa87fffff,0x3fe006ff,0x07ff900f,
    0x6c037fe4,0xffe803ff,0x540fff52,0xfff81fff,0xffffffff,0x3ff201ff,
    0x7ec7ffb6,0x00dff56f,0xffd87ffc,0x641ffd83,0x42ffb8ff,0x7fcc2ffc,
    0x7fd4000f,0xfff7000f,0x02ffe405,0x0003ffd4,0xffdb7510,0x405fffff,
    0xff904ffb,0x25ffb009,0x20005ffa,0x3a004ffc,0x9ff702ff,0x804ffc80,
    0x3ee03ffc,0x4ffb806f,0x003ffea0,0x33339ffd,0x13333333,0xbfffbaa8,
    0x00aaaaaa,0x7f45bff6,0xe80007ff,0xffffffff,0xffffffff,0x01fff885,
    0xb87ffa80,0xffffffff,0xffffffff,0x407ff901,0xfd805ffc,0x2ffe803f,
    0x74c0fff5,0xfbaa81ee,0xaaaaabff,0x5bff600a,0x3bb23ffd,0xffffff74,
    0xffffffff,0x0fff63ff,0xdfd13fee,0xffd13fe6,0x00fff981,0x8037fec0,
    0x6403fffa,0xffa804ff,0xfc880007,0xefffffff,0x3ee02fff,0x07ff904f,
    0x3ee7ffb0,0x3f60004f,0x3ff6003f,0x809ff703,0xfc803ffc,0x17fee03f,
    0xe813fee0,0xaaaaaeff,0x03fffaaa,0x1fff3000,0x57ffa000,0x007fffff,
    0xaaaaaa80,0xaaadffda,0xff881aaa,0xffa8001f,0xfffffc87,0xffffffff,
    0xff902fff,0x027fe407,0x7401ffec,0x0fff52ff,0x3ffe6000,0xbffd0000,
    0xf900fff6,0xffffffff,0x5fffffff,0x3e20fff6,0xf93fe26f,0x217fe26f,
    0x2000fff9,0x9803fffc,0xfc804fff,0x7ffa803f,0x7ffc4000,0xb1acefff,
    0x7fdc05ff,0x007ff904,0x3fee7ffb,0x3ff60005,0x0fff6003,0x32027fdc,
    0xffc803ff,0x017fee03,0x7d413fee,0xffffffff,0x03ffffff,0x1fff3000,
    0x53ffe000,0x007ffcef,0x1ffe4000,0x07ffe200,0x21ffea00,0xcccceffc,
    0xcccccccc,0x07ff901c,0x6c01ffe4,0xffe803ff,0x000fff52,0x003ffe60,
    0xfda7ffc0,0x77fe403f,0xcccccccc,0xfb1ccccc,0x43ffa07f,0x3ff62ffa,
    0xf305ff70,0x333335ff,0xffff9553,0xbfff100d,0x00fff200,0x0001ffea,
    0x4037fffd,0x3ee02ffe,0x07ff904f,0x3ea7ffb0,0x3f20006f,0x3ffa004f,
    0x809ff702,0xfc803ffc,0x17fee03f,0x7413fee0,0xffffffff,0x3fffffff,
    0xfff30000,0xfff10001,0x1ffee3a5,0x26662000,0x9cffd999,0x88099999,
    0xa8001fff,0x5ffb87ff,0x7fe40000,0x00fff203,0x3e00fff6,0x0fff52ff,
    0x3ffe6000,0xfff88000,0xb807ffb2,0x6c0005ff,0x5ff703ff,0xffb83ff2,
    0xf301ffb2,0xffffffff,0xdfffffff,0xeffe8803,0x07ff9000,0x000fff50,
    0x400fffcc,0x3ee02fff,0x07ff904f,0x3e67ffb0,0x3997007f,0xf8017fea,
    0x9ff701ff,0x803ffc80,0x3ee03ffc,0x4ffb805f,0xcccfffa8,0xfccccccc,
    0x300003ff,0x70001fff,0xffb81fff,0xffe80007,0xffffffff,0x85ffffff,
    0x8001fff8,0xff987ffa,0x7e400007,0x0fff203f,0x100fff20,0x3fea5fff,
    0xff300007,0xff70001f,0x00fff61f,0x8000fff3,0xff303ffd,0xff31bfeb,
    0x7cc1bfe9,0xffffffff,0x03ffffff,0x001fffd0,0x5401ffe4,0x2e0007ff,
    0xff9805ff,0x13fee02f,0x6c01ffe4,0x3fff13ff,0x263ffd00,0xfa800fff,
    0x13fee07f,0x9007ff90,0x7fdc07ff,0x84ffb805,0x3a005ffe,0x300003ff,
    0x88001fff,0xffb85fff,0xffe80007,0xffffffff,0x85ffffff,0x8001fff8,
    0xff887ffa,0xcef9801f,0x407ff900,0xfc803ffc,0x7ffcc04f,0x000fff52,
    0x003ffe60,0x6cbfff10,0x7fc403ff,0xcef9801f,0x7c07ffb0,0xf84ff8ff,
    0x303ffaff,0xdddddfff,0x01559bdd,0x007fff60,0x5007ff90,0x64000fff,
    0xffd806ff,0x13fee02f,0x6c01ffe4,0x17ff63ff,0xfe8fff30,0x5ffe805f,
    0x9013fee0,0xff9007ff,0x02ffdc07,0x3e627fdc,0x3fa001ff,0xf300003f,
    0xfd8001ff,0x7ffb82ff,0xaaaa8000,0xadffdaaa,0x881aaaaa,0xa8001fff,
    0xdffb07ff,0x40dffd00,0x3f203ffc,0x6ffb803f,0xa97ffec0,0x300007ff,
    0xd8001fff,0x3ff62fff,0x06ffd803,0x3f66ffe8,0x33ff203f,0xeffd81ff,
    0xfff300ff,0xfc800001,0xfc8002ff,0x7ffa803f,0x3ffee000,0x3ffff602,
    0x413fee03,0xfd803ffc,0x0fffe23f,0x2627ff44,0xfb103fff,0x7fdc01ff,
    0x01ffe404,0xf701ffe4,0x9ff700bf,0x4006ffd8,0x00003ffe,0x2001fff3,
    0x705fffc8,0x00000fff,0x4003ffc8,0x8001fff8,0xff107ffa,0x7ffe409f,
    0x80fff202,0xf9803ffc,0xfff903ff,0x01ffea5f,0x07ffcc00,0x5fffc880,
    0x4401ffec,0x3f204fff,0x0fff62ff,0x07ffffa8,0x40dffff7,0x0000fff9,
    0x00fffee0,0x401ffe40,0x20007ffa,0x8acffff8,0xfffffeba,0x413fee04,
    0xfd803ffc,0x6fffdc3f,0x6fffda9b,0x37bfff90,0x03fffd73,0x6404ffb8,
    0xffc803ff,0x017fee03,0xff993fee,0x7ff4002f,0xff300003,0x2ea6201f,
    0x700fffff,0x00000fff,0x4003ffc8,0x8001fff8,0x3f207ffa,0xec99beff,
    0x7e405fff,0x0fff203f,0x5f7fff40,0xffdffeca,0x000fff52,0x403ffe60,
    0xffffba98,0x01ffec0f,0x9befffc8,0x45fffec9,0x7fc03ffd,0xfff105ff,
    0x7ffcc07f,0xff300000,0xddb999ff,0x21dddddd,0xfa803ffc,0xffffffff,
    0x24ffffff,0xfffffffa,0x6ff9aeff,0x6413fee0,0xffd803ff,0xfffffb83,
    0x200effff,0xfffffffb,0xfb801fff,0x1ffe404f,0x701ffe40,0xff700bff,
    0x0037fec9,0x7ffffff4,0xffffffff,0xffff986f,0xffffffff,0x200fffff,
    0xfffffffb,0xffffffff,0x0fff2004,0x03fff100,0x80fff500,0xfffffffb,
    0xfc805fff,0x0fff203f,0x7ffff4c0,0xffb9ffff,0xffffff52,0xffffffff,
    0xffff309f,0xffffffff,0xb01fffff,0x7dc007ff,0xffffffff,0x03ffd85f,
    0xd01fffec,0x7cc03fff,0x300000ff,0xffffffff,0xffffffff,0x200fff21,
    0xfffffffa,0xffffffff,0x7ffff4c4,0x0fffc4ff,0xf904ffb8,0x7ffb007f,
    0x3ffff660,0xfb3003ff,0x017bffff,0x9013fee0,0xff9007ff,0x02ffdc07,
    0xff9a7fdc,0xffe8002f,0xffffffff,0x986fffff,0xffffffff,0x3effffff,
    0xfffffb80,0xffffffff,0x3f2004ff,0x7fc4003f,0xffa8001f,0xfffd8807,
    0x9002efff,0x7fe407ff,0x3ff62003,0xff71dfff,0x3ffffea5,0xffffffff,
    0xfff984ff,0xffffffff,0x3603efff,0x6c4003ff,0x2effffff,0xa807ffb0,
    0x3f201fff,0x7ffcc07f,0xff300000,0xffffffff,0x21ffffff,0xfa803ffc,
    0xffffffff,0x04ffffff,0x00013531,0xfc827fdc,0x3ffd803f,0x000aa980,
    0x40006a20,0x7e404ffb,0x3ffc803f,0x2017fee0,0xdffb4ffb,0x3fffa000,
    0xffffffff,0xf986ffff,0xffffffff,0x2002deef,0xfffffffb,0xffffffff,
    0x0fff2004,0x03fff100,0x00fff500,0x0009aa88,0xf901ffe4,0x2a60007f,
    0xffff5001,0xffffffff,0xff309fff,0xffffffff,0xfb005bdd,0x5440007f,
    0x7fec009a,0x00000003,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x80deec80,
    0xccccccc8,0xcccccccc,0x200ccccc,0x50155008,0x2eec8399,0x664d7ba6,
    0xccca8004,0x00733224,0x400f3260,0x999911ed,0x79999999,0x99910015,
    0x99999999,0x39999999,0x66666664,0xcccccccc,0x2ea200cc,0x2600abcc,
    0x0003cccc,0xc893332a,0xc98000cc,0x0059954c,0x654f32a0,0x0039952c,
    0xccc98000,0xa6664002,0xccccccc8,0x02abcccc,0x000e6654,0x22399950,
    0xcccccccc,0x0abccccc,0xccccc880,0xcccccccc,0x0ccccccc,0x26666666,
    0x99999999,0x00133261,0x0004cca8,0x0001ccc8,0x6ffffb80,0xffffff88,
    0xffffffff,0x80ffffff,0x31beffc8,0x0fff20ff,0x7fd47ffd,0x800fff57,
    0x261ffffa,0xa8006fff,0xffd806ff,0xffffff32,0xffffffff,0x7ffc4019,
    0xffffffff,0x2fffffff,0x3ffffffe,0xffffffff,0xffc881ff,0x03ffffff,
    0x01fffff5,0x3ffffa00,0x003fff10,0x3f2fff50,0xff90003f,0x7e4fff2b,
    0x4000003f,0x4006fffc,0xfff37fff,0xffffffff,0x1019ffff,0x2000dfff,
    0x3e26fff8,0xffffffff,0xdfffffff,0x3fffe200,0xffffffff,0xffffffff,
    0xffffff30,0xffffffff,0x1ffea3ff,0x1fffa800,0x3ffe6000,0xffffff50,
    0x4c07ffff,0x44ffcfff,0xfffffff8,0xffffffff,0xc80fffff,0xfeffffff,
    0x87ff904f,0x3fea3ffe,0x400fff57,0x4c1ffffa,0x4004ffff,0x7dc06ffa,
    0xffff32ff,0xffffffff,0x2209ffff,0xffffffff,0xffffffff,0x3fffe2ff,
    0xffffffff,0x441fffff,0xffffffff,0x7d40efff,0x8003ffff,0x10fffff8,
    0x50003fff,0x0fff2fff,0xcaffe400,0x07ff93ff,0xfff80000,0x3fe001ff,
    0xfffff37f,0xffffffff,0xf701ffff,0xfb0009ff,0x7ffc41ff,0xffffffff,
    0x0effffff,0xffffff10,0xffffffff,0x21ffffff,0xfffffff9,0xffffffff,
    0x00fff51f,0x004fff80,0xfa97ff20,0xffffffff,0x5fff103f,0xaa88fffa,
    0xfeaaaaaa,0xaaaaaaef,0x717ff02a,0x203ffffd,0x77643ffc,0x7d57ba62,
    0xfff5007f,0xffff301d,0x7fd4003f,0x3fffea06,0x557fff32,0xfd975555,
    0xff10bfff,0x5555557f,0x55555555,0x5567ffc1,0xaaaaaaaa,0x7fec0aaa,
    0x3ff220bf,0x7fffd44f,0xffb8006f,0xfff10fff,0xfff50003,0x4000fff2,
    0x7ff95ffc,0x0000fff2,0xffdffa80,0x5fffe005,0xaaabfff9,0xffcaaaaa,
    0xfffd06ff,0x7ffd4003,0x4d7ffc43,0xa9999999,0x80ffffeb,0xaaaaaaa8,
    0xaaaeffea,0x3a62aaaa,0xeeeeeeee,0x0efffeee,0x8000fff5,0x20007ffc,
    0x33262fff,0xcccccccc,0x4cbffb01,0x36001fff,0xc88004ff,0x6402b884,
    0x2a0003ff,0xffa807ff,0xfff300ef,0x2a001dff,0xffc886ff,0xfff32fff,
    0x3ffa6001,0x0fffc44f,0x2fff8000,0xfffb8000,0x8bffea00,0x0ffffffa,
    0x7ffff400,0x03fff10f,0x32fff500,0xf90003ff,0x1ffe40bf,0xffb00000,
    0x2001fff1,0xfff37fff,0x3ff62001,0x6fff884f,0x0bfff100,0x8003fff1,
    0x0003fffb,0x00009ffb,0x50fffcc0,0x98000fff,0xa8001fff,0x800007ff,
    0x4cc40999,0x13ff6000,0x64000000,0x2a0003ff,0x7fd407ff,0x3fe600ef,
    0x5004ffff,0xfffa8dff,0xff32ffff,0x7f44001f,0x3ffe20ff,0xfff00001,
    0xffb00005,0x49ffb007,0x3ffcfffa,0x3f3fe600,0x3fff10ff,0x2fff5000,
    0x90003ffc,0x7fe40bff,0xf1000003,0x00fff2df,0xff9bfffc,0x7ff4000f,
    0x09fff706,0x101fffb0,0xb0003fff,0x36000bff,0x000004ff,0xff50bffa,
    0xffd0000f,0x9ffb0009,0x00000000,0x013ff600,0x7e400000,0x3ea0003f,
    0x3ffea07f,0x7ffcc00e,0xa801fffc,0x3fff66ff,0xf32ffebf,0xf88001ff,
    0x3ffe25ff,0xfff00001,0xfff00005,0x4dff5001,0x5ff9fffa,0x3e7fee00,
    0x3fff10ff,0x2fff5000,0x90003ffc,0x7fe40bff,0xf7000003,0x01bfe69f,
    0xff9bfff4,0x7fe4000f,0x07fffa07,0x102fffa8,0x50003fff,0x36000fff,
    0x000004ff,0xff509ff9,0xff70000f,0xfff8800f,0x01665401,0x00166540,
    0x4009ffb0,0xd9510cca,0x7e4017bd,0x0b32a03f,0x7d41ffea,0xf9800eff,
    0x01dffd7f,0xff16ffa8,0x4bffa3df,0x8000fff9,0x3fe27ffc,0xff00001f,
    0xe880005f,0xfff3007e,0xfffbffd4,0xf1dfd000,0x3ffe21ff,0x7ffa8001,
    0x64407ff9,0x57ff23cc,0x7ff92cca,0x2f3bb2e2,0x1ffe8000,0x3a00bffe,
    0x1fff36ff,0x1fff9800,0x20dfff10,0x2205fff8,0x98001fff,0xd8001fff,
    0x800004ff,0xfa80fff9,0xf880007f,0x3ee002ff,0x4ffb806f,0x04ffb800,
    0x013ff600,0xfe88ffc8,0x02ffffff,0x2e027ff9,0x7ffa84ff,0x00efffa8,
    0x3e6fff30,0x7fd404ff,0xfe87ff16,0x01fff32f,0x23fff300,0x0001fff8,
    0x0005fff0,0xbff70000,0xffcbffd4,0x8bff9803,0xfff10fff,0xfff50003,
    0x7440fff2,0x3ff20eff,0x3f27ff95,0xffffe9bf,0x26001fff,0x2ffe47ff,
    0xf9b7fec0,0x7cc000ff,0x3fee01ff,0x0fffd83f,0x007ffe20,0x003ffee0,
    0x0013ff60,0x05ffd100,0x0001ffea,0xd002ffec,0xff7005ff,0x9ff70009,
    0x27fec000,0xff5ff900,0xfffffdff,0xb57ff905,0xf509ff70,0xefffa8ff,
    0x9ffe6000,0x2a01fffc,0x3a0716ff,0x1fff32ff,0x4bffa000,0x0001fff8,
    0x0005fff0,0x9ffd0000,0xff9bffd4,0x88ffc805,0xfff10fff,0xfff50003,
    0x3a20fff2,0x7fe40eff,0x3f27ff95,0xfeffffef,0xb001ffff,0xfff989ff,
    0x9affec00,0x5c000fff,0xffe807ff,0x0bffe60f,0x003fff10,0x000fffd0,
    0x00013ff6,0x540bff90,0x500007ff,0xf3001fff,0x3fee00ff,0x4ffb8004,
    0x13ff6000,0xeffffc80,0x1bffea0b,0x21bfbff2,0xffa84ffb,0x03bffea7,
    0xe8fff300,0xff500eff,0x25ffd00d,0x0000fff9,0x3fe27ffb,0xff00001f,
    0x0000005f,0x2a1fffa8,0x03ffe7ff,0x3fe2bfd0,0x35fff10f,0x33333333,
    0x2fff7333,0x7f443ffc,0x5ffc80ef,0x3ff27ff9,0x3ee21dff,0xff8807ff,
    0x03ffe81f,0xff9affe4,0x3fa2000f,0xfff8806f,0x2013ffa5,0x2001fff8,
    0x003fffe8,0x0009ffb0,0x00fffcc0,0x0000fff5,0x6401fff4,0xff7004ff,
    0x9ff70009,0x27fec000,0x09fff900,0x320fffd4,0xfb83ffff,0x57ffa84f,
    0x001fffff,0x7cc7ff98,0xdff504ff,0x265ffd00,0xb0000fff,0x3ffe2bff,
    0xeeeeeeee,0x42eeeeee,0xccccdfff,0x1ccccccc,0x3ffe2000,0xf93ffd44,
    0x9ffcc07f,0xff10fff8,0xffffffff,0xffffffff,0x88fff2ff,0xf900dffe,
    0x64fff2bf,0x3e606fff,0x7fdc01ff,0x80fff706,0xfff34ffb,0x3ff66001,
    0xfff7002f,0x200dff75,0xaaabfff8,0xfdcaaaaa,0x20006fff,0x00004ffd,
    0xf501bff6,0x5c0000ff,0xfff805ff,0x09ff7001,0x009ff700,0xfd555553,
    0x155555df,0x801fff90,0x7fe42fff,0x09ff702f,0xfff5fff5,0x9800dfff,
    0xfffc87ff,0x806ffa82,0xfff32ffe,0x3ff20001,0xffffff16,0xffffffff,
    0xfff85fff,0xffffffff,0x0002ffff,0xf50dffd1,0x02ffccff,0x3fe21ff9,
    0xfffff10f,0xffffffff,0x2fffffff,0xffd13ffc,0x95ffc80b,0x3fff27ff,
    0x017ff400,0x7c40fffa,0x3fee02ff,0x557fff34,0xfd975555,0xe800bfff,
    0x01fffeff,0xffffff10,0xffffffff,0x0001bfff,0x00027fec,0x402fff88,
    0x00007ffa,0xa803ffe2,0x3ee006ff,0xffb8004f,0xffffb804,0xffffffff,
    0x5ffc82ff,0x222ffe80,0x3ee03ffe,0xffffa84f,0x4fffbdff,0x41ffe600,
    0x7d40effe,0x2ffe806f,0x0001fff3,0x7fc5bff2,0xffffffff,0x2fffffff,
    0x7ffffffc,0xffffffff,0xffe88002,0x47ffa81f,0xbff00fff,0xf887ffc4,
    0xffffffff,0xffffffff,0x17ff97ff,0xf900bffd,0x64fff2bf,0xffd806ff,
    0x03ffe602,0x2a05ffd8,0xffff33ff,0xffffffff,0x001bffff,0x4fffff98,
    0x3fffe200,0xffffffff,0x0002dfff,0x0004ffd8,0x500fff70,0x80000fff,
    0x3f603ffd,0x3fee003f,0x4ffb8004,0xfffffb80,0xffffffff,0x04ffc82f,
    0xff32ffd8,0x7fdc07ff,0xfffffa84,0x00bfff65,0xf983ffcc,0x37fd44ff,
    0xf997ff40,0xfb0000ff,0x2bffe2bf,0x99999999,0x7c099999,0xaaaaacff,
    0x00aaaaaa,0x17fff440,0x7e47ffa8,0x22ff983f,0xff10fff8,0xff50003f,
    0x3fb3ff2f,0xffc800ff,0x3f27ff95,0x3ffc805f,0x5017ff20,0x3ea01fff,
    0xfffff33f,0xffffffff,0x5c0005df,0x44006fff,0xccccdfff,0x004ffffd,
    0x027fec00,0x04ffe800,0x0007ffa8,0x8837fd40,0x2e000fff,0xfb8004ff,
    0x3f60004f,0x3ff2004f,0xf3ffd803,0x5c07ffff,0xfffa84ff,0x7fffc44f,
    0x07ff9800,0xfa8bfff2,0x2ffe806f,0x0001fff3,0x7fc53ffa,0xff00001f,
    0x4000005f,0x202ffff9,0x7fcc7ffa,0x220ffc85,0xfff10fff,0xfff50003,
    0x3ffffff2,0x5ffc805f,0x3ff27ff9,0x03ffc804,0x33337ffe,0xfffccccc,
    0x265ff304,0xcccccfff,0x0009abcc,0x005fff00,0x201fff88,0x000dfffb,
    0x009ffb00,0x01fff300,0x000fff50,0x703fff00,0xfb800bff,0xffb8004f,
    0x3ff60004,0x0fff2004,0x67cfff60,0x3ee03ffd,0x4fffa84f,0x00bfff50,
    0xfe80fff3,0x0dff50ef,0x3e65ffd0,0xff0000ff,0x07ffe27f,0x17ffc000,
    0xffa80000,0x7fd401ff,0x7c0ffe87,0x87ffc45f,0x8001fff8,0xfff97ffa,
    0x805fffdf,0x7ff95ffc,0x3200fff2,0xfff503ff,0xffffffff,0x260fffff,
    0x1fff31ff,0xf8000000,0x7c4002ff,0x7fd401ff,0xfb00006f,0xf900009f,
    0x3fea00bf,0xfc800007,0x01ffe84f,0x0027fdc0,0x00027fdc,0x64009ffb,
    0xffd803ff,0x80fff273,0xffa84ffb,0x1fffe407,0x301ffe60,0x3fea9fff,
    0x32ffe806,0x10001fff,0x3fe25fff,0xff00001f,0x5000005f,0x5001dfff,
    0x7ff90fff,0x3e217fcc,0x3fff10ff,0x2fff5000,0xff95fffc,0xaffe401f,
    0x7ff93ffc,0x207ff900,0xfffffffd,0xffffffff,0x31ff882f,0x00001fff,
    0x02fff800,0x00fffc40,0x002fffdc,0x0027fec0,0x8017ffc0,0x00007ffa,
    0x7cc6ff98,0xffb8006f,0x4ffb8004,0x13ff6000,0x803ffc80,0x7fe43ffd,
    0x213fee03,0xfe807ffa,0x3fe601ff,0xafffc807,0xfe806ffa,0x01fff32f,
    0x21fff700,0x0001fff8,0x0005fff0,0x0dfffb80,0x30fff500,0x43fe4bff,
    0xff10fff8,0xff50003f,0xe897ff2f,0x3ff205ff,0x3f27ff95,0x3ffc803f,
    0x99afff88,0x99999999,0xff885ffe,0x001fff30,0xfff80000,0x7ffc4002,
    0x7fffb001,0x4ffd8000,0x37fd4000,0x00fff500,0x87ffa000,0xb8003ffc,
    0xfb8004ff,0x3f60004f,0x3ff2004f,0x43ffd803,0x3ee03ffc,0x07ffa84f,
    0x00efff98,0x3a00fff3,0x06ffafff,0xff32ffe8,0xff88001f,0x07ffe24f,
    0x17ffc000,0xfff70000,0x7ffa800b,0x3fe1ffd0,0x10fff884,0x50003fff,
    0x0fff2fff,0x3205fff5,0x27ff95ff,0xfc803ffc,0x06ffb83f,0x40fffdc0,
    0x1fff30cc,0xf8000000,0x7c4002ff,0xff1001ff,0x6c0003ff,0x6c0004ff,
    0x3ea004ff,0x7000007f,0x07ffc9ff,0x027fdc00,0x0027fdc0,0x4009ffb0,
    0xfd803ffc,0x01ffe43f,0xff509ff7,0x3ffee00f,0x00fff305,0x3ffbffe6,
    0x32ffe806,0xd8001fff,0x3fe21fff,0xff00001f,0x2e00005f,0xa8004fff,
    0x7ff907ff,0xff105ff5,0x07ffe21f,0x65ffea00,0xfffd83ff,0xf95ffc80,
    0x00fff27f,0x3fa0fff2,0x7fc4003f,0xfff9804f,0x40000000,0x44002fff,
    0x2a001fff,0x20006fff,0x40004ffd,0x2a003ffe,0x000007ff,0x3fe6fff1,
    0x9ff70005,0x09ff7000,0x027fec00,0xb007ff90,0x3ffc87ff,0x2a13fee0,
    0x3fa007ff,0x7ff983ff,0x3ffff200,0x2ffe806f,0x2001fff3,0x445fffc8,
    0x00001fff,0x00005fff,0x0009fff1,0x7cc1ffea,0xf107fcdf,0x3ffe21ff,
    0x7ffa8001,0xff107ff9,0x2bff90bf,0x7ff93ffc,0x987ff900,0xc8000fff,
    0xff9807ff,0x0000000f,0x20017ffc,0x4001fff8,0x0003fffd,0x40009ffb,
    0x2001fff8,0x00007ffa,0x3f27ff60,0xff70002f,0x9ff70009,0x27fec000,
    0x007ff900,0xffc87ffb,0x213fee03,0x22007ffa,0x7cc1ffff,0x3fa2007f,
    0xfe806fff,0x01fff32f,0x3ffeea62,0x7ffc40ef,0xfff00001,0xffb00005,
    0x7fd4000d,0x3ffffa07,0x21fff104,0x8001fff8,0x7ff97ffa,0x90bffea0,
    0x4fff2bff,0xfc803ffc,0x037fe43f,0x22fff980,0xfff33ccb,0x80000001,
    0x44002fff,0x44001fff,0x8000ffff,0x20004ffd,0x2000fffa,0x00007ffa,
    0x3fb3fe60,0x3fee0007,0x4ffb8004,0x13ff6000,0x803ffc80,0x7fe43ffd,
    0x213fee03,0x54007ffa,0x7fcc6fff,0x7ffcc007,0x2ffe806f,0xfffffff3,
    0xffffffff,0xfff101df,0xffffffff,0xffffffff,0x00017ffc,0x3fffffea,
    0xffffffff,0x81ffea7f,0x101ffffc,0x3fe21fff,0xffa8001f,0x6c07ff97,
    0x3ff20fff,0x3f27ff95,0x3ffc803f,0x0001fffc,0x7fecdffd,0x001fff36,
    0xfff80000,0x7ffc4002,0xfffb8001,0x4ffd8005,0x1ffee000,0xfffff500,
    0xffffffff,0x7f4009ff,0x20004fff,0xb8004ffb,0x360004ff,0x3f2004ff,
    0x3ffd803f,0xf701ffe4,0x0fff509f,0x49fffb00,0xc8007ff9,0xfe806fff,
    0xfffff32f,0xffffffff,0x3e2019ff,0xffffffff,0xffffffff,0x00bffe7f,
    0xfffff900,0xffffffff,0x3ffd4fff,0x40dfff30,0xff10fff8,0xff50003f,
    0x880fff2f,0x3ff25fff,0x3f27ff95,0x3ffc803f,0x0003ffea,0xfb1fffb8,
    0x03ffe6df,0xff000000,0xff88005f,0xffd0001f,0xffd8005f,0x3ff20004,
    0x7ffd4005,0xffffffff,0x2004ffff,0x000ffffb,0x0013fee0,0x80013fee,
    0x32004ffd,0xffd803ff,0x701ffe43,0xfff509ff,0xffff1000,0x001ffe65,
    0x201bffa2,0xfff32ffe,0xdfffffff,0xff10059b,0xffffffff,0xffffffff,
    0x0017ffcf,0x3fffffa0,0xffffffff,0x1ffea7ff,0x4409ffd0,0xfff10fff,
    0xfff50003,0xf700fff2,0x57ff25ff,0x7ff93ffc,0x6c7ff900,0x440005ff,
    0xdffb4fff,0x0003ffe6,0x5fff0000,0x1fff8800,0xffff3000,0x27fec001,
    0x09ff9000,0xfffffa80,0xffffffff,0x3e2004ff,0x000005ff,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x666665c0,0xcccccccc,0x0002cccc,
    0x33260599,0x33322004,0x06664004,0x00059993,0xcc98b332,0xcccccccc,
    0x3a0001ac,0x997005ee,0x2aaaaa67,0xaaaaaaaa,0x9800aaaa,0x000000aa,
    0x000000d4,0xfedca880,0xb8800bce,0x01bcefed,0x37bf72a0,0x6dcc001b,
    0x4001bdee,0x0bdeeca8,0x37bb2a20,0x32a2001b,0x40adeffd,0x1cefedb9,
    0x77654400,0x399500cd,0x26399700,0x039953cc,0x32639970,0x332e003c,
    0xb8039971,0x665402cc,0x2a219951,0xa881beec,0xca82deec,0x039db70c,
    0x3ffffff6,0xffffffff,0xc8004fff,0xfff305ff,0x3ffea001,0xfff3002f,
    0x00fffe81,0x507ffe40,0xffffffff,0x05ffffff,0x00dfff00,0x4cdd7ffa,
    0x99999999,0x2a999999,0x001ffc80,0x9bdfb930,0xa807fe21,0x01bdefdc,
    0xfd505fff,0xffffffff,0x7fffd407,0x403fffff,0xffffffd8,0xff9004ff,
    0x07ffffff,0xfffffb10,0xfc81dfff,0x3fffffff,0xfffffa80,0xf70effff,
    0xbfffffff,0xffffd100,0xfb09ffff,0x5ffd007f,0x7fedbfee,0x12ffe803,
    0xf1001fff,0x13ff21ff,0xd80dfff0,0x31ff91ff,0x9fffffff,0x7fffffcc,
    0x23ff20df,0x81fffffb,0xfffffffd,0xffffffff,0x7d4004ff,0x3ffe05ff,
    0xffff9002,0x1bfee009,0x801bffe2,0x7d42fffa,0xffffffff,0x03ffffff,
    0x8037ffc0,0x00075ffe,0xff900510,0xffd88003,0xedffffff,0xfffb105f,
    0xf09fffff,0xfffc85ff,0xfffeddff,0xefffa83f,0x5ffffecd,0xbdffff30,
    0x01dffffb,0x37bfffa2,0x00efffed,0xbbffffd1,0x361dfffd,0xfeddefff,
    0xffb00dff,0xffdb9dff,0xbdfffbff,0x409fffdb,0xddeffff9,0x7ec4ffff,
    0x2ffe803f,0x3ff6dff7,0x22ffe803,0xfb803ffd,0x81bfe65f,0x100ffff9,
    0x5ffe4fff,0xfffeefff,0xeefff9bf,0x3f24ffff,0x6fffffaf,0x55555550,
    0xd5555555,0x44005fff,0x3605ffff,0xfff004ff,0x3f600dff,0x9fff703f,
    0x09fff100,0x5555fff5,0xfff97555,0x7ffc009f,0x2bffd006,0x02880003,
    0x2001ffc8,0xedfffff9,0x80efffff,0xddeffff9,0x3e0effff,0x3ffe62ff,
    0x6ffe980c,0xc884ffe8,0xffe80fff,0x5fffa81e,0x303dffb0,0x3fa09fff,
    0x7fcc0bff,0x82fffdef,0xf984ffe9,0xfff302ff,0xfd305fff,0x3fffa05f,
    0x17ffe441,0xfd007ffb,0x6dbfee5f,0xffe803ff,0x201bfea2,0x7ffc2ffe,
    0x5ffff701,0xfc93fea0,0x7ec1cfff,0x6c44ffff,0xfff90fff,0x007b57bf,
    0x27ffdc00,0x3ffff600,0x01bfee05,0x3ffb3fe6,0x01fff800,0xd007fff6,
    0x3fea0dff,0xfffd1007,0x004ccc00,0x10000700,0x03ff9005,0x20ffff40,
    0xd06fffb8,0xff503dff,0x90fee4df,0xff880dff,0x01bfe21f,0xffc87ffd,
    0x3ffe600e,0x007ffd42,0xfa83fff1,0x3fe203ff,0x2201ffff,0x7fec0fff,
    0x7fffdc02,0x03ffe201,0x7401fff7,0x0fff65ff,0xdd0bffa0,0x3a00fff6,
    0x0fffc2ff,0xf90fff30,0x3fff607f,0x43ff904f,0xf305fffc,0x3e209fff,
    0xbfff91ff,0x7d400000,0x7dc006ff,0x2605ffef,0x7dc00fff,0x403ffcaf,
    0x7c407ff9,0xff900eff,0x1ffea01f,0x01fff880,0x01c00000,0x64014400,
    0xff7001ff,0x3ffe601f,0x077fe43f,0x5c7fff30,0x400ffec7,0x3fe61ffe,
    0x10d64c06,0xf9005fff,0x02ffe8df,0x7ec5ffb8,0xfffb805f,0x4ffb804f,
    0x2601ffe2,0xfb803fff,0x01ffec4f,0x7ec3ffe6,0x2ffe803f,0x03ffdafc,
    0x7e42ffe8,0x13ff204f,0x7fc17fea,0xfff06ffc,0x200fffc8,0x3a00ffff,
    0x1fff92ff,0x3e600000,0x22000fff,0x05ffbeff,0x36017ffc,0x05ff98ff,
    0x5402ffdc,0xffa84fff,0x1ffea02f,0xa89ffd00,0xcccccccc,0x02cccccc,
    0x28800038,0x801ffc80,0xd103fff8,0x7c4fffdf,0xffc802ff,0x80041b66,
    0x3fe22ffd,0xff98004f,0x1fff1006,0x4401ffe6,0x0fff47ff,0x01fffe80,
    0x0107ff88,0x003fff30,0x7ff8dff1,0xffd81300,0x22ffe803,0x07ffb3f9,
    0xf985ffd0,0x07ffe07f,0x3e61ffe2,0x4c0ffdaf,0x37fe45ff,0xb017ff60,
    0x1bff27ff,0x7f440000,0x7f4001ff,0x405ffa8f,0x7fc03ffd,0xfb01ffe6,
    0x3ff2007f,0x13ffe22f,0x800fff50,0x7fe44ffd,0xffffffff,0x3804ffff,
    0x95288000,0xffd99999,0x1999999b,0xfd81ffe6,0xf31fff8e,0x3fe200df,
    0x8003fb8f,0x42fffca8,0x0adffffd,0x005ffb80,0x7fd47ffe,0x43ffe006,
    0x36007ff8,0x3fe007ff,0x6dcc000f,0x3fe007ff,0x001bfe27,0xe803ffd8,
    0x21dd12ff,0xfe803ffd,0x81ffe82f,0x3f606ff9,0x5c7fe41f,0x17fe42ff,
    0xf9017ff2,0x3ffc809f,0x0000bff9,0x00ffff60,0x3ea7ff90,0x2ffd405f,
    0x7ec9ff50,0x03ffe01f,0xb0fffe80,0xff500dff,0x1fff800f,0x7fffffe4,
    0xfffeffff,0x80003803,0xfffff928,0xffffffff,0x3fea3fff,0x361ff705,
    0x0bff72ff,0x27f7ffc0,0x3fb6ea20,0x42ffffff,0xffffffe8,0x9ff901be,
    0xb97ff400,0xffffffff,0xffffffff,0x400dff31,0xfffffffc,0xffffffff,
    0x3b6ea01f,0xffffffff,0xffffffff,0xff50ffff,0x7fec000b,0xbbffe803,
    0x0fff60ee,0x2e0bffa0,0x3ffc84ff,0xfd13fee0,0xfd13fe6d,0x04ffc81f,
    0x3201ffe4,0x09ff93ff,0xfff90000,0x5ff98009,0xf1017fea,0x0ffe40ff,
    0x3e609ff7,0x7fcc006f,0x01fffbdf,0x2007ffa8,0x20007ffa,0x7005ffe8,
    0x32510000,0xffffffff,0xffffffff,0xf309ff71,0xc9ffe45f,0x3fa004ff,
    0x3f2202ff,0xefffffff,0xff902fff,0x1dffffff,0x2003ffd8,0xfff93ffd,
    0xffffffff,0x2e5fffff,0x3ee005ff,0xffffffff,0x2fffffff,0x7ffffec4,
    0xffffefff,0xffffffff,0xff72ffff,0x7fec0009,0xefffe803,0x01ffec0c,
    0x7c417ff4,0x00fff87f,0xff89bfe2,0xff89bfe4,0x403ffc85,0x7e403ffc,
    0x007ff93f,0x6fffa800,0x07ff4400,0xfd00bff5,0x31ffa03f,0x3fee0dff,
    0xfffb8004,0xf5003fff,0xff9100ff,0x7f40005f,0x000e006f,0x5554ca20,
    0xacffdaaa,0xf90aaaaa,0x44ff887f,0x7ffb4ffc,0x027fec00,0xdffffff1,
    0x0bff6359,0xffffda88,0x3ff62fff,0x4fff6003,0xcccceffc,0xcccccccc,
    0x00bff71c,0x6667ffdc,0xcccccccc,0x3ffa21cc,0x88abdeff,0xcccccfff,
    0xcccccccc,0x000bff71,0x7401ffec,0x3ff603ff,0x02ffe803,0x7fd45ffb,
    0x50ffe805,0x87fec5ff,0xffc82ffb,0x01ffe403,0x7fe4fff2,0x3e600003,
    0x64000fff,0x2ffd42ff,0x441ffe40,0x0fff85ff,0x0002ffd8,0x00bffffb,
    0x7777ffd4,0xfffffeee,0x3f60001f,0x00e000ef,0x3200a200,0xffc801ff,
    0x7e42fec4,0x007ffb3f,0xfd01ffec,0x7f4037ff,0x3ae6002f,0x3ff27fff,
    0x4bffa004,0x40005ffb,0x32006ffa,0xf80006ff,0xf101beff,0xfa8000ff,
    0x3f60006f,0x2fff803f,0x200fff60,0xff502fff,0x4017fecb,0x1ff92ffb,
    0xffd97fdc,0x403ffc80,0x7e403ffc,0x007ff93f,0x3fffa200,0x27fd4001,
    0x5402ffd4,0x3ffb85ff,0xff82ffc8,0xff10000f,0x7d4001ff,0xffffffff,
    0x00cfffff,0x03fff900,0x88000380,0x01ffc802,0x3f26ffb8,0x92ffd80f,
    0x7f4009ff,0x3fff302f,0x005fff00,0x547ffee0,0x3fe005ff,0x00fff31f,
    0x007ff880,0x0003fffa,0x401fffa8,0x0000fff9,0x5c01ffe6,0x07ff91cc,
    0x202fff88,0x7c403ffc,0x3ffe02ff,0x3007ff88,0x31bfebff,0x41bfe9ff,
    0x7e403ffc,0x9ffe403f,0x00003ffc,0x8005fffb,0xfa80eff8,0x7ff8805f,
    0xfa80ffd8,0x037fcc5f,0xbffff900,0x7fffd400,0xffffffff,0x4003ffff,
    0x8002fffb,0x02880003,0xa801ffc8,0x03ff57ff,0x7fd47ffe,0x07ffe005,
    0x4c02ffdc,0x3f6e2fff,0x33ffe803,0xf5001fff,0x0fffc4ff,0xf0677cc0,
    0xff3005ff,0xdf3005ff,0x402ffe4b,0xa802fffb,0xfff10eff,0x23ffd003,
    0x7cc04ffc,0x3ff202ff,0x17ffcc04,0xff75ff90,0x47ffc009,0xafff84ff,
    0x7ff903ff,0x403ffc80,0x7ff93ffc,0xfff90000,0x3ffb0009,0x4017fea0,
    0x37fc0ffe,0x7dc7ff88,0xff30003f,0x2005ffff,0x9999fffa,0xffcba999,
    0xff5003ff,0x00e0007f,0x3200a200,0xff8801ff,0xf503ffaf,0x07ffccff,
    0x903ffd40,0xffb00dff,0x03ffdc5f,0xfe87ffe2,0x5ffe805f,0x74037fec,
    0x37fe46ff,0x37fffec0,0xfb2fff40,0xfff980bf,0x7ff400ef,0x202ffec5,
    0x3fee7ff9,0x17ffec06,0xd80dff70,0x3e602fff,0x001ffddf,0x07ff3ff2,
    0x03ffbff6,0x3201ffe4,0x7fe403ff,0x0007ff93,0x005fffa8,0x2a04ffb8,
    0xff9005ff,0xd027fcc5,0x0ffec1ff,0x6fffc400,0xa800fffe,0x3a6007ff,
    0xff9807ff,0x7997004f,0x0a20000e,0x4007ff20,0x205ffffe,0x7ff45ffe,
    0x04ffe805,0xd80bffee,0x3e63ffff,0x3fee03ff,0x81fffcc6,0x440fffd8,
    0x3f204fff,0x7ffc42ff,0xffff900d,0x3ee01bff,0x3ffee2ff,0xffffd100,
    0x7ffe40bf,0x81fffc42,0x3e64ffe8,0xfff903ff,0x7ffcc05f,0x5ffff903,
    0x6ffffe80,0x7fffd400,0xdffff707,0x201ffe40,0x7e403ffc,0x007ff93f,
    0x077ffcc0,0x01bfe600,0x2600bff5,0x0bff24ff,0x3fe2ffc8,0xfffb0007,
    0x00dfff31,0x8800fff5,0x3e201fff,0x3fa005ff,0x1000075f,0x03ff9005,
    0x03fffe60,0x2607ffec,0x3f603fff,0x3fe200ff,0xeba8acff,0x644fffff,
    0xa9acefff,0xfc83fffc,0xeb99bdff,0xff901fff,0xfd9337df,0x3fee0bff,
    0xfeb99bef,0xffff9bff,0xfffec9ab,0x677ffc44,0xbfffdb89,0x9acefff9,
    0x704ffffc,0xb537bfff,0xffd0dfff,0xffd957bf,0xfe805ffb,0xfecabeff,
    0x5c02ffdf,0x8003ffff,0xf105ffff,0x7e407fff,0x1ffe403f,0x7e4fff20,
    0xfd10003f,0xf70003ff,0xffffffff,0xffffffff,0xfd37fc01,0xa7fcc01f,
    0xb8005ff8,0x3fee2fff,0x3ffd403f,0x827ff400,0x000effe8,0x001d7ffa,
    0x54c01440,0x3ff6000a,0xfeb99cff,0xfff902ff,0xffd7337b,0xfff5007f,
    0x5dffffff,0xffd0dff3,0xffffffff,0x7fffdc05,0x01ffffff,0x7fffffdc,
    0x5405ffff,0xffffffff,0x3ffa61ff,0x5fffffff,0xffffff50,0x7443dfff,
    0xffffffff,0x7ffdc04f,0x0effffff,0xfffffe98,0x2ffb9fff,0x7ffff4c0,
    0xffb9ffff,0x7fffc402,0xfffd8000,0x07fffa03,0x6403ffc8,0x7fe403ff,
    0x0007ff93,0x000bfff6,0x7fffffdc,0xffffffff,0x3f600fff,0x805ff88f,
    0x05ff56ff,0x84fff980,0x2a01fffe,0xfc8007ff,0x1fffd06f,0x75ffe800,
    0x00510000,0x3ffe6000,0xffffffff,0x7ffdc03f,0x2fffffff,0x3fffa600,
    0x7ffc4fff,0xffffea81,0xd9801dff,0x0bdfffff,0xffffb100,0x22005dff,
    0xdefffffc,0xfffec881,0x74c02eff,0x03efffff,0xfffffd91,0x3f66003b,
    0x403fffff,0xdfffffd8,0x1005ff71,0x3bfffffb,0x3600bfee,0xf50005ff,
    0x7fe403ff,0x01ffe407,0xf900fff2,0x00fff27f,0x013ffee0,0xeeeeea80,
    0xffeeeeee,0x2e00eeef,0x03ffa9ff,0x1ff97fd8,0x37ff4400,0x00efff88,
    0xb000fff5,0xfffb0bff,0x53e20003,0x92880003,0xffffffff,0xffffffff,
    0x3673fa23,0x0dffffff,0xffffb300,0x200037bf,0x00009a98,0x000554c4,
    0x00003510,0x00013551,0x200054c4,0x440009a9,0x4c4001a9,0x2600009a,
    0xa98000aa,0x54c00001,0x00000001,0x00000000,0x00000000,0x00bfff50,
    0x7fd40000,0x2ffe6005,0xfb801ffc,0x4006fe9f,0x2a01fffd,0xff505fff,
    0x7fff000f,0x002fffc8,0x001cfea0,0xfffc9440,0xffffffff,0xd11fffff,
    0x01aa988d,0x000d4c00,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x20000000,0x000efff8,
    0x3fea0000,0x76ffc005,0x7ff3007f,0x7dc009ff,0xffd803ff,0x07ffa82f,
    0x717ffec0,0x80007fff,0x000071fd,0x3ffff251,0xffffffff,0x0041ffff,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x44000000,0x0000effe,0x2ffd4000,
    0x3ffff600,0x3fffe004,0xfff3002f,0x3ffe200b,0x03ffd40f,0x2ffff5cc,
    0x999ffff3,0xdddddddb,0x9727ec1d,0x99999999,0xb9999999,0x00000005,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x98000000,0xffffffff,0xffffffff,
    0xa8007fff,0x7dc005ff,0x32002fff,0xd000ffff,0x54001fff,0x7fd46fff,
    0xffffffff,0x0effffff,0x3fffffe6,0xffffffff,0x000ee0ff,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x7fffffcc,0xffffffff,
    0x007fffff,0x4005ffa8,0x000ffff9,0x4017ffea,0x8002fffc,0x3ea3fffc,
    0xffffffff,0x0dffffff,0x7fffffcc,0xffffffff,0x000000ff,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x30000000,0xffffffff,0xffffffff,
    0x5000ffff,0xff000bff,0xff8800df,0xfffa803f,0x3ffa0004,0xfffff51f,
    0x9ddfffff,0x00000017,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x86654000,
    0x0bdeeca8,0x99999950,0x99999999,0x803ccc85,0x332a4ccb,0x0f332601,
    0x32a10000,0x0479972c,0x00000000,0x98000000,0x310cc409,0x00033103,
    0x00000000,0x000fbb60,0x3b2a2000,0x00000bee,0xb705fd10,0x00019ddd,
    0x00000000,0x32600000,0x4f32e0cc,0x9950ccc9,0x200aa209,0x420009a9,
    0x6c05eed8,0x55550dee,0x3bbbbbb6,0x43ddb4ee,0x79954eea,0x22222222,
    0x88888888,0x00088888,0x3a23ff20,0x2fffffff,0xffffffc8,0xffffffff,
    0x017ffdc4,0x7e45fff5,0xdfff103f,0x36600001,0x3f69ff77,0x00073e6f,
    0x00fff000,0xfa8003aa,0x207fe401,0x13fe26fd,0xbb005ff5,0x44013600,
    0x3e0006ff,0x6c4004ff,0x3600defe,0x05ffffff,0x33bfff6a,0x0bffe600,
    0xfffffffb,0x007fd403,0xffffffff,0xffffffff,0x7fffffcd,0xffffffff,
    0x7fecc6ff,0x07ffd42e,0x3feabffd,0x20fff91f,0xffb105fc,0x4405bfff,
    0x0bffea2d,0xfb17ffd4,0x3ffffabf,0xffd5ffff,0xfdb7fd43,0xfffff76f,
    0xffffffff,0x3fffffff,0x2bff2000,0xfffeffff,0x7ffe42ff,0xefffffff,
    0xffd83fff,0x4fff880f,0x7c41ffe4,0x80000eff,0xff77ffeb,0xff9bff69,
    0x000002ef,0xff500fff,0x9dfb511d,0x403ffea3,0x7fdc3ff9,0x360ffe42,
    0x3ff600ff,0x027fec05,0x0017ffe4,0x2004fff8,0xfffffffa,0x88affb82,
    0xffb81ffd,0x40ffffff,0x22ffffb8,0xfb99cffa,0x01fe605f,0xffffffff,
    0xffffffff,0x7fffffcd,0xffffffff,0x3ffea6ff,0x3fea4fff,0x557ffa0f,
    0xfff91fff,0xf3037fa0,0xffffffff,0xfd73139f,0xd06ffc85,0x5ffd87ff,
    0xfffffffd,0xa87ffabf,0x2dffb6ff,0xfffffffb,0xffffffff,0x001fffff,
    0x7dffff90,0x037ffd41,0x05ffe880,0xfb0bfff1,0x87ff90df,0x0005ffe8,
    0x7ffffe44,0x3f69ff76,0x3ffffe6f,0x200000cf,0xfe8807ff,0xffffffff,
    0x105fffff,0x5ff98dfd,0x7cc6ff88,0x3ffee05f,0x05fffb05,0x00bffff0,
    0x400fbb60,0xfdadfff8,0x21e5c0ff,0x7fc44ff8,0x49ff711d,0x2ffdfff8,
    0x3ff61bfa,0x0c6f9860,0x3ffffffe,0xffffffff,0x3ffffe6f,0xffffffff,
    0x7ff16fff,0x7d47fea1,0x57ffa0ff,0xff91fffa,0x9ffdd10f,0x7fffffdc,
    0xffffffff,0xffd82fff,0x6c2ffcc1,0x555535ff,0x3b635555,0x6d3baa1e,
    0x111116ff,0x11111111,0x11111111,0x7ffe4000,0x07ffea04,0x01bffa00,
    0x7dc5fff5,0x3ffc81ff,0x0017ffa2,0xfffffda8,0x013fee2e,0xfffffd71,
    0xff00003b,0x3ffa200f,0xfffeefff,0x3ff205ff,0xa80fff42,0x1ffe44ff,
    0xd8bfff70,0xfb802fff,0x0001ffef,0x81ff9000,0xf9005ff8,0x80fea83f,
    0x233e25fe,0xfb002ff9,0x7c577d4d,0x000feb8e,0x0006ff80,0xfb84fb80,
    0x881fff55,0x23fff54f,0x7e407ffb,0x4c3bf70f,0xffffffeb,0xbfd00eff,
    0x9880efd8,0x00000009,0x00000000,0x007ffe40,0xb000bffe,0xf9001dff,
    0x7fff31ff,0x744fff20,0xb88005ff,0x1cfffffe,0x2004ffb8,0xefffffd9,
    0x1ffe0003,0x43fffa80,0x500fffd8,0x4ffb8dff,0xf117ff40,0x7fdc01ff,
    0x2fffd8df,0xff3ffd00,0x26666209,0x99999999,0x27f41999,0x7e407fc8,
    0x744002ff,0x5ff3046f,0x6c9ff300,0xffffffff,0xf80003ff,0xd800006f,
    0xf36f881f,0x267f50ff,0xdff50fff,0xb8fff440,0x7ffe4403,0x408803ef,
    0x00000088,0x00000000,0xffc80000,0x02ffe805,0x007fff20,0x7f67ff44,
    0x2fff205f,0x4005ffe8,0xefffffc9,0x13fee00b,0x3ffae200,0x4000cfff,
    0x3f2007ff,0x0fff202f,0xf987ffe2,0x7fcc00ff,0x01bfee0f,0xfffffff7,
    0x53fea005,0xffc80ffe,0xffffffff,0x21ffffff,0x1ff703ff,0x00efffc0,
    0xffffd973,0x017fcc0d,0xa883ffea,0xcdffffec,0xff80000a,0xfc800006,
    0xff15f983,0x7fc3fb0d,0xdb17fe66,0x0009ffff,0x000000c4,0x00000000,
    0x00000000,0x2013ff20,0xf7002ffd,0xf98005ff,0x200effff,0xfffecffc,
    0xfffb5000,0x2e003bff,0x540004ff,0x2dfffffd,0x26666666,0x99999fff,
    0x202ffc09,0xffd85ff8,0x801fff44,0x7ff45ffd,0x7fffdc03,0x3ff6002f,
    0xf907ff50,0xffffffff,0x3fffffff,0x7d40bfe2,0x3f2a601f,0x7ffec43f,
    0x206ffeff,0x3f202ff9,0x3fa200ef,0xf800005f,0xa800006f,0x3e4fd86f,
    0x3a27ec4f,0x3e1ffc5f,0x000dffff,0x00000000,0x00000000,0x00000000,
    0x6c01ffe4,0xffa803ff,0xff90003f,0xffc803ff,0x005fffff,0x017dffff,
    0x004ffb80,0xffff9100,0x7fffffcf,0xffffffff,0x0ffe66ff,0xff51ff60,
    0x037fe41f,0x545fff10,0x7f401fff,0x3e6006ff,0x5c3ffc5f,0xeeeeeeee,
    0xeeeeeeee,0x2e07ff11,0xffb000ff,0x21beffd8,0x3fe606fd,0x0dffd882,
    0x3fb3fa20,0x7fc00005,0x26666666,0x99999999,0x2fbfa099,0x3f60ffeb,
    0x27e41dc3,0x35330bfa,0x99999501,0x99999999,0x19999999,0x00000000,
    0x00000000,0xffc80000,0x03ffd803,0x0027ffcc,0x01dfff10,0xfeffffc8,
    0xfff802ff,0xff70001e,0xfa800009,0x3fffe7ff,0xffffffff,0x3ea6ffff,
    0x1ffc802f,0xf98bffe2,0xff5000ff,0x037fe41f,0x17fffff6,0x3217fe40,
    0x000002ff,0x7fc827fc,0x3f202aa2,0x7417fe1f,0x0bfe606f,0xb007ffd3,
    0x09ff31ff,0xf37fc000,0xffffffff,0xdfffffff,0x77fffec4,0x980054c1,
    0x00054c1a,0x7fffffdc,0xffffffff,0x01ffffff,0x00000000,0x00000000,
    0x1ffe4000,0x101ffec0,0x8000bfff,0x404ffffd,0xff94fffc,0xffff801f,
    0x7dc002ef,0xb880004f,0x3a6ffffe,0xffeeeeee,0x5eeeeeef,0x3a013fe2,
    0x46ffb87f,0xfd005ffc,0x0fffc45f,0xffbfffb0,0x7ff880bf,0x2006ff88,
    0xfb000999,0x25ff883f,0x7fc45fe8,0x7e427fc7,0x8bfe606f,0x9802fff8,
    0x03bf22ff,0xf37fc000,0xffffffff,0xdfffffff,0x00059750,0x54000000,
    0xcccccccc,0xcccccccc,0x0000cccc,0x00000000,0x00000000,0x401ffe40,
    0xfd103ffd,0x5c0001df,0x02ffffff,0xff897ff2,0x7f5c405f,0x800cffff,
    0x20004ffb,0xefffffc9,0x01ffe002,0x7cc06fe8,0x87ffb04f,0x7dc01ffe,
    0x01ffec5f,0x3ee5fffb,0x3fee05ff,0x003ffb04,0x44013ffe,0xffdadfff,
    0x67ffd40f,0x7e43fffd,0xfffda9bf,0xe8bfe607,0xffffffff,0x1222442f,
    0x47990000,0xeeeeeeee,0xeeeeeeee,0x00000005,0x00000000,0x00000000,
    0x00000000,0x64000000,0xffd803ff,0x01fffd03,0x57ffc400,0xf900fffb,
    0x2fffa87f,0xffffb500,0x7fdc05bf,0xffda8004,0x8001dfff,0x3f2007ff,
    0x5ffd105f,0x983ffe20,0x3fe206ff,0x81bfe60f,0x7dc2fffd,0x1fff05ff,
    0x4017fea0,0x2a004fff,0x2fffffff,0xffffff90,0xfffff107,0x201ff7bf,
    0xfff32ff9,0x5fffffff,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x01ffe400,0x7ec1ffec,0x740001ff,0x17ffa5ff,
    0x7ec1ffe4,0x322000ff,0x0befffff,0x88027fdc,0xbffffffb,0x1ffe0000,
    0xaefffb80,0x1ffffb99,0xf913fea0,0x0bff207f,0x3f601ffd,0xfff702ff,
    0x405ffa8b,0xff800ffe,0x76c4004f,0x54400def,0x2a2009aa,0x39912ded,
    0x99884cc0,0x99999999,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x0fff2000,0xf90fff60,0xb80005ff,0x3fe60fff,
    0x83ffc83f,0x0005fff8,0x9fffffd7,0x3013fee3,0x5dfffffb,0x1ffe0000,
    0x7ffffd40,0xffffffff,0x07ff201f,0xff981ffd,0x7017fd44,0xffb805ff,
    0x2017ff42,0xaa804ffb,0x0000001a,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0xfc800000,0x3ffd803f,
    0x000fffee,0x705fff30,0xffc81fff,0x05fff503,0x7ffecc00,0x2e9ff77f,
    0x3fffe3cc,0x400001df,0xffa807ff,0xfffffddf,0x00fffece,0xff98bfd1,
    0x7fc37f44,0x7002b805,0x00000005,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0xffc80000,
    0x33ffd803,0xb999ffff,0xdddddddd,0x205ffe81,0x7fe46ffe,0x03fff603,
    0xfff91000,0x7fed3fee,0x002fffe6,0x03ffc000,0x32627f44,0x017fa21b,
    0xdeb83dd3,0xea83dd30,0x0000000d,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0x03ffc800,0xff33ffd8,0xffffffff,0x41ffffff,0x2600fffc,0x3ff23fff,
    0x17ffe203,0xf75b8000,0xe9bff69f,0xe8000002,0x0091005e,0x00000488,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x1ffe4000,0xf99ffec0,
    0xffffffff,0x0fffffff,0x9005fff5,0x3ff23fff,0x17ffdc03,0x7fdc0000,
    0x000dffb4,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
};

static signed short stb__arial_40_latin_ext_x[560]={ 0,3,1,0,1,2,1,1,2,2,1,1,2,1,
3,0,1,3,1,1,0,1,1,1,1,1,3,2,1,1,1,1,1,-1,2,1,2,2,2,1,2,3,0,2,
2,2,2,1,2,1,2,1,0,2,0,0,0,0,0,2,0,0,0,-1,1,1,2,1,1,1,0,1,2,2,
-2,2,2,2,2,1,2,1,2,1,0,2,0,0,0,0,0,0,3,0,1,4,4,4,4,4,4,4,4,4,
4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,0,4,1,0,1,-1,
3,1,1,0,0,2,1,1,0,-1,2,1,0,0,3,2,0,3,1,1,0,2,1,1,0,2,-1,-1,-1,-1,
-1,-1,0,1,2,2,2,2,0,2,-1,0,-1,2,1,1,1,1,1,2,1,2,2,2,2,0,2,2,1,1,
1,1,1,1,1,1,1,1,1,1,0,3,-1,0,1,2,1,1,1,1,1,1,2,2,2,2,2,0,2,0,
-1,1,-1,1,-1,1,1,1,1,1,1,1,1,1,2,1,-1,1,2,1,2,1,2,1,2,1,2,1,1,1,
1,1,1,1,1,1,2,2,0,0,-2,-1,-1,-1,-1,-1,2,1,3,3,3,2,0,-2,2,2,2,2,1,2,
-1,2,2,2,2,0,0,2,2,2,2,2,2,1,2,2,1,1,1,1,1,1,2,1,2,2,2,2,2,1,
1,1,1,1,1,1,1,1,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,
0,0,0,0,0,0,0,2,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,4,4,0,4,4,4,
4,4,4,4,4,4,4,4,4,4,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,2,2,4,4,4,
4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,-1,1,-1,-2,1,
1,2,2,2,2,2,2,2,2,2,2,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
4,4,4,4,4,4,4,4,4,4,-1,1,0,1,1,2,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
4,4,4,4,4,4, };
static signed short stb__arial_40_latin_ext_y[560]={ 32,6,6,5,4,5,5,6,5,5,5,10,28,21,
28,5,6,6,6,6,6,6,6,6,6,6,13,13,10,13,10,5,5,6,6,5,6,6,6,5,6,6,6,6,
6,6,6,5,6,5,6,5,6,6,6,6,6,6,6,6,5,6,5,36,6,13,6,13,6,13,5,13,6,6,
6,6,6,13,13,13,13,13,13,13,6,13,13,13,13,13,13,5,5,5,16,9,9,9,9,9,9,9,9,9,
9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,32,13,6,5,10,6,
5,5,6,5,5,14,13,21,5,2,5,10,6,6,6,13,6,17,31,6,5,14,5,5,5,13,-1,-1,-1,0,
1,0,6,5,-1,-1,-1,1,-1,-1,-1,1,6,0,-1,-1,-1,0,1,11,5,-1,-1,-1,1,-1,6,5,6,6,
6,6,6,5,13,13,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,12,12,6,6,6,6,6,6,6,
1,7,0,6,6,13,-1,6,0,6,0,7,0,6,0,6,6,6,1,7,0,6,0,7,6,13,0,6,0,6,
0,6,1,7,5,4,-1,-1,6,6,0,6,2,7,0,6,6,6,0,13,6,6,-1,6,6,6,13,-1,0,6,
6,6,6,6,6,6,6,-1,6,6,13,-1,6,6,5,13,1,7,0,6,-1,6,5,13,-1,6,6,13,0,6,
-1,6,0,6,5,13,0,6,6,6,0,6,6,6,0,6,1,7,0,6,-1,5,-1,6,6,13,-1,6,-1,6,
1,-1,6,0,7,0,6,5,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,5,9,9,5,9,9,9,
9,9,9,9,9,9,9,9,9,9,5,12,9,9,9,9,9,9,9,9,9,9,9,9,9,6,13,9,9,9,
9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,0,6,0,6,0,
6,0,6,-1,1,-1,-1,-1,-1,-1,-1,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,
9,9,9,9,9,9,9,9,9,9,-5,-2,-1,6,-1,6,9,9,9,9,9,9,9,9,9,9,9,9,9,9,
9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,
9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,
9,9,9,9,9,9, };
static unsigned short stb__arial_40_latin_ext_w[560]={ 0,4,11,20,18,28,23,5,9,9,12,18,5,10,
4,10,18,11,18,18,19,18,18,18,18,18,4,5,18,18,18,18,35,25,20,24,22,20,19,25,21,4,16,22,
17,26,21,26,21,26,24,22,22,21,24,34,24,24,21,8,10,8,16,22,8,18,17,17,17,18,12,17,16,4,
8,16,4,26,16,18,17,17,11,16,10,16,18,26,18,18,18,12,4,11,19,19,19,19,19,19,19,19,19,19,
19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,0,4,18,19,18,21,
4,18,10,27,13,16,18,10,27,22,10,18,12,12,8,16,20,4,9,8,13,16,29,29,30,18,25,25,25,25,
25,25,34,24,20,20,20,20,8,7,12,10,25,21,26,26,26,26,26,17,26,21,21,21,21,24,21,19,18,18,
18,18,18,18,30,17,18,18,18,18,8,7,12,10,18,16,18,18,18,18,18,18,18,16,16,16,16,18,17,18,
25,18,25,18,29,22,24,17,24,17,24,17,24,17,22,22,25,19,20,18,20,18,20,18,20,18,20,18,25,17,
25,17,25,17,25,17,21,16,26,18,13,12,12,12,12,12,9,9,4,4,22,12,20,12,22,16,16,17,7,17,
9,17,9,17,10,19,8,21,16,21,16,21,16,21,23,16,26,18,26,18,26,18,33,32,24,11,24,11,24,12,
22,16,22,16,22,16,22,16,22,10,22,14,22,10,21,16,21,16,21,16,21,16,21,16,21,20,34,26,24,18,
24,21,18,21,18,21,18,9,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,25,19,19,19,19,19,19,
19,19,19,19,19,19,19,19,19,19,29,22,19,19,19,19,19,19,19,19,19,19,19,19,19,28,21,19,19,19,
19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,25,18,12,12,26,
18,21,16,21,16,21,16,21,16,21,16,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,
19,19,19,19,19,19,19,19,19,19,25,18,34,30,26,18,19,19,19,19,19,19,19,19,19,19,19,19,19,19,
19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,
19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,
19,19,19,19,19,19, };
static unsigned short stb__arial_40_latin_ext_h[560]={ 0,26,10,28,32,28,28,10,35,35,12,18,10,4,
4,28,27,26,26,27,26,27,27,26,27,27,19,25,19,12,19,27,35,26,26,28,26,26,26,28,26,26,27,26,
26,26,26,28,26,29,26,28,26,27,26,26,26,26,26,34,28,34,15,4,6,20,27,20,27,20,27,27,26,26,
34,26,26,19,19,20,27,27,19,20,27,20,19,19,19,27,19,35,35,35,7,23,23,23,23,23,23,23,23,23,
23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,0,27,34,28,18,26,
35,35,4,28,14,17,12,4,28,3,11,22,14,14,6,27,34,5,9,14,15,17,28,28,28,27,33,33,33,32,
31,32,26,35,33,33,33,31,33,33,33,31,26,32,34,34,34,33,32,16,29,34,34,34,32,33,26,28,27,27,
27,27,27,28,20,27,27,27,27,27,26,26,26,26,27,26,27,27,27,27,27,15,22,27,27,27,27,34,34,34,
31,26,32,27,34,27,34,27,33,27,33,26,33,27,32,27,26,27,31,26,32,27,32,26,34,27,32,27,33,34,
33,34,32,33,35,36,33,33,26,26,32,26,30,25,32,26,34,34,32,19,27,34,34,34,34,34,19,33,32,34,
34,26,26,26,26,26,26,33,26,34,27,33,26,26,28,27,32,26,33,27,34,27,28,20,33,26,34,27,32,26,
34,27,33,27,35,27,33,27,37,36,32,27,26,27,33,27,32,26,33,27,34,28,34,27,34,27,33,26,33,34,
31,33,26,32,25,32,26,27,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,28,23,23,35,23,23,23,
23,23,23,23,23,23,23,23,23,23,28,21,23,23,23,23,23,23,23,23,23,23,23,23,23,27,20,23,23,23,
23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,32,27,32,26,33,
27,33,27,34,32,34,34,34,34,34,34,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,
23,23,23,23,23,23,23,23,23,23,37,35,33,27,35,28,23,23,23,23,23,23,23,23,23,23,23,23,23,23,
23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,
23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,
23,23,23,23,23,23, };
static unsigned short stb__arial_40_latin_ext_s[560]={ 509,333,384,348,54,219,38,372,92,188,310,
121,378,449,471,139,360,119,195,484,23,20,189,433,465,439,97,143,73,342,102,
367,223,307,103,144,131,154,175,62,241,280,405,74,452,214,97,321,338,88,385,
248,410,345,470,43,78,360,1,442,461,411,211,476,426,230,267,368,230,285,217,
161,290,285,368,263,505,471,1,266,90,430,498,249,493,408,425,444,37,71,18,
79,129,153,406,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,
149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,509,504,451,
271,140,320,218,310,460,399,274,159,323,449,472,406,361,169,297,261,435,422,470,
444,396,288,247,176,369,291,188,386,455,306,125,181,448,207,239,259,53,388,409,
427,262,320,152,499,449,384,435,45,1,165,317,193,61,93,137,107,295,237,28,
1,307,288,269,250,231,150,337,171,152,133,114,95,503,458,1,63,1,37,474,
455,436,417,398,228,188,343,379,345,284,88,491,348,22,99,269,379,367,301,28,
169,430,247,481,148,28,206,246,224,274,39,1,369,160,324,406,486,273,326,139,
59,99,196,151,178,344,244,284,61,350,372,342,198,370,185,48,495,233,118,316,
498,506,92,208,462,72,422,475,53,56,332,502,70,214,81,502,431,475,300,54,
262,485,115,78,177,131,217,115,448,424,166,1,265,224,187,427,304,363,69,397,
500,451,401,129,362,214,396,165,413,221,16,1,50,31,1,14,33,192,44,73,
414,298,125,326,21,294,179,251,196,328,1,74,159,474,199,50,95,124,117,466,
61,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,118,149,149,198,
149,149,149,149,149,149,149,149,149,149,149,149,149,88,207,149,149,149,149,149,
149,149,149,149,149,149,149,149,285,386,149,149,149,149,149,149,149,149,149,149,
149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,476,248,
18,388,271,142,284,108,329,1,420,394,1,351,23,377,149,149,149,149,149,149,
149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,
149,149,149,24,134,389,314,102,169,149,149,149,149,149,149,149,149,149,149,149,
149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,
149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,
149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,
149,149,149,149,149,149,149,149,149, };
static unsigned short stb__arial_40_latin_ext_t[560]={ 1,320,374,176,143,176,208,374,1,1,374,
374,374,374,374,176,208,320,320,237,347,237,237,320,237,265,374,347,374,374,374,
265,1,320,347,208,320,320,320,208,320,320,265,320,320,320,320,176,320,176,320,
176,320,265,320,347,347,320,347,1,175,1,374,374,374,347,265,347,265,347,265,
265,320,320,1,320,293,347,374,347,265,237,347,347,208,347,347,347,374,265,374,
1,1,1,374,347,347,347,347,347,347,347,347,347,347,347,347,347,347,347,347,
347,347,347,347,347,347,347,347,347,347,347,347,347,347,347,347,347,1,208,1,
176,374,293,1,1,374,176,374,374,374,374,175,382,374,347,374,374,374,265,1,
374,374,374,374,374,176,176,176,265,74,109,109,143,143,143,293,1,109,74,74,
143,74,74,74,143,293,143,39,39,74,74,143,374,176,39,39,74,143,74,293,
208,237,237,237,237,237,176,347,237,237,237,237,237,237,265,320,320,237,320,208,
208,208,208,208,374,347,208,237,237,208,74,1,39,176,293,143,208,39,208,74,
208,74,208,74,293,109,208,143,208,293,237,176,293,143,208,143,293,39,237,143,
237,109,39,109,39,143,109,1,1,109,109,293,293,143,293,176,320,143,293,39,
39,74,374,237,39,39,39,39,74,374,109,109,74,39,293,265,293,293,293,320,
109,265,39,237,109,293,293,176,237,109,293,109,208,39,208,175,347,74,293,39,
175,109,293,74,237,74,237,1,237,109,265,1,1,143,265,320,265,74,265,143,
293,74,265,39,208,39,265,39,265,74,293,109,39,143,109,293,143,347,143,265,
265,347,347,347,347,347,347,347,347,347,347,347,347,347,347,347,208,347,347,1,
347,347,347,347,347,347,347,347,347,347,347,347,347,208,347,347,347,347,347,347,
347,347,347,347,347,347,347,347,265,347,347,347,347,347,347,347,347,347,347,347,
347,347,347,347,347,347,347,347,347,347,347,347,347,347,347,347,347,347,109,265,
143,293,74,265,109,265,1,143,1,1,39,1,39,1,347,347,347,347,347,347,
347,347,347,347,347,347,347,347,347,347,347,347,347,347,347,347,347,347,347,347,
347,347,347,1,1,109,265,1,176,347,347,347,347,347,347,347,347,347,347,347,
347,347,347,347,347,347,347,347,347,347,347,347,347,347,347,347,347,347,347,347,
347,347,347,347,347,347,347,347,347,347,347,347,347,347,347,347,347,347,347,347,
347,347,347,347,347,347,347,347,347,347,347,347,347,347,347,347,347,347,347,347,
347,347,347,347,347,347,347,347,347, };
static unsigned short stb__arial_40_latin_ext_a[560]={ 159,159,203,319,319,509,382,109,
191,191,223,335,159,191,159,159,319,319,319,319,319,319,319,319,
319,319,159,159,335,335,335,319,582,382,382,414,414,382,350,446,
414,159,286,382,319,477,414,446,382,446,414,382,350,414,382,541,
382,382,350,159,159,159,269,319,191,319,319,286,319,319,159,319,
319,127,127,286,127,477,319,319,319,319,191,286,159,319,286,414,
286,286,286,191,149,191,335,430,430,430,430,430,430,430,430,430,
430,430,430,430,430,430,430,430,430,430,430,430,430,430,430,430,
430,430,430,430,430,430,430,430,159,191,319,319,319,319,149,319,
191,422,212,319,335,191,422,316,229,314,191,191,191,330,308,159,
191,191,209,319,478,478,478,350,382,382,382,382,382,382,573,414,
382,382,382,382,159,159,159,159,414,414,446,446,446,446,446,335,
446,414,414,414,414,382,382,350,319,319,319,319,319,319,509,286,
319,319,319,319,159,159,159,159,319,319,319,319,319,319,319,314,
350,319,319,319,319,286,319,286,382,319,382,319,382,319,414,286,
414,286,414,286,414,286,414,352,414,319,382,319,382,319,382,319,
382,319,382,319,446,319,446,319,446,319,446,319,414,319,414,319,
159,159,159,159,159,159,159,127,159,159,421,254,286,127,382,286,
286,319,127,319,127,319,167,319,191,319,127,414,319,414,319,414,
319,346,414,319,446,319,446,319,446,319,573,541,414,191,414,191,
414,191,382,286,382,286,382,286,382,286,350,159,350,215,350,159,
414,319,414,319,414,319,414,319,414,319,414,319,541,414,382,286,
382,350,286,350,286,350,286,127,430,430,430,430,430,430,430,430,
430,430,430,430,430,430,430,431,430,430,319,430,430,430,430,430,
430,430,430,430,430,430,430,430,491,376,430,430,430,430,430,430,
430,430,430,430,430,430,430,489,383,430,430,430,430,430,430,430,
430,430,430,430,430,430,430,430,430,430,430,430,430,430,430,430,
430,430,430,430,430,382,319,159,127,446,319,414,319,414,319,414,
319,414,319,414,319,430,430,430,430,430,430,430,430,430,430,430,
430,430,430,430,430,430,430,430,430,430,430,430,430,430,430,430,
430,430,382,319,573,509,446,350,430,430,430,430,430,430,430,430,
430,430,430,430,430,430,430,430,430,430,430,430,430,430,430,430,
430,430,430,430,430,430,430,430,430,430,430,430,430,430,430,430,
430,430,430,430,430,430,430,430,430,430,430,430,430,430,430,430,
430,430,430,430,430,430,430,430,430,430,430,430,430,430,430,430,
430,430,430,430,430,430,430,430, };

// Call this function with
//    font: NULL or array length
//    data: NULL or specified size
//    height: STB_FONT_arial_40_latin_ext_BITMAP_HEIGHT or STB_FONT_arial_40_latin_ext_BITMAP_HEIGHT_POW2
//    return value: spacing between lines
static void stb_font_arial_40_latin_ext(stb_fontchar font[STB_FONT_arial_40_latin_ext_NUM_CHARS],
                unsigned char data[STB_FONT_arial_40_latin_ext_BITMAP_HEIGHT][STB_FONT_arial_40_latin_ext_BITMAP_WIDTH],
                int height)
{
    int i,j;
    if (data != 0) {
        unsigned int *bits = stb__arial_40_latin_ext_pixels;
        unsigned int bitpack = *bits++, numbits = 32;
        for (i=0; i < STB_FONT_arial_40_latin_ext_BITMAP_WIDTH*height; ++i)
            data[0][i] = 0;  // zero entire bitmap
        for (j=1; j < STB_FONT_arial_40_latin_ext_BITMAP_HEIGHT-1; ++j) {
            for (i=1; i < STB_FONT_arial_40_latin_ext_BITMAP_WIDTH-1; ++i) {
                unsigned int value;
                if (numbits==0) bitpack = *bits++, numbits=32;
                value = bitpack & 1;
                bitpack >>= 1, --numbits;
                if (value) {
                    if (numbits < 3) bitpack = *bits++, numbits = 32;
                    data[j][i] = (bitpack & 7) * 0x20 + 0x1f;
                    bitpack >>= 3, numbits -= 3;
                } else {
                    data[j][i] = 0;
                }
            }
        }
    }

    // build font description
    if (font != 0) {
        float recip_width = 1.0f / STB_FONT_arial_40_latin_ext_BITMAP_WIDTH;
        float recip_height = 1.0f / height;
        for (i=0; i < STB_FONT_arial_40_latin_ext_NUM_CHARS; ++i) {
            // pad characters so they bilerp from empty space around each character
            font[i].s0 = (stb__arial_40_latin_ext_s[i]) * recip_width;
            font[i].t0 = (stb__arial_40_latin_ext_t[i]) * recip_height;
            font[i].s1 = (stb__arial_40_latin_ext_s[i] + stb__arial_40_latin_ext_w[i]) * recip_width;
            font[i].t1 = (stb__arial_40_latin_ext_t[i] + stb__arial_40_latin_ext_h[i]) * recip_height;
            font[i].x0 = stb__arial_40_latin_ext_x[i];
            font[i].y0 = stb__arial_40_latin_ext_y[i];
            font[i].x1 = stb__arial_40_latin_ext_x[i] + stb__arial_40_latin_ext_w[i];
            font[i].y1 = stb__arial_40_latin_ext_y[i] + stb__arial_40_latin_ext_h[i];
            font[i].advance_int = (stb__arial_40_latin_ext_a[i]+8)>>4;
            font[i].s0f = (stb__arial_40_latin_ext_s[i] - 0.5f) * recip_width;
            font[i].t0f = (stb__arial_40_latin_ext_t[i] - 0.5f) * recip_height;
            font[i].s1f = (stb__arial_40_latin_ext_s[i] + stb__arial_40_latin_ext_w[i] + 0.5f) * recip_width;
            font[i].t1f = (stb__arial_40_latin_ext_t[i] + stb__arial_40_latin_ext_h[i] + 0.5f) * recip_height;
            font[i].x0f = stb__arial_40_latin_ext_x[i] - 0.5f;
            font[i].y0f = stb__arial_40_latin_ext_y[i] - 0.5f;
            font[i].x1f = stb__arial_40_latin_ext_x[i] + stb__arial_40_latin_ext_w[i] + 0.5f;
            font[i].y1f = stb__arial_40_latin_ext_y[i] + stb__arial_40_latin_ext_h[i] + 0.5f;
            font[i].advance = stb__arial_40_latin_ext_a[i]/16.0f;
        }
    }
}

#ifndef STB_SOMEFONT_CREATE
#define STB_SOMEFONT_CREATE              stb_font_arial_40_latin_ext
#define STB_SOMEFONT_BITMAP_WIDTH        STB_FONT_arial_40_latin_ext_BITMAP_WIDTH
#define STB_SOMEFONT_BITMAP_HEIGHT       STB_FONT_arial_40_latin_ext_BITMAP_HEIGHT
#define STB_SOMEFONT_BITMAP_HEIGHT_POW2  STB_FONT_arial_40_latin_ext_BITMAP_HEIGHT_POW2
#define STB_SOMEFONT_FIRST_CHAR          STB_FONT_arial_40_latin_ext_FIRST_CHAR
#define STB_SOMEFONT_NUM_CHARS           STB_FONT_arial_40_latin_ext_NUM_CHARS
#define STB_SOMEFONT_LINE_SPACING        STB_FONT_arial_40_latin_ext_LINE_SPACING
#endif

