/*
 * Dictionary words.
 *
 * auto-generated, do not edit! (see contrib/unicode/)
 */

#include <string.h>
#include <ecl/ecl.h>
#include "ucd_names.h"

const ecl_ucd_names_char_group ecl_ucd_names_char[ECL_UCD_TOTAL_GROUPS] = {
{32,126,14824}
,{160,887,14919}
,{890,895,15647}
,{900,906,15653}
,{908,908,15660}
,{910,929,15661}
,{931,1327,15681}
,{1329,1366,16078}
,{1369,1418,16116}
,{1421,1423,16166}
,{1425,1479,16169}
,{1488,1514,16224}
,{1519,1524,16251}
,{1536,1564,16257}
,{1566,1805,16286}
,{1807,1866,16526}
,{1869,1969,16586}
,{1984,2042,16687}
,{2045,2093,16746}
,{2096,2110,16795}
,{2112,2139,16810}
,{2142,2142,16838}
,{2144,2154,16839}
,{2208,2228,16850}
,{2230,2247,16871}
,{2259,2435,16889}
,{2437,2444,17066}
,{2447,2448,17074}
,{2451,2472,17076}
,{2474,2480,17098}
,{2482,2482,17105}
,{2486,2489,17106}
,{2492,2500,17110}
,{2503,2504,17119}
,{2507,2510,17121}
,{2519,2519,17125}
,{2524,2525,17126}
,{2527,2531,17128}
,{2534,2558,17133}
,{2561,2563,17158}
,{2565,2570,17161}
,{2575,2576,17167}
,{2579,2600,17169}
,{2602,2608,17191}
,{2610,2611,17198}
,{2613,2614,17200}
,{2616,2617,17202}
,{2620,2620,17204}
,{2622,2626,17205}
,{2631,2632,17210}
,{2635,2637,17212}
,{2641,2641,17215}
,{2649,2652,17216}
,{2654,2654,17220}
,{2662,2678,17221}
,{2689,2691,17238}
,{2693,2701,17241}
,{2703,2705,17250}
,{2707,2728,17253}
,{2730,2736,17275}
,{2738,2739,17282}
,{2741,2745,17284}
,{2748,2757,17289}
,{2759,2761,17299}
,{2763,2765,17302}
,{2768,2768,17305}
,{2784,2787,17306}
,{2790,2801,17310}
,{2809,2815,17322}
,{2817,2819,17329}
,{2821,2828,17332}
,{2831,2832,17340}
,{2835,2856,17342}
,{2858,2864,17364}
,{2866,2867,17371}
,{2869,2873,17373}
,{2876,2884,17378}
,{2887,2888,17387}
,{2891,2893,17389}
,{2901,2903,17392}
,{2908,2909,17395}
,{2911,2915,17397}
,{2918,2935,17402}
,{2946,2947,17420}
,{2949,2954,17422}
,{2958,2960,17428}
,{2962,2965,17431}
,{2969,2970,17435}
,{2972,2972,17437}
,{2974,2975,17438}
,{2979,2980,17440}
,{2984,2986,17442}
,{2990,3001,17445}
,{3006,3010,17457}
,{3014,3016,17462}
,{3018,3021,17465}
,{3024,3024,17469}
,{3031,3031,17470}
,{3046,3066,17471}
,{3072,3084,17492}
,{3086,3088,17505}
,{3090,3112,17508}
,{3114,3129,17531}
,{3133,3140,17547}
,{3142,3144,17555}
,{3146,3149,17558}
,{3157,3158,17562}
,{3160,3162,17564}
,{3168,3171,17567}
,{3174,3183,17571}
,{3191,3212,17581}
,{3214,3216,17603}
,{3218,3240,17606}
,{3242,3251,17629}
,{3253,3257,17639}
,{3260,3268,17644}
,{3270,3272,17653}
,{3274,3277,17656}
,{3285,3286,17660}
,{3294,3294,17662}
,{3296,3299,17663}
,{3302,3311,17667}
,{3313,3314,17677}
,{3328,3340,17679}
,{3342,3344,17692}
,{3346,3396,17695}
,{3398,3400,17746}
,{3402,3407,17749}
,{3412,3427,17755}
,{3430,3455,17771}
,{3457,3459,17797}
,{3461,3478,17800}
,{3482,3505,17818}
,{3507,3515,17842}
,{3517,3517,17851}
,{3520,3526,17852}
,{3530,3530,17859}
,{3535,3540,17860}
,{3542,3542,17866}
,{3544,3551,17867}
,{3558,3567,17875}
,{3570,3572,17885}
,{3585,3642,17888}
,{3647,3675,17946}
,{3713,3714,17975}
,{3716,3716,17977}
,{3718,3722,17978}
,{3724,3747,17983}
,{3749,3749,18007}
,{3751,3773,18008}
,{3776,3780,18031}
,{3782,3782,18036}
,{3784,3789,18037}
,{3792,3801,18043}
,{3804,3807,18053}
,{3840,3911,18057}
,{3913,3948,18129}
,{3953,3991,18165}
,{3993,4028,18204}
,{4030,4044,18240}
,{4046,4058,18255}
,{4096,4293,18268}
,{4295,4295,18466}
,{4301,4301,18467}
,{4304,4680,18468}
,{4682,4685,18845}
,{4688,4694,18849}
,{4696,4696,18856}
,{4698,4701,18857}
,{4704,4744,18861}
,{4746,4749,18902}
,{4752,4784,18906}
,{4786,4789,18939}
,{4792,4798,18943}
,{4800,4800,18950}
,{4802,4805,18951}
,{4808,4822,18955}
,{4824,4880,18970}
,{4882,4885,19027}
,{4888,4954,19031}
,{4957,4988,19098}
,{4992,5017,19130}
,{5024,5109,19156}
,{5112,5117,19242}
,{5120,5788,19248}
,{5792,5880,19917}
,{5888,5900,20006}
,{5902,5908,20019}
,{5920,5942,20026}
,{5952,5971,20049}
,{5984,5996,20069}
,{5998,6000,20082}
,{6002,6003,20085}
,{6016,6109,20087}
,{6112,6121,20181}
,{6128,6137,20191}
,{6144,6158,20201}
,{6160,6169,20216}
,{6176,6264,20226}
,{6272,6314,20315}
,{6320,6389,20358}
,{6400,6430,20428}
,{6432,6443,20459}
,{6448,6459,20471}
,{6464,6464,20483}
,{6468,6509,20484}
,{6512,6516,20526}
,{6528,6571,20531}
,{6576,6601,20575}
,{6608,6618,20601}
,{6622,6683,20612}
,{6686,6750,20674}
,{6752,6780,20739}
,{6783,6793,20768}
,{6800,6809,20779}
,{6816,6829,20789}
,{6832,6848,20803}
,{6912,6987,20820}
,{6992,7036,20896}
,{7040,7155,20941}
,{7164,7223,21057}
,{7227,7241,21117}
,{7245,7304,21132}
,{7312,7354,21192}
,{7357,7367,21235}
,{7376,7418,21246}
,{7424,7673,21289}
,{7675,7957,21539}
,{7960,7965,21822}
,{7968,8005,21828}
,{8008,8013,21866}
,{8016,8023,21872}
,{8025,8025,21880}
,{8027,8027,21881}
,{8029,8029,21882}
,{8031,8061,21883}
,{8064,8116,21914}
,{8118,8132,21967}
,{8134,8147,21982}
,{8150,8155,21996}
,{8157,8175,22002}
,{8178,8180,22021}
,{8182,8190,22024}
,{8192,8292,22033}
,{8294,8305,22134}
,{8308,8334,22146}
,{8336,8348,22173}
,{8352,8383,22186}
,{8400,8432,22218}
,{8448,8587,22251}
,{8592,9254,22391}
,{9280,9290,23054}
,{9312,11123,23065}
,{11126,11157,24877}
,{11159,11310,24909}
,{11312,11358,25061}
,{11360,11507,25108}
,{11513,11557,25256}
,{11559,11559,25301}
,{11565,11565,25302}
,{11568,11623,25303}
,{11631,11632,25359}
,{11647,11670,25361}
,{11680,11686,25385}
,{11688,11694,25392}
,{11696,11702,25399}
,{11704,11710,25406}
,{11712,11718,25413}
,{11720,11726,25420}
,{11728,11734,25427}
,{11736,11742,25434}
,{11744,11858,25441}
,{11904,11929,25556}
,{11931,12019,25582}
,{12032,12245,25671}
,{12272,12283,25885}
,{12288,12351,25897}
,{12353,12438,25961}
,{12441,12543,26047}
,{12549,12591,26150}
,{12593,12686,26193}
,{12688,12771,26287}
,{12784,12830,26371}
,{12832,13311,26418}
,{19904,19967,26898}
,{40960,42124,26962}
,{42128,42182,28127}
,{42192,42539,28182}
,{42560,42743,28530}
,{42752,42943,28714}
,{42946,42954,28906}
,{42997,43052,28915}
,{43056,43065,28971}
,{43072,43127,28981}
,{43136,43205,29037}
,{43214,43225,29107}
,{43232,43347,29119}
,{43359,43388,29235}
,{43392,43469,29265}
,{43471,43481,29343}
,{43486,43518,29354}
,{43520,43574,29387}
,{43584,43597,29442}
,{43600,43609,29456}
,{43612,43714,29466}
,{43739,43766,29569}
,{43777,43782,29597}
,{43785,43790,29603}
,{43793,43798,29609}
,{43808,43814,29615}
,{43816,43822,29622}
,{43824,43883,29629}
,{43888,44013,29689}
,{44016,44025,29815}
,{44032,55203,29825}
,{55216,55238,40997}
,{55243,55291,41020}
,{63744,64109,41069}
,{64112,64217,41435}
,{64256,64262,41541}
,{64275,64279,41548}
,{64285,64310,41553}
,{64312,64316,41579}
,{64318,64318,41584}
,{64320,64321,41585}
,{64323,64324,41587}
,{64326,64449,41589}
,{64467,64831,41713}
,{64848,64911,42078}
,{64914,64967,42142}
,{65008,65021,42196}
,{65024,65049,42210}
,{65056,65106,42236}
,{65108,65126,42287}
,{65128,65131,42306}
,{65136,65140,42310}
,{65142,65276,42315}
,{65279,65279,42450}
,{65281,65470,42451}
,{65474,65479,42641}
,{65482,65487,42647}
,{65490,65495,42653}
,{65498,65500,42659}
,{65504,65510,42662}
,{65512,65518,42669}
,{65529,65533,42676}
,{65536,65547,42681}
,{65549,65574,42693}
,{65576,65594,42719}
,{65596,65597,42738}
,{65599,65613,42740}
,{65616,65629,42755}
,{65664,65786,42769}
,{65792,65794,42892}
,{65799,65843,42895}
,{65847,65934,42940}
,{65936,65948,43028}
,{65952,65952,43041}
,{66000,66045,43042}
,{66176,66204,43088}
,{66208,66256,43117}
,{66272,66299,43166}
,{66304,66339,43194}
,{66349,66378,43230}
,{66384,66426,43260}
,{66432,66461,43303}
,{66463,66499,43333}
,{66504,66517,43370}
,{66560,66717,43384}
,{66720,66729,43542}
,{66736,66771,43552}
,{66776,66811,43588}
,{66816,66855,43624}
,{66864,66915,43664}
,{66927,66927,43716}
,{67072,67382,43717}
,{67392,67413,44028}
,{67424,67431,44050}
,{67584,67589,44058}
,{67592,67592,44064}
,{67594,67637,44065}
,{67639,67640,44109}
,{67644,67644,44111}
,{67647,67669,44112}
,{67671,67742,44135}
,{67751,67759,44207}
,{67808,67826,44216}
,{67828,67829,44235}
,{67835,67867,44237}
,{67871,67897,44270}
,{67903,67903,44297}
,{67968,68023,44298}
,{68028,68047,44354}
,{68050,68099,44374}
,{68101,68102,44424}
,{68108,68115,44426}
,{68117,68119,44434}
,{68121,68149,44437}
,{68152,68154,44466}
,{68159,68168,44469}
,{68176,68184,44479}
,{68192,68255,44488}
,{68288,68326,44552}
,{68331,68342,44591}
,{68352,68405,44603}
,{68409,68437,44657}
,{68440,68466,44686}
,{68472,68497,44713}
,{68505,68508,44739}
,{68521,68527,44743}
,{68608,68680,44750}
,{68736,68786,44823}
,{68800,68850,44874}
,{68858,68903,44925}
,{68912,68921,44971}
,{69216,69246,44981}
,{69248,69289,45012}
,{69291,69293,45054}
,{69296,69297,45057}
,{69376,69415,45059}
,{69424,69465,45099}
,{69552,69579,45141}
,{69600,69622,45169}
,{69632,69709,45192}
,{69714,69743,45270}
,{69759,69825,45300}
,{69837,69837,45367}
,{69840,69864,45368}
,{69872,69881,45393}
,{69888,69940,45403}
,{69942,69959,45456}
,{69968,70006,45474}
,{70016,70111,45513}
,{70113,70132,45609}
,{70144,70161,45629}
,{70163,70206,45647}
,{70272,70278,45691}
,{70280,70280,45698}
,{70282,70285,45699}
,{70287,70301,45703}
,{70303,70313,45718}
,{70320,70378,45729}
,{70384,70393,45788}
,{70400,70403,45798}
,{70405,70412,45802}
,{70415,70416,45810}
,{70419,70440,45812}
,{70442,70448,45834}
,{70450,70451,45841}
,{70453,70457,45843}
,{70459,70468,45848}
,{70471,70472,45858}
,{70475,70477,45860}
,{70480,70480,45863}
,{70487,70487,45864}
,{70493,70499,45865}
,{70502,70508,45872}
,{70512,70516,45879}
,{70656,70747,45884}
,{70749,70753,45976}
,{70784,70855,45981}
,{70864,70873,46053}
,{71040,71093,46063}
,{71096,71133,46117}
,{71168,71236,46155}
,{71248,71257,46224}
,{71264,71276,46234}
,{71296,71352,46247}
,{71360,71369,46304}
,{71424,71450,46314}
,{71453,71467,46341}
,{71472,71487,46356}
,{71680,71739,46372}
,{71840,71922,46432}
,{71935,71942,46515}
,{71945,71945,46523}
,{71948,71955,46524}
,{71957,71958,46532}
,{71960,71989,46534}
,{71991,71992,46564}
,{71995,72006,46566}
,{72016,72025,46578}
,{72096,72103,46588}
,{72106,72151,46596}
,{72154,72164,46642}
,{72192,72263,46653}
,{72272,72354,46725}
,{72384,72440,46808}
,{72704,72712,46865}
,{72714,72758,46874}
,{72760,72773,46919}
,{72784,72812,46933}
,{72816,72847,46962}
,{72850,72871,46994}
,{72873,72886,47016}
,{72960,72966,47030}
,{72968,72969,47037}
,{72971,73014,47039}
,{73018,73018,47083}
,{73020,73021,47084}
,{73023,73031,47086}
,{73040,73049,47095}
,{73056,73061,47105}
,{73063,73064,47111}
,{73066,73102,47113}
,{73104,73105,47150}
,{73107,73112,47152}
,{73120,73129,47158}
,{73440,73464,47168}
,{73648,73648,47193}
,{73664,73713,47194}
,{73727,74649,47244}
,{74752,74862,48167}
,{74864,74868,48278}
,{74880,75075,48283}
,{77824,78894,48479}
,{78896,78904,49550}
,{82944,83526,49559}
,{92160,92728,50142}
,{92736,92766,50711}
,{92768,92777,50742}
,{92782,92783,50752}
,{92880,92909,50754}
,{92912,92917,50784}
,{92928,92997,50790}
,{93008,93017,50860}
,{93019,93025,50870}
,{93027,93047,50877}
,{93053,93071,50898}
,{93760,93850,50917}
,{93952,94026,51008}
,{94031,94087,51083}
,{94095,94111,51140}
,{94176,94180,51157}
,{94192,94193,51162}
,{100352,101589,51164}
,{110592,110878,52402}
,{110928,110930,52689}
,{110948,110951,52692}
,{110960,111355,52696}
,{113664,113770,53092}
,{113776,113788,53199}
,{113792,113800,53212}
,{113808,113817,53221}
,{113820,113827,53231}
,{118784,119029,53239}
,{119040,119078,53485}
,{119081,119272,53524}
,{119296,119365,53716}
,{119520,119539,53786}
,{119552,119638,53806}
,{119648,119672,53893}
,{119808,119892,53918}
,{119894,119964,54003}
,{119966,119967,54074}
,{119970,119970,54076}
,{119973,119974,54077}
,{119977,119980,54079}
,{119982,119993,54083}
,{119995,119995,54095}
,{119997,120003,54096}
,{120005,120069,54103}
,{120071,120074,54168}
,{120077,120084,54172}
,{120086,120092,54180}
,{120094,120121,54187}
,{120123,120126,54215}
,{120128,120132,54219}
,{120134,120134,54224}
,{120138,120144,54225}
,{120146,120485,54232}
,{120488,120779,54572}
,{120782,121483,54864}
,{121499,121503,55566}
,{121505,121519,55571}
,{122880,122886,55586}
,{122888,122904,55593}
,{122907,122913,55610}
,{122915,122916,55617}
,{122918,122922,55619}
,{123136,123180,55624}
,{123184,123197,55669}
,{123200,123209,55683}
,{123214,123215,55693}
,{123584,123641,55695}
,{123647,123647,55753}
,{124928,125124,55754}
,{125127,125142,55951}
,{125184,125259,55967}
,{125264,125273,56043}
,{125278,125279,56053}
,{126065,126132,56055}
,{126209,126269,56123}
,{126464,126467,56184}
,{126469,126495,56188}
,{126497,126498,56215}
,{126500,126500,56217}
,{126503,126503,56218}
,{126505,126514,56219}
,{126516,126519,56229}
,{126521,126521,56233}
,{126523,126523,56234}
,{126530,126530,56235}
,{126535,126535,56236}
,{126537,126537,56237}
,{126539,126539,56238}
,{126541,126543,56239}
,{126545,126546,56242}
,{126548,126548,56244}
,{126551,126551,56245}
,{126553,126553,56246}
,{126555,126555,56247}
,{126557,126557,56248}
,{126559,126559,56249}
,{126561,126562,56250}
,{126564,126564,56252}
,{126567,126570,56253}
,{126572,126578,56257}
,{126580,126583,56264}
,{126585,126588,56268}
,{126590,126590,56272}
,{126592,126601,56273}
,{126603,126619,56283}
,{126625,126627,56300}
,{126629,126633,56303}
,{126635,126651,56308}
,{126704,126705,56325}
,{126976,127019,56327}
,{127024,127123,56371}
,{127136,127150,56471}
,{127153,127167,56486}
,{127169,127183,56501}
,{127185,127221,56516}
,{127232,127405,56553}
,{127462,127490,56727}
,{127504,127547,56756}
,{127552,127560,56800}
,{127568,127569,56809}
,{127584,127589,56811}
,{127744,128727,56817}
,{128736,128748,57801}
,{128752,128764,57814}
,{128768,128883,57827}
,{128896,128984,57943}
,{128992,129003,58032}
,{129024,129035,58044}
,{129040,129095,58056}
,{129104,129113,58112}
,{129120,129159,58122}
,{129168,129197,58162}
,{129200,129201,58192}
,{129280,129400,58194}
,{129402,129483,58315}
,{129485,129619,58397}
,{129632,129645,58532}
,{129648,129652,58546}
,{129656,129658,58551}
,{129664,129670,58554}
,{129680,129704,58561}
,{129712,129718,58586}
,{129728,129730,58593}
,{129744,129750,58596}
,{129792,129938,58603}
,{129940,129994,58750}
,{130032,130041,58805}
,{194560,195101,58815}
,{917505,917505,59357}
,{917536,917631,59358}
};

static int
search_pair(ecl_character c)
{
  int mid, low = 0, up = ECL_UCD_TOTAL_GROUPS-1;
  do {
    mid = (up + low) / 2;
    if (c < ecl_ucd_names_char[mid].smallest)
      up = mid-1;
    else if (c > ecl_ucd_names_char[mid].largest)
      low = mid+1;
    else
      return (c - ecl_ucd_names_char[mid].smallest) +
             ecl_ucd_names_char[mid].pair_code;
  } while (low <= up && (low >= 0) && (up < ECL_UCD_TOTAL_GROUPS));
  return -1;
}

static void
fill_pair_name(char *buffer, int pair)
{
  if (pair < ECL_UCD_FIRST_PAIR) {
    strncat(buffer, ecl_ucd_names_word[pair], ECL_UCD_LARGEST_CHAR_NAME+1);
/*
    printf("text=%s\n", ecl_ucd_names_word[pair]);
 */
  } else {
    const ecl_ucd_names_pair_type p = ecl_ucd_names_pair[pair - ECL_UCD_FIRST_PAIR];
/*
    printf("ndx=%d\n", pair - ECL_UCD_FIRST_PAIR);
    printf("c0=%d\n", ecl_ucd_names_pair[pair - ECL_UCD_FIRST_PAIR].codes[0]);
    printf("c1=%d\n", ecl_ucd_names_pair[pair - ECL_UCD_FIRST_PAIR].codes[1]);
    printf("c2=%d\n", ecl_ucd_names_pair[pair - ECL_UCD_FIRST_PAIR].codes[2]);
    printf("c3=%d\n", ecl_ucd_names_pair[pair - ECL_UCD_FIRST_PAIR].codes[3]);
    printf("c4=%d\n", ecl_ucd_names_pair[pair - ECL_UCD_FIRST_PAIR].codes[4]);
    printf("c5=%d\n", ecl_ucd_names_pair[pair - ECL_UCD_FIRST_PAIR].codes[5]);
 */
    fill_pair_name(buffer, (((unsigned int)p.codes[2]) << 16) | (((unsigned int)p.codes[1]) << 8) | p.codes[0]);
    fill_pair_name(buffer, (((unsigned int)p.codes[5]) << 16) | (((unsigned int)p.codes[4]) << 8) | p.codes[3]);
  }
}

cl_object
_ecl_ucd_code_to_name(ecl_character c)
{
  int pair = search_pair(c);
  if (pair < 0)
    return ECL_NIL;
  else {
    char buffer[ECL_UCD_LARGEST_CHAR_NAME+1];
    buffer[0] = 0;
    fill_pair_name(buffer, pair);
    return ecl_make_simple_base_string(buffer,-1);
  }
}

cl_object
_ecl_ucd_name_to_code(cl_object name)
{
  int mid, low = 0, up = ECL_UCD_TOTAL_NAMES-1;
  int l = ecl_length(name);
  if (l <= ECL_UCD_LARGEST_CHAR_NAME) {
    char buffer1[ECL_UCD_LARGEST_CHAR_NAME+1];
    char buffer2[ECL_UCD_LARGEST_CHAR_NAME+1];
    for (mid = 0; mid < l; mid++) {
      ecl_character c = ecl_char_upcase(ecl_char(name, mid));
      buffer1[mid] = c;
      if (c < 32 || c > 127) /* All character names are [-A-Z_0-9]* */
        return ECL_NIL;
    }
    buffer1[mid] = 0;
    do {
      ecl_ucd_code_and_pair p = ecl_ucd_sorted_pairs[mid = (low + up) / 2];
      int flag, pair = ((unsigned int)p.pair[1] << 8) | p.pair[0];
      buffer2[0] = 0;
      fill_pair_name(buffer2, pair);
      flag = strcmp(buffer1, buffer2);
/*
      printf("[%d,%d,%d] %s <> (%d)%s -> %d\n",
             low, mid, up, buffer1, pair, buffer2, flag);
 */
      if (flag == 0) {
        return ecl_make_fixnum(((unsigned int)p.code[2] << 16) |
                               ((unsigned int)p.code[1] << 8) |
                               p.code[0]);
      } else if (flag < 0) {
        up = mid - 1;
      } else {
        low = mid + 1;
      }
    } while (low <= up);
  }
  return ECL_NIL;
}

