/**
 * Search the tree for a match that satisfies specific comparison
 * criteria, branch contains the desired data for which to search the
 * tree
 * @param  compareFunc is a binary function object that defines how to
 *                     compare nodes
 * @param  bRetrieve   indicates whether or not the input search
 *                     branch should be modified to reflect a branch
 *                     in the tree, assuming a match satisfying the
 *                     given search criteria exists
 * @return             true if a branch matching the input is found or
 *                     returns nullptr otherwise
 *
 *    It was the best of times, it was the worst of times, it was the
 *    age of wisdom, it was the age of foolishness, it was the epoch
 *    of belief, it was the epoch of incredulity, it was the season of
 *    Light, it was the season of Darkness, it was the spring of hope,
 *    it was the winter of despair, we had everything before us, we
 *    had nothing before us, we were all going direct to Heaven, we
 *    were all going direct the other way--in short, the period was so
 *    far like the present period, that some of its noisiest
 *    authorities insisted on its being received, for good or for
 *    evil, in the superlative degree of comparison only.
 *
 *        There were a king with a large jaw and a queen with a plain
 *        face on the throne of England; there were a king with a
 *        large jaw and a queen with a fair face, on the throne of
 *        France. In both countries it was clearer than crystal to the
 *        lords of the State preserves of loaves and fishes, that
 *        things in general were settled for ever.
 *
 *            It was the year of Our Lord one thousand seven hundred
 *            and seventy-five. Spiritual revelations were conceded to
 *            England at that favoured period, as at this. Mrs.
 *            Southcott had recently attained her five-and-twentieth
 *            blessed birthday, of whom a prophetic private in the
 *            Life Guards had heralded the sublime appearance by
 *            announcing that arrangements were made for the
 *            swallowing up of London and Westminster. Even the
 *            Cock-lane ghost had been laid only a round dozen of
 *            years, after rapping out its messages, as the spirits of
 *            this very year last past (supernaturally deficient in
 *            originality) rapped out theirs. Mere messages in the
 *            earthly order of events had lately come to the English
 *            Crown and People, from a congress of British subjects in
 *            America: which, strange to relate, have proved more
 *            important to the human race than any communications yet
 *            received through any of the chickens of the Cock-lane
 *            brood.
 */
